/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.FuturesCandlestick;
import io.gate.gateapi.models.FuturesOrderBook;
import io.gate.gateapi.models.FuturesTrade;
import io.gate.gateapi.models.OptionsAccount;
import io.gate.gateapi.models.OptionsAccountBook;
import io.gate.gateapi.models.OptionsCandlestick;
import io.gate.gateapi.models.OptionsContract;
import io.gate.gateapi.models.OptionsMySettlements;
import io.gate.gateapi.models.OptionsMyTrade;
import io.gate.gateapi.models.OptionsOrder;
import io.gate.gateapi.models.OptionsPosition;
import io.gate.gateapi.models.OptionsPositionClose;
import io.gate.gateapi.models.OptionsSettlement;
import io.gate.gateapi.models.OptionsTicker;
import io.gate.gateapi.models.OptionsUnderlying;
import io.gate.gateapi.models.OptionsUnderlyingTicker;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OptionsApi {
    private ApiClient localVarApiClient;

    public OptionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for listOptionsUnderlyings
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsUnderlyingsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/underlyings";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsUnderlyingsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsUnderlyingsCall(_callback);
        return localVarCall;
    }

    /**
     * List all underlyings
     * 
     * @return List&lt;OptionsUnderlying&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<OptionsUnderlying> listOptionsUnderlyings() throws ApiException {
        ApiResponse<List<OptionsUnderlying>> localVarResp = listOptionsUnderlyingsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List all underlyings
     * 
     * @return ApiResponse&lt;List&lt;OptionsUnderlying&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<OptionsUnderlying>> listOptionsUnderlyingsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listOptionsUnderlyingsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<OptionsUnderlying>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all underlyings (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsUnderlyingsAsync(final ApiCallback<List<OptionsUnderlying>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsUnderlyingsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<OptionsUnderlying>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for listOptionsExpirations
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List expiration times of specified underlying </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsExpirationsCall(String underlying, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/expirations";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsExpirationsValidateBeforeCall(String underlying, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsExpirations(Async)");
        }

        okhttp3.Call localVarCall = listOptionsExpirationsCall(underlying, _callback);
        return localVarCall;
    }

    /**
     * List all expiration times
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return List&lt;Long&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List expiration times of specified underlying </td><td>  -  </td></tr>
     </table>
     */
    public List<Long> listOptionsExpirations(String underlying) throws ApiException {
        ApiResponse<List<Long>> localVarResp = listOptionsExpirationsWithHttpInfo(underlying);
        return localVarResp.getData();
    }

    /**
     * List all expiration times
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return ApiResponse&lt;List&lt;Long&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List expiration times of specified underlying </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Long>> listOptionsExpirationsWithHttpInfo(String underlying) throws ApiException {
        okhttp3.Call localVarCall = listOptionsExpirationsValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<List<Long>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all expiration times (asynchronously)
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List expiration times of specified underlying </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsExpirationsAsync(String underlying, final ApiCallback<List<Long>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsExpirationsValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<List<Long>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listOptionsContractsCall(String underlying, Long expiration, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/contracts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (expiration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration", expiration));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsContractsValidateBeforeCall(String underlying, Long expiration, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsContracts(Async)");
        }

        okhttp3.Call localVarCall = listOptionsContractsCall(underlying, expiration, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsContract>> listOptionsContractsWithHttpInfo(String underlying, Long expiration) throws ApiException {
        okhttp3.Call localVarCall = listOptionsContractsValidateBeforeCall(underlying, expiration, null);
        Type localVarReturnType = new TypeToken<List<OptionsContract>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsContractsAsync(String underlying, Long expiration, final ApiCallback<List<OptionsContract>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsContractsValidateBeforeCall(underlying, expiration, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsContract>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsContractsRequest {
        private final String underlying;
        private Long expiration;

        private APIlistOptionsContractsRequest(String underlying) {
            this.underlying = underlying;
        }

        /**
         * Set expiration
         * @param expiration Unix timestamp of the expiration time (optional)
         * @return APIlistOptionsContractsRequest
         */
        public APIlistOptionsContractsRequest expiration(Long expiration) {
            this.expiration = expiration;
            return this;
        }

        /**
         * Build call for listOptionsContracts
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsContractsCall(underlying, expiration, _callback);
        }

        /**
         * Execute listOptionsContracts request
         * @return List&lt;OptionsContract&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsContract> execute() throws ApiException {
            ApiResponse<List<OptionsContract>> localVarResp = listOptionsContractsWithHttpInfo(underlying, expiration);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsContracts request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsContract&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsContract>> executeWithHttpInfo() throws ApiException {
            return listOptionsContractsWithHttpInfo(underlying, expiration);
        }

        /**
         * Execute listOptionsContracts request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsContract>> _callback) throws ApiException {
            return listOptionsContractsAsync(underlying, expiration, _callback);
        }
    }

    /**
     * List all the contracts with specified underlying and expiration time
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return APIlistOptionsContractsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsContractsRequest listOptionsContracts(String underlying) {
        return new APIlistOptionsContractsRequest(underlying);
    }

    /**
     * Build call for getOptionsContract
     * @param contract  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsContractCall(String contract, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/contracts/{contract}"
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionsContractValidateBeforeCall(String contract, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getOptionsContract(Async)");
        }

        okhttp3.Call localVarCall = getOptionsContractCall(contract, _callback);
        return localVarCall;
    }

    /**
     * Query specified contract detail
     * 
     * @param contract  (required)
     * @return OptionsContract
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public OptionsContract getOptionsContract(String contract) throws ApiException {
        ApiResponse<OptionsContract> localVarResp = getOptionsContractWithHttpInfo(contract);
        return localVarResp.getData();
    }

    /**
     * Query specified contract detail
     * 
     * @param contract  (required)
     * @return ApiResponse&lt;OptionsContract&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OptionsContract> getOptionsContractWithHttpInfo(String contract) throws ApiException {
        okhttp3.Call localVarCall = getOptionsContractValidateBeforeCall(contract, null);
        Type localVarReturnType = new TypeToken<OptionsContract>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Query specified contract detail (asynchronously)
     * 
     * @param contract  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsContractAsync(String contract, final ApiCallback<OptionsContract> _callback) throws ApiException {
        okhttp3.Call localVarCall = getOptionsContractValidateBeforeCall(contract, _callback);
        Type localVarReturnType = new TypeToken<OptionsContract>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listOptionsSettlementsCall(String underlying, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/settlements";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsSettlementsValidateBeforeCall(String underlying, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsSettlements(Async)");
        }

        okhttp3.Call localVarCall = listOptionsSettlementsCall(underlying, limit, offset, from, to, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsSettlement>> listOptionsSettlementsWithHttpInfo(String underlying, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        okhttp3.Call localVarCall = listOptionsSettlementsValidateBeforeCall(underlying, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<OptionsSettlement>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsSettlementsAsync(String underlying, Integer limit, Integer offset, Long from, Long to, final ApiCallback<List<OptionsSettlement>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsSettlementsValidateBeforeCall(underlying, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsSettlement>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsSettlementsRequest {
        private final String underlying;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistOptionsSettlementsRequest(String underlying) {
            this.underlying = underlying;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistOptionsSettlementsRequest
         */
        public APIlistOptionsSettlementsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistOptionsSettlementsRequest
         */
        public APIlistOptionsSettlementsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistOptionsSettlementsRequest
         */
        public APIlistOptionsSettlementsRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistOptionsSettlementsRequest
         */
        public APIlistOptionsSettlementsRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Build call for listOptionsSettlements
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsSettlementsCall(underlying, limit, offset, from, to, _callback);
        }

        /**
         * Execute listOptionsSettlements request
         * @return List&lt;OptionsSettlement&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsSettlement> execute() throws ApiException {
            ApiResponse<List<OptionsSettlement>> localVarResp = listOptionsSettlementsWithHttpInfo(underlying, limit, offset, from, to);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsSettlements request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsSettlement&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsSettlement>> executeWithHttpInfo() throws ApiException {
            return listOptionsSettlementsWithHttpInfo(underlying, limit, offset, from, to);
        }

        /**
         * Execute listOptionsSettlements request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsSettlement>> _callback) throws ApiException {
            return listOptionsSettlementsAsync(underlying, limit, offset, from, to, _callback);
        }
    }

    /**
     * List settlement history
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return APIlistOptionsSettlementsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsSettlementsRequest listOptionsSettlements(String underlying) {
        return new APIlistOptionsSettlementsRequest(underlying);
    }

    /**
     * Build call for getOptionsSettlement
     * @param contract  (required)
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @param at  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsSettlementCall(String contract, String underlying, Long at, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/settlements/{contract}"
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (at != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("at", at));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionsSettlementValidateBeforeCall(String contract, String underlying, Long at, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getOptionsSettlement(Async)");
        }

        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling getOptionsSettlement(Async)");
        }

        // verify the required parameter 'at' is set
        if (at == null) {
            throw new ApiException("Missing the required parameter 'at' when calling getOptionsSettlement(Async)");
        }

        okhttp3.Call localVarCall = getOptionsSettlementCall(contract, underlying, at, _callback);
        return localVarCall;
    }

    /**
     * Get specified contract&#39;s settlement
     * 
     * @param contract  (required)
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @param at  (required)
     * @return OptionsSettlement
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public OptionsSettlement getOptionsSettlement(String contract, String underlying, Long at) throws ApiException {
        ApiResponse<OptionsSettlement> localVarResp = getOptionsSettlementWithHttpInfo(contract, underlying, at);
        return localVarResp.getData();
    }

    /**
     * Get specified contract&#39;s settlement
     * 
     * @param contract  (required)
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @param at  (required)
     * @return ApiResponse&lt;OptionsSettlement&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OptionsSettlement> getOptionsSettlementWithHttpInfo(String contract, String underlying, Long at) throws ApiException {
        okhttp3.Call localVarCall = getOptionsSettlementValidateBeforeCall(contract, underlying, at, null);
        Type localVarReturnType = new TypeToken<OptionsSettlement>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get specified contract&#39;s settlement (asynchronously)
     * 
     * @param contract  (required)
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @param at  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsSettlementAsync(String contract, String underlying, Long at, final ApiCallback<OptionsSettlement> _callback) throws ApiException {
        okhttp3.Call localVarCall = getOptionsSettlementValidateBeforeCall(contract, underlying, at, _callback);
        Type localVarReturnType = new TypeToken<OptionsSettlement>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listMyOptionsSettlementsCall(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/my_settlements";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMyOptionsSettlementsValidateBeforeCall(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listMyOptionsSettlements(Async)");
        }

        okhttp3.Call localVarCall = listMyOptionsSettlementsCall(underlying, contract, limit, offset, from, to, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsMySettlements>> listMyOptionsSettlementsWithHttpInfo(String underlying, String contract, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        okhttp3.Call localVarCall = listMyOptionsSettlementsValidateBeforeCall(underlying, contract, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<OptionsMySettlements>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listMyOptionsSettlementsAsync(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback<List<OptionsMySettlements>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listMyOptionsSettlementsValidateBeforeCall(underlying, contract, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsMySettlements>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistMyOptionsSettlementsRequest {
        private final String underlying;
        private String contract;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistMyOptionsSettlementsRequest(String underlying) {
            this.underlying = underlying;
        }

        /**
         * Set contract
         * @param contract Options contract name (optional)
         * @return APIlistMyOptionsSettlementsRequest
         */
        public APIlistMyOptionsSettlementsRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistMyOptionsSettlementsRequest
         */
        public APIlistMyOptionsSettlementsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistMyOptionsSettlementsRequest
         */
        public APIlistMyOptionsSettlementsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistMyOptionsSettlementsRequest
         */
        public APIlistMyOptionsSettlementsRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistMyOptionsSettlementsRequest
         */
        public APIlistMyOptionsSettlementsRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Build call for listMyOptionsSettlements
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listMyOptionsSettlementsCall(underlying, contract, limit, offset, from, to, _callback);
        }

        /**
         * Execute listMyOptionsSettlements request
         * @return List&lt;OptionsMySettlements&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsMySettlements> execute() throws ApiException {
            ApiResponse<List<OptionsMySettlements>> localVarResp = listMyOptionsSettlementsWithHttpInfo(underlying, contract, limit, offset, from, to);
            return localVarResp.getData();
        }

        /**
         * Execute listMyOptionsSettlements request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsMySettlements&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsMySettlements>> executeWithHttpInfo() throws ApiException {
            return listMyOptionsSettlementsWithHttpInfo(underlying, contract, limit, offset, from, to);
        }

        /**
         * Execute listMyOptionsSettlements request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsMySettlements>> _callback) throws ApiException {
            return listMyOptionsSettlementsAsync(underlying, contract, limit, offset, from, to, _callback);
        }
    }

    /**
     * List my options settlements
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return APIlistMyOptionsSettlementsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistMyOptionsSettlementsRequest listMyOptionsSettlements(String underlying) {
        return new APIlistMyOptionsSettlementsRequest(underlying);
    }

    private okhttp3.Call listOptionsOrderBookCall(String contract, String interval, Integer limit, Boolean withId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/order_book";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (withId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("with_id", withId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsOrderBookValidateBeforeCall(String contract, String interval, Integer limit, Boolean withId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listOptionsOrderBook(Async)");
        }

        okhttp3.Call localVarCall = listOptionsOrderBookCall(contract, interval, limit, withId, _callback);
        return localVarCall;
    }


    private ApiResponse<FuturesOrderBook> listOptionsOrderBookWithHttpInfo(String contract, String interval, Integer limit, Boolean withId) throws ApiException {
        okhttp3.Call localVarCall = listOptionsOrderBookValidateBeforeCall(contract, interval, limit, withId, null);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsOrderBookAsync(String contract, String interval, Integer limit, Boolean withId, final ApiCallback<FuturesOrderBook> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsOrderBookValidateBeforeCall(contract, interval, limit, withId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsOrderBookRequest {
        private final String contract;
        private String interval;
        private Integer limit;
        private Boolean withId;

        private APIlistOptionsOrderBookRequest(String contract) {
            this.contract = contract;
        }

        /**
         * Set interval
         * @param interval Order depth. 0 means no aggregation is applied. default to 0 (optional, default to 0)
         * @return APIlistOptionsOrderBookRequest
         */
        public APIlistOptionsOrderBookRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of order depth data in asks or bids (optional, default to 10)
         * @return APIlistOptionsOrderBookRequest
         */
        public APIlistOptionsOrderBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set withId
         * @param withId Whether the order book update ID will be returned. This ID increases by 1 on every order book update (optional, default to false)
         * @return APIlistOptionsOrderBookRequest
         */
        public APIlistOptionsOrderBookRequest withId(Boolean withId) {
            this.withId = withId;
            return this;
        }

        /**
         * Build call for listOptionsOrderBook
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsOrderBookCall(contract, interval, limit, withId, _callback);
        }

        /**
         * Execute listOptionsOrderBook request
         * @return FuturesOrderBook
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
         </table>
         */
        public FuturesOrderBook execute() throws ApiException {
            ApiResponse<FuturesOrderBook> localVarResp = listOptionsOrderBookWithHttpInfo(contract, interval, limit, withId);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsOrderBook request with HTTP info returned
         * @return ApiResponse&lt;FuturesOrderBook&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<FuturesOrderBook> executeWithHttpInfo() throws ApiException {
            return listOptionsOrderBookWithHttpInfo(contract, interval, limit, withId);
        }

        /**
         * Execute listOptionsOrderBook request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<FuturesOrderBook> _callback) throws ApiException {
            return listOptionsOrderBookAsync(contract, interval, limit, withId, _callback);
        }
    }

    /**
     * Options order book
     * Bids will be sorted by price from high to low, while asks sorted reversely
     * @param contract Options contract name (required)
     * @return APIlistOptionsOrderBookRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsOrderBookRequest listOptionsOrderBook(String contract) {
        return new APIlistOptionsOrderBookRequest(contract);
    }

    /**
     * Build call for listOptionsTickers
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsTickersCall(String underlying, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/tickers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsTickersValidateBeforeCall(String underlying, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsTickers(Async)");
        }

        okhttp3.Call localVarCall = listOptionsTickersCall(underlying, _callback);
        return localVarCall;
    }

    /**
     * List tickers of options contracts
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return List&lt;OptionsTicker&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<OptionsTicker> listOptionsTickers(String underlying) throws ApiException {
        ApiResponse<List<OptionsTicker>> localVarResp = listOptionsTickersWithHttpInfo(underlying);
        return localVarResp.getData();
    }

    /**
     * List tickers of options contracts
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return ApiResponse&lt;List&lt;OptionsTicker&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<OptionsTicker>> listOptionsTickersWithHttpInfo(String underlying) throws ApiException {
        okhttp3.Call localVarCall = listOptionsTickersValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<List<OptionsTicker>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List tickers of options contracts (asynchronously)
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsTickersAsync(String underlying, final ApiCallback<List<OptionsTicker>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsTickersValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsTicker>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for listOptionsUnderlyingTickers
     * @param underlying Underlying (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsUnderlyingTickersCall(String underlying, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/underlying/tickers/{underlying}"
            .replaceAll("\\{" + "underlying" + "\\}", localVarApiClient.escapeString(underlying));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsUnderlyingTickersValidateBeforeCall(String underlying, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsUnderlyingTickers(Async)");
        }

        okhttp3.Call localVarCall = listOptionsUnderlyingTickersCall(underlying, _callback);
        return localVarCall;
    }

    /**
     * Get underlying ticker
     * 
     * @param underlying Underlying (required)
     * @return OptionsUnderlyingTicker
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public OptionsUnderlyingTicker listOptionsUnderlyingTickers(String underlying) throws ApiException {
        ApiResponse<OptionsUnderlyingTicker> localVarResp = listOptionsUnderlyingTickersWithHttpInfo(underlying);
        return localVarResp.getData();
    }

    /**
     * Get underlying ticker
     * 
     * @param underlying Underlying (required)
     * @return ApiResponse&lt;OptionsUnderlyingTicker&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OptionsUnderlyingTicker> listOptionsUnderlyingTickersWithHttpInfo(String underlying) throws ApiException {
        okhttp3.Call localVarCall = listOptionsUnderlyingTickersValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<OptionsUnderlyingTicker>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get underlying ticker (asynchronously)
     * 
     * @param underlying Underlying (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsUnderlyingTickersAsync(String underlying, final ApiCallback<OptionsUnderlyingTicker> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsUnderlyingTickersValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<OptionsUnderlyingTicker>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listOptionsCandlesticksCall(String contract, Integer limit, Long from, Long to, String interval, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/candlesticks";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsCandlesticksValidateBeforeCall(String contract, Integer limit, Long from, Long to, String interval, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listOptionsCandlesticks(Async)");
        }

        okhttp3.Call localVarCall = listOptionsCandlesticksCall(contract, limit, from, to, interval, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsCandlestick>> listOptionsCandlesticksWithHttpInfo(String contract, Integer limit, Long from, Long to, String interval) throws ApiException {
        okhttp3.Call localVarCall = listOptionsCandlesticksValidateBeforeCall(contract, limit, from, to, interval, null);
        Type localVarReturnType = new TypeToken<List<OptionsCandlestick>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsCandlesticksAsync(String contract, Integer limit, Long from, Long to, String interval, final ApiCallback<List<OptionsCandlestick>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsCandlesticksValidateBeforeCall(contract, limit, from, to, interval, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsCandlestick>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsCandlesticksRequest {
        private final String contract;
        private Integer limit;
        private Long from;
        private Long to;
        private String interval;

        private APIlistOptionsCandlesticksRequest(String contract) {
            this.contract = contract;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistOptionsCandlesticksRequest
         */
        public APIlistOptionsCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistOptionsCandlesticksRequest
         */
        public APIlistOptionsCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistOptionsCandlesticksRequest
         */
        public APIlistOptionsCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set interval
         * @param interval Interval time between data points (optional, default to 5m)
         * @return APIlistOptionsCandlesticksRequest
         */
        public APIlistOptionsCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Build call for listOptionsCandlesticks
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsCandlesticksCall(contract, limit, from, to, interval, _callback);
        }

        /**
         * Execute listOptionsCandlesticks request
         * @return List&lt;OptionsCandlestick&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsCandlestick> execute() throws ApiException {
            ApiResponse<List<OptionsCandlestick>> localVarResp = listOptionsCandlesticksWithHttpInfo(contract, limit, from, to, interval);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsCandlesticks request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsCandlestick&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsCandlestick>> executeWithHttpInfo() throws ApiException {
            return listOptionsCandlesticksWithHttpInfo(contract, limit, from, to, interval);
        }

        /**
         * Execute listOptionsCandlesticks request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsCandlestick>> _callback) throws ApiException {
            return listOptionsCandlesticksAsync(contract, limit, from, to, interval, _callback);
        }
    }

    /**
     * Get options candlesticks
     * 
     * @param contract Options contract name (required)
     * @return APIlistOptionsCandlesticksRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsCandlesticksRequest listOptionsCandlesticks(String contract) {
        return new APIlistOptionsCandlesticksRequest(contract);
    }

    private okhttp3.Call listOptionsUnderlyingCandlesticksCall(String underlying, Integer limit, Long from, Long to, String interval, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/underlying/candlesticks";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsUnderlyingCandlesticksValidateBeforeCall(String underlying, Integer limit, Long from, Long to, String interval, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsUnderlyingCandlesticks(Async)");
        }

        okhttp3.Call localVarCall = listOptionsUnderlyingCandlesticksCall(underlying, limit, from, to, interval, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesCandlestick>> listOptionsUnderlyingCandlesticksWithHttpInfo(String underlying, Integer limit, Long from, Long to, String interval) throws ApiException {
        okhttp3.Call localVarCall = listOptionsUnderlyingCandlesticksValidateBeforeCall(underlying, limit, from, to, interval, null);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsUnderlyingCandlesticksAsync(String underlying, Integer limit, Long from, Long to, String interval, final ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsUnderlyingCandlesticksValidateBeforeCall(underlying, limit, from, to, interval, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsUnderlyingCandlesticksRequest {
        private final String underlying;
        private Integer limit;
        private Long from;
        private Long to;
        private String interval;

        private APIlistOptionsUnderlyingCandlesticksRequest(String underlying) {
            this.underlying = underlying;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistOptionsUnderlyingCandlesticksRequest
         */
        public APIlistOptionsUnderlyingCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistOptionsUnderlyingCandlesticksRequest
         */
        public APIlistOptionsUnderlyingCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistOptionsUnderlyingCandlesticksRequest
         */
        public APIlistOptionsUnderlyingCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set interval
         * @param interval Interval time between data points (optional, default to 5m)
         * @return APIlistOptionsUnderlyingCandlesticksRequest
         */
        public APIlistOptionsUnderlyingCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Build call for listOptionsUnderlyingCandlesticks
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsUnderlyingCandlesticksCall(underlying, limit, from, to, interval, _callback);
        }

        /**
         * Execute listOptionsUnderlyingCandlesticks request
         * @return List&lt;FuturesCandlestick&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesCandlestick> execute() throws ApiException {
            ApiResponse<List<FuturesCandlestick>> localVarResp = listOptionsUnderlyingCandlesticksWithHttpInfo(underlying, limit, from, to, interval);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsUnderlyingCandlesticks request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesCandlestick&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesCandlestick>> executeWithHttpInfo() throws ApiException {
            return listOptionsUnderlyingCandlesticksWithHttpInfo(underlying, limit, from, to, interval);
        }

        /**
         * Execute listOptionsUnderlyingCandlesticks request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
            return listOptionsUnderlyingCandlesticksAsync(underlying, limit, from, to, interval, _callback);
        }
    }

    /**
     * Mark price candlesticks of an underlying
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return APIlistOptionsUnderlyingCandlesticksRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsUnderlyingCandlesticksRequest listOptionsUnderlyingCandlesticks(String underlying) {
        return new APIlistOptionsUnderlyingCandlesticksRequest(underlying);
    }

    private okhttp3.Call listOptionsTradesCall(String contract, String type, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/trades";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsTradesValidateBeforeCall(String contract, String type, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsTradesCall(contract, type, limit, offset, from, to, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesTrade>> listOptionsTradesWithHttpInfo(String contract, String type, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        okhttp3.Call localVarCall = listOptionsTradesValidateBeforeCall(contract, type, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsTradesAsync(String contract, String type, Integer limit, Integer offset, Long from, Long to, final ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsTradesValidateBeforeCall(contract, type, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsTradesRequest {
        private String contract;
        private String type;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistOptionsTradesRequest() {
        }

        /**
         * Set contract
         * @param contract Options contract name (optional)
         * @return APIlistOptionsTradesRequest
         */
        public APIlistOptionsTradesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set type
         * @param type &#x60;C&#x60; is call, while &#x60;P&#x60; is put (optional)
         * @return APIlistOptionsTradesRequest
         */
        public APIlistOptionsTradesRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistOptionsTradesRequest
         */
        public APIlistOptionsTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistOptionsTradesRequest
         */
        public APIlistOptionsTradesRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistOptionsTradesRequest
         */
        public APIlistOptionsTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistOptionsTradesRequest
         */
        public APIlistOptionsTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Build call for listOptionsTrades
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsTradesCall(contract, type, limit, offset, from, to, _callback);
        }

        /**
         * Execute listOptionsTrades request
         * @return List&lt;FuturesTrade&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesTrade> execute() throws ApiException {
            ApiResponse<List<FuturesTrade>> localVarResp = listOptionsTradesWithHttpInfo(contract, type, limit, offset, from, to);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsTrades request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesTrade&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesTrade>> executeWithHttpInfo() throws ApiException {
            return listOptionsTradesWithHttpInfo(contract, type, limit, offset, from, to);
        }

        /**
         * Execute listOptionsTrades request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
            return listOptionsTradesAsync(contract, type, limit, offset, from, to, _callback);
        }
    }

    /**
     * Options trade history
     * 
     * @return APIlistOptionsTradesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsTradesRequest listOptionsTrades() {
        return new APIlistOptionsTradesRequest();
    }

    /**
     * Build call for listOptionsAccount
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsAccountCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsAccountValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsAccountCall(_callback);
        return localVarCall;
    }

    /**
     * List options account
     * 
     * @return OptionsAccount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public OptionsAccount listOptionsAccount() throws ApiException {
        ApiResponse<OptionsAccount> localVarResp = listOptionsAccountWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List options account
     * 
     * @return ApiResponse&lt;OptionsAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OptionsAccount> listOptionsAccountWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listOptionsAccountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<OptionsAccount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List options account (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOptionsAccountAsync(final ApiCallback<OptionsAccount> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsAccountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<OptionsAccount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listOptionsAccountBookCall(Integer limit, Integer offset, Long from, Long to, String type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/account_book";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsAccountBookValidateBeforeCall(Integer limit, Integer offset, Long from, Long to, String type, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsAccountBookCall(limit, offset, from, to, type, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsAccountBook>> listOptionsAccountBookWithHttpInfo(Integer limit, Integer offset, Long from, Long to, String type) throws ApiException {
        okhttp3.Call localVarCall = listOptionsAccountBookValidateBeforeCall(limit, offset, from, to, type, null);
        Type localVarReturnType = new TypeToken<List<OptionsAccountBook>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsAccountBookAsync(Integer limit, Integer offset, Long from, Long to, String type, final ApiCallback<List<OptionsAccountBook>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsAccountBookValidateBeforeCall(limit, offset, from, to, type, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsAccountBook>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsAccountBookRequest {
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;
        private String type;

        private APIlistOptionsAccountBookRequest() {
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistOptionsAccountBookRequest
         */
        public APIlistOptionsAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistOptionsAccountBookRequest
         */
        public APIlistOptionsAccountBookRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistOptionsAccountBookRequest
         */
        public APIlistOptionsAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistOptionsAccountBookRequest
         */
        public APIlistOptionsAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set type
         * @param type Changing Type: - dnw: Deposit &amp; Withdraw - prem: Trading premium - fee: Trading fee - refr: Referrer rebate - set: settlement PNL  (optional)
         * @return APIlistOptionsAccountBookRequest
         */
        public APIlistOptionsAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Build call for listOptionsAccountBook
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsAccountBookCall(limit, offset, from, to, type, _callback);
        }

        /**
         * Execute listOptionsAccountBook request
         * @return List&lt;OptionsAccountBook&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsAccountBook> execute() throws ApiException {
            ApiResponse<List<OptionsAccountBook>> localVarResp = listOptionsAccountBookWithHttpInfo(limit, offset, from, to, type);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsAccountBook request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsAccountBook&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsAccountBook>> executeWithHttpInfo() throws ApiException {
            return listOptionsAccountBookWithHttpInfo(limit, offset, from, to, type);
        }

        /**
         * Execute listOptionsAccountBook request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsAccountBook>> _callback) throws ApiException {
            return listOptionsAccountBookAsync(limit, offset, from, to, type, _callback);
        }
    }

    /**
     * List account changing history
     * 
     * @return APIlistOptionsAccountBookRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsAccountBookRequest listOptionsAccountBook() {
        return new APIlistOptionsAccountBookRequest();
    }

    private okhttp3.Call listOptionsPositionsCall(String underlying, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/positions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsPositionsValidateBeforeCall(String underlying, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsPositionsCall(underlying, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsPosition>> listOptionsPositionsWithHttpInfo(String underlying) throws ApiException {
        okhttp3.Call localVarCall = listOptionsPositionsValidateBeforeCall(underlying, null);
        Type localVarReturnType = new TypeToken<List<OptionsPosition>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsPositionsAsync(String underlying, final ApiCallback<List<OptionsPosition>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsPositionsValidateBeforeCall(underlying, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsPosition>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsPositionsRequest {
        private String underlying;

        private APIlistOptionsPositionsRequest() {
        }

        /**
         * Set underlying
         * @param underlying Underlying (optional)
         * @return APIlistOptionsPositionsRequest
         */
        public APIlistOptionsPositionsRequest underlying(String underlying) {
            this.underlying = underlying;
            return this;
        }

        /**
         * Build call for listOptionsPositions
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsPositionsCall(underlying, _callback);
        }

        /**
         * Execute listOptionsPositions request
         * @return List&lt;OptionsPosition&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsPosition> execute() throws ApiException {
            ApiResponse<List<OptionsPosition>> localVarResp = listOptionsPositionsWithHttpInfo(underlying);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsPositions request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsPosition&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsPosition>> executeWithHttpInfo() throws ApiException {
            return listOptionsPositionsWithHttpInfo(underlying);
        }

        /**
         * Execute listOptionsPositions request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsPosition>> _callback) throws ApiException {
            return listOptionsPositionsAsync(underlying, _callback);
        }
    }

    /**
     * List user&#39;s positions of specified underlying
     * 
     * @return APIlistOptionsPositionsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsPositionsRequest listOptionsPositions() {
        return new APIlistOptionsPositionsRequest();
    }

    /**
     * Build call for getOptionsPosition
     * @param contract  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsPositionCall(String contract, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/positions/{contract}"
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionsPositionValidateBeforeCall(String contract, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getOptionsPosition(Async)");
        }

        okhttp3.Call localVarCall = getOptionsPositionCall(contract, _callback);
        return localVarCall;
    }

    /**
     * Get specified contract position
     * 
     * @param contract  (required)
     * @return OptionsPosition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public OptionsPosition getOptionsPosition(String contract) throws ApiException {
        ApiResponse<OptionsPosition> localVarResp = getOptionsPositionWithHttpInfo(contract);
        return localVarResp.getData();
    }

    /**
     * Get specified contract position
     * 
     * @param contract  (required)
     * @return ApiResponse&lt;OptionsPosition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OptionsPosition> getOptionsPositionWithHttpInfo(String contract) throws ApiException {
        okhttp3.Call localVarCall = getOptionsPositionValidateBeforeCall(contract, null);
        Type localVarReturnType = new TypeToken<OptionsPosition>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get specified contract position (asynchronously)
     * 
     * @param contract  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsPositionAsync(String contract, final ApiCallback<OptionsPosition> _callback) throws ApiException {
        okhttp3.Call localVarCall = getOptionsPositionValidateBeforeCall(contract, _callback);
        Type localVarReturnType = new TypeToken<OptionsPosition>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listOptionsPositionCloseCall(String underlying, String contract, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/position_close";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsPositionCloseValidateBeforeCall(String underlying, String contract, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listOptionsPositionClose(Async)");
        }

        okhttp3.Call localVarCall = listOptionsPositionCloseCall(underlying, contract, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsPositionClose>> listOptionsPositionCloseWithHttpInfo(String underlying, String contract) throws ApiException {
        okhttp3.Call localVarCall = listOptionsPositionCloseValidateBeforeCall(underlying, contract, null);
        Type localVarReturnType = new TypeToken<List<OptionsPositionClose>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsPositionCloseAsync(String underlying, String contract, final ApiCallback<List<OptionsPositionClose>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsPositionCloseValidateBeforeCall(underlying, contract, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsPositionClose>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsPositionCloseRequest {
        private final String underlying;
        private String contract;

        private APIlistOptionsPositionCloseRequest(String underlying) {
            this.underlying = underlying;
        }

        /**
         * Set contract
         * @param contract Options contract name (optional)
         * @return APIlistOptionsPositionCloseRequest
         */
        public APIlistOptionsPositionCloseRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Build call for listOptionsPositionClose
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsPositionCloseCall(underlying, contract, _callback);
        }

        /**
         * Execute listOptionsPositionClose request
         * @return List&lt;OptionsPositionClose&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsPositionClose> execute() throws ApiException {
            ApiResponse<List<OptionsPositionClose>> localVarResp = listOptionsPositionCloseWithHttpInfo(underlying, contract);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsPositionClose request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsPositionClose&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsPositionClose>> executeWithHttpInfo() throws ApiException {
            return listOptionsPositionCloseWithHttpInfo(underlying, contract);
        }

        /**
         * Execute listOptionsPositionClose request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsPositionClose>> _callback) throws ApiException {
            return listOptionsPositionCloseAsync(underlying, contract, _callback);
        }
    }

    /**
     * List user&#39;s liquidation history of specified underlying
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return APIlistOptionsPositionCloseRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsPositionCloseRequest listOptionsPositionClose(String underlying) {
        return new APIlistOptionsPositionCloseRequest(underlying);
    }

    private okhttp3.Call listOptionsOrdersCall(String status, String contract, String underlying, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/orders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOptionsOrdersValidateBeforeCall(String status, String contract, String underlying, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'status' is set
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listOptionsOrders(Async)");
        }

        okhttp3.Call localVarCall = listOptionsOrdersCall(status, contract, underlying, limit, offset, from, to, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsOrder>> listOptionsOrdersWithHttpInfo(String status, String contract, String underlying, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        okhttp3.Call localVarCall = listOptionsOrdersValidateBeforeCall(status, contract, underlying, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<OptionsOrder>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listOptionsOrdersAsync(String status, String contract, String underlying, Integer limit, Integer offset, Long from, Long to, final ApiCallback<List<OptionsOrder>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listOptionsOrdersValidateBeforeCall(status, contract, underlying, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsOrder>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistOptionsOrdersRequest {
        private final String status;
        private String contract;
        private String underlying;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistOptionsOrdersRequest(String status) {
            this.status = status;
        }

        /**
         * Set contract
         * @param contract Options contract name (optional)
         * @return APIlistOptionsOrdersRequest
         */
        public APIlistOptionsOrdersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set underlying
         * @param underlying Underlying (optional)
         * @return APIlistOptionsOrdersRequest
         */
        public APIlistOptionsOrdersRequest underlying(String underlying) {
            this.underlying = underlying;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistOptionsOrdersRequest
         */
        public APIlistOptionsOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistOptionsOrdersRequest
         */
        public APIlistOptionsOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistOptionsOrdersRequest
         */
        public APIlistOptionsOrdersRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistOptionsOrdersRequest
         */
        public APIlistOptionsOrdersRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Build call for listOptionsOrders
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listOptionsOrdersCall(status, contract, underlying, limit, offset, from, to, _callback);
        }

        /**
         * Execute listOptionsOrders request
         * @return List&lt;OptionsOrder&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsOrder> execute() throws ApiException {
            ApiResponse<List<OptionsOrder>> localVarResp = listOptionsOrdersWithHttpInfo(status, contract, underlying, limit, offset, from, to);
            return localVarResp.getData();
        }

        /**
         * Execute listOptionsOrders request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsOrder&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsOrder>> executeWithHttpInfo() throws ApiException {
            return listOptionsOrdersWithHttpInfo(status, contract, underlying, limit, offset, from, to);
        }

        /**
         * Execute listOptionsOrders request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsOrder>> _callback) throws ApiException {
            return listOptionsOrdersAsync(status, contract, underlying, limit, offset, from, to, _callback);
        }
    }

    /**
     * List options orders
     * 
     * @param status Only list the orders with this status (required)
     * @return APIlistOptionsOrdersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistOptionsOrdersRequest listOptionsOrders(String status) {
        return new APIlistOptionsOrdersRequest(status);
    }

    /**
     * Build call for createOptionsOrder
     * @param optionsOrder  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createOptionsOrderCall(OptionsOrder optionsOrder, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = optionsOrder;

        // create path and map variables
        String localVarPath = "/options/orders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createOptionsOrderValidateBeforeCall(OptionsOrder optionsOrder, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'optionsOrder' is set
        if (optionsOrder == null) {
            throw new ApiException("Missing the required parameter 'optionsOrder' when calling createOptionsOrder(Async)");
        }

        okhttp3.Call localVarCall = createOptionsOrderCall(optionsOrder, _callback);
        return localVarCall;
    }

    /**
     * Create an options order
     * 
     * @param optionsOrder  (required)
     * @return OptionsOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public OptionsOrder createOptionsOrder(OptionsOrder optionsOrder) throws ApiException {
        ApiResponse<OptionsOrder> localVarResp = createOptionsOrderWithHttpInfo(optionsOrder);
        return localVarResp.getData();
    }

    /**
     * Create an options order
     * 
     * @param optionsOrder  (required)
     * @return ApiResponse&lt;OptionsOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OptionsOrder> createOptionsOrderWithHttpInfo(OptionsOrder optionsOrder) throws ApiException {
        okhttp3.Call localVarCall = createOptionsOrderValidateBeforeCall(optionsOrder, null);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an options order (asynchronously)
     * 
     * @param optionsOrder  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createOptionsOrderAsync(OptionsOrder optionsOrder, final ApiCallback<OptionsOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = createOptionsOrderValidateBeforeCall(optionsOrder, _callback);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for cancelOptionsOrders
     * @param contract Options contract name (optional)
     * @param underlying Underlying (optional)
     * @param side All bids or asks. Both included if not specified (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All orders matched cancelled </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelOptionsOrdersCall(String contract, String underlying, String side, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/orders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (side != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("side", side));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelOptionsOrdersValidateBeforeCall(String contract, String underlying, String side, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = cancelOptionsOrdersCall(contract, underlying, side, _callback);
        return localVarCall;
    }

    /**
     * Cancel all &#x60;open&#x60; orders matched
     * 
     * @param contract Options contract name (optional)
     * @param underlying Underlying (optional)
     * @param side All bids or asks. Both included if not specified (optional)
     * @return List&lt;OptionsOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All orders matched cancelled </td><td>  -  </td></tr>
     </table>
     */
    public List<OptionsOrder> cancelOptionsOrders(String contract, String underlying, String side) throws ApiException {
        ApiResponse<List<OptionsOrder>> localVarResp = cancelOptionsOrdersWithHttpInfo(contract, underlying, side);
        return localVarResp.getData();
    }

    /**
     * Cancel all &#x60;open&#x60; orders matched
     * 
     * @param contract Options contract name (optional)
     * @param underlying Underlying (optional)
     * @param side All bids or asks. Both included if not specified (optional)
     * @return ApiResponse&lt;List&lt;OptionsOrder&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All orders matched cancelled </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<OptionsOrder>> cancelOptionsOrdersWithHttpInfo(String contract, String underlying, String side) throws ApiException {
        okhttp3.Call localVarCall = cancelOptionsOrdersValidateBeforeCall(contract, underlying, side, null);
        Type localVarReturnType = new TypeToken<List<OptionsOrder>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cancel all &#x60;open&#x60; orders matched (asynchronously)
     * 
     * @param contract Options contract name (optional)
     * @param underlying Underlying (optional)
     * @param side All bids or asks. Both included if not specified (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All orders matched cancelled </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelOptionsOrdersAsync(String contract, String underlying, String side, final ApiCallback<List<OptionsOrder>> _callback) throws ApiException {
        okhttp3.Call localVarCall = cancelOptionsOrdersValidateBeforeCall(contract, underlying, side, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsOrder>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getOptionsOrder
     * @param orderId Order ID returned on successful order creation (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsOrderCall(Long orderId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/orders/{order_id}"
            .replaceAll("\\{" + "order_id" + "\\}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOptionsOrderValidateBeforeCall(Long orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOptionsOrder(Async)");
        }

        okhttp3.Call localVarCall = getOptionsOrderCall(orderId, _callback);
        return localVarCall;
    }

    /**
     * Get a single order
     * 
     * @param orderId Order ID returned on successful order creation (required)
     * @return OptionsOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public OptionsOrder getOptionsOrder(Long orderId) throws ApiException {
        ApiResponse<OptionsOrder> localVarResp = getOptionsOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    /**
     * Get a single order
     * 
     * @param orderId Order ID returned on successful order creation (required)
     * @return ApiResponse&lt;OptionsOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OptionsOrder> getOptionsOrderWithHttpInfo(Long orderId) throws ApiException {
        okhttp3.Call localVarCall = getOptionsOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a single order (asynchronously)
     * 
     * @param orderId Order ID returned on successful order creation (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOptionsOrderAsync(Long orderId, final ApiCallback<OptionsOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = getOptionsOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for cancelOptionsOrder
     * @param orderId Order ID returned on successful order creation (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelOptionsOrderCall(Long orderId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/orders/{order_id}"
            .replaceAll("\\{" + "order_id" + "\\}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelOptionsOrderValidateBeforeCall(Long orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelOptionsOrder(Async)");
        }

        okhttp3.Call localVarCall = cancelOptionsOrderCall(orderId, _callback);
        return localVarCall;
    }

    /**
     * Cancel a single order
     * 
     * @param orderId Order ID returned on successful order creation (required)
     * @return OptionsOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public OptionsOrder cancelOptionsOrder(Long orderId) throws ApiException {
        ApiResponse<OptionsOrder> localVarResp = cancelOptionsOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    /**
     * Cancel a single order
     * 
     * @param orderId Order ID returned on successful order creation (required)
     * @return ApiResponse&lt;OptionsOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<OptionsOrder> cancelOptionsOrderWithHttpInfo(Long orderId) throws ApiException {
        okhttp3.Call localVarCall = cancelOptionsOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cancel a single order (asynchronously)
     * 
     * @param orderId Order ID returned on successful order creation (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelOptionsOrderAsync(Long orderId, final ApiCallback<OptionsOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = cancelOptionsOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<OptionsOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listMyOptionsTradesCall(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/options/my_trades";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (underlying != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("underlying", underlying));
        }

        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMyOptionsTradesValidateBeforeCall(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'underlying' is set
        if (underlying == null) {
            throw new ApiException("Missing the required parameter 'underlying' when calling listMyOptionsTrades(Async)");
        }

        okhttp3.Call localVarCall = listMyOptionsTradesCall(underlying, contract, limit, offset, from, to, _callback);
        return localVarCall;
    }


    private ApiResponse<List<OptionsMyTrade>> listMyOptionsTradesWithHttpInfo(String underlying, String contract, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        okhttp3.Call localVarCall = listMyOptionsTradesValidateBeforeCall(underlying, contract, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<OptionsMyTrade>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listMyOptionsTradesAsync(String underlying, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback<List<OptionsMyTrade>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listMyOptionsTradesValidateBeforeCall(underlying, contract, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<OptionsMyTrade>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistMyOptionsTradesRequest {
        private final String underlying;
        private String contract;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistMyOptionsTradesRequest(String underlying) {
            this.underlying = underlying;
        }

        /**
         * Set contract
         * @param contract Options contract name (optional)
         * @return APIlistMyOptionsTradesRequest
         */
        public APIlistMyOptionsTradesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistMyOptionsTradesRequest
         */
        public APIlistMyOptionsTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistMyOptionsTradesRequest
         */
        public APIlistMyOptionsTradesRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistMyOptionsTradesRequest
         */
        public APIlistMyOptionsTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistMyOptionsTradesRequest
         */
        public APIlistMyOptionsTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Build call for listMyOptionsTrades
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listMyOptionsTradesCall(underlying, contract, limit, offset, from, to, _callback);
        }

        /**
         * Execute listMyOptionsTrades request
         * @return List&lt;OptionsMyTrade&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<OptionsMyTrade> execute() throws ApiException {
            ApiResponse<List<OptionsMyTrade>> localVarResp = listMyOptionsTradesWithHttpInfo(underlying, contract, limit, offset, from, to);
            return localVarResp.getData();
        }

        /**
         * Execute listMyOptionsTrades request with HTTP info returned
         * @return ApiResponse&lt;List&lt;OptionsMyTrade&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<OptionsMyTrade>> executeWithHttpInfo() throws ApiException {
            return listMyOptionsTradesWithHttpInfo(underlying, contract, limit, offset, from, to);
        }

        /**
         * Execute listMyOptionsTrades request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<OptionsMyTrade>> _callback) throws ApiException {
            return listMyOptionsTradesAsync(underlying, contract, limit, offset, from, to, _callback);
        }
    }

    /**
     * List personal trading history
     * 
     * @param underlying Underlying (Obtained by listing underlying endpoint) (required)
     * @return APIlistMyOptionsTradesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistMyOptionsTradesRequest listMyOptionsTrades(String underlying) {
        return new APIlistMyOptionsTradesRequest(underlying);
    }

}
