/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.CreateUniLoan;
import io.gate.gateapi.models.MaxUniBorrowable;
import io.gate.gateapi.models.UniCurrencyPair;
import io.gate.gateapi.models.UniLoan;
import io.gate.gateapi.models.UniLoanInterestRecord;
import io.gate.gateapi.models.UniLoanRecord;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarginUniApi {
    private ApiClient localVarApiClient;

    public MarginUniApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MarginUniApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for listUniCurrencyPairs
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUniCurrencyPairsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/uni/currency_pairs";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUniCurrencyPairsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniCurrencyPairsCall(_callback);
        return localVarCall;
    }

    /**
     * List lending markets
     * 
     * @return List&lt;UniCurrencyPair&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<UniCurrencyPair> listUniCurrencyPairs() throws ApiException {
        ApiResponse<List<UniCurrencyPair>> localVarResp = listUniCurrencyPairsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List lending markets
     * 
     * @return ApiResponse&lt;List&lt;UniCurrencyPair&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<UniCurrencyPair>> listUniCurrencyPairsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listUniCurrencyPairsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<UniCurrencyPair>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List lending markets (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUniCurrencyPairsAsync(final ApiCallback<List<UniCurrencyPair>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniCurrencyPairsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<UniCurrencyPair>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniCurrencyPair
     * @param currencyPair Currency pair (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUniCurrencyPairCall(String currencyPair, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/uni/currency_pairs/{currency_pair}"
            .replaceAll("\\{" + "currency_pair" + "\\}", localVarApiClient.escapeString(currencyPair));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniCurrencyPairValidateBeforeCall(String currencyPair, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currencyPair' is set
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getUniCurrencyPair(Async)");
        }

        okhttp3.Call localVarCall = getUniCurrencyPairCall(currencyPair, _callback);
        return localVarCall;
    }

    /**
     * Get detail of lending market
     * 
     * @param currencyPair Currency pair (required)
     * @return UniCurrencyPair
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public UniCurrencyPair getUniCurrencyPair(String currencyPair) throws ApiException {
        ApiResponse<UniCurrencyPair> localVarResp = getUniCurrencyPairWithHttpInfo(currencyPair);
        return localVarResp.getData();
    }

    /**
     * Get detail of lending market
     * 
     * @param currencyPair Currency pair (required)
     * @return ApiResponse&lt;UniCurrencyPair&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UniCurrencyPair> getUniCurrencyPairWithHttpInfo(String currencyPair) throws ApiException {
        okhttp3.Call localVarCall = getUniCurrencyPairValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<UniCurrencyPair>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get detail of lending market (asynchronously)
     * 
     * @param currencyPair Currency pair (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUniCurrencyPairAsync(String currencyPair, final ApiCallback<UniCurrencyPair> _callback) throws ApiException {
        okhttp3.Call localVarCall = getUniCurrencyPairValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<UniCurrencyPair>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listUniLoansCall(String currencyPair, String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/uni/loans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUniLoansValidateBeforeCall(String currencyPair, String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniLoansCall(currencyPair, currency, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<UniLoan>> listUniLoansWithHttpInfo(String currencyPair, String currency, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listUniLoansValidateBeforeCall(currencyPair, currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLoan>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUniLoansAsync(String currencyPair, String currency, Integer page, Integer limit, final ApiCallback<List<UniLoan>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniLoansValidateBeforeCall(currencyPair, currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoan>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUniLoansRequest {
        private String currencyPair;
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistUniLoansRequest() {
        }

        /**
         * Set currencyPair
         * @param currencyPair Currency pair (optional)
         * @return APIlistUniLoansRequest
         */
        public APIlistUniLoansRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistUniLoansRequest
         */
        public APIlistUniLoansRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistUniLoansRequest
         */
        public APIlistUniLoansRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum response items.  Default: 100, minimum: 1, Maximum: 100 (optional, default to 100)
         * @return APIlistUniLoansRequest
         */
        public APIlistUniLoansRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listUniLoans
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUniLoansCall(currencyPair, currency, page, limit, _callback);
        }

        /**
         * Execute listUniLoans request
         * @return List&lt;UniLoan&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<UniLoan> execute() throws ApiException {
            ApiResponse<List<UniLoan>> localVarResp = listUniLoansWithHttpInfo(currencyPair, currency, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listUniLoans request with HTTP info returned
         * @return ApiResponse&lt;List&lt;UniLoan&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<UniLoan>> executeWithHttpInfo() throws ApiException {
            return listUniLoansWithHttpInfo(currencyPair, currency, page, limit);
        }

        /**
         * Execute listUniLoans request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<UniLoan>> _callback) throws ApiException {
            return listUniLoansAsync(currencyPair, currency, page, limit, _callback);
        }
    }

    /**
     * List loans
     * 
     * @return APIlistUniLoansRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUniLoansRequest listUniLoans() {
        return new APIlistUniLoansRequest();
    }

    /**
     * Build call for createUniLoan
     * @param createUniLoan  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Operated successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUniLoanCall(CreateUniLoan createUniLoan, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createUniLoan;

        // create path and map variables
        String localVarPath = "/margin/uni/loans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createUniLoanValidateBeforeCall(CreateUniLoan createUniLoan, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'createUniLoan' is set
        if (createUniLoan == null) {
            throw new ApiException("Missing the required parameter 'createUniLoan' when calling createUniLoan(Async)");
        }

        okhttp3.Call localVarCall = createUniLoanCall(createUniLoan, _callback);
        return localVarCall;
    }

    /**
     * Borrow or repay
     * 
     * @param createUniLoan  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Operated successfully </td><td>  -  </td></tr>
     </table>
     */
    public void createUniLoan(CreateUniLoan createUniLoan) throws ApiException {
        createUniLoanWithHttpInfo(createUniLoan);
    }

    /**
     * Borrow or repay
     * 
     * @param createUniLoan  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Operated successfully </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createUniLoanWithHttpInfo(CreateUniLoan createUniLoan) throws ApiException {
        okhttp3.Call localVarCall = createUniLoanValidateBeforeCall(createUniLoan, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Borrow or repay (asynchronously)
     * 
     * @param createUniLoan  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Operated successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUniLoanAsync(CreateUniLoan createUniLoan, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = createUniLoanValidateBeforeCall(createUniLoan, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private okhttp3.Call listUniLoanRecordsCall(String type, String currency, String currencyPair, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/uni/loan_records";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUniLoanRecordsValidateBeforeCall(String type, String currency, String currencyPair, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniLoanRecordsCall(type, currency, currencyPair, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<UniLoanRecord>> listUniLoanRecordsWithHttpInfo(String type, String currency, String currencyPair, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listUniLoanRecordsValidateBeforeCall(type, currency, currencyPair, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLoanRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUniLoanRecordsAsync(String type, String currency, String currencyPair, Integer page, Integer limit, final ApiCallback<List<UniLoanRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniLoanRecordsValidateBeforeCall(type, currency, currencyPair, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoanRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUniLoanRecordsRequest {
        private String type;
        private String currency;
        private String currencyPair;
        private Integer page;
        private Integer limit;

        private APIlistUniLoanRecordsRequest() {
        }

        /**
         * Set type
         * @param type type: borrow - borrow, repay - repay (optional)
         * @return APIlistUniLoanRecordsRequest
         */
        public APIlistUniLoanRecordsRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistUniLoanRecordsRequest
         */
        public APIlistUniLoanRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set currencyPair
         * @param currencyPair Currency pair (optional)
         * @return APIlistUniLoanRecordsRequest
         */
        public APIlistUniLoanRecordsRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistUniLoanRecordsRequest
         */
        public APIlistUniLoanRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum response items.  Default: 100, minimum: 1, Maximum: 100 (optional, default to 100)
         * @return APIlistUniLoanRecordsRequest
         */
        public APIlistUniLoanRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listUniLoanRecords
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUniLoanRecordsCall(type, currency, currencyPair, page, limit, _callback);
        }

        /**
         * Execute listUniLoanRecords request
         * @return List&lt;UniLoanRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<UniLoanRecord> execute() throws ApiException {
            ApiResponse<List<UniLoanRecord>> localVarResp = listUniLoanRecordsWithHttpInfo(type, currency, currencyPair, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listUniLoanRecords request with HTTP info returned
         * @return ApiResponse&lt;List&lt;UniLoanRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<UniLoanRecord>> executeWithHttpInfo() throws ApiException {
            return listUniLoanRecordsWithHttpInfo(type, currency, currencyPair, page, limit);
        }

        /**
         * Execute listUniLoanRecords request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<UniLoanRecord>> _callback) throws ApiException {
            return listUniLoanRecordsAsync(type, currency, currencyPair, page, limit, _callback);
        }
    }

    /**
     * Get load records
     * 
     * @return APIlistUniLoanRecordsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUniLoanRecordsRequest listUniLoanRecords() {
        return new APIlistUniLoanRecordsRequest();
    }

    private okhttp3.Call listUniLoanInterestRecordsCall(String currencyPair, String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/uni/interest_records";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUniLoanInterestRecordsValidateBeforeCall(String currencyPair, String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniLoanInterestRecordsCall(currencyPair, currency, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<UniLoanInterestRecord>> listUniLoanInterestRecordsWithHttpInfo(String currencyPair, String currency, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listUniLoanInterestRecordsValidateBeforeCall(currencyPair, currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUniLoanInterestRecordsAsync(String currencyPair, String currency, Integer page, Integer limit, final ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniLoanInterestRecordsValidateBeforeCall(currencyPair, currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUniLoanInterestRecordsRequest {
        private String currencyPair;
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistUniLoanInterestRecordsRequest() {
        }

        /**
         * Set currencyPair
         * @param currencyPair Currency pair (optional)
         * @return APIlistUniLoanInterestRecordsRequest
         */
        public APIlistUniLoanInterestRecordsRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistUniLoanInterestRecordsRequest
         */
        public APIlistUniLoanInterestRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistUniLoanInterestRecordsRequest
         */
        public APIlistUniLoanInterestRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum response items.  Default: 100, minimum: 1, Maximum: 100 (optional, default to 100)
         * @return APIlistUniLoanInterestRecordsRequest
         */
        public APIlistUniLoanInterestRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listUniLoanInterestRecords
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUniLoanInterestRecordsCall(currencyPair, currency, page, limit, _callback);
        }

        /**
         * Execute listUniLoanInterestRecords request
         * @return List&lt;UniLoanInterestRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<UniLoanInterestRecord> execute() throws ApiException {
            ApiResponse<List<UniLoanInterestRecord>> localVarResp = listUniLoanInterestRecordsWithHttpInfo(currencyPair, currency, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listUniLoanInterestRecords request with HTTP info returned
         * @return ApiResponse&lt;List&lt;UniLoanInterestRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<UniLoanInterestRecord>> executeWithHttpInfo() throws ApiException {
            return listUniLoanInterestRecordsWithHttpInfo(currencyPair, currency, page, limit);
        }

        /**
         * Execute listUniLoanInterestRecords request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
            return listUniLoanInterestRecordsAsync(currencyPair, currency, page, limit, _callback);
        }
    }

    /**
     * List interest records
     * 
     * @return APIlistUniLoanInterestRecordsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUniLoanInterestRecordsRequest listUniLoanInterestRecords() {
        return new APIlistUniLoanInterestRecordsRequest();
    }

    /**
     * Build call for getUniBorrowable
     * @param currency Retrieve data of the specified currency (required)
     * @param currencyPair Currency pair (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUniBorrowableCall(String currency, String currencyPair, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/uni/borrowable";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniBorrowableValidateBeforeCall(String currency, String currencyPair, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUniBorrowable(Async)");
        }

        // verify the required parameter 'currencyPair' is set
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getUniBorrowable(Async)");
        }

        okhttp3.Call localVarCall = getUniBorrowableCall(currency, currencyPair, _callback);
        return localVarCall;
    }

    /**
     * Get maximum borrowable
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param currencyPair Currency pair (required)
     * @return MaxUniBorrowable
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public MaxUniBorrowable getUniBorrowable(String currency, String currencyPair) throws ApiException {
        ApiResponse<MaxUniBorrowable> localVarResp = getUniBorrowableWithHttpInfo(currency, currencyPair);
        return localVarResp.getData();
    }

    /**
     * Get maximum borrowable
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param currencyPair Currency pair (required)
     * @return ApiResponse&lt;MaxUniBorrowable&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MaxUniBorrowable> getUniBorrowableWithHttpInfo(String currency, String currencyPair) throws ApiException {
        okhttp3.Call localVarCall = getUniBorrowableValidateBeforeCall(currency, currencyPair, null);
        Type localVarReturnType = new TypeToken<MaxUniBorrowable>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get maximum borrowable (asynchronously)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param currencyPair Currency pair (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUniBorrowableAsync(String currency, String currencyPair, final ApiCallback<MaxUniBorrowable> _callback) throws ApiException {
        okhttp3.Call localVarCall = getUniBorrowableValidateBeforeCall(currency, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MaxUniBorrowable>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

}
