/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.AutoRepaySetting;
import io.gate.gateapi.models.CrossMarginAccount;
import io.gate.gateapi.models.CrossMarginAccountBook;
import io.gate.gateapi.models.CrossMarginBorrowable;
import io.gate.gateapi.models.CrossMarginCurrency;
import io.gate.gateapi.models.CrossMarginLoan;
import io.gate.gateapi.models.CrossMarginRepayRequest;
import io.gate.gateapi.models.CrossMarginRepayment;
import io.gate.gateapi.models.CrossMarginTransferable;
import io.gate.gateapi.models.FundingAccount;
import io.gate.gateapi.models.FundingBookItem;
import io.gate.gateapi.models.Loan;
import io.gate.gateapi.models.LoanPatch;
import io.gate.gateapi.models.LoanRecord;
import io.gate.gateapi.models.MarginAccount;
import io.gate.gateapi.models.MarginAccountBook;
import io.gate.gateapi.models.MarginBorrowable;
import io.gate.gateapi.models.MarginCurrencyPair;
import io.gate.gateapi.models.MarginTransferable;
import io.gate.gateapi.models.RepayRequest;
import io.gate.gateapi.models.Repayment;
import io.gate.gateapi.models.UniLoanInterestRecord;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MarginApi {
    private ApiClient localVarApiClient;

    public MarginApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MarginApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private okhttp3.Call listMarginAccountsCall(String currencyPair, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMarginAccountsValidateBeforeCall(String currencyPair, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listMarginAccountsCall(currencyPair, _callback);
        return localVarCall;
    }


    private ApiResponse<List<MarginAccount>> listMarginAccountsWithHttpInfo(String currencyPair) throws ApiException {
        okhttp3.Call localVarCall = listMarginAccountsValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<List<MarginAccount>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listMarginAccountsAsync(String currencyPair, final ApiCallback<List<MarginAccount>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listMarginAccountsValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<List<MarginAccount>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistMarginAccountsRequest {
        private String currencyPair;

        private APIlistMarginAccountsRequest() {
        }

        /**
         * Set currencyPair
         * @param currencyPair Currency pair (optional)
         * @return APIlistMarginAccountsRequest
         */
        public APIlistMarginAccountsRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Build call for listMarginAccounts
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listMarginAccountsCall(currencyPair, _callback);
        }

        /**
         * Execute listMarginAccounts request
         * @return List&lt;MarginAccount&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<MarginAccount> execute() throws ApiException {
            ApiResponse<List<MarginAccount>> localVarResp = listMarginAccountsWithHttpInfo(currencyPair);
            return localVarResp.getData();
        }

        /**
         * Execute listMarginAccounts request with HTTP info returned
         * @return ApiResponse&lt;List&lt;MarginAccount&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<MarginAccount>> executeWithHttpInfo() throws ApiException {
            return listMarginAccountsWithHttpInfo(currencyPair);
        }

        /**
         * Execute listMarginAccounts request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<MarginAccount>> _callback) throws ApiException {
            return listMarginAccountsAsync(currencyPair, _callback);
        }
    }

    /**
     * Margin account list
     * 
     * @return APIlistMarginAccountsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistMarginAccountsRequest listMarginAccounts() {
        return new APIlistMarginAccountsRequest();
    }

    private okhttp3.Call listMarginAccountBookCall(String currency, String currencyPair, Long from, Long to, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/account_book";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMarginAccountBookValidateBeforeCall(String currency, String currencyPair, Long from, Long to, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listMarginAccountBookCall(currency, currencyPair, from, to, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<MarginAccountBook>> listMarginAccountBookWithHttpInfo(String currency, String currencyPair, Long from, Long to, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listMarginAccountBookValidateBeforeCall(currency, currencyPair, from, to, page, limit, null);
        Type localVarReturnType = new TypeToken<List<MarginAccountBook>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listMarginAccountBookAsync(String currency, String currencyPair, Long from, Long to, Integer page, Integer limit, final ApiCallback<List<MarginAccountBook>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listMarginAccountBookValidateBeforeCall(currency, currencyPair, from, to, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<MarginAccountBook>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistMarginAccountBookRequest {
        private String currency;
        private String currencyPair;
        private Long from;
        private Long to;
        private Integer page;
        private Integer limit;

        private APIlistMarginAccountBookRequest() {
        }

        /**
         * Set currency
         * @param currency List records related to specified currency only. If specified, &#x60;currency_pair&#x60; is also required. (optional)
         * @return APIlistMarginAccountBookRequest
         */
        public APIlistMarginAccountBookRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set currencyPair
         * @param currencyPair List records related to specified currency pair. Used in combination with &#x60;currency&#x60;. Ignored if &#x60;currency&#x60; is not provided (optional)
         * @return APIlistMarginAccountBookRequest
         */
        public APIlistMarginAccountBookRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp of the query (optional)
         * @return APIlistMarginAccountBookRequest
         */
        public APIlistMarginAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to Time range ending, default to current time (optional)
         * @return APIlistMarginAccountBookRequest
         */
        public APIlistMarginAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistMarginAccountBookRequest
         */
        public APIlistMarginAccountBookRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistMarginAccountBookRequest
         */
        public APIlistMarginAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listMarginAccountBook
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listMarginAccountBookCall(currency, currencyPair, from, to, page, limit, _callback);
        }

        /**
         * Execute listMarginAccountBook request
         * @return List&lt;MarginAccountBook&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<MarginAccountBook> execute() throws ApiException {
            ApiResponse<List<MarginAccountBook>> localVarResp = listMarginAccountBookWithHttpInfo(currency, currencyPair, from, to, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listMarginAccountBook request with HTTP info returned
         * @return ApiResponse&lt;List&lt;MarginAccountBook&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<MarginAccountBook>> executeWithHttpInfo() throws ApiException {
            return listMarginAccountBookWithHttpInfo(currency, currencyPair, from, to, page, limit);
        }

        /**
         * Execute listMarginAccountBook request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<MarginAccountBook>> _callback) throws ApiException {
            return listMarginAccountBookAsync(currency, currencyPair, from, to, page, limit, _callback);
        }
    }

    /**
     * List margin account balance change history
     * Only transferals from and to margin account are provided for now. Time range allows 30 days at most
     * @return APIlistMarginAccountBookRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistMarginAccountBookRequest listMarginAccountBook() {
        return new APIlistMarginAccountBookRequest();
    }

    private okhttp3.Call listFundingAccountsCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/funding_accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFundingAccountsValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listFundingAccountsCall(currency, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FundingAccount>> listFundingAccountsWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = listFundingAccountsValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<FundingAccount>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFundingAccountsAsync(String currency, final ApiCallback<List<FundingAccount>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFundingAccountsValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<FundingAccount>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFundingAccountsRequest {
        private String currency;

        private APIlistFundingAccountsRequest() {
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistFundingAccountsRequest
         */
        public APIlistFundingAccountsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Build call for listFundingAccounts
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFundingAccountsCall(currency, _callback);
        }

        /**
         * Execute listFundingAccounts request
         * @return List&lt;FundingAccount&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FundingAccount> execute() throws ApiException {
            ApiResponse<List<FundingAccount>> localVarResp = listFundingAccountsWithHttpInfo(currency);
            return localVarResp.getData();
        }

        /**
         * Execute listFundingAccounts request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FundingAccount&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FundingAccount>> executeWithHttpInfo() throws ApiException {
            return listFundingAccountsWithHttpInfo(currency);
        }

        /**
         * Execute listFundingAccounts request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FundingAccount>> _callback) throws ApiException {
            return listFundingAccountsAsync(currency, _callback);
        }
    }

    /**
     * Funding account list
     * 
     * @return APIlistFundingAccountsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFundingAccountsRequest listFundingAccounts() {
        return new APIlistFundingAccountsRequest();
    }

    /**
     * Build call for getAutoRepayStatus
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Current auto repayment setting </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAutoRepayStatusCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/auto_repay";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAutoRepayStatusValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = getAutoRepayStatusCall(_callback);
        return localVarCall;
    }

    /**
     * Retrieve user auto repayment setting
     * 
     * @return AutoRepaySetting
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Current auto repayment setting </td><td>  -  </td></tr>
     </table>
     */
    public AutoRepaySetting getAutoRepayStatus() throws ApiException {
        ApiResponse<AutoRepaySetting> localVarResp = getAutoRepayStatusWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Retrieve user auto repayment setting
     * 
     * @return ApiResponse&lt;AutoRepaySetting&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Current auto repayment setting </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AutoRepaySetting> getAutoRepayStatusWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getAutoRepayStatusValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve user auto repayment setting (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Current auto repayment setting </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAutoRepayStatusAsync(final ApiCallback<AutoRepaySetting> _callback) throws ApiException {
        okhttp3.Call localVarCall = getAutoRepayStatusValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for setAutoRepay
     * @param status New auto repayment status. &#x60;on&#x60; - enabled, &#x60;off&#x60; - disabled (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Current auto repayment setting </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setAutoRepayCall(String status, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/auto_repay";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setAutoRepayValidateBeforeCall(String status, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'status' is set
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling setAutoRepay(Async)");
        }

        okhttp3.Call localVarCall = setAutoRepayCall(status, _callback);
        return localVarCall;
    }

    /**
     * Update user&#39;s auto repayment setting
     * 
     * @param status New auto repayment status. &#x60;on&#x60; - enabled, &#x60;off&#x60; - disabled (required)
     * @return AutoRepaySetting
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Current auto repayment setting </td><td>  -  </td></tr>
     </table>
     */
    public AutoRepaySetting setAutoRepay(String status) throws ApiException {
        ApiResponse<AutoRepaySetting> localVarResp = setAutoRepayWithHttpInfo(status);
        return localVarResp.getData();
    }

    /**
     * Update user&#39;s auto repayment setting
     * 
     * @param status New auto repayment status. &#x60;on&#x60; - enabled, &#x60;off&#x60; - disabled (required)
     * @return ApiResponse&lt;AutoRepaySetting&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Current auto repayment setting </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AutoRepaySetting> setAutoRepayWithHttpInfo(String status) throws ApiException {
        okhttp3.Call localVarCall = setAutoRepayValidateBeforeCall(status, null);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update user&#39;s auto repayment setting (asynchronously)
     * 
     * @param status New auto repayment status. &#x60;on&#x60; - enabled, &#x60;off&#x60; - disabled (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Current auto repayment setting </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setAutoRepayAsync(String status, final ApiCallback<AutoRepaySetting> _callback) throws ApiException {
        okhttp3.Call localVarCall = setAutoRepayValidateBeforeCall(status, _callback);
        Type localVarReturnType = new TypeToken<AutoRepaySetting>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call getMarginTransferableCall(String currency, String currencyPair, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/transferable";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarginTransferableValidateBeforeCall(String currency, String currencyPair, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getMarginTransferable(Async)");
        }

        okhttp3.Call localVarCall = getMarginTransferableCall(currency, currencyPair, _callback);
        return localVarCall;
    }


    private ApiResponse<MarginTransferable> getMarginTransferableWithHttpInfo(String currency, String currencyPair) throws ApiException {
        okhttp3.Call localVarCall = getMarginTransferableValidateBeforeCall(currency, currencyPair, null);
        Type localVarReturnType = new TypeToken<MarginTransferable>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getMarginTransferableAsync(String currency, String currencyPair, final ApiCallback<MarginTransferable> _callback) throws ApiException {
        okhttp3.Call localVarCall = getMarginTransferableValidateBeforeCall(currency, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MarginTransferable>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetMarginTransferableRequest {
        private final String currency;
        private String currencyPair;

        private APIgetMarginTransferableRequest(String currency) {
            this.currency = currency;
        }

        /**
         * Set currencyPair
         * @param currencyPair Currency pair (optional)
         * @return APIgetMarginTransferableRequest
         */
        public APIgetMarginTransferableRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Build call for getMarginTransferable
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getMarginTransferableCall(currency, currencyPair, _callback);
        }

        /**
         * Execute getMarginTransferable request
         * @return MarginTransferable
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public MarginTransferable execute() throws ApiException {
            ApiResponse<MarginTransferable> localVarResp = getMarginTransferableWithHttpInfo(currency, currencyPair);
            return localVarResp.getData();
        }

        /**
         * Execute getMarginTransferable request with HTTP info returned
         * @return ApiResponse&lt;MarginTransferable&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<MarginTransferable> executeWithHttpInfo() throws ApiException {
            return getMarginTransferableWithHttpInfo(currency, currencyPair);
        }

        /**
         * Execute getMarginTransferable request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<MarginTransferable> _callback) throws ApiException {
            return getMarginTransferableAsync(currency, currencyPair, _callback);
        }
    }

    /**
     * Get the max transferable amount for a specific margin currency
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @return APIgetMarginTransferableRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIgetMarginTransferableRequest getMarginTransferable(String currency) {
        return new APIgetMarginTransferableRequest(currency);
    }

    /**
     * Build call for listMarginCurrencyPairs
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMarginCurrencyPairsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/currency_pairs";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listMarginCurrencyPairsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listMarginCurrencyPairsCall(_callback);
        return localVarCall;
    }

    /**
     * List all supported currency pairs supported in margin trading(Deprecated)
     * 
     * @return List&lt;MarginCurrencyPair&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<MarginCurrencyPair> listMarginCurrencyPairs() throws ApiException {
        ApiResponse<List<MarginCurrencyPair>> localVarResp = listMarginCurrencyPairsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List all supported currency pairs supported in margin trading(Deprecated)
     * 
     * @return ApiResponse&lt;List&lt;MarginCurrencyPair&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<MarginCurrencyPair>> listMarginCurrencyPairsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listMarginCurrencyPairsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<MarginCurrencyPair>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all supported currency pairs supported in margin trading(Deprecated) (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listMarginCurrencyPairsAsync(final ApiCallback<List<MarginCurrencyPair>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listMarginCurrencyPairsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<MarginCurrencyPair>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getMarginCurrencyPair
     * @param currencyPair Margin currency pair (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMarginCurrencyPairCall(String currencyPair, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/currency_pairs/{currency_pair}"
            .replaceAll("\\{" + "currency_pair" + "\\}", localVarApiClient.escapeString(currencyPair));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarginCurrencyPairValidateBeforeCall(String currencyPair, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currencyPair' is set
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getMarginCurrencyPair(Async)");
        }

        okhttp3.Call localVarCall = getMarginCurrencyPairCall(currencyPair, _callback);
        return localVarCall;
    }

    /**
     * Query one single margin currency pair(Deprecated)
     * 
     * @param currencyPair Margin currency pair (required)
     * @return MarginCurrencyPair
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public MarginCurrencyPair getMarginCurrencyPair(String currencyPair) throws ApiException {
        ApiResponse<MarginCurrencyPair> localVarResp = getMarginCurrencyPairWithHttpInfo(currencyPair);
        return localVarResp.getData();
    }

    /**
     * Query one single margin currency pair(Deprecated)
     * 
     * @param currencyPair Margin currency pair (required)
     * @return ApiResponse&lt;MarginCurrencyPair&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MarginCurrencyPair> getMarginCurrencyPairWithHttpInfo(String currencyPair) throws ApiException {
        okhttp3.Call localVarCall = getMarginCurrencyPairValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<MarginCurrencyPair>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Query one single margin currency pair(Deprecated) (asynchronously)
     * 
     * @param currencyPair Margin currency pair (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getMarginCurrencyPairAsync(String currencyPair, final ApiCallback<MarginCurrencyPair> _callback) throws ApiException {
        okhttp3.Call localVarCall = getMarginCurrencyPairValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MarginCurrencyPair>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for listFundingBook
     * @param currency Retrieve data of the specified currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFundingBookCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/funding_book";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFundingBookValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling listFundingBook(Async)");
        }

        okhttp3.Call localVarCall = listFundingBookCall(currency, _callback);
        return localVarCall;
    }

    /**
     * Order book of lending loans(Deprecated)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @return List&lt;FundingBookItem&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<FundingBookItem> listFundingBook(String currency) throws ApiException {
        ApiResponse<List<FundingBookItem>> localVarResp = listFundingBookWithHttpInfo(currency);
        return localVarResp.getData();
    }

    /**
     * Order book of lending loans(Deprecated)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @return ApiResponse&lt;List&lt;FundingBookItem&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<FundingBookItem>> listFundingBookWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = listFundingBookValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<FundingBookItem>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Order book of lending loans(Deprecated) (asynchronously)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFundingBookAsync(String currency, final ApiCallback<List<FundingBookItem>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFundingBookValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<FundingBookItem>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listLoansCall(String status, String side, String currency, String currencyPair, String sortBy, Boolean reverseSort, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/loans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (side != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("side", side));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort_by", sortBy));
        }

        if (reverseSort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("reverse_sort", reverseSort));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listLoansValidateBeforeCall(String status, String side, String currency, String currencyPair, String sortBy, Boolean reverseSort, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'status' is set
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listLoans(Async)");
        }

        // verify the required parameter 'side' is set
        if (side == null) {
            throw new ApiException("Missing the required parameter 'side' when calling listLoans(Async)");
        }

        okhttp3.Call localVarCall = listLoansCall(status, side, currency, currencyPair, sortBy, reverseSort, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<Loan>> listLoansWithHttpInfo(String status, String side, String currency, String currencyPair, String sortBy, Boolean reverseSort, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listLoansValidateBeforeCall(status, side, currency, currencyPair, sortBy, reverseSort, page, limit, null);
        Type localVarReturnType = new TypeToken<List<Loan>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listLoansAsync(String status, String side, String currency, String currencyPair, String sortBy, Boolean reverseSort, Integer page, Integer limit, final ApiCallback<List<Loan>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listLoansValidateBeforeCall(status, side, currency, currencyPair, sortBy, reverseSort, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<Loan>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistLoansRequest {
        private final String status;
        private final String side;
        private String currency;
        private String currencyPair;
        private String sortBy;
        private Boolean reverseSort;
        private Integer page;
        private Integer limit;

        private APIlistLoansRequest(String status, String side) {
            this.status = status;
            this.side = side;
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistLoansRequest
         */
        public APIlistLoansRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set currencyPair
         * @param currencyPair Currency pair (optional)
         * @return APIlistLoansRequest
         */
        public APIlistLoansRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Set sortBy
         * @param sortBy Specify which field is used to sort. &#x60;create_time&#x60; or &#x60;rate&#x60; is supported. Default to &#x60;create_time&#x60; (optional)
         * @return APIlistLoansRequest
         */
        public APIlistLoansRequest sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        /**
         * Set reverseSort
         * @param reverseSort Whether to sort in descending order. Default to &#x60;true&#x60; (optional)
         * @return APIlistLoansRequest
         */
        public APIlistLoansRequest reverseSort(Boolean reverseSort) {
            this.reverseSort = reverseSort;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistLoansRequest
         */
        public APIlistLoansRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistLoansRequest
         */
        public APIlistLoansRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listLoans
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listLoansCall(status, side, currency, currencyPair, sortBy, reverseSort, page, limit, _callback);
        }

        /**
         * Execute listLoans request
         * @return List&lt;Loan&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<Loan> execute() throws ApiException {
            ApiResponse<List<Loan>> localVarResp = listLoansWithHttpInfo(status, side, currency, currencyPair, sortBy, reverseSort, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listLoans request with HTTP info returned
         * @return ApiResponse&lt;List&lt;Loan&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<Loan>> executeWithHttpInfo() throws ApiException {
            return listLoansWithHttpInfo(status, side, currency, currencyPair, sortBy, reverseSort, page, limit);
        }

        /**
         * Execute listLoans request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<Loan>> _callback) throws ApiException {
            return listLoansAsync(status, side, currency, currencyPair, sortBy, reverseSort, page, limit, _callback);
        }
    }

    /**
     * List all loans(Deprecated)
     * 
     * @param status Loan status (required)
     * @param side Lend or borrow (required)
     * @return APIlistLoansRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistLoansRequest listLoans(String status, String side) {
        return new APIlistLoansRequest(status, side);
    }

    /**
     * Build call for createLoan
     * @param loan  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Loan created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createLoanCall(Loan loan, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = loan;

        // create path and map variables
        String localVarPath = "/margin/loans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createLoanValidateBeforeCall(Loan loan, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loan' is set
        if (loan == null) {
            throw new ApiException("Missing the required parameter 'loan' when calling createLoan(Async)");
        }

        okhttp3.Call localVarCall = createLoanCall(loan, _callback);
        return localVarCall;
    }

    /**
     * Lend or borrow(Deprecated)
     * 
     * @param loan  (required)
     * @return Loan
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Loan created </td><td>  -  </td></tr>
     </table>
     */
    public Loan createLoan(Loan loan) throws ApiException {
        ApiResponse<Loan> localVarResp = createLoanWithHttpInfo(loan);
        return localVarResp.getData();
    }

    /**
     * Lend or borrow(Deprecated)
     * 
     * @param loan  (required)
     * @return ApiResponse&lt;Loan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Loan created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Loan> createLoanWithHttpInfo(Loan loan) throws ApiException {
        okhttp3.Call localVarCall = createLoanValidateBeforeCall(loan, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Lend or borrow(Deprecated) (asynchronously)
     * 
     * @param loan  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Loan created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createLoanAsync(Loan loan, final ApiCallback<Loan> _callback) throws ApiException {
        okhttp3.Call localVarCall = createLoanValidateBeforeCall(loan, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for mergeLoans
     * @param currency Retrieve data of the specified currency (required)
     * @param ids A comma-separated (,) list of IDs of the loans lent. Maximum of 20 IDs are allowed in a request (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Loans merged </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call mergeLoansCall(String currency, String ids, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/merged_loans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (ids != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ids", ids));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call mergeLoansValidateBeforeCall(String currency, String ids, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling mergeLoans(Async)");
        }

        // verify the required parameter 'ids' is set
        if (ids == null) {
            throw new ApiException("Missing the required parameter 'ids' when calling mergeLoans(Async)");
        }

        okhttp3.Call localVarCall = mergeLoansCall(currency, ids, _callback);
        return localVarCall;
    }

    /**
     * Merge multiple lending loans(Deprecated)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param ids A comma-separated (,) list of IDs of the loans lent. Maximum of 20 IDs are allowed in a request (required)
     * @return Loan
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Loans merged </td><td>  -  </td></tr>
     </table>
     */
    public Loan mergeLoans(String currency, String ids) throws ApiException {
        ApiResponse<Loan> localVarResp = mergeLoansWithHttpInfo(currency, ids);
        return localVarResp.getData();
    }

    /**
     * Merge multiple lending loans(Deprecated)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param ids A comma-separated (,) list of IDs of the loans lent. Maximum of 20 IDs are allowed in a request (required)
     * @return ApiResponse&lt;Loan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Loans merged </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Loan> mergeLoansWithHttpInfo(String currency, String ids) throws ApiException {
        okhttp3.Call localVarCall = mergeLoansValidateBeforeCall(currency, ids, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Merge multiple lending loans(Deprecated) (asynchronously)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param ids A comma-separated (,) list of IDs of the loans lent. Maximum of 20 IDs are allowed in a request (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Loans merged </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call mergeLoansAsync(String currency, String ids, final ApiCallback<Loan> _callback) throws ApiException {
        okhttp3.Call localVarCall = mergeLoansValidateBeforeCall(currency, ids, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getLoan
     * @param loanId Loan ID (required)
     * @param side Lend or borrow (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLoanCall(String loanId, String side, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/loans/{loan_id}"
            .replaceAll("\\{" + "loan_id" + "\\}", localVarApiClient.escapeString(loanId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (side != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("side", side));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLoanValidateBeforeCall(String loanId, String side, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanId' is set
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling getLoan(Async)");
        }

        // verify the required parameter 'side' is set
        if (side == null) {
            throw new ApiException("Missing the required parameter 'side' when calling getLoan(Async)");
        }

        okhttp3.Call localVarCall = getLoanCall(loanId, side, _callback);
        return localVarCall;
    }

    /**
     * Retrieve one single loan detail(Deprecated)
     * 
     * @param loanId Loan ID (required)
     * @param side Lend or borrow (required)
     * @return Loan
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public Loan getLoan(String loanId, String side) throws ApiException {
        ApiResponse<Loan> localVarResp = getLoanWithHttpInfo(loanId, side);
        return localVarResp.getData();
    }

    /**
     * Retrieve one single loan detail(Deprecated)
     * 
     * @param loanId Loan ID (required)
     * @param side Lend or borrow (required)
     * @return ApiResponse&lt;Loan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Loan> getLoanWithHttpInfo(String loanId, String side) throws ApiException {
        okhttp3.Call localVarCall = getLoanValidateBeforeCall(loanId, side, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve one single loan detail(Deprecated) (asynchronously)
     * 
     * @param loanId Loan ID (required)
     * @param side Lend or borrow (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLoanAsync(String loanId, String side, final ApiCallback<Loan> _callback) throws ApiException {
        okhttp3.Call localVarCall = getLoanValidateBeforeCall(loanId, side, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for cancelLoan
     * @param loanId Loan ID (required)
     * @param currency Retrieve data of the specified currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order cancelled </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelLoanCall(String loanId, String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/loans/{loan_id}"
            .replaceAll("\\{" + "loan_id" + "\\}", localVarApiClient.escapeString(loanId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelLoanValidateBeforeCall(String loanId, String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanId' is set
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling cancelLoan(Async)");
        }

        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling cancelLoan(Async)");
        }

        okhttp3.Call localVarCall = cancelLoanCall(loanId, currency, _callback);
        return localVarCall;
    }

    /**
     * Cancel lending loan(Deprecated)
     * Only lent loans can be cancelled
     * @param loanId Loan ID (required)
     * @param currency Retrieve data of the specified currency (required)
     * @return Loan
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order cancelled </td><td>  -  </td></tr>
     </table>
     */
    public Loan cancelLoan(String loanId, String currency) throws ApiException {
        ApiResponse<Loan> localVarResp = cancelLoanWithHttpInfo(loanId, currency);
        return localVarResp.getData();
    }

    /**
     * Cancel lending loan(Deprecated)
     * Only lent loans can be cancelled
     * @param loanId Loan ID (required)
     * @param currency Retrieve data of the specified currency (required)
     * @return ApiResponse&lt;Loan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order cancelled </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Loan> cancelLoanWithHttpInfo(String loanId, String currency) throws ApiException {
        okhttp3.Call localVarCall = cancelLoanValidateBeforeCall(loanId, currency, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cancel lending loan(Deprecated) (asynchronously)
     * Only lent loans can be cancelled
     * @param loanId Loan ID (required)
     * @param currency Retrieve data of the specified currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order cancelled </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelLoanAsync(String loanId, String currency, final ApiCallback<Loan> _callback) throws ApiException {
        okhttp3.Call localVarCall = cancelLoanValidateBeforeCall(loanId, currency, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updateLoan
     * @param loanId Loan ID (required)
     * @param loanPatch  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateLoanCall(String loanId, LoanPatch loanPatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = loanPatch;

        // create path and map variables
        String localVarPath = "/margin/loans/{loan_id}"
            .replaceAll("\\{" + "loan_id" + "\\}", localVarApiClient.escapeString(loanId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateLoanValidateBeforeCall(String loanId, LoanPatch loanPatch, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanId' is set
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling updateLoan(Async)");
        }

        // verify the required parameter 'loanPatch' is set
        if (loanPatch == null) {
            throw new ApiException("Missing the required parameter 'loanPatch' when calling updateLoan(Async)");
        }

        okhttp3.Call localVarCall = updateLoanCall(loanId, loanPatch, _callback);
        return localVarCall;
    }

    /**
     * Modify a loan(Deprecated)
     * Only &#x60;auto_renew&#x60; modification is supported currently
     * @param loanId Loan ID (required)
     * @param loanPatch  (required)
     * @return Loan
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public Loan updateLoan(String loanId, LoanPatch loanPatch) throws ApiException {
        ApiResponse<Loan> localVarResp = updateLoanWithHttpInfo(loanId, loanPatch);
        return localVarResp.getData();
    }

    /**
     * Modify a loan(Deprecated)
     * Only &#x60;auto_renew&#x60; modification is supported currently
     * @param loanId Loan ID (required)
     * @param loanPatch  (required)
     * @return ApiResponse&lt;Loan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Loan> updateLoanWithHttpInfo(String loanId, LoanPatch loanPatch) throws ApiException {
        okhttp3.Call localVarCall = updateLoanValidateBeforeCall(loanId, loanPatch, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Modify a loan(Deprecated) (asynchronously)
     * Only &#x60;auto_renew&#x60; modification is supported currently
     * @param loanId Loan ID (required)
     * @param loanPatch  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateLoanAsync(String loanId, LoanPatch loanPatch, final ApiCallback<Loan> _callback) throws ApiException {
        okhttp3.Call localVarCall = updateLoanValidateBeforeCall(loanId, loanPatch, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for listLoanRepayments
     * @param loanId Loan ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listLoanRepaymentsCall(String loanId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/loans/{loan_id}/repayment"
            .replaceAll("\\{" + "loan_id" + "\\}", localVarApiClient.escapeString(loanId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listLoanRepaymentsValidateBeforeCall(String loanId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanId' is set
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling listLoanRepayments(Async)");
        }

        okhttp3.Call localVarCall = listLoanRepaymentsCall(loanId, _callback);
        return localVarCall;
    }

    /**
     * List loan repayment records(Deprecated)
     * 
     * @param loanId Loan ID (required)
     * @return List&lt;Repayment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<Repayment> listLoanRepayments(String loanId) throws ApiException {
        ApiResponse<List<Repayment>> localVarResp = listLoanRepaymentsWithHttpInfo(loanId);
        return localVarResp.getData();
    }

    /**
     * List loan repayment records(Deprecated)
     * 
     * @param loanId Loan ID (required)
     * @return ApiResponse&lt;List&lt;Repayment&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Repayment>> listLoanRepaymentsWithHttpInfo(String loanId) throws ApiException {
        okhttp3.Call localVarCall = listLoanRepaymentsValidateBeforeCall(loanId, null);
        Type localVarReturnType = new TypeToken<List<Repayment>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List loan repayment records(Deprecated) (asynchronously)
     * 
     * @param loanId Loan ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listLoanRepaymentsAsync(String loanId, final ApiCallback<List<Repayment>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listLoanRepaymentsValidateBeforeCall(loanId, _callback);
        Type localVarReturnType = new TypeToken<List<Repayment>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for repayLoan
     * @param loanId Loan ID (required)
     * @param repayRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan repaid </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call repayLoanCall(String loanId, RepayRequest repayRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = repayRequest;

        // create path and map variables
        String localVarPath = "/margin/loans/{loan_id}/repayment"
            .replaceAll("\\{" + "loan_id" + "\\}", localVarApiClient.escapeString(loanId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call repayLoanValidateBeforeCall(String loanId, RepayRequest repayRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanId' is set
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling repayLoan(Async)");
        }

        // verify the required parameter 'repayRequest' is set
        if (repayRequest == null) {
            throw new ApiException("Missing the required parameter 'repayRequest' when calling repayLoan(Async)");
        }

        okhttp3.Call localVarCall = repayLoanCall(loanId, repayRequest, _callback);
        return localVarCall;
    }

    /**
     * Repay a loan(Deprecated)
     * 
     * @param loanId Loan ID (required)
     * @param repayRequest  (required)
     * @return Loan
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan repaid </td><td>  -  </td></tr>
     </table>
     */
    public Loan repayLoan(String loanId, RepayRequest repayRequest) throws ApiException {
        ApiResponse<Loan> localVarResp = repayLoanWithHttpInfo(loanId, repayRequest);
        return localVarResp.getData();
    }

    /**
     * Repay a loan(Deprecated)
     * 
     * @param loanId Loan ID (required)
     * @param repayRequest  (required)
     * @return ApiResponse&lt;Loan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan repaid </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Loan> repayLoanWithHttpInfo(String loanId, RepayRequest repayRequest) throws ApiException {
        okhttp3.Call localVarCall = repayLoanValidateBeforeCall(loanId, repayRequest, null);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Repay a loan(Deprecated) (asynchronously)
     * 
     * @param loanId Loan ID (required)
     * @param repayRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan repaid </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call repayLoanAsync(String loanId, RepayRequest repayRequest, final ApiCallback<Loan> _callback) throws ApiException {
        okhttp3.Call localVarCall = repayLoanValidateBeforeCall(loanId, repayRequest, _callback);
        Type localVarReturnType = new TypeToken<Loan>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listLoanRecordsCall(String loanId, String status, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/loan_records";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (loanId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("loan_id", loanId));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listLoanRecordsValidateBeforeCall(String loanId, String status, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanId' is set
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling listLoanRecords(Async)");
        }

        okhttp3.Call localVarCall = listLoanRecordsCall(loanId, status, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<LoanRecord>> listLoanRecordsWithHttpInfo(String loanId, String status, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listLoanRecordsValidateBeforeCall(loanId, status, page, limit, null);
        Type localVarReturnType = new TypeToken<List<LoanRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listLoanRecordsAsync(String loanId, String status, Integer page, Integer limit, final ApiCallback<List<LoanRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listLoanRecordsValidateBeforeCall(loanId, status, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<LoanRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistLoanRecordsRequest {
        private final String loanId;
        private String status;
        private Integer page;
        private Integer limit;

        private APIlistLoanRecordsRequest(String loanId) {
            this.loanId = loanId;
        }

        /**
         * Set status
         * @param status Loan record status (optional)
         * @return APIlistLoanRecordsRequest
         */
        public APIlistLoanRecordsRequest status(String status) {
            this.status = status;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistLoanRecordsRequest
         */
        public APIlistLoanRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistLoanRecordsRequest
         */
        public APIlistLoanRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listLoanRecords
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listLoanRecordsCall(loanId, status, page, limit, _callback);
        }

        /**
         * Execute listLoanRecords request
         * @return List&lt;LoanRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<LoanRecord> execute() throws ApiException {
            ApiResponse<List<LoanRecord>> localVarResp = listLoanRecordsWithHttpInfo(loanId, status, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listLoanRecords request with HTTP info returned
         * @return ApiResponse&lt;List&lt;LoanRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<LoanRecord>> executeWithHttpInfo() throws ApiException {
            return listLoanRecordsWithHttpInfo(loanId, status, page, limit);
        }

        /**
         * Execute listLoanRecords request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<LoanRecord>> _callback) throws ApiException {
            return listLoanRecordsAsync(loanId, status, page, limit, _callback);
        }
    }

    /**
     * List repayment records of a specific loan(Deprecated)
     * 
     * @param loanId Loan ID (required)
     * @return APIlistLoanRecordsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistLoanRecordsRequest listLoanRecords(String loanId) {
        return new APIlistLoanRecordsRequest(loanId);
    }

    /**
     * Build call for getLoanRecord
     * @param loanRecordId Loan record ID (required)
     * @param loanId Loan ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Detail retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLoanRecordCall(String loanRecordId, String loanId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/loan_records/{loan_record_id}"
            .replaceAll("\\{" + "loan_record_id" + "\\}", localVarApiClient.escapeString(loanRecordId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (loanId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("loan_id", loanId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLoanRecordValidateBeforeCall(String loanRecordId, String loanId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanRecordId' is set
        if (loanRecordId == null) {
            throw new ApiException("Missing the required parameter 'loanRecordId' when calling getLoanRecord(Async)");
        }

        // verify the required parameter 'loanId' is set
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling getLoanRecord(Async)");
        }

        okhttp3.Call localVarCall = getLoanRecordCall(loanRecordId, loanId, _callback);
        return localVarCall;
    }

    /**
     * Get one single loan record(Deprecated)
     * 
     * @param loanRecordId Loan record ID (required)
     * @param loanId Loan ID (required)
     * @return LoanRecord
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Detail retrieved </td><td>  -  </td></tr>
     </table>
     */
    public LoanRecord getLoanRecord(String loanRecordId, String loanId) throws ApiException {
        ApiResponse<LoanRecord> localVarResp = getLoanRecordWithHttpInfo(loanRecordId, loanId);
        return localVarResp.getData();
    }

    /**
     * Get one single loan record(Deprecated)
     * 
     * @param loanRecordId Loan record ID (required)
     * @param loanId Loan ID (required)
     * @return ApiResponse&lt;LoanRecord&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Detail retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<LoanRecord> getLoanRecordWithHttpInfo(String loanRecordId, String loanId) throws ApiException {
        okhttp3.Call localVarCall = getLoanRecordValidateBeforeCall(loanRecordId, loanId, null);
        Type localVarReturnType = new TypeToken<LoanRecord>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get one single loan record(Deprecated) (asynchronously)
     * 
     * @param loanRecordId Loan record ID (required)
     * @param loanId Loan ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Detail retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLoanRecordAsync(String loanRecordId, String loanId, final ApiCallback<LoanRecord> _callback) throws ApiException {
        okhttp3.Call localVarCall = getLoanRecordValidateBeforeCall(loanRecordId, loanId, _callback);
        Type localVarReturnType = new TypeToken<LoanRecord>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updateLoanRecord
     * @param loanRecordId Loan record ID (required)
     * @param loanPatch  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan record updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateLoanRecordCall(String loanRecordId, LoanPatch loanPatch, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = loanPatch;

        // create path and map variables
        String localVarPath = "/margin/loan_records/{loan_record_id}"
            .replaceAll("\\{" + "loan_record_id" + "\\}", localVarApiClient.escapeString(loanRecordId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateLoanRecordValidateBeforeCall(String loanRecordId, LoanPatch loanPatch, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanRecordId' is set
        if (loanRecordId == null) {
            throw new ApiException("Missing the required parameter 'loanRecordId' when calling updateLoanRecord(Async)");
        }

        // verify the required parameter 'loanPatch' is set
        if (loanPatch == null) {
            throw new ApiException("Missing the required parameter 'loanPatch' when calling updateLoanRecord(Async)");
        }

        okhttp3.Call localVarCall = updateLoanRecordCall(loanRecordId, loanPatch, _callback);
        return localVarCall;
    }

    /**
     * Modify a loan record(Deprecated)
     * Only &#x60;auto_renew&#x60; modification is supported currently
     * @param loanRecordId Loan record ID (required)
     * @param loanPatch  (required)
     * @return LoanRecord
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan record updated </td><td>  -  </td></tr>
     </table>
     */
    public LoanRecord updateLoanRecord(String loanRecordId, LoanPatch loanPatch) throws ApiException {
        ApiResponse<LoanRecord> localVarResp = updateLoanRecordWithHttpInfo(loanRecordId, loanPatch);
        return localVarResp.getData();
    }

    /**
     * Modify a loan record(Deprecated)
     * Only &#x60;auto_renew&#x60; modification is supported currently
     * @param loanRecordId Loan record ID (required)
     * @param loanPatch  (required)
     * @return ApiResponse&lt;LoanRecord&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan record updated </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<LoanRecord> updateLoanRecordWithHttpInfo(String loanRecordId, LoanPatch loanPatch) throws ApiException {
        okhttp3.Call localVarCall = updateLoanRecordValidateBeforeCall(loanRecordId, loanPatch, null);
        Type localVarReturnType = new TypeToken<LoanRecord>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Modify a loan record(Deprecated) (asynchronously)
     * Only &#x60;auto_renew&#x60; modification is supported currently
     * @param loanRecordId Loan record ID (required)
     * @param loanPatch  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan record updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateLoanRecordAsync(String loanRecordId, LoanPatch loanPatch, final ApiCallback<LoanRecord> _callback) throws ApiException {
        okhttp3.Call localVarCall = updateLoanRecordValidateBeforeCall(loanRecordId, loanPatch, _callback);
        Type localVarReturnType = new TypeToken<LoanRecord>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call getMarginBorrowableCall(String currency, String currencyPair, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/borrowable";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMarginBorrowableValidateBeforeCall(String currency, String currencyPair, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getMarginBorrowable(Async)");
        }

        okhttp3.Call localVarCall = getMarginBorrowableCall(currency, currencyPair, _callback);
        return localVarCall;
    }


    private ApiResponse<MarginBorrowable> getMarginBorrowableWithHttpInfo(String currency, String currencyPair) throws ApiException {
        okhttp3.Call localVarCall = getMarginBorrowableValidateBeforeCall(currency, currencyPair, null);
        Type localVarReturnType = new TypeToken<MarginBorrowable>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getMarginBorrowableAsync(String currency, String currencyPair, final ApiCallback<MarginBorrowable> _callback) throws ApiException {
        okhttp3.Call localVarCall = getMarginBorrowableValidateBeforeCall(currency, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<MarginBorrowable>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetMarginBorrowableRequest {
        private final String currency;
        private String currencyPair;

        private APIgetMarginBorrowableRequest(String currency) {
            this.currency = currency;
        }

        /**
         * Set currencyPair
         * @param currencyPair Currency pair (optional)
         * @return APIgetMarginBorrowableRequest
         */
        public APIgetMarginBorrowableRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Build call for getMarginBorrowable
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getMarginBorrowableCall(currency, currencyPair, _callback);
        }

        /**
         * Execute getMarginBorrowable request
         * @return MarginBorrowable
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public MarginBorrowable execute() throws ApiException {
            ApiResponse<MarginBorrowable> localVarResp = getMarginBorrowableWithHttpInfo(currency, currencyPair);
            return localVarResp.getData();
        }

        /**
         * Execute getMarginBorrowable request with HTTP info returned
         * @return ApiResponse&lt;MarginBorrowable&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<MarginBorrowable> executeWithHttpInfo() throws ApiException {
            return getMarginBorrowableWithHttpInfo(currency, currencyPair);
        }

        /**
         * Execute getMarginBorrowable request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<MarginBorrowable> _callback) throws ApiException {
            return getMarginBorrowableAsync(currency, currencyPair, _callback);
        }
    }

    /**
     * Get the max borrowable amount for a specific margin currency(Deprecated)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @return APIgetMarginBorrowableRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIgetMarginBorrowableRequest getMarginBorrowable(String currency) {
        return new APIgetMarginBorrowableRequest(currency);
    }

    /**
     * Build call for listCrossMarginCurrencies
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCrossMarginCurrenciesCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/currencies";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCrossMarginCurrenciesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginCurrenciesCall(_callback);
        return localVarCall;
    }

    /**
     * Currencies supported by cross margin.
     * 
     * @return List&lt;CrossMarginCurrency&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<CrossMarginCurrency> listCrossMarginCurrencies() throws ApiException {
        ApiResponse<List<CrossMarginCurrency>> localVarResp = listCrossMarginCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Currencies supported by cross margin.
     * 
     * @return ApiResponse&lt;List&lt;CrossMarginCurrency&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CrossMarginCurrency>> listCrossMarginCurrenciesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<CrossMarginCurrency>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Currencies supported by cross margin. (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCrossMarginCurrenciesAsync(final ApiCallback<List<CrossMarginCurrency>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginCurrency>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCrossMarginCurrency
     * @param currency Currency name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginCurrencyCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/currencies/{currency}"
            .replaceAll("\\{" + "currency" + "\\}", localVarApiClient.escapeString(currency));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCrossMarginCurrencyValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCrossMarginCurrency(Async)");
        }

        okhttp3.Call localVarCall = getCrossMarginCurrencyCall(currency, _callback);
        return localVarCall;
    }

    /**
     * Retrieve detail of one single currency supported by cross margin
     * 
     * @param currency Currency name (required)
     * @return CrossMarginCurrency
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public CrossMarginCurrency getCrossMarginCurrency(String currency) throws ApiException {
        ApiResponse<CrossMarginCurrency> localVarResp = getCrossMarginCurrencyWithHttpInfo(currency);
        return localVarResp.getData();
    }

    /**
     * Retrieve detail of one single currency supported by cross margin
     * 
     * @param currency Currency name (required)
     * @return ApiResponse&lt;CrossMarginCurrency&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CrossMarginCurrency> getCrossMarginCurrencyWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginCurrencyValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<CrossMarginCurrency>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve detail of one single currency supported by cross margin (asynchronously)
     * 
     * @param currency Currency name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginCurrencyAsync(String currency, final ApiCallback<CrossMarginCurrency> _callback) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginCurrencyValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginCurrency>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCrossMarginAccount
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginAccountCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/accounts";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCrossMarginAccountValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginAccountCall(_callback);
        return localVarCall;
    }

    /**
     * Retrieve cross margin account
     * 
     * @return CrossMarginAccount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public CrossMarginAccount getCrossMarginAccount() throws ApiException {
        ApiResponse<CrossMarginAccount> localVarResp = getCrossMarginAccountWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Retrieve cross margin account
     * 
     * @return ApiResponse&lt;CrossMarginAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CrossMarginAccount> getCrossMarginAccountWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginAccountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CrossMarginAccount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve cross margin account (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginAccountAsync(final ApiCallback<CrossMarginAccount> _callback) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginAccountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CrossMarginAccount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listCrossMarginAccountBookCall(String currency, Long from, Long to, Integer page, Integer limit, String type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/account_book";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCrossMarginAccountBookValidateBeforeCall(String currency, Long from, Long to, Integer page, Integer limit, String type, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginAccountBookCall(currency, from, to, page, limit, type, _callback);
        return localVarCall;
    }


    private ApiResponse<List<CrossMarginAccountBook>> listCrossMarginAccountBookWithHttpInfo(String currency, Long from, Long to, Integer page, Integer limit, String type) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginAccountBookValidateBeforeCall(currency, from, to, page, limit, type, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginAccountBook>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listCrossMarginAccountBookAsync(String currency, Long from, Long to, Integer page, Integer limit, String type, final ApiCallback<List<CrossMarginAccountBook>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginAccountBookValidateBeforeCall(currency, from, to, page, limit, type, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginAccountBook>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistCrossMarginAccountBookRequest {
        private String currency;
        private Long from;
        private Long to;
        private Integer page;
        private Integer limit;
        private String type;

        private APIlistCrossMarginAccountBookRequest() {
        }

        /**
         * Set currency
         * @param currency Filter by currency (optional)
         * @return APIlistCrossMarginAccountBookRequest
         */
        public APIlistCrossMarginAccountBookRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp of the query (optional)
         * @return APIlistCrossMarginAccountBookRequest
         */
        public APIlistCrossMarginAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to Time range ending, default to current time (optional)
         * @return APIlistCrossMarginAccountBookRequest
         */
        public APIlistCrossMarginAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistCrossMarginAccountBookRequest
         */
        public APIlistCrossMarginAccountBookRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistCrossMarginAccountBookRequest
         */
        public APIlistCrossMarginAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set type
         * @param type Only retrieve changes of the specified type. All types will be returned if not specified. (optional)
         * @return APIlistCrossMarginAccountBookRequest
         */
        public APIlistCrossMarginAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Build call for listCrossMarginAccountBook
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listCrossMarginAccountBookCall(currency, from, to, page, limit, type, _callback);
        }

        /**
         * Execute listCrossMarginAccountBook request
         * @return List&lt;CrossMarginAccountBook&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<CrossMarginAccountBook> execute() throws ApiException {
            ApiResponse<List<CrossMarginAccountBook>> localVarResp = listCrossMarginAccountBookWithHttpInfo(currency, from, to, page, limit, type);
            return localVarResp.getData();
        }

        /**
         * Execute listCrossMarginAccountBook request with HTTP info returned
         * @return ApiResponse&lt;List&lt;CrossMarginAccountBook&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<CrossMarginAccountBook>> executeWithHttpInfo() throws ApiException {
            return listCrossMarginAccountBookWithHttpInfo(currency, from, to, page, limit, type);
        }

        /**
         * Execute listCrossMarginAccountBook request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<CrossMarginAccountBook>> _callback) throws ApiException {
            return listCrossMarginAccountBookAsync(currency, from, to, page, limit, type, _callback);
        }
    }

    /**
     * Retrieve cross margin account change history
     * Record time range cannot exceed 30 days
     * @return APIlistCrossMarginAccountBookRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistCrossMarginAccountBookRequest listCrossMarginAccountBook() {
        return new APIlistCrossMarginAccountBookRequest();
    }

    private okhttp3.Call listCrossMarginLoansCall(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/loans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (reverse != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("reverse", reverse));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCrossMarginLoansValidateBeforeCall(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'status' is set
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listCrossMarginLoans(Async)");
        }

        okhttp3.Call localVarCall = listCrossMarginLoansCall(status, currency, limit, offset, reverse, _callback);
        return localVarCall;
    }


    private ApiResponse<List<CrossMarginLoan>> listCrossMarginLoansWithHttpInfo(Integer status, String currency, Integer limit, Integer offset, Boolean reverse) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginLoansValidateBeforeCall(status, currency, limit, offset, reverse, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listCrossMarginLoansAsync(Integer status, String currency, Integer limit, Integer offset, Boolean reverse, final ApiCallback<List<CrossMarginLoan>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginLoansValidateBeforeCall(status, currency, limit, offset, reverse, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistCrossMarginLoansRequest {
        private final Integer status;
        private String currency;
        private Integer limit;
        private Integer offset;
        private Boolean reverse;

        private APIlistCrossMarginLoansRequest(Integer status) {
            this.status = status;
        }

        /**
         * Set currency
         * @param currency Filter by currency (optional)
         * @return APIlistCrossMarginLoansRequest
         */
        public APIlistCrossMarginLoansRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistCrossMarginLoansRequest
         */
        public APIlistCrossMarginLoansRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistCrossMarginLoansRequest
         */
        public APIlistCrossMarginLoansRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set reverse
         * @param reverse Whether to sort in descending order, which is the default. Set &#x60;reverse&#x3D;false&#x60; to return ascending results (optional, default to true)
         * @return APIlistCrossMarginLoansRequest
         */
        public APIlistCrossMarginLoansRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        /**
         * Build call for listCrossMarginLoans
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listCrossMarginLoansCall(status, currency, limit, offset, reverse, _callback);
        }

        /**
         * Execute listCrossMarginLoans request
         * @return List&lt;CrossMarginLoan&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<CrossMarginLoan> execute() throws ApiException {
            ApiResponse<List<CrossMarginLoan>> localVarResp = listCrossMarginLoansWithHttpInfo(status, currency, limit, offset, reverse);
            return localVarResp.getData();
        }

        /**
         * Execute listCrossMarginLoans request with HTTP info returned
         * @return ApiResponse&lt;List&lt;CrossMarginLoan&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<CrossMarginLoan>> executeWithHttpInfo() throws ApiException {
            return listCrossMarginLoansWithHttpInfo(status, currency, limit, offset, reverse);
        }

        /**
         * Execute listCrossMarginLoans request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<CrossMarginLoan>> _callback) throws ApiException {
            return listCrossMarginLoansAsync(status, currency, limit, offset, reverse, _callback);
        }
    }

    /**
     * List cross margin borrow history
     * Sort by creation time in descending order by default. Set &#x60;reverse&#x3D;false&#x60; to return ascending results.
     * @param status Filter by status. Supported values are 2 and 3. (required)
     * @return APIlistCrossMarginLoansRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistCrossMarginLoansRequest listCrossMarginLoans(Integer status) {
        return new APIlistCrossMarginLoansRequest(status);
    }

    /**
     * Build call for createCrossMarginLoan
     * @param crossMarginLoan  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully borrowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCrossMarginLoanCall(CrossMarginLoan crossMarginLoan, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = crossMarginLoan;

        // create path and map variables
        String localVarPath = "/margin/cross/loans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createCrossMarginLoanValidateBeforeCall(CrossMarginLoan crossMarginLoan, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'crossMarginLoan' is set
        if (crossMarginLoan == null) {
            throw new ApiException("Missing the required parameter 'crossMarginLoan' when calling createCrossMarginLoan(Async)");
        }

        okhttp3.Call localVarCall = createCrossMarginLoanCall(crossMarginLoan, _callback);
        return localVarCall;
    }

    /**
     * Create a cross margin borrow loan
     * Borrow amount cannot be less than currency minimum borrow amount
     * @param crossMarginLoan  (required)
     * @return CrossMarginLoan
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully borrowed </td><td>  -  </td></tr>
     </table>
     */
    public CrossMarginLoan createCrossMarginLoan(CrossMarginLoan crossMarginLoan) throws ApiException {
        ApiResponse<CrossMarginLoan> localVarResp = createCrossMarginLoanWithHttpInfo(crossMarginLoan);
        return localVarResp.getData();
    }

    /**
     * Create a cross margin borrow loan
     * Borrow amount cannot be less than currency minimum borrow amount
     * @param crossMarginLoan  (required)
     * @return ApiResponse&lt;CrossMarginLoan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully borrowed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CrossMarginLoan> createCrossMarginLoanWithHttpInfo(CrossMarginLoan crossMarginLoan) throws ApiException {
        okhttp3.Call localVarCall = createCrossMarginLoanValidateBeforeCall(crossMarginLoan, null);
        Type localVarReturnType = new TypeToken<CrossMarginLoan>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a cross margin borrow loan (asynchronously)
     * Borrow amount cannot be less than currency minimum borrow amount
     * @param crossMarginLoan  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully borrowed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCrossMarginLoanAsync(CrossMarginLoan crossMarginLoan, final ApiCallback<CrossMarginLoan> _callback) throws ApiException {
        okhttp3.Call localVarCall = createCrossMarginLoanValidateBeforeCall(crossMarginLoan, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginLoan>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCrossMarginLoan
     * @param loanId Borrow loan ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginLoanCall(String loanId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/loans/{loan_id}"
            .replaceAll("\\{" + "loan_id" + "\\}", localVarApiClient.escapeString(loanId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCrossMarginLoanValidateBeforeCall(String loanId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'loanId' is set
        if (loanId == null) {
            throw new ApiException("Missing the required parameter 'loanId' when calling getCrossMarginLoan(Async)");
        }

        okhttp3.Call localVarCall = getCrossMarginLoanCall(loanId, _callback);
        return localVarCall;
    }

    /**
     * Retrieve single borrow loan detail
     * 
     * @param loanId Borrow loan ID (required)
     * @return CrossMarginLoan
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public CrossMarginLoan getCrossMarginLoan(String loanId) throws ApiException {
        ApiResponse<CrossMarginLoan> localVarResp = getCrossMarginLoanWithHttpInfo(loanId);
        return localVarResp.getData();
    }

    /**
     * Retrieve single borrow loan detail
     * 
     * @param loanId Borrow loan ID (required)
     * @return ApiResponse&lt;CrossMarginLoan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CrossMarginLoan> getCrossMarginLoanWithHttpInfo(String loanId) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginLoanValidateBeforeCall(loanId, null);
        Type localVarReturnType = new TypeToken<CrossMarginLoan>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve single borrow loan detail (asynchronously)
     * 
     * @param loanId Borrow loan ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginLoanAsync(String loanId, final ApiCallback<CrossMarginLoan> _callback) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginLoanValidateBeforeCall(loanId, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginLoan>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listCrossMarginRepaymentsCall(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/repayments";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (loanId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("loan_id", loanId));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (reverse != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("reverse", reverse));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCrossMarginRepaymentsValidateBeforeCall(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginRepaymentsCall(currency, loanId, limit, offset, reverse, _callback);
        return localVarCall;
    }


    private ApiResponse<List<CrossMarginRepayment>> listCrossMarginRepaymentsWithHttpInfo(String currency, String loanId, Integer limit, Integer offset, Boolean reverse) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginRepaymentsValidateBeforeCall(currency, loanId, limit, offset, reverse, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginRepayment>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listCrossMarginRepaymentsAsync(String currency, String loanId, Integer limit, Integer offset, Boolean reverse, final ApiCallback<List<CrossMarginRepayment>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listCrossMarginRepaymentsValidateBeforeCall(currency, loanId, limit, offset, reverse, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginRepayment>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistCrossMarginRepaymentsRequest {
        private String currency;
        private String loanId;
        private Integer limit;
        private Integer offset;
        private Boolean reverse;

        private APIlistCrossMarginRepaymentsRequest() {
        }

        /**
         * Set currency
         * @param currency  (optional)
         * @return APIlistCrossMarginRepaymentsRequest
         */
        public APIlistCrossMarginRepaymentsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set loanId
         * @param loanId  (optional)
         * @return APIlistCrossMarginRepaymentsRequest
         */
        public APIlistCrossMarginRepaymentsRequest loanId(String loanId) {
            this.loanId = loanId;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistCrossMarginRepaymentsRequest
         */
        public APIlistCrossMarginRepaymentsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistCrossMarginRepaymentsRequest
         */
        public APIlistCrossMarginRepaymentsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set reverse
         * @param reverse Whether to sort in descending order, which is the default. Set &#x60;reverse&#x3D;false&#x60; to return ascending results (optional, default to true)
         * @return APIlistCrossMarginRepaymentsRequest
         */
        public APIlistCrossMarginRepaymentsRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        /**
         * Build call for listCrossMarginRepayments
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listCrossMarginRepaymentsCall(currency, loanId, limit, offset, reverse, _callback);
        }

        /**
         * Execute listCrossMarginRepayments request
         * @return List&lt;CrossMarginRepayment&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<CrossMarginRepayment> execute() throws ApiException {
            ApiResponse<List<CrossMarginRepayment>> localVarResp = listCrossMarginRepaymentsWithHttpInfo(currency, loanId, limit, offset, reverse);
            return localVarResp.getData();
        }

        /**
         * Execute listCrossMarginRepayments request with HTTP info returned
         * @return ApiResponse&lt;List&lt;CrossMarginRepayment&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<CrossMarginRepayment>> executeWithHttpInfo() throws ApiException {
            return listCrossMarginRepaymentsWithHttpInfo(currency, loanId, limit, offset, reverse);
        }

        /**
         * Execute listCrossMarginRepayments request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<CrossMarginRepayment>> _callback) throws ApiException {
            return listCrossMarginRepaymentsAsync(currency, loanId, limit, offset, reverse, _callback);
        }
    }

    /**
     * Retrieve cross margin repayments
     * Sort by creation time in descending order by default. Set &#x60;reverse&#x3D;false&#x60; to return ascending results.
     * @return APIlistCrossMarginRepaymentsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistCrossMarginRepaymentsRequest listCrossMarginRepayments() {
        return new APIlistCrossMarginRepaymentsRequest();
    }

    /**
     * Build call for repayCrossMarginLoan
     * @param crossMarginRepayRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan repaid </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call repayCrossMarginLoanCall(CrossMarginRepayRequest crossMarginRepayRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = crossMarginRepayRequest;

        // create path and map variables
        String localVarPath = "/margin/cross/repayments";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call repayCrossMarginLoanValidateBeforeCall(CrossMarginRepayRequest crossMarginRepayRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'crossMarginRepayRequest' is set
        if (crossMarginRepayRequest == null) {
            throw new ApiException("Missing the required parameter 'crossMarginRepayRequest' when calling repayCrossMarginLoan(Async)");
        }

        okhttp3.Call localVarCall = repayCrossMarginLoanCall(crossMarginRepayRequest, _callback);
        return localVarCall;
    }

    /**
     * Cross margin repayments
     * When the liquidity of the currency is insufficient and the transaction risk is high, the currency will be disabled, and funds cannot be transferred.When the available balance of cross-margin is insufficient, the balance of the spot account can be used for repayment. Please ensure that the balance of the spot account is sufficient, and system uses cross-margin account for repayment first
     * @param crossMarginRepayRequest  (required)
     * @return List&lt;CrossMarginLoan&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan repaid </td><td>  -  </td></tr>
     </table>
     */
    public List<CrossMarginLoan> repayCrossMarginLoan(CrossMarginRepayRequest crossMarginRepayRequest) throws ApiException {
        ApiResponse<List<CrossMarginLoan>> localVarResp = repayCrossMarginLoanWithHttpInfo(crossMarginRepayRequest);
        return localVarResp.getData();
    }

    /**
     * Cross margin repayments
     * When the liquidity of the currency is insufficient and the transaction risk is high, the currency will be disabled, and funds cannot be transferred.When the available balance of cross-margin is insufficient, the balance of the spot account can be used for repayment. Please ensure that the balance of the spot account is sufficient, and system uses cross-margin account for repayment first
     * @param crossMarginRepayRequest  (required)
     * @return ApiResponse&lt;List&lt;CrossMarginLoan&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan repaid </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CrossMarginLoan>> repayCrossMarginLoanWithHttpInfo(CrossMarginRepayRequest crossMarginRepayRequest) throws ApiException {
        okhttp3.Call localVarCall = repayCrossMarginLoanValidateBeforeCall(crossMarginRepayRequest, null);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cross margin repayments (asynchronously)
     * When the liquidity of the currency is insufficient and the transaction risk is high, the currency will be disabled, and funds cannot be transferred.When the available balance of cross-margin is insufficient, the balance of the spot account can be used for repayment. Please ensure that the balance of the spot account is sufficient, and system uses cross-margin account for repayment first
     * @param crossMarginRepayRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Loan repaid </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call repayCrossMarginLoanAsync(CrossMarginRepayRequest crossMarginRepayRequest, final ApiCallback<List<CrossMarginLoan>> _callback) throws ApiException {
        okhttp3.Call localVarCall = repayCrossMarginLoanValidateBeforeCall(crossMarginRepayRequest, _callback);
        Type localVarReturnType = new TypeToken<List<CrossMarginLoan>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call getCrossMarginInterestRecordsCall(String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/interest_records";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCrossMarginInterestRecordsValidateBeforeCall(String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginInterestRecordsCall(currency, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<UniLoanInterestRecord>> getCrossMarginInterestRecordsWithHttpInfo(String currency, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginInterestRecordsValidateBeforeCall(currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getCrossMarginInterestRecordsAsync(String currency, Integer page, Integer limit, final ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginInterestRecordsValidateBeforeCall(currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLoanInterestRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetCrossMarginInterestRecordsRequest {
        private String currency;
        private Integer page;
        private Integer limit;

        private APIgetCrossMarginInterestRecordsRequest() {
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIgetCrossMarginInterestRecordsRequest
         */
        public APIgetCrossMarginInterestRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIgetCrossMarginInterestRecordsRequest
         */
        public APIgetCrossMarginInterestRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum response items.  Default: 100, minimum: 1, Maximum: 100 (optional, default to 100)
         * @return APIgetCrossMarginInterestRecordsRequest
         */
        public APIgetCrossMarginInterestRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for getCrossMarginInterestRecords
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getCrossMarginInterestRecordsCall(currency, page, limit, _callback);
        }

        /**
         * Execute getCrossMarginInterestRecords request
         * @return List&lt;UniLoanInterestRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<UniLoanInterestRecord> execute() throws ApiException {
            ApiResponse<List<UniLoanInterestRecord>> localVarResp = getCrossMarginInterestRecordsWithHttpInfo(currency, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute getCrossMarginInterestRecords request with HTTP info returned
         * @return ApiResponse&lt;List&lt;UniLoanInterestRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<UniLoanInterestRecord>> executeWithHttpInfo() throws ApiException {
            return getCrossMarginInterestRecordsWithHttpInfo(currency, page, limit);
        }

        /**
         * Execute getCrossMarginInterestRecords request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<UniLoanInterestRecord>> _callback) throws ApiException {
            return getCrossMarginInterestRecordsAsync(currency, page, limit, _callback);
        }
    }

    /**
     * Interest records for the cross margin account
     * 
     * @return APIgetCrossMarginInterestRecordsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIgetCrossMarginInterestRecordsRequest getCrossMarginInterestRecords() {
        return new APIgetCrossMarginInterestRecordsRequest();
    }

    /**
     * Build call for getCrossMarginTransferable
     * @param currency Retrieve data of the specified currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginTransferableCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/transferable";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCrossMarginTransferableValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCrossMarginTransferable(Async)");
        }

        okhttp3.Call localVarCall = getCrossMarginTransferableCall(currency, _callback);
        return localVarCall;
    }

    /**
     * Get the max transferable amount for a specific cross margin currency
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @return CrossMarginTransferable
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public CrossMarginTransferable getCrossMarginTransferable(String currency) throws ApiException {
        ApiResponse<CrossMarginTransferable> localVarResp = getCrossMarginTransferableWithHttpInfo(currency);
        return localVarResp.getData();
    }

    /**
     * Get the max transferable amount for a specific cross margin currency
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @return ApiResponse&lt;CrossMarginTransferable&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CrossMarginTransferable> getCrossMarginTransferableWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginTransferableValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<CrossMarginTransferable>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the max transferable amount for a specific cross margin currency (asynchronously)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginTransferableAsync(String currency, final ApiCallback<CrossMarginTransferable> _callback) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginTransferableValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginTransferable>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getCrossMarginBorrowable
     * @param currency Retrieve data of the specified currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginBorrowableCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/margin/cross/borrowable";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getCrossMarginBorrowableValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCrossMarginBorrowable(Async)");
        }

        okhttp3.Call localVarCall = getCrossMarginBorrowableCall(currency, _callback);
        return localVarCall;
    }

    /**
     * Get the max borrowable amount for a specific cross margin currency
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @return CrossMarginBorrowable
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public CrossMarginBorrowable getCrossMarginBorrowable(String currency) throws ApiException {
        ApiResponse<CrossMarginBorrowable> localVarResp = getCrossMarginBorrowableWithHttpInfo(currency);
        return localVarResp.getData();
    }

    /**
     * Get the max borrowable amount for a specific cross margin currency
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @return ApiResponse&lt;CrossMarginBorrowable&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CrossMarginBorrowable> getCrossMarginBorrowableWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginBorrowableValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<CrossMarginBorrowable>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the max borrowable amount for a specific cross margin currency (asynchronously)
     * 
     * @param currency Retrieve data of the specified currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getCrossMarginBorrowableAsync(String currency, final ApiCallback<CrossMarginBorrowable> _callback) throws ApiException {
        okhttp3.Call localVarCall = getCrossMarginBorrowableValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<CrossMarginBorrowable>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

}
