/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.CreateUniLend;
import io.gate.gateapi.models.PatchUniLend;
import io.gate.gateapi.models.UniCurrency;
import io.gate.gateapi.models.UniInterestRecord;
import io.gate.gateapi.models.UniLend;
import io.gate.gateapi.models.UniLendInterest;
import io.gate.gateapi.models.UniLendRecord;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EarnUniApi {
    private ApiClient localVarApiClient;

    public EarnUniApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EarnUniApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for listUniCurrencies
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUniCurrenciesCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/earn/uni/currencies";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUniCurrenciesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniCurrenciesCall(_callback);
        return localVarCall;
    }

    /**
     * List currencies for lending
     * 
     * @return List&lt;UniCurrency&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<UniCurrency> listUniCurrencies() throws ApiException {
        ApiResponse<List<UniCurrency>> localVarResp = listUniCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List currencies for lending
     * 
     * @return ApiResponse&lt;List&lt;UniCurrency&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<UniCurrency>> listUniCurrenciesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listUniCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<UniCurrency>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List currencies for lending (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listUniCurrenciesAsync(final ApiCallback<List<UniCurrency>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<UniCurrency>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getUniCurrency
     * @param currency Currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUniCurrencyCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/earn/uni/currencies/{currency}"
            .replaceAll("\\{" + "currency" + "\\}", localVarApiClient.escapeString(currency));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniCurrencyValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUniCurrency(Async)");
        }

        okhttp3.Call localVarCall = getUniCurrencyCall(currency, _callback);
        return localVarCall;
    }

    /**
     * Get currency detail for lending
     * 
     * @param currency Currency (required)
     * @return UniCurrency
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public UniCurrency getUniCurrency(String currency) throws ApiException {
        ApiResponse<UniCurrency> localVarResp = getUniCurrencyWithHttpInfo(currency);
        return localVarResp.getData();
    }

    /**
     * Get currency detail for lending
     * 
     * @param currency Currency (required)
     * @return ApiResponse&lt;UniCurrency&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UniCurrency> getUniCurrencyWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = getUniCurrencyValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<UniCurrency>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get currency detail for lending (asynchronously)
     * 
     * @param currency Currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUniCurrencyAsync(String currency, final ApiCallback<UniCurrency> _callback) throws ApiException {
        okhttp3.Call localVarCall = getUniCurrencyValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<UniCurrency>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listUserUniLendsCall(String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/earn/uni/lends";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUserUniLendsValidateBeforeCall(String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listUserUniLendsCall(currency, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<UniLend>> listUserUniLendsWithHttpInfo(String currency, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listUserUniLendsValidateBeforeCall(currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniLend>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUserUniLendsAsync(String currency, Integer page, Integer limit, final ApiCallback<List<UniLend>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listUserUniLendsValidateBeforeCall(currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniLend>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUserUniLendsRequest {
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistUserUniLendsRequest() {
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistUserUniLendsRequest
         */
        public APIlistUserUniLendsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistUserUniLendsRequest
         */
        public APIlistUserUniLendsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum response items.  Default: 100, minimum: 1, Maximum: 100 (optional, default to 100)
         * @return APIlistUserUniLendsRequest
         */
        public APIlistUserUniLendsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listUserUniLends
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUserUniLendsCall(currency, page, limit, _callback);
        }

        /**
         * Execute listUserUniLends request
         * @return List&lt;UniLend&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<UniLend> execute() throws ApiException {
            ApiResponse<List<UniLend>> localVarResp = listUserUniLendsWithHttpInfo(currency, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listUserUniLends request with HTTP info returned
         * @return ApiResponse&lt;List&lt;UniLend&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<UniLend>> executeWithHttpInfo() throws ApiException {
            return listUserUniLendsWithHttpInfo(currency, page, limit);
        }

        /**
         * Execute listUserUniLends request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<UniLend>> _callback) throws ApiException {
            return listUserUniLendsAsync(currency, page, limit, _callback);
        }
    }

    /**
     * List user&#39;s lending orders
     * 
     * @return APIlistUserUniLendsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUserUniLendsRequest listUserUniLends() {
        return new APIlistUserUniLendsRequest();
    }

    /**
     * Build call for createUniLend
     * @param createUniLend  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Operated successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUniLendCall(CreateUniLend createUniLend, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createUniLend;

        // create path and map variables
        String localVarPath = "/earn/uni/lends";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createUniLendValidateBeforeCall(CreateUniLend createUniLend, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'createUniLend' is set
        if (createUniLend == null) {
            throw new ApiException("Missing the required parameter 'createUniLend' when calling createUniLend(Async)");
        }

        okhttp3.Call localVarCall = createUniLendCall(createUniLend, _callback);
        return localVarCall;
    }

    /**
     * Lend or redeem
     * &#x60;Lending&#x60;:  The minimum interest rate is required in lending. The lending result is updated hourly and the interest profit is paid on the next hour. A high interest rate might lead to unsuccessful lending and no profit will be gained for that hour. If the funds are redeemed before the hourly settlement, no interest can be obtained for that hour. About priority: the orders created or amended first under the same interest rate will be lent out first  &#x60;Redemption&#x60;:  Funds that failed to be lent can be redeemed immediately.  For the successfully lent funds, enjoy the hourly income, and the redemption will arrive at the next hour  &#x60;Note&#x60;:  Two minutes before and after the hour is the settlement time, lending and redemption are prohibited. 
     * @param createUniLend  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Operated successfully </td><td>  -  </td></tr>
     </table>
     */
    public void createUniLend(CreateUniLend createUniLend) throws ApiException {
        createUniLendWithHttpInfo(createUniLend);
    }

    /**
     * Lend or redeem
     * &#x60;Lending&#x60;:  The minimum interest rate is required in lending. The lending result is updated hourly and the interest profit is paid on the next hour. A high interest rate might lead to unsuccessful lending and no profit will be gained for that hour. If the funds are redeemed before the hourly settlement, no interest can be obtained for that hour. About priority: the orders created or amended first under the same interest rate will be lent out first  &#x60;Redemption&#x60;:  Funds that failed to be lent can be redeemed immediately.  For the successfully lent funds, enjoy the hourly income, and the redemption will arrive at the next hour  &#x60;Note&#x60;:  Two minutes before and after the hour is the settlement time, lending and redemption are prohibited. 
     * @param createUniLend  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Operated successfully </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createUniLendWithHttpInfo(CreateUniLend createUniLend) throws ApiException {
        okhttp3.Call localVarCall = createUniLendValidateBeforeCall(createUniLend, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Lend or redeem (asynchronously)
     * &#x60;Lending&#x60;:  The minimum interest rate is required in lending. The lending result is updated hourly and the interest profit is paid on the next hour. A high interest rate might lead to unsuccessful lending and no profit will be gained for that hour. If the funds are redeemed before the hourly settlement, no interest can be obtained for that hour. About priority: the orders created or amended first under the same interest rate will be lent out first  &#x60;Redemption&#x60;:  Funds that failed to be lent can be redeemed immediately.  For the successfully lent funds, enjoy the hourly income, and the redemption will arrive at the next hour  &#x60;Note&#x60;:  Two minutes before and after the hour is the settlement time, lending and redemption are prohibited. 
     * @param createUniLend  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Operated successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createUniLendAsync(CreateUniLend createUniLend, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = createUniLendValidateBeforeCall(createUniLend, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    /**
     * Build call for changeUniLend
     * @param patchUniLend  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call changeUniLendCall(PatchUniLend patchUniLend, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = patchUniLend;

        // create path and map variables
        String localVarPath = "/earn/uni/lends";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call changeUniLendValidateBeforeCall(PatchUniLend patchUniLend, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'patchUniLend' is set
        if (patchUniLend == null) {
            throw new ApiException("Missing the required parameter 'patchUniLend' when calling changeUniLend(Async)");
        }

        okhttp3.Call localVarCall = changeUniLendCall(patchUniLend, _callback);
        return localVarCall;
    }

    /**
     * Amend lending order
     * Currently only supports amending the minimum interest rate (hour)
     * @param patchUniLend  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public void changeUniLend(PatchUniLend patchUniLend) throws ApiException {
        changeUniLendWithHttpInfo(patchUniLend);
    }

    /**
     * Amend lending order
     * Currently only supports amending the minimum interest rate (hour)
     * @param patchUniLend  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> changeUniLendWithHttpInfo(PatchUniLend patchUniLend) throws ApiException {
        okhttp3.Call localVarCall = changeUniLendValidateBeforeCall(patchUniLend, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Amend lending order (asynchronously)
     * Currently only supports amending the minimum interest rate (hour)
     * @param patchUniLend  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call changeUniLendAsync(PatchUniLend patchUniLend, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = changeUniLendValidateBeforeCall(patchUniLend, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private okhttp3.Call listUniLendRecordsCall(String currency, Integer page, Integer limit, String type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/earn/uni/lend_records";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUniLendRecordsValidateBeforeCall(String currency, Integer page, Integer limit, String type, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniLendRecordsCall(currency, page, limit, type, _callback);
        return localVarCall;
    }


    private ApiResponse<List<UniLendRecord>> listUniLendRecordsWithHttpInfo(String currency, Integer page, Integer limit, String type) throws ApiException {
        okhttp3.Call localVarCall = listUniLendRecordsValidateBeforeCall(currency, page, limit, type, null);
        Type localVarReturnType = new TypeToken<List<UniLendRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUniLendRecordsAsync(String currency, Integer page, Integer limit, String type, final ApiCallback<List<UniLendRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniLendRecordsValidateBeforeCall(currency, page, limit, type, _callback);
        Type localVarReturnType = new TypeToken<List<UniLendRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUniLendRecordsRequest {
        private String currency;
        private Integer page;
        private Integer limit;
        private String type;

        private APIlistUniLendRecordsRequest() {
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistUniLendRecordsRequest
         */
        public APIlistUniLendRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistUniLendRecordsRequest
         */
        public APIlistUniLendRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum response items.  Default: 100, minimum: 1, Maximum: 100 (optional, default to 100)
         * @return APIlistUniLendRecordsRequest
         */
        public APIlistUniLendRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set type
         * @param type type: lend - lend, redeem - redeem (optional)
         * @return APIlistUniLendRecordsRequest
         */
        public APIlistUniLendRecordsRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Build call for listUniLendRecords
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUniLendRecordsCall(currency, page, limit, type, _callback);
        }

        /**
         * Execute listUniLendRecords request
         * @return List&lt;UniLendRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<UniLendRecord> execute() throws ApiException {
            ApiResponse<List<UniLendRecord>> localVarResp = listUniLendRecordsWithHttpInfo(currency, page, limit, type);
            return localVarResp.getData();
        }

        /**
         * Execute listUniLendRecords request with HTTP info returned
         * @return ApiResponse&lt;List&lt;UniLendRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<UniLendRecord>> executeWithHttpInfo() throws ApiException {
            return listUniLendRecordsWithHttpInfo(currency, page, limit, type);
        }

        /**
         * Execute listUniLendRecords request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<UniLendRecord>> _callback) throws ApiException {
            return listUniLendRecordsAsync(currency, page, limit, type, _callback);
        }
    }

    /**
     * List records of lending
     * 
     * @return APIlistUniLendRecordsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUniLendRecordsRequest listUniLendRecords() {
        return new APIlistUniLendRecordsRequest();
    }

    /**
     * Build call for getUniInterest
     * @param currency Currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUniInterestCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/earn/uni/interests/{currency}"
            .replaceAll("\\{" + "currency" + "\\}", localVarApiClient.escapeString(currency));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUniInterestValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getUniInterest(Async)");
        }

        okhttp3.Call localVarCall = getUniInterestCall(currency, _callback);
        return localVarCall;
    }

    /**
     * Get the user&#39;s total interest income of specified currency
     * 
     * @param currency Currency (required)
     * @return UniLendInterest
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public UniLendInterest getUniInterest(String currency) throws ApiException {
        ApiResponse<UniLendInterest> localVarResp = getUniInterestWithHttpInfo(currency);
        return localVarResp.getData();
    }

    /**
     * Get the user&#39;s total interest income of specified currency
     * 
     * @param currency Currency (required)
     * @return ApiResponse&lt;UniLendInterest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UniLendInterest> getUniInterestWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = getUniInterestValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<UniLendInterest>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the user&#39;s total interest income of specified currency (asynchronously)
     * 
     * @param currency Currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUniInterestAsync(String currency, final ApiCallback<UniLendInterest> _callback) throws ApiException {
        okhttp3.Call localVarCall = getUniInterestValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<UniLendInterest>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listUniInterestRecordsCall(String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/earn/uni/interest_records";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listUniInterestRecordsValidateBeforeCall(String currency, Integer page, Integer limit, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniInterestRecordsCall(currency, page, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<UniInterestRecord>> listUniInterestRecordsWithHttpInfo(String currency, Integer page, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listUniInterestRecordsValidateBeforeCall(currency, page, limit, null);
        Type localVarReturnType = new TypeToken<List<UniInterestRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listUniInterestRecordsAsync(String currency, Integer page, Integer limit, final ApiCallback<List<UniInterestRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listUniInterestRecordsValidateBeforeCall(currency, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<UniInterestRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistUniInterestRecordsRequest {
        private String currency;
        private Integer page;
        private Integer limit;

        private APIlistUniInterestRecordsRequest() {
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistUniInterestRecordsRequest
         */
        public APIlistUniInterestRecordsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistUniInterestRecordsRequest
         */
        public APIlistUniInterestRecordsRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum response items.  Default: 100, minimum: 1, Maximum: 100 (optional, default to 100)
         * @return APIlistUniInterestRecordsRequest
         */
        public APIlistUniInterestRecordsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listUniInterestRecords
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listUniInterestRecordsCall(currency, page, limit, _callback);
        }

        /**
         * Execute listUniInterestRecords request
         * @return List&lt;UniInterestRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<UniInterestRecord> execute() throws ApiException {
            ApiResponse<List<UniInterestRecord>> localVarResp = listUniInterestRecordsWithHttpInfo(currency, page, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listUniInterestRecords request with HTTP info returned
         * @return ApiResponse&lt;List&lt;UniInterestRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<UniInterestRecord>> executeWithHttpInfo() throws ApiException {
            return listUniInterestRecordsWithHttpInfo(currency, page, limit);
        }

        /**
         * Execute listUniInterestRecords request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<UniInterestRecord>> _callback) throws ApiException {
            return listUniInterestRecordsAsync(currency, page, limit, _callback);
        }
    }

    /**
     * List interest records
     * 
     * @return APIlistUniInterestRecordsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistUniInterestRecordsRequest listUniInterestRecords() {
        return new APIlistUniInterestRecordsRequest();
    }

}
