/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gate.gateapi.models.PositionCloseOrder;
import java.io.IOException;

/**
 * Futures position details
 */
public class OptionsPosition {
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(SERIALIZED_NAME_USER)
    private Integer user;

    public static final String SERIALIZED_NAME_CONTRACT = "contract";
    @SerializedName(SERIALIZED_NAME_CONTRACT)
    private String contract;

    public static final String SERIALIZED_NAME_SIZE = "size";
    @SerializedName(SERIALIZED_NAME_SIZE)
    private Long size;

    public static final String SERIALIZED_NAME_ENTRY_PRICE = "entry_price";
    @SerializedName(SERIALIZED_NAME_ENTRY_PRICE)
    private String entryPrice;

    public static final String SERIALIZED_NAME_MARK_PRICE = "mark_price";
    @SerializedName(SERIALIZED_NAME_MARK_PRICE)
    private String markPrice;

    public static final String SERIALIZED_NAME_REALISED_PNL = "realised_pnl";
    @SerializedName(SERIALIZED_NAME_REALISED_PNL)
    private String realisedPnl;

    public static final String SERIALIZED_NAME_UNREALISED_PNL = "unrealised_pnl";
    @SerializedName(SERIALIZED_NAME_UNREALISED_PNL)
    private String unrealisedPnl;

    public static final String SERIALIZED_NAME_PENDING_ORDERS = "pending_orders";
    @SerializedName(SERIALIZED_NAME_PENDING_ORDERS)
    private Integer pendingOrders;

    public static final String SERIALIZED_NAME_CLOSE_ORDER = "close_order";
    @SerializedName(SERIALIZED_NAME_CLOSE_ORDER)
    private PositionCloseOrder closeOrder;


     /**
     * User ID
     * @return user
    **/
    @javax.annotation.Nullable
    public Integer getUser() {
        return user;
    }


     /**
     * Futures contract
     * @return contract
    **/
    @javax.annotation.Nullable
    public String getContract() {
        return contract;
    }


     /**
     * Position size
     * @return size
    **/
    @javax.annotation.Nullable
    public Long getSize() {
        return size;
    }


     /**
     * Entry price
     * @return entryPrice
    **/
    @javax.annotation.Nullable
    public String getEntryPrice() {
        return entryPrice;
    }


     /**
     * Current mark price
     * @return markPrice
    **/
    @javax.annotation.Nullable
    public String getMarkPrice() {
        return markPrice;
    }


     /**
     * Realized PNL
     * @return realisedPnl
    **/
    @javax.annotation.Nullable
    public String getRealisedPnl() {
        return realisedPnl;
    }


     /**
     * Unrealized PNL
     * @return unrealisedPnl
    **/
    @javax.annotation.Nullable
    public String getUnrealisedPnl() {
        return unrealisedPnl;
    }


     /**
     * Current open orders
     * @return pendingOrders
    **/
    @javax.annotation.Nullable
    public Integer getPendingOrders() {
        return pendingOrders;
    }


    public OptionsPosition closeOrder(PositionCloseOrder closeOrder) {
        
        this.closeOrder = closeOrder;
        return this;
    }

     /**
     * Get closeOrder
     * @return closeOrder
    **/
    @javax.annotation.Nullable
    public PositionCloseOrder getCloseOrder() {
        return closeOrder;
    }


    public void setCloseOrder(PositionCloseOrder closeOrder) {
        this.closeOrder = closeOrder;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OptionsPosition optionsPosition = (OptionsPosition) o;
        return Objects.equals(this.user, optionsPosition.user) &&
                Objects.equals(this.contract, optionsPosition.contract) &&
                Objects.equals(this.size, optionsPosition.size) &&
                Objects.equals(this.entryPrice, optionsPosition.entryPrice) &&
                Objects.equals(this.markPrice, optionsPosition.markPrice) &&
                Objects.equals(this.realisedPnl, optionsPosition.realisedPnl) &&
                Objects.equals(this.unrealisedPnl, optionsPosition.unrealisedPnl) &&
                Objects.equals(this.pendingOrders, optionsPosition.pendingOrders) &&
                Objects.equals(this.closeOrder, optionsPosition.closeOrder);
    }

    @Override
    public int hashCode() {
        return Objects.hash(user, contract, size, entryPrice, markPrice, realisedPnl, unrealisedPnl, pendingOrders, closeOrder);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OptionsPosition {\n");
        sb.append("      user: ").append(toIndentedString(user)).append("\n");
        sb.append("      contract: ").append(toIndentedString(contract)).append("\n");
        sb.append("      size: ").append(toIndentedString(size)).append("\n");
        sb.append("      entryPrice: ").append(toIndentedString(entryPrice)).append("\n");
        sb.append("      markPrice: ").append(toIndentedString(markPrice)).append("\n");
        sb.append("      realisedPnl: ").append(toIndentedString(realisedPnl)).append("\n");
        sb.append("      unrealisedPnl: ").append(toIndentedString(unrealisedPnl)).append("\n");
        sb.append("      pendingOrders: ").append(toIndentedString(pendingOrders)).append("\n");
        sb.append("      closeOrder: ").append(toIndentedString(closeOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

