/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * Flash swap order
 */
public class FlashSwapOrder {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(SERIALIZED_NAME_ID)
    private Long id;

    public static final String SERIALIZED_NAME_CREATE_TIME = "create_time";
    @SerializedName(SERIALIZED_NAME_CREATE_TIME)
    private Long createTime;

    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(SERIALIZED_NAME_USER_ID)
    private Long userId;

    public static final String SERIALIZED_NAME_SELL_CURRENCY = "sell_currency";
    @SerializedName(SERIALIZED_NAME_SELL_CURRENCY)
    private String sellCurrency;

    public static final String SERIALIZED_NAME_SELL_AMOUNT = "sell_amount";
    @SerializedName(SERIALIZED_NAME_SELL_AMOUNT)
    private String sellAmount;

    public static final String SERIALIZED_NAME_BUY_CURRENCY = "buy_currency";
    @SerializedName(SERIALIZED_NAME_BUY_CURRENCY)
    private String buyCurrency;

    public static final String SERIALIZED_NAME_BUY_AMOUNT = "buy_amount";
    @SerializedName(SERIALIZED_NAME_BUY_AMOUNT)
    private String buyAmount;

    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(SERIALIZED_NAME_PRICE)
    private String price;

    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(SERIALIZED_NAME_STATUS)
    private Integer status;


     /**
     * Flash swap order ID
     * @return id
    **/
    @javax.annotation.Nullable
    public Long getId() {
        return id;
    }


     /**
     * Creation time of order (in milliseconds)
     * @return createTime
    **/
    @javax.annotation.Nullable
    public Long getCreateTime() {
        return createTime;
    }


     /**
     * User ID
     * @return userId
    **/
    @javax.annotation.Nullable
    public Long getUserId() {
        return userId;
    }


     /**
     * Currency to sell
     * @return sellCurrency
    **/
    @javax.annotation.Nullable
    public String getSellCurrency() {
        return sellCurrency;
    }


     /**
     * Amount to sell
     * @return sellAmount
    **/
    @javax.annotation.Nullable
    public String getSellAmount() {
        return sellAmount;
    }


     /**
     * Currency to buy
     * @return buyCurrency
    **/
    @javax.annotation.Nullable
    public String getBuyCurrency() {
        return buyCurrency;
    }


     /**
     * Amount to buy
     * @return buyAmount
    **/
    @javax.annotation.Nullable
    public String getBuyAmount() {
        return buyAmount;
    }


     /**
     * Price
     * @return price
    **/
    @javax.annotation.Nullable
    public String getPrice() {
        return price;
    }


     /**
     * Flash swap order status  &#x60;1&#x60; - success &#x60;2&#x60; - failure
     * @return status
    **/
    @javax.annotation.Nullable
    public Integer getStatus() {
        return status;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FlashSwapOrder flashSwapOrder = (FlashSwapOrder) o;
        return Objects.equals(this.id, flashSwapOrder.id) &&
                Objects.equals(this.createTime, flashSwapOrder.createTime) &&
                Objects.equals(this.userId, flashSwapOrder.userId) &&
                Objects.equals(this.sellCurrency, flashSwapOrder.sellCurrency) &&
                Objects.equals(this.sellAmount, flashSwapOrder.sellAmount) &&
                Objects.equals(this.buyCurrency, flashSwapOrder.buyCurrency) &&
                Objects.equals(this.buyAmount, flashSwapOrder.buyAmount) &&
                Objects.equals(this.price, flashSwapOrder.price) &&
                Objects.equals(this.status, flashSwapOrder.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, createTime, userId, sellCurrency, sellAmount, buyCurrency, buyAmount, price, status);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FlashSwapOrder {\n");
        sb.append("      id: ").append(toIndentedString(id)).append("\n");
        sb.append("      createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("      userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("      sellCurrency: ").append(toIndentedString(sellCurrency)).append("\n");
        sb.append("      sellAmount: ").append(toIndentedString(sellAmount)).append("\n");
        sb.append("      buyCurrency: ").append(toIndentedString(buyCurrency)).append("\n");
        sb.append("      buyAmount: ").append(toIndentedString(buyAmount)).append("\n");
        sb.append("      price: ").append(toIndentedString(price)).append("\n");
        sb.append("      status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

