/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gate.gateapi.models.MultiChainAddressItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * DepositAddress
 */
public class DepositAddress {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(SERIALIZED_NAME_CURRENCY)
    private String currency;

    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(SERIALIZED_NAME_ADDRESS)
    private String address;

    public static final String SERIALIZED_NAME_MULTICHAIN_ADDRESSES = "multichain_addresses";
    @SerializedName(SERIALIZED_NAME_MULTICHAIN_ADDRESSES)
    private List<MultiChainAddressItem> multichainAddresses = null;


    public DepositAddress currency(String currency) {
        
        this.currency = currency;
        return this;
    }

     /**
     * Currency detail
     * @return currency
    **/
    public String getCurrency() {
        return currency;
    }


    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public DepositAddress address(String address) {
        
        this.address = address;
        return this;
    }

     /**
     * Deposit address
     * @return address
    **/
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    public DepositAddress multichainAddresses(List<MultiChainAddressItem> multichainAddresses) {
        
        this.multichainAddresses = multichainAddresses;
        return this;
    }

    public DepositAddress addMultichainAddressesItem(MultiChainAddressItem multichainAddressesItem) {
        if (this.multichainAddresses == null) {
            this.multichainAddresses = new ArrayList<>();
        }
        this.multichainAddresses.add(multichainAddressesItem);
        return this;
    }

     /**
     * Get multichainAddresses
     * @return multichainAddresses
    **/
    @javax.annotation.Nullable
    public List<MultiChainAddressItem> getMultichainAddresses() {
        return multichainAddresses;
    }


    public void setMultichainAddresses(List<MultiChainAddressItem> multichainAddresses) {
        this.multichainAddresses = multichainAddresses;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DepositAddress depositAddress = (DepositAddress) o;
        return Objects.equals(this.currency, depositAddress.currency) &&
                Objects.equals(this.address, depositAddress.address) &&
                Objects.equals(this.multichainAddresses, depositAddress.multichainAddresses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, address, multichainAddresses);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositAddress {\n");
        sb.append("      currency: ").append(toIndentedString(currency)).append("\n");
        sb.append("      address: ").append(toIndentedString(address)).append("\n");
        sb.append("      multichainAddresses: ").append(toIndentedString(multichainAddresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

