/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gate.gateapi.models.CrossMarginBalance;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CrossMarginAccount
 */
public class CrossMarginAccount {
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(SERIALIZED_NAME_USER_ID)
    private Long userId;

    public static final String SERIALIZED_NAME_LOCKED = "locked";
    @SerializedName(SERIALIZED_NAME_LOCKED)
    private Boolean locked;

    public static final String SERIALIZED_NAME_BALANCES = "balances";
    @SerializedName(SERIALIZED_NAME_BALANCES)
    private Map<String, CrossMarginBalance> balances = null;

    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(SERIALIZED_NAME_TOTAL)
    private String total;

    public static final String SERIALIZED_NAME_BORROWED = "borrowed";
    @SerializedName(SERIALIZED_NAME_BORROWED)
    private String borrowed;

    public static final String SERIALIZED_NAME_INTEREST = "interest";
    @SerializedName(SERIALIZED_NAME_INTEREST)
    private String interest;

    public static final String SERIALIZED_NAME_RISK = "risk";
    @SerializedName(SERIALIZED_NAME_RISK)
    private String risk;


    public CrossMarginAccount userId(Long userId) {
        
        this.userId = userId;
        return this;
    }

     /**
     * User ID
     * @return userId
    **/
    @javax.annotation.Nullable
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public CrossMarginAccount locked(Boolean locked) {
        
        this.locked = locked;
        return this;
    }

     /**
     * Whether account is locked
     * @return locked
    **/
    @javax.annotation.Nullable
    public Boolean getLocked() {
        return locked;
    }


    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public CrossMarginAccount balances(Map<String, CrossMarginBalance> balances) {
        
        this.balances = balances;
        return this;
    }

    public CrossMarginAccount putBalancesItem(String key, CrossMarginBalance balancesItem) {
        if (this.balances == null) {
            this.balances = new HashMap<>();
        }
        this.balances.put(key, balancesItem);
        return this;
    }

     /**
     * Get balances
     * @return balances
    **/
    @javax.annotation.Nullable
    public Map<String, CrossMarginBalance> getBalances() {
        return balances;
    }


    public void setBalances(Map<String, CrossMarginBalance> balances) {
        this.balances = balances;
    }

    public CrossMarginAccount total(String total) {
        
        this.total = total;
        return this;
    }

     /**
     * Total account value in USDT, i.e., the sum of all currencies&#39; &#x60;(available+freeze)*price*discount&#x60;
     * @return total
    **/
    @javax.annotation.Nullable
    public String getTotal() {
        return total;
    }


    public void setTotal(String total) {
        this.total = total;
    }

    public CrossMarginAccount borrowed(String borrowed) {
        
        this.borrowed = borrowed;
        return this;
    }

     /**
     * Total borrowed value in USDT, i.e., the sum of all currencies&#39; &#x60;borrowed*price*discount&#x60;
     * @return borrowed
    **/
    @javax.annotation.Nullable
    public String getBorrowed() {
        return borrowed;
    }


    public void setBorrowed(String borrowed) {
        this.borrowed = borrowed;
    }

    public CrossMarginAccount interest(String interest) {
        
        this.interest = interest;
        return this;
    }

     /**
     * Total unpaid interests in USDT, i.e., the sum of all currencies&#39; &#x60;interest*price*discount&#x60;
     * @return interest
    **/
    @javax.annotation.Nullable
    public String getInterest() {
        return interest;
    }


    public void setInterest(String interest) {
        this.interest = interest;
    }

    public CrossMarginAccount risk(String risk) {
        
        this.risk = risk;
        return this;
    }

     /**
     * Risk rate. When it belows 110%, liquidation will be triggered. Calculation formula: &#x60;total / (borrowed+interest)&#x60;
     * @return risk
    **/
    @javax.annotation.Nullable
    public String getRisk() {
        return risk;
    }


    public void setRisk(String risk) {
        this.risk = risk;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CrossMarginAccount crossMarginAccount = (CrossMarginAccount) o;
        return Objects.equals(this.userId, crossMarginAccount.userId) &&
                Objects.equals(this.locked, crossMarginAccount.locked) &&
                Objects.equals(this.balances, crossMarginAccount.balances) &&
                Objects.equals(this.total, crossMarginAccount.total) &&
                Objects.equals(this.borrowed, crossMarginAccount.borrowed) &&
                Objects.equals(this.interest, crossMarginAccount.interest) &&
                Objects.equals(this.risk, crossMarginAccount.risk);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId, locked, balances, total, borrowed, interest, risk);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrossMarginAccount {\n");
        sb.append("      userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("      locked: ").append(toIndentedString(locked)).append("\n");
        sb.append("      balances: ").append(toIndentedString(balances)).append("\n");
        sb.append("      total: ").append(toIndentedString(total)).append("\n");
        sb.append("      borrowed: ").append(toIndentedString(borrowed)).append("\n");
        sb.append("      interest: ").append(toIndentedString(interest)).append("\n");
        sb.append("      risk: ").append(toIndentedString(risk)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

