/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

/**
 * ContractStat
 */
public class ContractStat {
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(SERIALIZED_NAME_TIME)
    private Long time;

    public static final String SERIALIZED_NAME_LSR_TAKER = "lsr_taker";
    @SerializedName(SERIALIZED_NAME_LSR_TAKER)
    private BigDecimal lsrTaker;

    public static final String SERIALIZED_NAME_LSR_ACCOUNT = "lsr_account";
    @SerializedName(SERIALIZED_NAME_LSR_ACCOUNT)
    private BigDecimal lsrAccount;

    public static final String SERIALIZED_NAME_LONG_LIQ_SIZE = "long_liq_size";
    @SerializedName(SERIALIZED_NAME_LONG_LIQ_SIZE)
    private Long longLiqSize;

    public static final String SERIALIZED_NAME_LONG_LIQ_AMOUNT = "long_liq_amount";
    @SerializedName(SERIALIZED_NAME_LONG_LIQ_AMOUNT)
    private Double longLiqAmount;

    public static final String SERIALIZED_NAME_LONG_LIQ_USD = "long_liq_usd";
    @SerializedName(SERIALIZED_NAME_LONG_LIQ_USD)
    private Double longLiqUsd;

    public static final String SERIALIZED_NAME_SHORT_LIQ_SIZE = "short_liq_size";
    @SerializedName(SERIALIZED_NAME_SHORT_LIQ_SIZE)
    private Long shortLiqSize;

    public static final String SERIALIZED_NAME_SHORT_LIQ_AMOUNT = "short_liq_amount";
    @SerializedName(SERIALIZED_NAME_SHORT_LIQ_AMOUNT)
    private Double shortLiqAmount;

    public static final String SERIALIZED_NAME_SHORT_LIQ_USD = "short_liq_usd";
    @SerializedName(SERIALIZED_NAME_SHORT_LIQ_USD)
    private Double shortLiqUsd;

    public static final String SERIALIZED_NAME_OPEN_INTEREST = "open_interest";
    @SerializedName(SERIALIZED_NAME_OPEN_INTEREST)
    private Long openInterest;

    public static final String SERIALIZED_NAME_OPEN_INTEREST_USD = "open_interest_usd";
    @SerializedName(SERIALIZED_NAME_OPEN_INTEREST_USD)
    private Double openInterestUsd;

    public static final String SERIALIZED_NAME_TOP_LSR_ACCOUNT = "top_lsr_account";
    @SerializedName(SERIALIZED_NAME_TOP_LSR_ACCOUNT)
    private Double topLsrAccount;

    public static final String SERIALIZED_NAME_TOP_LSR_SIZE = "top_lsr_size";
    @SerializedName(SERIALIZED_NAME_TOP_LSR_SIZE)
    private Double topLsrSize;


    public ContractStat time(Long time) {
        
        this.time = time;
        return this;
    }

     /**
     * Stat timestamp
     * @return time
    **/
    @javax.annotation.Nullable
    public Long getTime() {
        return time;
    }


    public void setTime(Long time) {
        this.time = time;
    }

    public ContractStat lsrTaker(BigDecimal lsrTaker) {
        
        this.lsrTaker = lsrTaker;
        return this;
    }

     /**
     * Long/short account number ratio
     * @return lsrTaker
    **/
    @javax.annotation.Nullable
    public BigDecimal getLsrTaker() {
        return lsrTaker;
    }


    public void setLsrTaker(BigDecimal lsrTaker) {
        this.lsrTaker = lsrTaker;
    }

    public ContractStat lsrAccount(BigDecimal lsrAccount) {
        
        this.lsrAccount = lsrAccount;
        return this;
    }

     /**
     * Long/short taker size ratio
     * @return lsrAccount
    **/
    @javax.annotation.Nullable
    public BigDecimal getLsrAccount() {
        return lsrAccount;
    }


    public void setLsrAccount(BigDecimal lsrAccount) {
        this.lsrAccount = lsrAccount;
    }

    public ContractStat longLiqSize(Long longLiqSize) {
        
        this.longLiqSize = longLiqSize;
        return this;
    }

     /**
     * Long liquidation size
     * @return longLiqSize
    **/
    @javax.annotation.Nullable
    public Long getLongLiqSize() {
        return longLiqSize;
    }


    public void setLongLiqSize(Long longLiqSize) {
        this.longLiqSize = longLiqSize;
    }

    public ContractStat longLiqAmount(Double longLiqAmount) {
        
        this.longLiqAmount = longLiqAmount;
        return this;
    }

     /**
     * Long liquidation amount(base currency)
     * @return longLiqAmount
    **/
    @javax.annotation.Nullable
    public Double getLongLiqAmount() {
        return longLiqAmount;
    }


    public void setLongLiqAmount(Double longLiqAmount) {
        this.longLiqAmount = longLiqAmount;
    }

    public ContractStat longLiqUsd(Double longLiqUsd) {
        
        this.longLiqUsd = longLiqUsd;
        return this;
    }

     /**
     * Long liquidation volume(quote currency)
     * @return longLiqUsd
    **/
    @javax.annotation.Nullable
    public Double getLongLiqUsd() {
        return longLiqUsd;
    }


    public void setLongLiqUsd(Double longLiqUsd) {
        this.longLiqUsd = longLiqUsd;
    }

    public ContractStat shortLiqSize(Long shortLiqSize) {
        
        this.shortLiqSize = shortLiqSize;
        return this;
    }

     /**
     * Short liquidation size
     * @return shortLiqSize
    **/
    @javax.annotation.Nullable
    public Long getShortLiqSize() {
        return shortLiqSize;
    }


    public void setShortLiqSize(Long shortLiqSize) {
        this.shortLiqSize = shortLiqSize;
    }

    public ContractStat shortLiqAmount(Double shortLiqAmount) {
        
        this.shortLiqAmount = shortLiqAmount;
        return this;
    }

     /**
     * Short liquidation amount(base currency)
     * @return shortLiqAmount
    **/
    @javax.annotation.Nullable
    public Double getShortLiqAmount() {
        return shortLiqAmount;
    }


    public void setShortLiqAmount(Double shortLiqAmount) {
        this.shortLiqAmount = shortLiqAmount;
    }

    public ContractStat shortLiqUsd(Double shortLiqUsd) {
        
        this.shortLiqUsd = shortLiqUsd;
        return this;
    }

     /**
     * Short liquidation volume(quote currency)
     * @return shortLiqUsd
    **/
    @javax.annotation.Nullable
    public Double getShortLiqUsd() {
        return shortLiqUsd;
    }


    public void setShortLiqUsd(Double shortLiqUsd) {
        this.shortLiqUsd = shortLiqUsd;
    }

    public ContractStat openInterest(Long openInterest) {
        
        this.openInterest = openInterest;
        return this;
    }

     /**
     * Open interest size
     * @return openInterest
    **/
    @javax.annotation.Nullable
    public Long getOpenInterest() {
        return openInterest;
    }


    public void setOpenInterest(Long openInterest) {
        this.openInterest = openInterest;
    }

    public ContractStat openInterestUsd(Double openInterestUsd) {
        
        this.openInterestUsd = openInterestUsd;
        return this;
    }

     /**
     * Open interest volume(quote currency)
     * @return openInterestUsd
    **/
    @javax.annotation.Nullable
    public Double getOpenInterestUsd() {
        return openInterestUsd;
    }


    public void setOpenInterestUsd(Double openInterestUsd) {
        this.openInterestUsd = openInterestUsd;
    }

    public ContractStat topLsrAccount(Double topLsrAccount) {
        
        this.topLsrAccount = topLsrAccount;
        return this;
    }

     /**
     * Top trader long/short account ratio
     * @return topLsrAccount
    **/
    @javax.annotation.Nullable
    public Double getTopLsrAccount() {
        return topLsrAccount;
    }


    public void setTopLsrAccount(Double topLsrAccount) {
        this.topLsrAccount = topLsrAccount;
    }

    public ContractStat topLsrSize(Double topLsrSize) {
        
        this.topLsrSize = topLsrSize;
        return this;
    }

     /**
     * Top trader long/short position ratio
     * @return topLsrSize
    **/
    @javax.annotation.Nullable
    public Double getTopLsrSize() {
        return topLsrSize;
    }


    public void setTopLsrSize(Double topLsrSize) {
        this.topLsrSize = topLsrSize;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ContractStat contractStat = (ContractStat) o;
        return Objects.equals(this.time, contractStat.time) &&
                Objects.equals(this.lsrTaker, contractStat.lsrTaker) &&
                Objects.equals(this.lsrAccount, contractStat.lsrAccount) &&
                Objects.equals(this.longLiqSize, contractStat.longLiqSize) &&
                Objects.equals(this.longLiqAmount, contractStat.longLiqAmount) &&
                Objects.equals(this.longLiqUsd, contractStat.longLiqUsd) &&
                Objects.equals(this.shortLiqSize, contractStat.shortLiqSize) &&
                Objects.equals(this.shortLiqAmount, contractStat.shortLiqAmount) &&
                Objects.equals(this.shortLiqUsd, contractStat.shortLiqUsd) &&
                Objects.equals(this.openInterest, contractStat.openInterest) &&
                Objects.equals(this.openInterestUsd, contractStat.openInterestUsd) &&
                Objects.equals(this.topLsrAccount, contractStat.topLsrAccount) &&
                Objects.equals(this.topLsrSize, contractStat.topLsrSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(time, lsrTaker, lsrAccount, longLiqSize, longLiqAmount, longLiqUsd, shortLiqSize, shortLiqAmount, shortLiqUsd, openInterest, openInterestUsd, topLsrAccount, topLsrSize);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContractStat {\n");
        sb.append("      time: ").append(toIndentedString(time)).append("\n");
        sb.append("      lsrTaker: ").append(toIndentedString(lsrTaker)).append("\n");
        sb.append("      lsrAccount: ").append(toIndentedString(lsrAccount)).append("\n");
        sb.append("      longLiqSize: ").append(toIndentedString(longLiqSize)).append("\n");
        sb.append("      longLiqAmount: ").append(toIndentedString(longLiqAmount)).append("\n");
        sb.append("      longLiqUsd: ").append(toIndentedString(longLiqUsd)).append("\n");
        sb.append("      shortLiqSize: ").append(toIndentedString(shortLiqSize)).append("\n");
        sb.append("      shortLiqAmount: ").append(toIndentedString(shortLiqAmount)).append("\n");
        sb.append("      shortLiqUsd: ").append(toIndentedString(shortLiqUsd)).append("\n");
        sb.append("      openInterest: ").append(toIndentedString(openInterest)).append("\n");
        sb.append("      openInterestUsd: ").append(toIndentedString(openInterestUsd)).append("\n");
        sb.append("      topLsrAccount: ").append(toIndentedString(topLsrAccount)).append("\n");
        sb.append("      topLsrSize: ").append(toIndentedString(topLsrSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

