/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.CurrencyChain;
import io.gate.gateapi.models.DepositAddress;
import io.gate.gateapi.models.LedgerRecord;
import io.gate.gateapi.models.SubAccountBalance;
import io.gate.gateapi.models.SubAccountFuturesBalance;
import io.gate.gateapi.models.SubAccountMarginBalance;
import io.gate.gateapi.models.SubAccountTransfer;
import io.gate.gateapi.models.TotalBalance;
import io.gate.gateapi.models.TradeFee;
import io.gate.gateapi.models.Transfer;
import io.gate.gateapi.models.WithdrawStatus;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WalletApi {
    private ApiClient localVarApiClient;

    public WalletApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WalletApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for listCurrencyChains
     * @param currency Currency name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCurrencyChainsCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/currency_chains";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listCurrencyChainsValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling listCurrencyChains(Async)");
        }

        okhttp3.Call localVarCall = listCurrencyChainsCall(currency, _callback);
        return localVarCall;
    }

    /**
     * List chains supported for specified currency
     * 
     * @param currency Currency name (required)
     * @return List&lt;CurrencyChain&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<CurrencyChain> listCurrencyChains(String currency) throws ApiException {
        ApiResponse<List<CurrencyChain>> localVarResp = listCurrencyChainsWithHttpInfo(currency);
        return localVarResp.getData();
    }

    /**
     * List chains supported for specified currency
     * 
     * @param currency Currency name (required)
     * @return ApiResponse&lt;List&lt;CurrencyChain&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<CurrencyChain>> listCurrencyChainsWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = listCurrencyChainsValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<CurrencyChain>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List chains supported for specified currency (asynchronously)
     * 
     * @param currency Currency name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listCurrencyChainsAsync(String currency, final ApiCallback<List<CurrencyChain>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listCurrencyChainsValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<CurrencyChain>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getDepositAddress
     * @param currency Currency name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Address successfully generated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDepositAddressCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/deposit_address";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDepositAddressValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'currency' is set
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getDepositAddress(Async)");
        }

        okhttp3.Call localVarCall = getDepositAddressCall(currency, _callback);
        return localVarCall;
    }

    /**
     * Generate currency deposit address
     * 
     * @param currency Currency name (required)
     * @return DepositAddress
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Address successfully generated </td><td>  -  </td></tr>
     </table>
     */
    public DepositAddress getDepositAddress(String currency) throws ApiException {
        ApiResponse<DepositAddress> localVarResp = getDepositAddressWithHttpInfo(currency);
        return localVarResp.getData();
    }

    /**
     * Generate currency deposit address
     * 
     * @param currency Currency name (required)
     * @return ApiResponse&lt;DepositAddress&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Address successfully generated </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DepositAddress> getDepositAddressWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = getDepositAddressValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<DepositAddress>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Generate currency deposit address (asynchronously)
     * 
     * @param currency Currency name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Address successfully generated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDepositAddressAsync(String currency, final ApiCallback<DepositAddress> _callback) throws ApiException {
        okhttp3.Call localVarCall = getDepositAddressValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<DepositAddress>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listWithdrawalsCall(String currency, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/withdrawals";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listWithdrawalsValidateBeforeCall(String currency, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listWithdrawalsCall(currency, from, to, limit, offset, _callback);
        return localVarCall;
    }


    private ApiResponse<List<LedgerRecord>> listWithdrawalsWithHttpInfo(String currency, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        okhttp3.Call localVarCall = listWithdrawalsValidateBeforeCall(currency, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<LedgerRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listWithdrawalsAsync(String currency, Long from, Long to, Integer limit, Integer offset, final ApiCallback<List<LedgerRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listWithdrawalsValidateBeforeCall(currency, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<LedgerRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistWithdrawalsRequest {
        private String currency;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistWithdrawalsRequest() {
        }

        /**
         * Set currency
         * @param currency Filter by currency. Return all currency records if not specified (optional)
         * @return APIlistWithdrawalsRequest
         */
        public APIlistWithdrawalsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set from
         * @param from Time range beginning, default to 7 days before current time (optional)
         * @return APIlistWithdrawalsRequest
         */
        public APIlistWithdrawalsRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to Time range ending, default to current time (optional)
         * @return APIlistWithdrawalsRequest
         */
        public APIlistWithdrawalsRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistWithdrawalsRequest
         */
        public APIlistWithdrawalsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistWithdrawalsRequest
         */
        public APIlistWithdrawalsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Build call for listWithdrawals
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listWithdrawalsCall(currency, from, to, limit, offset, _callback);
        }

        /**
         * Execute listWithdrawals request
         * @return List&lt;LedgerRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<LedgerRecord> execute() throws ApiException {
            ApiResponse<List<LedgerRecord>> localVarResp = listWithdrawalsWithHttpInfo(currency, from, to, limit, offset);
            return localVarResp.getData();
        }

        /**
         * Execute listWithdrawals request with HTTP info returned
         * @return ApiResponse&lt;List&lt;LedgerRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<LedgerRecord>> executeWithHttpInfo() throws ApiException {
            return listWithdrawalsWithHttpInfo(currency, from, to, limit, offset);
        }

        /**
         * Execute listWithdrawals request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<LedgerRecord>> _callback) throws ApiException {
            return listWithdrawalsAsync(currency, from, to, limit, offset, _callback);
        }
    }

    /**
     * Retrieve withdrawal records
     * Record time range cannot exceed 30 days
     * @return APIlistWithdrawalsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistWithdrawalsRequest listWithdrawals() {
        return new APIlistWithdrawalsRequest();
    }

    private okhttp3.Call listDepositsCall(String currency, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/deposits";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listDepositsValidateBeforeCall(String currency, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listDepositsCall(currency, from, to, limit, offset, _callback);
        return localVarCall;
    }


    private ApiResponse<List<LedgerRecord>> listDepositsWithHttpInfo(String currency, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        okhttp3.Call localVarCall = listDepositsValidateBeforeCall(currency, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<LedgerRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listDepositsAsync(String currency, Long from, Long to, Integer limit, Integer offset, final ApiCallback<List<LedgerRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listDepositsValidateBeforeCall(currency, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<LedgerRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistDepositsRequest {
        private String currency;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistDepositsRequest() {
        }

        /**
         * Set currency
         * @param currency Filter by currency. Return all currency records if not specified (optional)
         * @return APIlistDepositsRequest
         */
        public APIlistDepositsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Set from
         * @param from Time range beginning, default to 7 days before current time (optional)
         * @return APIlistDepositsRequest
         */
        public APIlistDepositsRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to Time range ending, default to current time (optional)
         * @return APIlistDepositsRequest
         */
        public APIlistDepositsRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistDepositsRequest
         */
        public APIlistDepositsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistDepositsRequest
         */
        public APIlistDepositsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Build call for listDeposits
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listDepositsCall(currency, from, to, limit, offset, _callback);
        }

        /**
         * Execute listDeposits request
         * @return List&lt;LedgerRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<LedgerRecord> execute() throws ApiException {
            ApiResponse<List<LedgerRecord>> localVarResp = listDepositsWithHttpInfo(currency, from, to, limit, offset);
            return localVarResp.getData();
        }

        /**
         * Execute listDeposits request with HTTP info returned
         * @return ApiResponse&lt;List&lt;LedgerRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<LedgerRecord>> executeWithHttpInfo() throws ApiException {
            return listDepositsWithHttpInfo(currency, from, to, limit, offset);
        }

        /**
         * Execute listDeposits request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<LedgerRecord>> _callback) throws ApiException {
            return listDepositsAsync(currency, from, to, limit, offset, _callback);
        }
    }

    /**
     * Retrieve deposit records
     * Record time range cannot exceed 30 days
     * @return APIlistDepositsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistDepositsRequest listDeposits() {
        return new APIlistDepositsRequest();
    }

    /**
     * Build call for transfer
     * @param transfer  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Balance transferred </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call transferCall(Transfer transfer, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = transfer;

        // create path and map variables
        String localVarPath = "/wallet/transfers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call transferValidateBeforeCall(Transfer transfer, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'transfer' is set
        if (transfer == null) {
            throw new ApiException("Missing the required parameter 'transfer' when calling transfer(Async)");
        }

        okhttp3.Call localVarCall = transferCall(transfer, _callback);
        return localVarCall;
    }

    /**
     * Transfer between trading accounts
     * Transfer between different accounts. Currently support transfers between the following:  1. spot - margin 2. spot - futures(perpetual) 3. spot - delivery 4. spot - cross margin 5. spot - options
     * @param transfer  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Balance transferred </td><td>  -  </td></tr>
     </table>
     */
    public void transfer(Transfer transfer) throws ApiException {
        transferWithHttpInfo(transfer);
    }

    /**
     * Transfer between trading accounts
     * Transfer between different accounts. Currently support transfers between the following:  1. spot - margin 2. spot - futures(perpetual) 3. spot - delivery 4. spot - cross margin 5. spot - options
     * @param transfer  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Balance transferred </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> transferWithHttpInfo(Transfer transfer) throws ApiException {
        okhttp3.Call localVarCall = transferValidateBeforeCall(transfer, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Transfer between trading accounts (asynchronously)
     * Transfer between different accounts. Currently support transfers between the following:  1. spot - margin 2. spot - futures(perpetual) 3. spot - delivery 4. spot - cross margin 5. spot - options
     * @param transfer  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Balance transferred </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call transferAsync(Transfer transfer, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = transferValidateBeforeCall(transfer, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private okhttp3.Call listSubAccountTransfersCall(String subUid, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/sub_account_transfers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sub_uid", subUid));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSubAccountTransfersValidateBeforeCall(String subUid, Long from, Long to, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountTransfersCall(subUid, from, to, limit, offset, _callback);
        return localVarCall;
    }


    private ApiResponse<List<SubAccountTransfer>> listSubAccountTransfersWithHttpInfo(String subUid, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountTransfersValidateBeforeCall(subUid, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<SubAccountTransfer>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listSubAccountTransfersAsync(String subUid, Long from, Long to, Integer limit, Integer offset, final ApiCallback<List<SubAccountTransfer>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountTransfersValidateBeforeCall(subUid, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountTransfer>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistSubAccountTransfersRequest {
        private String subUid;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistSubAccountTransfersRequest() {
        }

        /**
         * Set subUid
         * @param subUid Sub account user ID. Return records related to all sub accounts if not specified (optional)
         * @return APIlistSubAccountTransfersRequest
         */
        public APIlistSubAccountTransfersRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        /**
         * Set from
         * @param from Time range beginning, default to 7 days before current time (optional)
         * @return APIlistSubAccountTransfersRequest
         */
        public APIlistSubAccountTransfersRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to Time range ending, default to current time (optional)
         * @return APIlistSubAccountTransfersRequest
         */
        public APIlistSubAccountTransfersRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistSubAccountTransfersRequest
         */
        public APIlistSubAccountTransfersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistSubAccountTransfersRequest
         */
        public APIlistSubAccountTransfersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Build call for listSubAccountTransfers
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listSubAccountTransfersCall(subUid, from, to, limit, offset, _callback);
        }

        /**
         * Execute listSubAccountTransfers request
         * @return List&lt;SubAccountTransfer&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<SubAccountTransfer> execute() throws ApiException {
            ApiResponse<List<SubAccountTransfer>> localVarResp = listSubAccountTransfersWithHttpInfo(subUid, from, to, limit, offset);
            return localVarResp.getData();
        }

        /**
         * Execute listSubAccountTransfers request with HTTP info returned
         * @return ApiResponse&lt;List&lt;SubAccountTransfer&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<SubAccountTransfer>> executeWithHttpInfo() throws ApiException {
            return listSubAccountTransfersWithHttpInfo(subUid, from, to, limit, offset);
        }

        /**
         * Execute listSubAccountTransfers request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<SubAccountTransfer>> _callback) throws ApiException {
            return listSubAccountTransfersAsync(subUid, from, to, limit, offset, _callback);
        }
    }

    /**
     * Retrieve transfer records between main and sub accounts
     * Record time range cannot exceed 30 days  &gt; Note: only records after 2020-04-10 can be retrieved
     * @return APIlistSubAccountTransfersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistSubAccountTransfersRequest listSubAccountTransfers() {
        return new APIlistSubAccountTransfersRequest();
    }

    /**
     * Build call for transferWithSubAccount
     * @param subAccountTransfer  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Balance transferred </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call transferWithSubAccountCall(SubAccountTransfer subAccountTransfer, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = subAccountTransfer;

        // create path and map variables
        String localVarPath = "/wallet/sub_account_transfers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call transferWithSubAccountValidateBeforeCall(SubAccountTransfer subAccountTransfer, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'subAccountTransfer' is set
        if (subAccountTransfer == null) {
            throw new ApiException("Missing the required parameter 'subAccountTransfer' when calling transferWithSubAccount(Async)");
        }

        okhttp3.Call localVarCall = transferWithSubAccountCall(subAccountTransfer, _callback);
        return localVarCall;
    }

    /**
     * Transfer between main and sub accounts
     * Support transferring with sub user&#39;s spot or futures account. Note that only main user&#39;s spot account is used no matter which sub user&#39;s account is operated.
     * @param subAccountTransfer  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Balance transferred </td><td>  -  </td></tr>
     </table>
     */
    public void transferWithSubAccount(SubAccountTransfer subAccountTransfer) throws ApiException {
        transferWithSubAccountWithHttpInfo(subAccountTransfer);
    }

    /**
     * Transfer between main and sub accounts
     * Support transferring with sub user&#39;s spot or futures account. Note that only main user&#39;s spot account is used no matter which sub user&#39;s account is operated.
     * @param subAccountTransfer  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Balance transferred </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> transferWithSubAccountWithHttpInfo(SubAccountTransfer subAccountTransfer) throws ApiException {
        okhttp3.Call localVarCall = transferWithSubAccountValidateBeforeCall(subAccountTransfer, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Transfer between main and sub accounts (asynchronously)
     * Support transferring with sub user&#39;s spot or futures account. Note that only main user&#39;s spot account is used no matter which sub user&#39;s account is operated.
     * @param subAccountTransfer  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Balance transferred </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call transferWithSubAccountAsync(SubAccountTransfer subAccountTransfer, final ApiCallback<Void> _callback) throws ApiException {
        okhttp3.Call localVarCall = transferWithSubAccountValidateBeforeCall(subAccountTransfer, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private okhttp3.Call listWithdrawStatusCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/withdraw_status";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listWithdrawStatusValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listWithdrawStatusCall(currency, _callback);
        return localVarCall;
    }


    private ApiResponse<List<WithdrawStatus>> listWithdrawStatusWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = listWithdrawStatusValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<WithdrawStatus>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listWithdrawStatusAsync(String currency, final ApiCallback<List<WithdrawStatus>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listWithdrawStatusValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<WithdrawStatus>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistWithdrawStatusRequest {
        private String currency;

        private APIlistWithdrawStatusRequest() {
        }

        /**
         * Set currency
         * @param currency Retrieve data of the specified currency (optional)
         * @return APIlistWithdrawStatusRequest
         */
        public APIlistWithdrawStatusRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Build call for listWithdrawStatus
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listWithdrawStatusCall(currency, _callback);
        }

        /**
         * Execute listWithdrawStatus request
         * @return List&lt;WithdrawStatus&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<WithdrawStatus> execute() throws ApiException {
            ApiResponse<List<WithdrawStatus>> localVarResp = listWithdrawStatusWithHttpInfo(currency);
            return localVarResp.getData();
        }

        /**
         * Execute listWithdrawStatus request with HTTP info returned
         * @return ApiResponse&lt;List&lt;WithdrawStatus&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<WithdrawStatus>> executeWithHttpInfo() throws ApiException {
            return listWithdrawStatusWithHttpInfo(currency);
        }

        /**
         * Execute listWithdrawStatus request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<WithdrawStatus>> _callback) throws ApiException {
            return listWithdrawStatusAsync(currency, _callback);
        }
    }

    /**
     * Retrieve withdrawal status
     * 
     * @return APIlistWithdrawStatusRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistWithdrawStatusRequest listWithdrawStatus() {
        return new APIlistWithdrawStatusRequest();
    }

    private okhttp3.Call listSubAccountBalancesCall(String subUid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/sub_account_balances";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sub_uid", subUid));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSubAccountBalancesValidateBeforeCall(String subUid, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountBalancesCall(subUid, _callback);
        return localVarCall;
    }


    private ApiResponse<List<SubAccountBalance>> listSubAccountBalancesWithHttpInfo(String subUid) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountBalancesValidateBeforeCall(subUid, null);
        Type localVarReturnType = new TypeToken<List<SubAccountBalance>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listSubAccountBalancesAsync(String subUid, final ApiCallback<List<SubAccountBalance>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountBalancesValidateBeforeCall(subUid, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountBalance>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistSubAccountBalancesRequest {
        private String subUid;

        private APIlistSubAccountBalancesRequest() {
        }

        /**
         * Set subUid
         * @param subUid Sub account user ID. Return records related to all sub accounts if not specified (optional)
         * @return APIlistSubAccountBalancesRequest
         */
        public APIlistSubAccountBalancesRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        /**
         * Build call for listSubAccountBalances
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listSubAccountBalancesCall(subUid, _callback);
        }

        /**
         * Execute listSubAccountBalances request
         * @return List&lt;SubAccountBalance&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<SubAccountBalance> execute() throws ApiException {
            ApiResponse<List<SubAccountBalance>> localVarResp = listSubAccountBalancesWithHttpInfo(subUid);
            return localVarResp.getData();
        }

        /**
         * Execute listSubAccountBalances request with HTTP info returned
         * @return ApiResponse&lt;List&lt;SubAccountBalance&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<SubAccountBalance>> executeWithHttpInfo() throws ApiException {
            return listSubAccountBalancesWithHttpInfo(subUid);
        }

        /**
         * Execute listSubAccountBalances request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<SubAccountBalance>> _callback) throws ApiException {
            return listSubAccountBalancesAsync(subUid, _callback);
        }
    }

    /**
     * Retrieve sub account balances
     * 
     * @return APIlistSubAccountBalancesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistSubAccountBalancesRequest listSubAccountBalances() {
        return new APIlistSubAccountBalancesRequest();
    }

    private okhttp3.Call listSubAccountMarginBalancesCall(String subUid, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/sub_account_margin_balances";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sub_uid", subUid));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSubAccountMarginBalancesValidateBeforeCall(String subUid, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountMarginBalancesCall(subUid, _callback);
        return localVarCall;
    }


    private ApiResponse<List<SubAccountMarginBalance>> listSubAccountMarginBalancesWithHttpInfo(String subUid) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountMarginBalancesValidateBeforeCall(subUid, null);
        Type localVarReturnType = new TypeToken<List<SubAccountMarginBalance>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listSubAccountMarginBalancesAsync(String subUid, final ApiCallback<List<SubAccountMarginBalance>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountMarginBalancesValidateBeforeCall(subUid, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountMarginBalance>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistSubAccountMarginBalancesRequest {
        private String subUid;

        private APIlistSubAccountMarginBalancesRequest() {
        }

        /**
         * Set subUid
         * @param subUid Sub account user ID. Return records related to all sub accounts if not specified (optional)
         * @return APIlistSubAccountMarginBalancesRequest
         */
        public APIlistSubAccountMarginBalancesRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        /**
         * Build call for listSubAccountMarginBalances
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listSubAccountMarginBalancesCall(subUid, _callback);
        }

        /**
         * Execute listSubAccountMarginBalances request
         * @return List&lt;SubAccountMarginBalance&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<SubAccountMarginBalance> execute() throws ApiException {
            ApiResponse<List<SubAccountMarginBalance>> localVarResp = listSubAccountMarginBalancesWithHttpInfo(subUid);
            return localVarResp.getData();
        }

        /**
         * Execute listSubAccountMarginBalances request with HTTP info returned
         * @return ApiResponse&lt;List&lt;SubAccountMarginBalance&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<SubAccountMarginBalance>> executeWithHttpInfo() throws ApiException {
            return listSubAccountMarginBalancesWithHttpInfo(subUid);
        }

        /**
         * Execute listSubAccountMarginBalances request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<SubAccountMarginBalance>> _callback) throws ApiException {
            return listSubAccountMarginBalancesAsync(subUid, _callback);
        }
    }

    /**
     * Query sub accounts&#39; margin balances
     * 
     * @return APIlistSubAccountMarginBalancesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistSubAccountMarginBalancesRequest listSubAccountMarginBalances() {
        return new APIlistSubAccountMarginBalancesRequest();
    }

    private okhttp3.Call listSubAccountFuturesBalancesCall(String subUid, String settle, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/sub_account_futures_balances";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sub_uid", subUid));
        }

        if (settle != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("settle", settle));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSubAccountFuturesBalancesValidateBeforeCall(String subUid, String settle, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountFuturesBalancesCall(subUid, settle, _callback);
        return localVarCall;
    }


    private ApiResponse<List<SubAccountFuturesBalance>> listSubAccountFuturesBalancesWithHttpInfo(String subUid, String settle) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountFuturesBalancesValidateBeforeCall(subUid, settle, null);
        Type localVarReturnType = new TypeToken<List<SubAccountFuturesBalance>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listSubAccountFuturesBalancesAsync(String subUid, String settle, final ApiCallback<List<SubAccountFuturesBalance>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listSubAccountFuturesBalancesValidateBeforeCall(subUid, settle, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountFuturesBalance>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistSubAccountFuturesBalancesRequest {
        private String subUid;
        private String settle;

        private APIlistSubAccountFuturesBalancesRequest() {
        }

        /**
         * Set subUid
         * @param subUid Sub account user ID. Return records related to all sub accounts if not specified (optional)
         * @return APIlistSubAccountFuturesBalancesRequest
         */
        public APIlistSubAccountFuturesBalancesRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        /**
         * Set settle
         * @param settle Query only balances of specified settle currency (optional)
         * @return APIlistSubAccountFuturesBalancesRequest
         */
        public APIlistSubAccountFuturesBalancesRequest settle(String settle) {
            this.settle = settle;
            return this;
        }

        /**
         * Build call for listSubAccountFuturesBalances
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listSubAccountFuturesBalancesCall(subUid, settle, _callback);
        }

        /**
         * Execute listSubAccountFuturesBalances request
         * @return List&lt;SubAccountFuturesBalance&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<SubAccountFuturesBalance> execute() throws ApiException {
            ApiResponse<List<SubAccountFuturesBalance>> localVarResp = listSubAccountFuturesBalancesWithHttpInfo(subUid, settle);
            return localVarResp.getData();
        }

        /**
         * Execute listSubAccountFuturesBalances request with HTTP info returned
         * @return ApiResponse&lt;List&lt;SubAccountFuturesBalance&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<SubAccountFuturesBalance>> executeWithHttpInfo() throws ApiException {
            return listSubAccountFuturesBalancesWithHttpInfo(subUid, settle);
        }

        /**
         * Execute listSubAccountFuturesBalances request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<SubAccountFuturesBalance>> _callback) throws ApiException {
            return listSubAccountFuturesBalancesAsync(subUid, settle, _callback);
        }
    }

    /**
     * Query sub accounts&#39; futures account balances
     * 
     * @return APIlistSubAccountFuturesBalancesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistSubAccountFuturesBalancesRequest listSubAccountFuturesBalances() {
        return new APIlistSubAccountFuturesBalancesRequest();
    }

    private okhttp3.Call getTradeFeeCall(String currencyPair, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/fee";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTradeFeeValidateBeforeCall(String currencyPair, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = getTradeFeeCall(currencyPair, _callback);
        return localVarCall;
    }


    private ApiResponse<TradeFee> getTradeFeeWithHttpInfo(String currencyPair) throws ApiException {
        okhttp3.Call localVarCall = getTradeFeeValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<TradeFee>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getTradeFeeAsync(String currencyPair, final ApiCallback<TradeFee> _callback) throws ApiException {
        okhttp3.Call localVarCall = getTradeFeeValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<TradeFee>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetTradeFeeRequest {
        private String currencyPair;

        private APIgetTradeFeeRequest() {
        }

        /**
         * Set currencyPair
         * @param currencyPair Specify a currency pair to retrieve precise fee rate  This field is optional. In most cases, the fee rate is identical among all currency pairs (optional)
         * @return APIgetTradeFeeRequest
         */
        public APIgetTradeFeeRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        /**
         * Build call for getTradeFee
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getTradeFeeCall(currencyPair, _callback);
        }

        /**
         * Execute getTradeFee request
         * @return TradeFee
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public TradeFee execute() throws ApiException {
            ApiResponse<TradeFee> localVarResp = getTradeFeeWithHttpInfo(currencyPair);
            return localVarResp.getData();
        }

        /**
         * Execute getTradeFee request with HTTP info returned
         * @return ApiResponse&lt;TradeFee&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<TradeFee> executeWithHttpInfo() throws ApiException {
            return getTradeFeeWithHttpInfo(currencyPair);
        }

        /**
         * Execute getTradeFee request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<TradeFee> _callback) throws ApiException {
            return getTradeFeeAsync(currencyPair, _callback);
        }
    }

    /**
     * Retrieve personal trading fee
     * 
     * @return APIgetTradeFeeRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIgetTradeFeeRequest getTradeFee() {
        return new APIgetTradeFeeRequest();
    }

    private okhttp3.Call getTotalBalanceCall(String currency, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/wallet/total_balance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("currency", currency));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTotalBalanceValidateBeforeCall(String currency, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = getTotalBalanceCall(currency, _callback);
        return localVarCall;
    }


    private ApiResponse<TotalBalance> getTotalBalanceWithHttpInfo(String currency) throws ApiException {
        okhttp3.Call localVarCall = getTotalBalanceValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<TotalBalance>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getTotalBalanceAsync(String currency, final ApiCallback<TotalBalance> _callback) throws ApiException {
        okhttp3.Call localVarCall = getTotalBalanceValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<TotalBalance>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetTotalBalanceRequest {
        private String currency;

        private APIgetTotalBalanceRequest() {
        }

        /**
         * Set currency
         * @param currency Currency unit used to calculate the balance amount. BTC, CNY, USD and USDT are allowed. USDT is the default. (optional, default to &quot;USDT&quot;)
         * @return APIgetTotalBalanceRequest
         */
        public APIgetTotalBalanceRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        /**
         * Build call for getTotalBalance
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Request is valid and is successfully responded </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getTotalBalanceCall(currency, _callback);
        }

        /**
         * Execute getTotalBalance request
         * @return TotalBalance
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Request is valid and is successfully responded </td><td>  -  </td></tr>
         </table>
         */
        public TotalBalance execute() throws ApiException {
            ApiResponse<TotalBalance> localVarResp = getTotalBalanceWithHttpInfo(currency);
            return localVarResp.getData();
        }

        /**
         * Execute getTotalBalance request with HTTP info returned
         * @return ApiResponse&lt;TotalBalance&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Request is valid and is successfully responded </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<TotalBalance> executeWithHttpInfo() throws ApiException {
            return getTotalBalanceWithHttpInfo(currency);
        }

        /**
         * Execute getTotalBalance request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Request is valid and is successfully responded </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<TotalBalance> _callback) throws ApiException {
            return getTotalBalanceAsync(currency, _callback);
        }
    }

    /**
     * Retrieve user&#39;s total balances
     * This endpoint returns an approximate sum of exchanged amount from all currencies to input currency for each account.The exchange rate and account balance could have been cached for at most 1 minute. It is not recommended to use its result for any trading calculation.  For trading calculation, use the corresponding account query endpoint for each account type. For example:   - &#x60;GET /spot/accounts&#x60; to query spot account balance - &#x60;GET /margin/accounts&#x60; to query margin account balance - &#x60;GET /futures/{settle}/accounts&#x60; to query futures account balance
     * @return APIgetTotalBalanceRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request is valid and is successfully responded </td><td>  -  </td></tr>
     </table>
     */
    public APIgetTotalBalanceRequest getTotalBalance() {
        return new APIgetTotalBalanceRequest();
    }

}
