/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.Contract;
import io.gate.gateapi.models.ContractStat;
import io.gate.gateapi.models.FundingRateRecord;
import io.gate.gateapi.models.FuturesAccount;
import io.gate.gateapi.models.FuturesAccountBook;
import io.gate.gateapi.models.FuturesCandlestick;
import io.gate.gateapi.models.FuturesIndexConstituents;
import io.gate.gateapi.models.FuturesLiquidate;
import io.gate.gateapi.models.FuturesOrder;
import io.gate.gateapi.models.FuturesOrderAmendment;
import io.gate.gateapi.models.FuturesOrderBook;
import io.gate.gateapi.models.FuturesPriceTriggeredOrder;
import io.gate.gateapi.models.FuturesTicker;
import io.gate.gateapi.models.FuturesTrade;
import io.gate.gateapi.models.InsuranceRecord;
import io.gate.gateapi.models.MyFuturesTrade;
import io.gate.gateapi.models.Position;
import io.gate.gateapi.models.PositionClose;
import io.gate.gateapi.models.TriggerOrderResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FuturesApi {
    private ApiClient localVarApiClient;

    public FuturesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FuturesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for listFuturesContracts
     * @param settle Settle currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFuturesContractsCall(String settle, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/contracts"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesContractsValidateBeforeCall(String settle, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesContracts(Async)");
        }

        okhttp3.Call localVarCall = listFuturesContractsCall(settle, _callback);
        return localVarCall;
    }

    /**
     * List all futures contracts
     * 
     * @param settle Settle currency (required)
     * @return List&lt;Contract&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<Contract> listFuturesContracts(String settle) throws ApiException {
        ApiResponse<List<Contract>> localVarResp = listFuturesContractsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    /**
     * List all futures contracts
     * 
     * @param settle Settle currency (required)
     * @return ApiResponse&lt;List&lt;Contract&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Contract>> listFuturesContractsWithHttpInfo(String settle) throws ApiException {
        okhttp3.Call localVarCall = listFuturesContractsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<List<Contract>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all futures contracts (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFuturesContractsAsync(String settle, final ApiCallback<List<Contract>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesContractsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<List<Contract>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getFuturesContract
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Contract information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFuturesContractCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/contracts/{contract}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFuturesContractValidateBeforeCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getFuturesContract(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getFuturesContract(Async)");
        }

        okhttp3.Call localVarCall = getFuturesContractCall(settle, contract, _callback);
        return localVarCall;
    }

    /**
     * Get a single contract
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return Contract
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Contract information </td><td>  -  </td></tr>
     </table>
     */
    public Contract getFuturesContract(String settle, String contract) throws ApiException {
        ApiResponse<Contract> localVarResp = getFuturesContractWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    /**
     * Get a single contract
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return ApiResponse&lt;Contract&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Contract information </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Contract> getFuturesContractWithHttpInfo(String settle, String contract) throws ApiException {
        okhttp3.Call localVarCall = getFuturesContractValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<Contract>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a single contract (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Contract information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFuturesContractAsync(String settle, String contract, final ApiCallback<Contract> _callback) throws ApiException {
        okhttp3.Call localVarCall = getFuturesContractValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<Contract>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listFuturesOrderBookCall(String settle, String contract, String interval, Integer limit, Boolean withId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/order_book"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (withId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("with_id", withId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesOrderBookValidateBeforeCall(String settle, String contract, String interval, Integer limit, Boolean withId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesOrderBook(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesOrderBook(Async)");
        }

        okhttp3.Call localVarCall = listFuturesOrderBookCall(settle, contract, interval, limit, withId, _callback);
        return localVarCall;
    }


    private ApiResponse<FuturesOrderBook> listFuturesOrderBookWithHttpInfo(String settle, String contract, String interval, Integer limit, Boolean withId) throws ApiException {
        okhttp3.Call localVarCall = listFuturesOrderBookValidateBeforeCall(settle, contract, interval, limit, withId, null);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFuturesOrderBookAsync(String settle, String contract, String interval, Integer limit, Boolean withId, final ApiCallback<FuturesOrderBook> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesOrderBookValidateBeforeCall(settle, contract, interval, limit, withId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFuturesOrderBookRequest {
        private final String settle;
        private final String contract;
        private String interval;
        private Integer limit;
        private Boolean withId;

        private APIlistFuturesOrderBookRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        /**
         * Set interval
         * @param interval Order depth. 0 means no aggregation is applied. default to 0 (optional, default to 0)
         * @return APIlistFuturesOrderBookRequest
         */
        public APIlistFuturesOrderBookRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of order depth data in asks or bids (optional, default to 10)
         * @return APIlistFuturesOrderBookRequest
         */
        public APIlistFuturesOrderBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set withId
         * @param withId Whether the order book update ID will be returned. This ID increases by 1 on every order book update (optional, default to false)
         * @return APIlistFuturesOrderBookRequest
         */
        public APIlistFuturesOrderBookRequest withId(Boolean withId) {
            this.withId = withId;
            return this;
        }

        /**
         * Build call for listFuturesOrderBook
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFuturesOrderBookCall(settle, contract, interval, limit, withId, _callback);
        }

        /**
         * Execute listFuturesOrderBook request
         * @return FuturesOrderBook
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
         </table>
         */
        public FuturesOrderBook execute() throws ApiException {
            ApiResponse<FuturesOrderBook> localVarResp = listFuturesOrderBookWithHttpInfo(settle, contract, interval, limit, withId);
            return localVarResp.getData();
        }

        /**
         * Execute listFuturesOrderBook request with HTTP info returned
         * @return ApiResponse&lt;FuturesOrderBook&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<FuturesOrderBook> executeWithHttpInfo() throws ApiException {
            return listFuturesOrderBookWithHttpInfo(settle, contract, interval, limit, withId);
        }

        /**
         * Execute listFuturesOrderBook request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<FuturesOrderBook> _callback) throws ApiException {
            return listFuturesOrderBookAsync(settle, contract, interval, limit, withId, _callback);
        }
    }

    /**
     * Futures order book
     * Bids will be sorted by price from high to low, while asks sorted reversely
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return APIlistFuturesOrderBookRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order book retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFuturesOrderBookRequest listFuturesOrderBook(String settle, String contract) {
        return new APIlistFuturesOrderBookRequest(settle, contract);
    }

    private okhttp3.Call listFuturesTradesCall(String settle, String contract, Integer limit, String lastId, Long from, Long to, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/trades"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (lastId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("last_id", lastId));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesTradesValidateBeforeCall(String settle, String contract, Integer limit, String lastId, Long from, Long to, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesTrades(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesTrades(Async)");
        }

        okhttp3.Call localVarCall = listFuturesTradesCall(settle, contract, limit, lastId, from, to, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesTrade>> listFuturesTradesWithHttpInfo(String settle, String contract, Integer limit, String lastId, Long from, Long to) throws ApiException {
        okhttp3.Call localVarCall = listFuturesTradesValidateBeforeCall(settle, contract, limit, lastId, from, to, null);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFuturesTradesAsync(String settle, String contract, Integer limit, String lastId, Long from, Long to, final ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesTradesValidateBeforeCall(settle, contract, limit, lastId, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFuturesTradesRequest {
        private final String settle;
        private final String contract;
        private Integer limit;
        private String lastId;
        private Long from;
        private Long to;

        private APIlistFuturesTradesRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistFuturesTradesRequest
         */
        public APIlistFuturesTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set lastId
         * @param lastId Specify the starting point for this list based on a previously retrieved id  This parameter is deprecated. Use &#x60;from&#x60; and &#x60;to&#x60; instead to limit time range (optional)
         * @return APIlistFuturesTradesRequest
         */
        public APIlistFuturesTradesRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        /**
         * Set from
         * @param from Specify starting time in Unix seconds. If not specified, &#x60;to&#x60; and &#x60;limit&#x60; will be used to limit response items. If items between &#x60;from&#x60; and &#x60;to&#x60; are more than &#x60;limit&#x60;, only &#x60;limit&#x60; number will be returned.  (optional)
         * @return APIlistFuturesTradesRequest
         */
        public APIlistFuturesTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to Specify end time in Unix seconds, default to current time (optional)
         * @return APIlistFuturesTradesRequest
         */
        public APIlistFuturesTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Build call for listFuturesTrades
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFuturesTradesCall(settle, contract, limit, lastId, from, to, _callback);
        }

        /**
         * Execute listFuturesTrades request
         * @return List&lt;FuturesTrade&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesTrade> execute() throws ApiException {
            ApiResponse<List<FuturesTrade>> localVarResp = listFuturesTradesWithHttpInfo(settle, contract, limit, lastId, from, to);
            return localVarResp.getData();
        }

        /**
         * Execute listFuturesTrades request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesTrade&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesTrade>> executeWithHttpInfo() throws ApiException {
            return listFuturesTradesWithHttpInfo(settle, contract, limit, lastId, from, to);
        }

        /**
         * Execute listFuturesTrades request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
            return listFuturesTradesAsync(settle, contract, limit, lastId, from, to, _callback);
        }
    }

    /**
     * Futures trading history
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return APIlistFuturesTradesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFuturesTradesRequest listFuturesTrades(String settle, String contract) {
        return new APIlistFuturesTradesRequest(settle, contract);
    }

    private okhttp3.Call listFuturesCandlesticksCall(String settle, String contract, Long from, Long to, Integer limit, String interval, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/candlesticks"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesCandlesticksValidateBeforeCall(String settle, String contract, Long from, Long to, Integer limit, String interval, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesCandlesticks(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesCandlesticks(Async)");
        }

        okhttp3.Call localVarCall = listFuturesCandlesticksCall(settle, contract, from, to, limit, interval, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesCandlestick>> listFuturesCandlesticksWithHttpInfo(String settle, String contract, Long from, Long to, Integer limit, String interval) throws ApiException {
        okhttp3.Call localVarCall = listFuturesCandlesticksValidateBeforeCall(settle, contract, from, to, limit, interval, null);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFuturesCandlesticksAsync(String settle, String contract, Long from, Long to, Integer limit, String interval, final ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesCandlesticksValidateBeforeCall(settle, contract, from, to, limit, interval, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFuturesCandlesticksRequest {
        private final String settle;
        private final String contract;
        private Long from;
        private Long to;
        private Integer limit;
        private String interval;

        private APIlistFuturesCandlesticksRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        /**
         * Set from
         * @param from Start time of candlesticks, formatted in Unix timestamp in seconds. Default to&#x60;to - 100 * interval&#x60; if not specified (optional)
         * @return APIlistFuturesCandlesticksRequest
         */
        public APIlistFuturesCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End time of candlesticks, formatted in Unix timestamp in seconds. Default to current time (optional)
         * @return APIlistFuturesCandlesticksRequest
         */
        public APIlistFuturesCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum recent data points to return. &#x60;limit&#x60; is conflicted with &#x60;from&#x60; and &#x60;to&#x60;. If either &#x60;from&#x60; or &#x60;to&#x60; is specified, request will be rejected. (optional, default to 100)
         * @return APIlistFuturesCandlesticksRequest
         */
        public APIlistFuturesCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set interval
         * @param interval Interval time between data points. Note that &#x60;1w&#x60; means natual week(Mon-Sun), while &#x60;7d&#x60; means every 7d since unix 0 (optional, default to 5m)
         * @return APIlistFuturesCandlesticksRequest
         */
        public APIlistFuturesCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Build call for listFuturesCandlesticks
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFuturesCandlesticksCall(settle, contract, from, to, limit, interval, _callback);
        }

        /**
         * Execute listFuturesCandlesticks request
         * @return List&lt;FuturesCandlestick&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesCandlestick> execute() throws ApiException {
            ApiResponse<List<FuturesCandlestick>> localVarResp = listFuturesCandlesticksWithHttpInfo(settle, contract, from, to, limit, interval);
            return localVarResp.getData();
        }

        /**
         * Execute listFuturesCandlesticks request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesCandlestick&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesCandlestick>> executeWithHttpInfo() throws ApiException {
            return listFuturesCandlesticksWithHttpInfo(settle, contract, from, to, limit, interval);
        }

        /**
         * Execute listFuturesCandlesticks request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
            return listFuturesCandlesticksAsync(settle, contract, from, to, limit, interval, _callback);
        }
    }

    /**
     * Get futures candlesticks
     * Return specified contract candlesticks. If prefix &#x60;contract&#x60; with &#x60;mark_&#x60;, the contract&#39;s mark price candlesticks are returned; if prefix with &#x60;index_&#x60;, index price candlesticks will be returned.  Maximum of 2000 points are returned in one query. Be sure not to exceed the limit when specifying &#x60;from&#x60;, &#x60;to&#x60; and &#x60;interval&#x60;
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return APIlistFuturesCandlesticksRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFuturesCandlesticksRequest listFuturesCandlesticks(String settle, String contract) {
        return new APIlistFuturesCandlesticksRequest(settle, contract);
    }

    private okhttp3.Call listFuturesTickersCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/tickers"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesTickersValidateBeforeCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesTickers(Async)");
        }

        okhttp3.Call localVarCall = listFuturesTickersCall(settle, contract, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesTicker>> listFuturesTickersWithHttpInfo(String settle, String contract) throws ApiException {
        okhttp3.Call localVarCall = listFuturesTickersValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<List<FuturesTicker>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFuturesTickersAsync(String settle, String contract, final ApiCallback<List<FuturesTicker>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesTickersValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesTicker>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFuturesTickersRequest {
        private final String settle;
        private String contract;

        private APIlistFuturesTickersRequest(String settle) {
            this.settle = settle;
        }

        /**
         * Set contract
         * @param contract Futures contract, return related data only if specified (optional)
         * @return APIlistFuturesTickersRequest
         */
        public APIlistFuturesTickersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Build call for listFuturesTickers
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFuturesTickersCall(settle, contract, _callback);
        }

        /**
         * Execute listFuturesTickers request
         * @return List&lt;FuturesTicker&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesTicker> execute() throws ApiException {
            ApiResponse<List<FuturesTicker>> localVarResp = listFuturesTickersWithHttpInfo(settle, contract);
            return localVarResp.getData();
        }

        /**
         * Execute listFuturesTickers request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesTicker&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesTicker>> executeWithHttpInfo() throws ApiException {
            return listFuturesTickersWithHttpInfo(settle, contract);
        }

        /**
         * Execute listFuturesTickers request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesTicker>> _callback) throws ApiException {
            return listFuturesTickersAsync(settle, contract, _callback);
        }
    }

    /**
     * List futures tickers
     * 
     * @param settle Settle currency (required)
     * @return APIlistFuturesTickersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFuturesTickersRequest listFuturesTickers(String settle) {
        return new APIlistFuturesTickersRequest(settle);
    }

    private okhttp3.Call listFuturesFundingRateHistoryCall(String settle, String contract, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/funding_rate"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesFundingRateHistoryValidateBeforeCall(String settle, String contract, Integer limit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesFundingRateHistory(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesFundingRateHistory(Async)");
        }

        okhttp3.Call localVarCall = listFuturesFundingRateHistoryCall(settle, contract, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FundingRateRecord>> listFuturesFundingRateHistoryWithHttpInfo(String settle, String contract, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listFuturesFundingRateHistoryValidateBeforeCall(settle, contract, limit, null);
        Type localVarReturnType = new TypeToken<List<FundingRateRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFuturesFundingRateHistoryAsync(String settle, String contract, Integer limit, final ApiCallback<List<FundingRateRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesFundingRateHistoryValidateBeforeCall(settle, contract, limit, _callback);
        Type localVarReturnType = new TypeToken<List<FundingRateRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFuturesFundingRateHistoryRequest {
        private final String settle;
        private final String contract;
        private Integer limit;

        private APIlistFuturesFundingRateHistoryRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistFuturesFundingRateHistoryRequest
         */
        public APIlistFuturesFundingRateHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listFuturesFundingRateHistory
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> History retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFuturesFundingRateHistoryCall(settle, contract, limit, _callback);
        }

        /**
         * Execute listFuturesFundingRateHistory request
         * @return List&lt;FundingRateRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> History retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FundingRateRecord> execute() throws ApiException {
            ApiResponse<List<FundingRateRecord>> localVarResp = listFuturesFundingRateHistoryWithHttpInfo(settle, contract, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listFuturesFundingRateHistory request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FundingRateRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> History retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FundingRateRecord>> executeWithHttpInfo() throws ApiException {
            return listFuturesFundingRateHistoryWithHttpInfo(settle, contract, limit);
        }

        /**
         * Execute listFuturesFundingRateHistory request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> History retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FundingRateRecord>> _callback) throws ApiException {
            return listFuturesFundingRateHistoryAsync(settle, contract, limit, _callback);
        }
    }

    /**
     * Funding rate history
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return APIlistFuturesFundingRateHistoryRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> History retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFuturesFundingRateHistoryRequest listFuturesFundingRateHistory(String settle, String contract) {
        return new APIlistFuturesFundingRateHistoryRequest(settle, contract);
    }

    private okhttp3.Call listFuturesInsuranceLedgerCall(String settle, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/insurance"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesInsuranceLedgerValidateBeforeCall(String settle, Integer limit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesInsuranceLedger(Async)");
        }

        okhttp3.Call localVarCall = listFuturesInsuranceLedgerCall(settle, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<InsuranceRecord>> listFuturesInsuranceLedgerWithHttpInfo(String settle, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listFuturesInsuranceLedgerValidateBeforeCall(settle, limit, null);
        Type localVarReturnType = new TypeToken<List<InsuranceRecord>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFuturesInsuranceLedgerAsync(String settle, Integer limit, final ApiCallback<List<InsuranceRecord>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesInsuranceLedgerValidateBeforeCall(settle, limit, _callback);
        Type localVarReturnType = new TypeToken<List<InsuranceRecord>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFuturesInsuranceLedgerRequest {
        private final String settle;
        private Integer limit;

        private APIlistFuturesInsuranceLedgerRequest(String settle) {
            this.settle = settle;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistFuturesInsuranceLedgerRequest
         */
        public APIlistFuturesInsuranceLedgerRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listFuturesInsuranceLedger
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFuturesInsuranceLedgerCall(settle, limit, _callback);
        }

        /**
         * Execute listFuturesInsuranceLedger request
         * @return List&lt;InsuranceRecord&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<InsuranceRecord> execute() throws ApiException {
            ApiResponse<List<InsuranceRecord>> localVarResp = listFuturesInsuranceLedgerWithHttpInfo(settle, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listFuturesInsuranceLedger request with HTTP info returned
         * @return ApiResponse&lt;List&lt;InsuranceRecord&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<InsuranceRecord>> executeWithHttpInfo() throws ApiException {
            return listFuturesInsuranceLedgerWithHttpInfo(settle, limit);
        }

        /**
         * Execute listFuturesInsuranceLedger request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<InsuranceRecord>> _callback) throws ApiException {
            return listFuturesInsuranceLedgerAsync(settle, limit, _callback);
        }
    }

    /**
     * Futures insurance balance history
     * 
     * @param settle Settle currency (required)
     * @return APIlistFuturesInsuranceLedgerRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFuturesInsuranceLedgerRequest listFuturesInsuranceLedger(String settle) {
        return new APIlistFuturesInsuranceLedgerRequest(settle);
    }

    private okhttp3.Call listContractStatsCall(String settle, String contract, Long from, String interval, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/contract_stats"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (interval != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("interval", interval));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listContractStatsValidateBeforeCall(String settle, String contract, Long from, String interval, Integer limit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listContractStats(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listContractStats(Async)");
        }

        okhttp3.Call localVarCall = listContractStatsCall(settle, contract, from, interval, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<ContractStat>> listContractStatsWithHttpInfo(String settle, String contract, Long from, String interval, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listContractStatsValidateBeforeCall(settle, contract, from, interval, limit, null);
        Type localVarReturnType = new TypeToken<List<ContractStat>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listContractStatsAsync(String settle, String contract, Long from, String interval, Integer limit, final ApiCallback<List<ContractStat>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listContractStatsValidateBeforeCall(settle, contract, from, interval, limit, _callback);
        Type localVarReturnType = new TypeToken<List<ContractStat>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistContractStatsRequest {
        private final String settle;
        private final String contract;
        private Long from;
        private String interval;
        private Integer limit;

        private APIlistContractStatsRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistContractStatsRequest
         */
        public APIlistContractStatsRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set interval
         * @param interval  (optional, default to 5m)
         * @return APIlistContractStatsRequest
         */
        public APIlistContractStatsRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Set limit
         * @param limit  (optional, default to 30)
         * @return APIlistContractStatsRequest
         */
        public APIlistContractStatsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listContractStats
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listContractStatsCall(settle, contract, from, interval, limit, _callback);
        }

        /**
         * Execute listContractStats request
         * @return List&lt;ContractStat&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<ContractStat> execute() throws ApiException {
            ApiResponse<List<ContractStat>> localVarResp = listContractStatsWithHttpInfo(settle, contract, from, interval, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listContractStats request with HTTP info returned
         * @return ApiResponse&lt;List&lt;ContractStat&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<ContractStat>> executeWithHttpInfo() throws ApiException {
            return listContractStatsWithHttpInfo(settle, contract, from, interval, limit);
        }

        /**
         * Execute listContractStats request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<ContractStat>> _callback) throws ApiException {
            return listContractStatsAsync(settle, contract, from, interval, limit, _callback);
        }
    }

    /**
     * Futures stats
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return APIlistContractStatsRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistContractStatsRequest listContractStats(String settle, String contract) {
        return new APIlistContractStatsRequest(settle, contract);
    }

    /**
     * Build call for getIndexConstituents
     * @param settle Settle currency (required)
     * @param index Index name (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIndexConstituentsCall(String settle, String index, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/index_constituents/{index}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "index" + "\\}", localVarApiClient.escapeString(index));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getIndexConstituentsValidateBeforeCall(String settle, String index, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getIndexConstituents(Async)");
        }

        // verify the required parameter 'index' is set
        if (index == null) {
            throw new ApiException("Missing the required parameter 'index' when calling getIndexConstituents(Async)");
        }

        okhttp3.Call localVarCall = getIndexConstituentsCall(settle, index, _callback);
        return localVarCall;
    }

    /**
     * Get index constituents
     * 
     * @param settle Settle currency (required)
     * @param index Index name (required)
     * @return FuturesIndexConstituents
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public FuturesIndexConstituents getIndexConstituents(String settle, String index) throws ApiException {
        ApiResponse<FuturesIndexConstituents> localVarResp = getIndexConstituentsWithHttpInfo(settle, index);
        return localVarResp.getData();
    }

    /**
     * Get index constituents
     * 
     * @param settle Settle currency (required)
     * @param index Index name (required)
     * @return ApiResponse&lt;FuturesIndexConstituents&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesIndexConstituents> getIndexConstituentsWithHttpInfo(String settle, String index) throws ApiException {
        okhttp3.Call localVarCall = getIndexConstituentsValidateBeforeCall(settle, index, null);
        Type localVarReturnType = new TypeToken<FuturesIndexConstituents>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get index constituents (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param index Index name (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getIndexConstituentsAsync(String settle, String index, final ApiCallback<FuturesIndexConstituents> _callback) throws ApiException {
        okhttp3.Call localVarCall = getIndexConstituentsValidateBeforeCall(settle, index, _callback);
        Type localVarReturnType = new TypeToken<FuturesIndexConstituents>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listLiquidatedOrdersCall(String settle, String contract, Long from, Long to, Integer limit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/liq_orders"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listLiquidatedOrdersValidateBeforeCall(String settle, String contract, Long from, Long to, Integer limit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listLiquidatedOrders(Async)");
        }

        okhttp3.Call localVarCall = listLiquidatedOrdersCall(settle, contract, from, to, limit, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesLiquidate>> listLiquidatedOrdersWithHttpInfo(String settle, String contract, Long from, Long to, Integer limit) throws ApiException {
        okhttp3.Call localVarCall = listLiquidatedOrdersValidateBeforeCall(settle, contract, from, to, limit, null);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listLiquidatedOrdersAsync(String settle, String contract, Long from, Long to, Integer limit, final ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listLiquidatedOrdersValidateBeforeCall(settle, contract, from, to, limit, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistLiquidatedOrdersRequest {
        private final String settle;
        private String contract;
        private Long from;
        private Long to;
        private Integer limit;

        private APIlistLiquidatedOrdersRequest(String settle) {
            this.settle = settle;
        }

        /**
         * Set contract
         * @param contract Futures contract, return related data only if specified (optional)
         * @return APIlistLiquidatedOrdersRequest
         */
        public APIlistLiquidatedOrdersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistLiquidatedOrdersRequest
         */
        public APIlistLiquidatedOrdersRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistLiquidatedOrdersRequest
         */
        public APIlistLiquidatedOrdersRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistLiquidatedOrdersRequest
         */
        public APIlistLiquidatedOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Build call for listLiquidatedOrders
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listLiquidatedOrdersCall(settle, contract, from, to, limit, _callback);
        }

        /**
         * Execute listLiquidatedOrders request
         * @return List&lt;FuturesLiquidate&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesLiquidate> execute() throws ApiException {
            ApiResponse<List<FuturesLiquidate>> localVarResp = listLiquidatedOrdersWithHttpInfo(settle, contract, from, to, limit);
            return localVarResp.getData();
        }

        /**
         * Execute listLiquidatedOrders request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesLiquidate&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesLiquidate>> executeWithHttpInfo() throws ApiException {
            return listLiquidatedOrdersWithHttpInfo(settle, contract, from, to, limit);
        }

        /**
         * Execute listLiquidatedOrders request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
            return listLiquidatedOrdersAsync(settle, contract, from, to, limit, _callback);
        }
    }

    /**
     * Retrieve liquidation history
     * Interval between &#x60;from&#x60; and &#x60;to&#x60; cannot exceeds 3600. Some private fields will not be returned in public endpoints. Refer to field description for detail.
     * @param settle Settle currency (required)
     * @return APIlistLiquidatedOrdersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistLiquidatedOrdersRequest listLiquidatedOrders(String settle) {
        return new APIlistLiquidatedOrdersRequest(settle);
    }

    /**
     * Build call for listFuturesAccounts
     * @param settle Settle currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFuturesAccountsCall(String settle, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/accounts"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesAccountsValidateBeforeCall(String settle, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesAccounts(Async)");
        }

        okhttp3.Call localVarCall = listFuturesAccountsCall(settle, _callback);
        return localVarCall;
    }

    /**
     * Query futures account
     * 
     * @param settle Settle currency (required)
     * @return FuturesAccount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public FuturesAccount listFuturesAccounts(String settle) throws ApiException {
        ApiResponse<FuturesAccount> localVarResp = listFuturesAccountsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    /**
     * Query futures account
     * 
     * @param settle Settle currency (required)
     * @return ApiResponse&lt;FuturesAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesAccount> listFuturesAccountsWithHttpInfo(String settle) throws ApiException {
        okhttp3.Call localVarCall = listFuturesAccountsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Query futures account (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFuturesAccountsAsync(String settle, final ApiCallback<FuturesAccount> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesAccountsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listFuturesAccountBookCall(String settle, Integer limit, Long from, Long to, String type, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/account_book"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesAccountBookValidateBeforeCall(String settle, Integer limit, Long from, Long to, String type, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesAccountBook(Async)");
        }

        okhttp3.Call localVarCall = listFuturesAccountBookCall(settle, limit, from, to, type, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesAccountBook>> listFuturesAccountBookWithHttpInfo(String settle, Integer limit, Long from, Long to, String type) throws ApiException {
        okhttp3.Call localVarCall = listFuturesAccountBookValidateBeforeCall(settle, limit, from, to, type, null);
        Type localVarReturnType = new TypeToken<List<FuturesAccountBook>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFuturesAccountBookAsync(String settle, Integer limit, Long from, Long to, String type, final ApiCallback<List<FuturesAccountBook>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesAccountBookValidateBeforeCall(settle, limit, from, to, type, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesAccountBook>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFuturesAccountBookRequest {
        private final String settle;
        private Integer limit;
        private Long from;
        private Long to;
        private String type;

        private APIlistFuturesAccountBookRequest(String settle) {
            this.settle = settle;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistFuturesAccountBookRequest
         */
        public APIlistFuturesAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistFuturesAccountBookRequest
         */
        public APIlistFuturesAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistFuturesAccountBookRequest
         */
        public APIlistFuturesAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Set type
         * @param type Changing Type: - dnw: Deposit &amp; Withdraw - pnl: Profit &amp; Loss by reducing position - fee: Trading fee - refr: Referrer rebate - fund: Funding - point_dnw: POINT Deposit &amp; Withdraw - point_fee: POINT Trading fee - point_refr: POINT Referrer rebate (optional)
         * @return APIlistFuturesAccountBookRequest
         */
        public APIlistFuturesAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        /**
         * Build call for listFuturesAccountBook
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFuturesAccountBookCall(settle, limit, from, to, type, _callback);
        }

        /**
         * Execute listFuturesAccountBook request
         * @return List&lt;FuturesAccountBook&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesAccountBook> execute() throws ApiException {
            ApiResponse<List<FuturesAccountBook>> localVarResp = listFuturesAccountBookWithHttpInfo(settle, limit, from, to, type);
            return localVarResp.getData();
        }

        /**
         * Execute listFuturesAccountBook request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesAccountBook&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesAccountBook>> executeWithHttpInfo() throws ApiException {
            return listFuturesAccountBookWithHttpInfo(settle, limit, from, to, type);
        }

        /**
         * Execute listFuturesAccountBook request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesAccountBook>> _callback) throws ApiException {
            return listFuturesAccountBookAsync(settle, limit, from, to, type, _callback);
        }
    }

    /**
     * Query account book
     * 
     * @param settle Settle currency (required)
     * @return APIlistFuturesAccountBookRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFuturesAccountBookRequest listFuturesAccountBook(String settle) {
        return new APIlistFuturesAccountBookRequest(settle);
    }

    /**
     * Build call for listPositions
     * @param settle Settle currency (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listPositionsCall(String settle, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/positions"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listPositionsValidateBeforeCall(String settle, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listPositions(Async)");
        }

        okhttp3.Call localVarCall = listPositionsCall(settle, _callback);
        return localVarCall;
    }

    /**
     * List all positions of a user
     * 
     * @param settle Settle currency (required)
     * @return List&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<Position> listPositions(String settle) throws ApiException {
        ApiResponse<List<Position>> localVarResp = listPositionsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    /**
     * List all positions of a user
     * 
     * @param settle Settle currency (required)
     * @return ApiResponse&lt;List&lt;Position&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Position>> listPositionsWithHttpInfo(String settle) throws ApiException {
        okhttp3.Call localVarCall = listPositionsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all positions of a user (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listPositionsAsync(String settle, final ApiCallback<List<Position>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listPositionsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getPosition
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPositionCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/positions/{contract}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPositionValidateBeforeCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getPosition(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getPosition(Async)");
        }

        okhttp3.Call localVarCall = getPositionCall(settle, contract, _callback);
        return localVarCall;
    }

    /**
     * Get single position
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return Position
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public Position getPosition(String settle, String contract) throws ApiException {
        ApiResponse<Position> localVarResp = getPositionWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    /**
     * Get single position
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return ApiResponse&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Position> getPositionWithHttpInfo(String settle, String contract) throws ApiException {
        okhttp3.Call localVarCall = getPositionValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get single position (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPositionAsync(String settle, String contract, final ApiCallback<Position> _callback) throws ApiException {
        okhttp3.Call localVarCall = getPositionValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updatePositionMargin
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param change Margin change. Use positive number to increase margin, negative number otherwise. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updatePositionMarginCall(String settle, String contract, String change, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/positions/{contract}/margin"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (change != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("change", change));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updatePositionMarginValidateBeforeCall(String settle, String contract, String change, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updatePositionMargin(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updatePositionMargin(Async)");
        }

        // verify the required parameter 'change' is set
        if (change == null) {
            throw new ApiException("Missing the required parameter 'change' when calling updatePositionMargin(Async)");
        }

        okhttp3.Call localVarCall = updatePositionMarginCall(settle, contract, change, _callback);
        return localVarCall;
    }

    /**
     * Update position margin
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param change Margin change. Use positive number to increase margin, negative number otherwise. (required)
     * @return Position
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public Position updatePositionMargin(String settle, String contract, String change) throws ApiException {
        ApiResponse<Position> localVarResp = updatePositionMarginWithHttpInfo(settle, contract, change);
        return localVarResp.getData();
    }

    /**
     * Update position margin
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param change Margin change. Use positive number to increase margin, negative number otherwise. (required)
     * @return ApiResponse&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Position> updatePositionMarginWithHttpInfo(String settle, String contract, String change) throws ApiException {
        okhttp3.Call localVarCall = updatePositionMarginValidateBeforeCall(settle, contract, change, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update position margin (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param change Margin change. Use positive number to increase margin, negative number otherwise. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updatePositionMarginAsync(String settle, String contract, String change, final ApiCallback<Position> _callback) throws ApiException {
        okhttp3.Call localVarCall = updatePositionMarginValidateBeforeCall(settle, contract, change, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updatePositionLeverage
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param leverage New position leverage (required)
     * @param crossLeverageLimit Cross margin leverage(valid only when &#x60;leverage&#x60; is 0) (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updatePositionLeverageCall(String settle, String contract, String leverage, String crossLeverageLimit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/positions/{contract}/leverage"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (leverage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("leverage", leverage));
        }

        if (crossLeverageLimit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cross_leverage_limit", crossLeverageLimit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updatePositionLeverageValidateBeforeCall(String settle, String contract, String leverage, String crossLeverageLimit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updatePositionLeverage(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updatePositionLeverage(Async)");
        }

        // verify the required parameter 'leverage' is set
        if (leverage == null) {
            throw new ApiException("Missing the required parameter 'leverage' when calling updatePositionLeverage(Async)");
        }

        okhttp3.Call localVarCall = updatePositionLeverageCall(settle, contract, leverage, crossLeverageLimit, _callback);
        return localVarCall;
    }

    /**
     * Update position leverage
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param leverage New position leverage (required)
     * @param crossLeverageLimit Cross margin leverage(valid only when &#x60;leverage&#x60; is 0) (optional)
     * @return Position
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public Position updatePositionLeverage(String settle, String contract, String leverage, String crossLeverageLimit) throws ApiException {
        ApiResponse<Position> localVarResp = updatePositionLeverageWithHttpInfo(settle, contract, leverage, crossLeverageLimit);
        return localVarResp.getData();
    }

    /**
     * Update position leverage
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param leverage New position leverage (required)
     * @param crossLeverageLimit Cross margin leverage(valid only when &#x60;leverage&#x60; is 0) (optional)
     * @return ApiResponse&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Position> updatePositionLeverageWithHttpInfo(String settle, String contract, String leverage, String crossLeverageLimit) throws ApiException {
        okhttp3.Call localVarCall = updatePositionLeverageValidateBeforeCall(settle, contract, leverage, crossLeverageLimit, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update position leverage (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param leverage New position leverage (required)
     * @param crossLeverageLimit Cross margin leverage(valid only when &#x60;leverage&#x60; is 0) (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updatePositionLeverageAsync(String settle, String contract, String leverage, String crossLeverageLimit, final ApiCallback<Position> _callback) throws ApiException {
        okhttp3.Call localVarCall = updatePositionLeverageValidateBeforeCall(settle, contract, leverage, crossLeverageLimit, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updatePositionRiskLimit
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param riskLimit New position risk limit (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updatePositionRiskLimitCall(String settle, String contract, String riskLimit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/positions/{contract}/risk_limit"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (riskLimit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("risk_limit", riskLimit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updatePositionRiskLimitValidateBeforeCall(String settle, String contract, String riskLimit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updatePositionRiskLimit(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updatePositionRiskLimit(Async)");
        }

        // verify the required parameter 'riskLimit' is set
        if (riskLimit == null) {
            throw new ApiException("Missing the required parameter 'riskLimit' when calling updatePositionRiskLimit(Async)");
        }

        okhttp3.Call localVarCall = updatePositionRiskLimitCall(settle, contract, riskLimit, _callback);
        return localVarCall;
    }

    /**
     * Update position risk limit
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param riskLimit New position risk limit (required)
     * @return Position
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public Position updatePositionRiskLimit(String settle, String contract, String riskLimit) throws ApiException {
        ApiResponse<Position> localVarResp = updatePositionRiskLimitWithHttpInfo(settle, contract, riskLimit);
        return localVarResp.getData();
    }

    /**
     * Update position risk limit
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param riskLimit New position risk limit (required)
     * @return ApiResponse&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Position> updatePositionRiskLimitWithHttpInfo(String settle, String contract, String riskLimit) throws ApiException {
        okhttp3.Call localVarCall = updatePositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update position risk limit (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param riskLimit New position risk limit (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Position information </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updatePositionRiskLimitAsync(String settle, String contract, String riskLimit, final ApiCallback<Position> _callback) throws ApiException {
        okhttp3.Call localVarCall = updatePositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for setDualMode
     * @param settle Settle currency (required)
     * @param dualMode Whether to enable dual mode (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setDualModeCall(String settle, Boolean dualMode, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/dual_mode"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dualMode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dual_mode", dualMode));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setDualModeValidateBeforeCall(String settle, Boolean dualMode, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling setDualMode(Async)");
        }

        // verify the required parameter 'dualMode' is set
        if (dualMode == null) {
            throw new ApiException("Missing the required parameter 'dualMode' when calling setDualMode(Async)");
        }

        okhttp3.Call localVarCall = setDualModeCall(settle, dualMode, _callback);
        return localVarCall;
    }

    /**
     * Enable or disable dual mode
     * Before setting dual mode, make sure all positions are closed and no orders are open
     * @param settle Settle currency (required)
     * @param dualMode Whether to enable dual mode (required)
     * @return FuturesAccount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public FuturesAccount setDualMode(String settle, Boolean dualMode) throws ApiException {
        ApiResponse<FuturesAccount> localVarResp = setDualModeWithHttpInfo(settle, dualMode);
        return localVarResp.getData();
    }

    /**
     * Enable or disable dual mode
     * Before setting dual mode, make sure all positions are closed and no orders are open
     * @param settle Settle currency (required)
     * @param dualMode Whether to enable dual mode (required)
     * @return ApiResponse&lt;FuturesAccount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesAccount> setDualModeWithHttpInfo(String settle, Boolean dualMode) throws ApiException {
        okhttp3.Call localVarCall = setDualModeValidateBeforeCall(settle, dualMode, null);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Enable or disable dual mode (asynchronously)
     * Before setting dual mode, make sure all positions are closed and no orders are open
     * @param settle Settle currency (required)
     * @param dualMode Whether to enable dual mode (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Updated </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setDualModeAsync(String settle, Boolean dualMode, final ApiCallback<FuturesAccount> _callback) throws ApiException {
        okhttp3.Call localVarCall = setDualModeValidateBeforeCall(settle, dualMode, _callback);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getDualModePosition
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDualModePositionCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/dual_comp/positions/{contract}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getDualModePositionValidateBeforeCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getDualModePosition(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getDualModePosition(Async)");
        }

        okhttp3.Call localVarCall = getDualModePositionCall(settle, contract, _callback);
        return localVarCall;
    }

    /**
     * Retrieve position detail in dual mode
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return List&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<Position> getDualModePosition(String settle, String contract) throws ApiException {
        ApiResponse<List<Position>> localVarResp = getDualModePositionWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    /**
     * Retrieve position detail in dual mode
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return ApiResponse&lt;List&lt;Position&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Position>> getDualModePositionWithHttpInfo(String settle, String contract) throws ApiException {
        okhttp3.Call localVarCall = getDualModePositionValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve position detail in dual mode (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getDualModePositionAsync(String settle, String contract, final ApiCallback<List<Position>> _callback) throws ApiException {
        okhttp3.Call localVarCall = getDualModePositionValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updateDualModePositionMargin
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param change Margin change. Use positive number to increase margin, negative number otherwise. (required)
     * @param dualSide Long or short position (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDualModePositionMarginCall(String settle, String contract, String change, String dualSide, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/dual_comp/positions/{contract}/margin"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (change != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("change", change));
        }

        if (dualSide != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dual_side", dualSide));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateDualModePositionMarginValidateBeforeCall(String settle, String contract, String change, String dualSide, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDualModePositionMargin(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDualModePositionMargin(Async)");
        }

        // verify the required parameter 'change' is set
        if (change == null) {
            throw new ApiException("Missing the required parameter 'change' when calling updateDualModePositionMargin(Async)");
        }

        // verify the required parameter 'dualSide' is set
        if (dualSide == null) {
            throw new ApiException("Missing the required parameter 'dualSide' when calling updateDualModePositionMargin(Async)");
        }

        okhttp3.Call localVarCall = updateDualModePositionMarginCall(settle, contract, change, dualSide, _callback);
        return localVarCall;
    }

    /**
     * Update position margin in dual mode
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param change Margin change. Use positive number to increase margin, negative number otherwise. (required)
     * @param dualSide Long or short position (required)
     * @return List&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<Position> updateDualModePositionMargin(String settle, String contract, String change, String dualSide) throws ApiException {
        ApiResponse<List<Position>> localVarResp = updateDualModePositionMarginWithHttpInfo(settle, contract, change, dualSide);
        return localVarResp.getData();
    }

    /**
     * Update position margin in dual mode
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param change Margin change. Use positive number to increase margin, negative number otherwise. (required)
     * @param dualSide Long or short position (required)
     * @return ApiResponse&lt;List&lt;Position&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Position>> updateDualModePositionMarginWithHttpInfo(String settle, String contract, String change, String dualSide) throws ApiException {
        okhttp3.Call localVarCall = updateDualModePositionMarginValidateBeforeCall(settle, contract, change, dualSide, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update position margin in dual mode (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param change Margin change. Use positive number to increase margin, negative number otherwise. (required)
     * @param dualSide Long or short position (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDualModePositionMarginAsync(String settle, String contract, String change, String dualSide, final ApiCallback<List<Position>> _callback) throws ApiException {
        okhttp3.Call localVarCall = updateDualModePositionMarginValidateBeforeCall(settle, contract, change, dualSide, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updateDualModePositionLeverage
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param leverage New position leverage (required)
     * @param crossLeverageLimit Cross margin leverage(valid only when &#x60;leverage&#x60; is 0) (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDualModePositionLeverageCall(String settle, String contract, String leverage, String crossLeverageLimit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/dual_comp/positions/{contract}/leverage"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (leverage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("leverage", leverage));
        }

        if (crossLeverageLimit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cross_leverage_limit", crossLeverageLimit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateDualModePositionLeverageValidateBeforeCall(String settle, String contract, String leverage, String crossLeverageLimit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDualModePositionLeverage(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDualModePositionLeverage(Async)");
        }

        // verify the required parameter 'leverage' is set
        if (leverage == null) {
            throw new ApiException("Missing the required parameter 'leverage' when calling updateDualModePositionLeverage(Async)");
        }

        okhttp3.Call localVarCall = updateDualModePositionLeverageCall(settle, contract, leverage, crossLeverageLimit, _callback);
        return localVarCall;
    }

    /**
     * Update position leverage in dual mode
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param leverage New position leverage (required)
     * @param crossLeverageLimit Cross margin leverage(valid only when &#x60;leverage&#x60; is 0) (optional)
     * @return List&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<Position> updateDualModePositionLeverage(String settle, String contract, String leverage, String crossLeverageLimit) throws ApiException {
        ApiResponse<List<Position>> localVarResp = updateDualModePositionLeverageWithHttpInfo(settle, contract, leverage, crossLeverageLimit);
        return localVarResp.getData();
    }

    /**
     * Update position leverage in dual mode
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param leverage New position leverage (required)
     * @param crossLeverageLimit Cross margin leverage(valid only when &#x60;leverage&#x60; is 0) (optional)
     * @return ApiResponse&lt;List&lt;Position&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Position>> updateDualModePositionLeverageWithHttpInfo(String settle, String contract, String leverage, String crossLeverageLimit) throws ApiException {
        okhttp3.Call localVarCall = updateDualModePositionLeverageValidateBeforeCall(settle, contract, leverage, crossLeverageLimit, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update position leverage in dual mode (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param leverage New position leverage (required)
     * @param crossLeverageLimit Cross margin leverage(valid only when &#x60;leverage&#x60; is 0) (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDualModePositionLeverageAsync(String settle, String contract, String leverage, String crossLeverageLimit, final ApiCallback<List<Position>> _callback) throws ApiException {
        okhttp3.Call localVarCall = updateDualModePositionLeverageValidateBeforeCall(settle, contract, leverage, crossLeverageLimit, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for updateDualModePositionRiskLimit
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param riskLimit New position risk limit (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDualModePositionRiskLimitCall(String settle, String contract, String riskLimit, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/dual_comp/positions/{contract}/risk_limit"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "contract" + "\\}", localVarApiClient.escapeString(contract));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (riskLimit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("risk_limit", riskLimit));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateDualModePositionRiskLimitValidateBeforeCall(String settle, String contract, String riskLimit, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDualModePositionRiskLimit(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDualModePositionRiskLimit(Async)");
        }

        // verify the required parameter 'riskLimit' is set
        if (riskLimit == null) {
            throw new ApiException("Missing the required parameter 'riskLimit' when calling updateDualModePositionRiskLimit(Async)");
        }

        okhttp3.Call localVarCall = updateDualModePositionRiskLimitCall(settle, contract, riskLimit, _callback);
        return localVarCall;
    }

    /**
     * Update position risk limit in dual mode
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param riskLimit New position risk limit (required)
     * @return List&lt;Position&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<Position> updateDualModePositionRiskLimit(String settle, String contract, String riskLimit) throws ApiException {
        ApiResponse<List<Position>> localVarResp = updateDualModePositionRiskLimitWithHttpInfo(settle, contract, riskLimit);
        return localVarResp.getData();
    }

    /**
     * Update position risk limit in dual mode
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param riskLimit New position risk limit (required)
     * @return ApiResponse&lt;List&lt;Position&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Position>> updateDualModePositionRiskLimitWithHttpInfo(String settle, String contract, String riskLimit) throws ApiException {
        okhttp3.Call localVarCall = updateDualModePositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update position risk limit in dual mode (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param riskLimit New position risk limit (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDualModePositionRiskLimitAsync(String settle, String contract, String riskLimit, final ApiCallback<List<Position>> _callback) throws ApiException {
        okhttp3.Call localVarCall = updateDualModePositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listFuturesOrdersCall(String settle, String contract, String status, Integer limit, Integer offset, String lastId, Integer countTotal, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/orders"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (lastId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("last_id", lastId));
        }

        if (countTotal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count_total", countTotal));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFuturesOrdersValidateBeforeCall(String settle, String contract, String status, Integer limit, Integer offset, String lastId, Integer countTotal, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesOrders(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesOrders(Async)");
        }

        // verify the required parameter 'status' is set
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listFuturesOrders(Async)");
        }

        okhttp3.Call localVarCall = listFuturesOrdersCall(settle, contract, status, limit, offset, lastId, countTotal, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesOrder>> listFuturesOrdersWithHttpInfo(String settle, String contract, String status, Integer limit, Integer offset, String lastId, Integer countTotal) throws ApiException {
        okhttp3.Call localVarCall = listFuturesOrdersValidateBeforeCall(settle, contract, status, limit, offset, lastId, countTotal, null);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFuturesOrdersAsync(String settle, String contract, String status, Integer limit, Integer offset, String lastId, Integer countTotal, final ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFuturesOrdersValidateBeforeCall(settle, contract, status, limit, offset, lastId, countTotal, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFuturesOrdersRequest {
        private final String settle;
        private final String contract;
        private final String status;
        private Integer limit;
        private Integer offset;
        private String lastId;
        private Integer countTotal;

        private APIlistFuturesOrdersRequest(String settle, String contract, String status) {
            this.settle = settle;
            this.contract = contract;
            this.status = status;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistFuturesOrdersRequest
         */
        public APIlistFuturesOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistFuturesOrdersRequest
         */
        public APIlistFuturesOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set lastId
         * @param lastId Specify list staring point using the &#x60;id&#x60; of last record in previous list-query results (optional)
         * @return APIlistFuturesOrdersRequest
         */
        public APIlistFuturesOrdersRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        /**
         * Set countTotal
         * @param countTotal Whether to return total number matched. Default to 0(no return) (optional, default to 0)
         * @return APIlistFuturesOrdersRequest
         */
        public APIlistFuturesOrdersRequest countTotal(Integer countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        /**
         * Build call for listFuturesOrders
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFuturesOrdersCall(settle, contract, status, limit, offset, lastId, countTotal, _callback);
        }

        /**
         * Execute listFuturesOrders request
         * @return List&lt;FuturesOrder&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
         </table>
         */
        public List<FuturesOrder> execute() throws ApiException {
            ApiResponse<List<FuturesOrder>> localVarResp = listFuturesOrdersWithHttpInfo(settle, contract, status, limit, offset, lastId, countTotal);
            return localVarResp.getData();
        }

        /**
         * Execute listFuturesOrders request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesOrder&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesOrder>> executeWithHttpInfo() throws ApiException {
            return listFuturesOrdersWithHttpInfo(settle, contract, status, limit, offset, lastId, countTotal);
        }

        /**
         * Execute listFuturesOrders request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
            return listFuturesOrdersAsync(settle, contract, status, limit, offset, lastId, countTotal, _callback);
        }
    }

    /**
     * List futures orders
     * Zero-filled order cannot be retrieved 10 minutes after order cancellation
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param status Only list the orders with this status (required)
     * @return APIlistFuturesOrdersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
     </table>
     */
    public APIlistFuturesOrdersRequest listFuturesOrders(String settle, String contract, String status) {
        return new APIlistFuturesOrdersRequest(settle, contract, status);
    }

    /**
     * Build call for createFuturesOrder
     * @param settle Settle currency (required)
     * @param futuresOrder  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createFuturesOrderCall(String settle, FuturesOrder futuresOrder, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = futuresOrder;

        // create path and map variables
        String localVarPath = "/futures/{settle}/orders"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createFuturesOrderValidateBeforeCall(String settle, FuturesOrder futuresOrder, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling createFuturesOrder(Async)");
        }

        // verify the required parameter 'futuresOrder' is set
        if (futuresOrder == null) {
            throw new ApiException("Missing the required parameter 'futuresOrder' when calling createFuturesOrder(Async)");
        }

        okhttp3.Call localVarCall = createFuturesOrderCall(settle, futuresOrder, _callback);
        return localVarCall;
    }

    /**
     * Create a futures order
     * - Creating futures orders requires &#x60;size&#x60;, which is number of contracts instead of currency amount. You can use &#x60;quanto_multiplier&#x60; in contract detail response to know how much currency 1 size contract represents - Zero-filled order cannot be retrieved 10 minutes after order cancellation. You will get a 404 not found for such orders - Set &#x60;reduce_only&#x60; to &#x60;true&#x60; can keep the position from changing side when reducing position size - In single position mode, to close a position, you need to set &#x60;size&#x60; to 0 and &#x60;close&#x60; to &#x60;true&#x60; - In dual position mode, to close one side position, you need to set &#x60;auto_size&#x60; side, &#x60;reduce_only&#x60; to true and &#x60;size&#x60; to 0
     * @param settle Settle currency (required)
     * @param futuresOrder  (required)
     * @return FuturesOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public FuturesOrder createFuturesOrder(String settle, FuturesOrder futuresOrder) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = createFuturesOrderWithHttpInfo(settle, futuresOrder);
        return localVarResp.getData();
    }

    /**
     * Create a futures order
     * - Creating futures orders requires &#x60;size&#x60;, which is number of contracts instead of currency amount. You can use &#x60;quanto_multiplier&#x60; in contract detail response to know how much currency 1 size contract represents - Zero-filled order cannot be retrieved 10 minutes after order cancellation. You will get a 404 not found for such orders - Set &#x60;reduce_only&#x60; to &#x60;true&#x60; can keep the position from changing side when reducing position size - In single position mode, to close a position, you need to set &#x60;size&#x60; to 0 and &#x60;close&#x60; to &#x60;true&#x60; - In dual position mode, to close one side position, you need to set &#x60;auto_size&#x60; side, &#x60;reduce_only&#x60; to true and &#x60;size&#x60; to 0
     * @param settle Settle currency (required)
     * @param futuresOrder  (required)
     * @return ApiResponse&lt;FuturesOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesOrder> createFuturesOrderWithHttpInfo(String settle, FuturesOrder futuresOrder) throws ApiException {
        okhttp3.Call localVarCall = createFuturesOrderValidateBeforeCall(settle, futuresOrder, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a futures order (asynchronously)
     * - Creating futures orders requires &#x60;size&#x60;, which is number of contracts instead of currency amount. You can use &#x60;quanto_multiplier&#x60; in contract detail response to know how much currency 1 size contract represents - Zero-filled order cannot be retrieved 10 minutes after order cancellation. You will get a 404 not found for such orders - Set &#x60;reduce_only&#x60; to &#x60;true&#x60; can keep the position from changing side when reducing position size - In single position mode, to close a position, you need to set &#x60;size&#x60; to 0 and &#x60;close&#x60; to &#x60;true&#x60; - In dual position mode, to close one side position, you need to set &#x60;auto_size&#x60; side, &#x60;reduce_only&#x60; to true and &#x60;size&#x60; to 0
     * @param settle Settle currency (required)
     * @param futuresOrder  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createFuturesOrderAsync(String settle, FuturesOrder futuresOrder, final ApiCallback<FuturesOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = createFuturesOrderValidateBeforeCall(settle, futuresOrder, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for cancelFuturesOrders
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param side All bids or asks. Both included if not specified (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All orders matched cancelled </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelFuturesOrdersCall(String settle, String contract, String side, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/orders"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (side != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("side", side));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelFuturesOrdersValidateBeforeCall(String settle, String contract, String side, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelFuturesOrders(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling cancelFuturesOrders(Async)");
        }

        okhttp3.Call localVarCall = cancelFuturesOrdersCall(settle, contract, side, _callback);
        return localVarCall;
    }

    /**
     * Cancel all &#x60;open&#x60; orders matched
     * Zero-filled order cannot be retrieved 10 minutes after order cancellation
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param side All bids or asks. Both included if not specified (optional)
     * @return List&lt;FuturesOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All orders matched cancelled </td><td>  -  </td></tr>
     </table>
     */
    public List<FuturesOrder> cancelFuturesOrders(String settle, String contract, String side) throws ApiException {
        ApiResponse<List<FuturesOrder>> localVarResp = cancelFuturesOrdersWithHttpInfo(settle, contract, side);
        return localVarResp.getData();
    }

    /**
     * Cancel all &#x60;open&#x60; orders matched
     * Zero-filled order cannot be retrieved 10 minutes after order cancellation
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param side All bids or asks. Both included if not specified (optional)
     * @return ApiResponse&lt;List&lt;FuturesOrder&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All orders matched cancelled </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<FuturesOrder>> cancelFuturesOrdersWithHttpInfo(String settle, String contract, String side) throws ApiException {
        okhttp3.Call localVarCall = cancelFuturesOrdersValidateBeforeCall(settle, contract, side, null);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cancel all &#x60;open&#x60; orders matched (asynchronously)
     * Zero-filled order cannot be retrieved 10 minutes after order cancellation
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param side All bids or asks. Both included if not specified (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> All orders matched cancelled </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelFuturesOrdersAsync(String settle, String contract, String side, final ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
        okhttp3.Call localVarCall = cancelFuturesOrdersValidateBeforeCall(settle, contract, side, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getFuturesOrder
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFuturesOrderCall(String settle, String orderId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/orders/{order_id}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "order_id" + "\\}", localVarApiClient.escapeString(orderId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFuturesOrderValidateBeforeCall(String settle, String orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getFuturesOrder(Async)");
        }

        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getFuturesOrder(Async)");
        }

        okhttp3.Call localVarCall = getFuturesOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    /**
     * Get a single order
     * Zero-filled order cannot be retrieved 10 minutes after order cancellation
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @return FuturesOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public FuturesOrder getFuturesOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = getFuturesOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    /**
     * Get a single order
     * Zero-filled order cannot be retrieved 10 minutes after order cancellation
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @return ApiResponse&lt;FuturesOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesOrder> getFuturesOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        okhttp3.Call localVarCall = getFuturesOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a single order (asynchronously)
     * Zero-filled order cannot be retrieved 10 minutes after order cancellation
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFuturesOrderAsync(String settle, String orderId, final ApiCallback<FuturesOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = getFuturesOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for amendFuturesOrder
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @param futuresOrderAmendment  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call amendFuturesOrderCall(String settle, String orderId, FuturesOrderAmendment futuresOrderAmendment, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = futuresOrderAmendment;

        // create path and map variables
        String localVarPath = "/futures/{settle}/orders/{order_id}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "order_id" + "\\}", localVarApiClient.escapeString(orderId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call amendFuturesOrderValidateBeforeCall(String settle, String orderId, FuturesOrderAmendment futuresOrderAmendment, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling amendFuturesOrder(Async)");
        }

        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling amendFuturesOrder(Async)");
        }

        // verify the required parameter 'futuresOrderAmendment' is set
        if (futuresOrderAmendment == null) {
            throw new ApiException("Missing the required parameter 'futuresOrderAmendment' when calling amendFuturesOrder(Async)");
        }

        okhttp3.Call localVarCall = amendFuturesOrderCall(settle, orderId, futuresOrderAmendment, _callback);
        return localVarCall;
    }

    /**
     * Amend an order
     * 
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @param futuresOrderAmendment  (required)
     * @return FuturesOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public FuturesOrder amendFuturesOrder(String settle, String orderId, FuturesOrderAmendment futuresOrderAmendment) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = amendFuturesOrderWithHttpInfo(settle, orderId, futuresOrderAmendment);
        return localVarResp.getData();
    }

    /**
     * Amend an order
     * 
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @param futuresOrderAmendment  (required)
     * @return ApiResponse&lt;FuturesOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesOrder> amendFuturesOrderWithHttpInfo(String settle, String orderId, FuturesOrderAmendment futuresOrderAmendment) throws ApiException {
        okhttp3.Call localVarCall = amendFuturesOrderValidateBeforeCall(settle, orderId, futuresOrderAmendment, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Amend an order (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @param futuresOrderAmendment  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call amendFuturesOrderAsync(String settle, String orderId, FuturesOrderAmendment futuresOrderAmendment, final ApiCallback<FuturesOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = amendFuturesOrderValidateBeforeCall(settle, orderId, futuresOrderAmendment, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for cancelFuturesOrder
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelFuturesOrderCall(String settle, String orderId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/orders/{order_id}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "order_id" + "\\}", localVarApiClient.escapeString(orderId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelFuturesOrderValidateBeforeCall(String settle, String orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelFuturesOrder(Async)");
        }

        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelFuturesOrder(Async)");
        }

        okhttp3.Call localVarCall = cancelFuturesOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    /**
     * Cancel a single order
     * 
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @return FuturesOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public FuturesOrder cancelFuturesOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = cancelFuturesOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    /**
     * Cancel a single order
     * 
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @return ApiResponse&lt;FuturesOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesOrder> cancelFuturesOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        okhttp3.Call localVarCall = cancelFuturesOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cancel a single order (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param orderId Order ID returned, or user custom ID(i.e., &#x60;text&#x60; field). Operations based on custom ID are accepted only in the first 30 minutes after order creation.After that, only order ID is accepted. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Order details </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelFuturesOrderAsync(String settle, String orderId, final ApiCallback<FuturesOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = cancelFuturesOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call getMyTradesCall(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/my_trades"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (order != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("order", order));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (lastId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("last_id", lastId));
        }

        if (countTotal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("count_total", countTotal));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getMyTradesValidateBeforeCall(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getMyTrades(Async)");
        }

        okhttp3.Call localVarCall = getMyTradesCall(settle, contract, order, limit, offset, lastId, countTotal, _callback);
        return localVarCall;
    }


    private ApiResponse<List<MyFuturesTrade>> getMyTradesWithHttpInfo(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal) throws ApiException {
        okhttp3.Call localVarCall = getMyTradesValidateBeforeCall(settle, contract, order, limit, offset, lastId, countTotal, null);
        Type localVarReturnType = new TypeToken<List<MyFuturesTrade>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getMyTradesAsync(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, final ApiCallback<List<MyFuturesTrade>> _callback) throws ApiException {
        okhttp3.Call localVarCall = getMyTradesValidateBeforeCall(settle, contract, order, limit, offset, lastId, countTotal, _callback);
        Type localVarReturnType = new TypeToken<List<MyFuturesTrade>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIgetMyTradesRequest {
        private final String settle;
        private String contract;
        private Long order;
        private Integer limit;
        private Integer offset;
        private String lastId;
        private Integer countTotal;

        private APIgetMyTradesRequest(String settle) {
            this.settle = settle;
        }

        /**
         * Set contract
         * @param contract Futures contract, return related data only if specified (optional)
         * @return APIgetMyTradesRequest
         */
        public APIgetMyTradesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set order
         * @param order Futures order ID, return related data only if specified (optional)
         * @return APIgetMyTradesRequest
         */
        public APIgetMyTradesRequest order(Long order) {
            this.order = order;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIgetMyTradesRequest
         */
        public APIgetMyTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIgetMyTradesRequest
         */
        public APIgetMyTradesRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set lastId
         * @param lastId Specify list staring point using the &#x60;id&#x60; of last record in previous list-query results (optional)
         * @return APIgetMyTradesRequest
         */
        public APIgetMyTradesRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        /**
         * Set countTotal
         * @param countTotal Whether to return total number matched. Default to 0(no return) (optional, default to 0)
         * @return APIgetMyTradesRequest
         */
        public APIgetMyTradesRequest countTotal(Integer countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        /**
         * Build call for getMyTrades
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getMyTradesCall(settle, contract, order, limit, offset, lastId, countTotal, _callback);
        }

        /**
         * Execute getMyTrades request
         * @return List&lt;MyFuturesTrade&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
         </table>
         */
        public List<MyFuturesTrade> execute() throws ApiException {
            ApiResponse<List<MyFuturesTrade>> localVarResp = getMyTradesWithHttpInfo(settle, contract, order, limit, offset, lastId, countTotal);
            return localVarResp.getData();
        }

        /**
         * Execute getMyTrades request with HTTP info returned
         * @return ApiResponse&lt;List&lt;MyFuturesTrade&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
         </table>
         */
        public ApiResponse<List<MyFuturesTrade>> executeWithHttpInfo() throws ApiException {
            return getMyTradesWithHttpInfo(settle, contract, order, limit, offset, lastId, countTotal);
        }

        /**
         * Execute getMyTrades request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<MyFuturesTrade>> _callback) throws ApiException {
            return getMyTradesAsync(settle, contract, order, limit, offset, lastId, countTotal, _callback);
        }
    }

    /**
     * List personal trading history
     * 
     * @param settle Settle currency (required)
     * @return APIgetMyTradesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  * X-Pagination-Limit - Request limit specified <br>  * X-Pagination-Offset - Request offset specified <br>  * X-Pagination-Total - Total number matched. Only returned if &#x60;count_total&#x60; set to 1 <br>  </td></tr>
     </table>
     */
    public APIgetMyTradesRequest getMyTrades(String settle) {
        return new APIgetMyTradesRequest(settle);
    }

    private okhttp3.Call listPositionCloseCall(String settle, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/position_close"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        if (from != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("from", from));
        }

        if (to != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("to", to));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listPositionCloseValidateBeforeCall(String settle, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listPositionClose(Async)");
        }

        okhttp3.Call localVarCall = listPositionCloseCall(settle, contract, limit, offset, from, to, _callback);
        return localVarCall;
    }


    private ApiResponse<List<PositionClose>> listPositionCloseWithHttpInfo(String settle, String contract, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        okhttp3.Call localVarCall = listPositionCloseValidateBeforeCall(settle, contract, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<PositionClose>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listPositionCloseAsync(String settle, String contract, Integer limit, Integer offset, Long from, Long to, final ApiCallback<List<PositionClose>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listPositionCloseValidateBeforeCall(settle, contract, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<PositionClose>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistPositionCloseRequest {
        private final String settle;
        private String contract;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistPositionCloseRequest(String settle) {
            this.settle = settle;
        }

        /**
         * Set contract
         * @param contract Futures contract, return related data only if specified (optional)
         * @return APIlistPositionCloseRequest
         */
        public APIlistPositionCloseRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistPositionCloseRequest
         */
        public APIlistPositionCloseRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistPositionCloseRequest
         */
        public APIlistPositionCloseRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Set from
         * @param from Start timestamp (optional)
         * @return APIlistPositionCloseRequest
         */
        public APIlistPositionCloseRequest from(Long from) {
            this.from = from;
            return this;
        }

        /**
         * Set to
         * @param to End timestamp (optional)
         * @return APIlistPositionCloseRequest
         */
        public APIlistPositionCloseRequest to(Long to) {
            this.to = to;
            return this;
        }

        /**
         * Build call for listPositionClose
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listPositionCloseCall(settle, contract, limit, offset, from, to, _callback);
        }

        /**
         * Execute listPositionClose request
         * @return List&lt;PositionClose&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<PositionClose> execute() throws ApiException {
            ApiResponse<List<PositionClose>> localVarResp = listPositionCloseWithHttpInfo(settle, contract, limit, offset, from, to);
            return localVarResp.getData();
        }

        /**
         * Execute listPositionClose request with HTTP info returned
         * @return ApiResponse&lt;List&lt;PositionClose&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<PositionClose>> executeWithHttpInfo() throws ApiException {
            return listPositionCloseWithHttpInfo(settle, contract, limit, offset, from, to);
        }

        /**
         * Execute listPositionClose request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<PositionClose>> _callback) throws ApiException {
            return listPositionCloseAsync(settle, contract, limit, offset, from, to, _callback);
        }
    }

    /**
     * List position close history
     * 
     * @param settle Settle currency (required)
     * @return APIlistPositionCloseRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistPositionCloseRequest listPositionClose(String settle) {
        return new APIlistPositionCloseRequest(settle);
    }

    private okhttp3.Call listLiquidatesCall(String settle, String contract, Integer limit, Integer at, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/liquidates"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (at != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("at", at));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listLiquidatesValidateBeforeCall(String settle, String contract, Integer limit, Integer at, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listLiquidates(Async)");
        }

        okhttp3.Call localVarCall = listLiquidatesCall(settle, contract, limit, at, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesLiquidate>> listLiquidatesWithHttpInfo(String settle, String contract, Integer limit, Integer at) throws ApiException {
        okhttp3.Call localVarCall = listLiquidatesValidateBeforeCall(settle, contract, limit, at, null);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listLiquidatesAsync(String settle, String contract, Integer limit, Integer at, final ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listLiquidatesValidateBeforeCall(settle, contract, limit, at, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistLiquidatesRequest {
        private final String settle;
        private String contract;
        private Integer limit;
        private Integer at;

        private APIlistLiquidatesRequest(String settle) {
            this.settle = settle;
        }

        /**
         * Set contract
         * @param contract Futures contract, return related data only if specified (optional)
         * @return APIlistLiquidatesRequest
         */
        public APIlistLiquidatesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistLiquidatesRequest
         */
        public APIlistLiquidatesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set at
         * @param at Specify a liquidation timestamp (optional, default to 0)
         * @return APIlistLiquidatesRequest
         */
        public APIlistLiquidatesRequest at(Integer at) {
            this.at = at;
            return this;
        }

        /**
         * Build call for listLiquidates
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listLiquidatesCall(settle, contract, limit, at, _callback);
        }

        /**
         * Execute listLiquidates request
         * @return List&lt;FuturesLiquidate&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesLiquidate> execute() throws ApiException {
            ApiResponse<List<FuturesLiquidate>> localVarResp = listLiquidatesWithHttpInfo(settle, contract, limit, at);
            return localVarResp.getData();
        }

        /**
         * Execute listLiquidates request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesLiquidate&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesLiquidate>> executeWithHttpInfo() throws ApiException {
            return listLiquidatesWithHttpInfo(settle, contract, limit, at);
        }

        /**
         * Execute listLiquidates request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
            return listLiquidatesAsync(settle, contract, limit, at, _callback);
        }
    }

    /**
     * List liquidation history
     * 
     * @param settle Settle currency (required)
     * @return APIlistLiquidatesRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistLiquidatesRequest listLiquidates(String settle) {
        return new APIlistLiquidatesRequest(settle);
    }

    private okhttp3.Call listPriceTriggeredOrdersCall(String settle, String status, String contract, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/price_orders"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (offset != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("offset", offset));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listPriceTriggeredOrdersValidateBeforeCall(String settle, String status, String contract, Integer limit, Integer offset, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listPriceTriggeredOrders(Async)");
        }

        // verify the required parameter 'status' is set
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listPriceTriggeredOrders(Async)");
        }

        okhttp3.Call localVarCall = listPriceTriggeredOrdersCall(settle, status, contract, limit, offset, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FuturesPriceTriggeredOrder>> listPriceTriggeredOrdersWithHttpInfo(String settle, String status, String contract, Integer limit, Integer offset) throws ApiException {
        okhttp3.Call localVarCall = listPriceTriggeredOrdersValidateBeforeCall(settle, status, contract, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listPriceTriggeredOrdersAsync(String settle, String status, String contract, Integer limit, Integer offset, final ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listPriceTriggeredOrdersValidateBeforeCall(settle, status, contract, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistPriceTriggeredOrdersRequest {
        private final String settle;
        private final String status;
        private String contract;
        private Integer limit;
        private Integer offset;

        private APIlistPriceTriggeredOrdersRequest(String settle, String status) {
            this.settle = settle;
            this.status = status;
        }

        /**
         * Set contract
         * @param contract Futures contract, return related data only if specified (optional)
         * @return APIlistPriceTriggeredOrdersRequest
         */
        public APIlistPriceTriggeredOrdersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistPriceTriggeredOrdersRequest
         */
        public APIlistPriceTriggeredOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set offset
         * @param offset List offset, starting from 0 (optional, default to 0)
         * @return APIlistPriceTriggeredOrdersRequest
         */
        public APIlistPriceTriggeredOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        /**
         * Build call for listPriceTriggeredOrders
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listPriceTriggeredOrdersCall(settle, status, contract, limit, offset, _callback);
        }

        /**
         * Execute listPriceTriggeredOrders request
         * @return List&lt;FuturesPriceTriggeredOrder&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FuturesPriceTriggeredOrder> execute() throws ApiException {
            ApiResponse<List<FuturesPriceTriggeredOrder>> localVarResp = listPriceTriggeredOrdersWithHttpInfo(settle, status, contract, limit, offset);
            return localVarResp.getData();
        }

        /**
         * Execute listPriceTriggeredOrders request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FuturesPriceTriggeredOrder&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FuturesPriceTriggeredOrder>> executeWithHttpInfo() throws ApiException {
            return listPriceTriggeredOrdersWithHttpInfo(settle, status, contract, limit, offset);
        }

        /**
         * Execute listPriceTriggeredOrders request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
            return listPriceTriggeredOrdersAsync(settle, status, contract, limit, offset, _callback);
        }
    }

    /**
     * List all auto orders
     * 
     * @param settle Settle currency (required)
     * @param status Only list the orders with this status (required)
     * @return APIlistPriceTriggeredOrdersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistPriceTriggeredOrdersRequest listPriceTriggeredOrders(String settle, String status) {
        return new APIlistPriceTriggeredOrdersRequest(settle, status);
    }

    /**
     * Build call for createPriceTriggeredOrder
     * @param settle Settle currency (required)
     * @param futuresPriceTriggeredOrder  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createPriceTriggeredOrderCall(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = futuresPriceTriggeredOrder;

        // create path and map variables
        String localVarPath = "/futures/{settle}/price_orders"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createPriceTriggeredOrderValidateBeforeCall(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling createPriceTriggeredOrder(Async)");
        }

        // verify the required parameter 'futuresPriceTriggeredOrder' is set
        if (futuresPriceTriggeredOrder == null) {
            throw new ApiException("Missing the required parameter 'futuresPriceTriggeredOrder' when calling createPriceTriggeredOrder(Async)");
        }

        okhttp3.Call localVarCall = createPriceTriggeredOrderCall(settle, futuresPriceTriggeredOrder, _callback);
        return localVarCall;
    }

    /**
     * Create a price-triggered order
     * 
     * @param settle Settle currency (required)
     * @param futuresPriceTriggeredOrder  (required)
     * @return TriggerOrderResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order created </td><td>  -  </td></tr>
     </table>
     */
    public TriggerOrderResponse createPriceTriggeredOrder(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder) throws ApiException {
        ApiResponse<TriggerOrderResponse> localVarResp = createPriceTriggeredOrderWithHttpInfo(settle, futuresPriceTriggeredOrder);
        return localVarResp.getData();
    }

    /**
     * Create a price-triggered order
     * 
     * @param settle Settle currency (required)
     * @param futuresPriceTriggeredOrder  (required)
     * @return ApiResponse&lt;TriggerOrderResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order created </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TriggerOrderResponse> createPriceTriggeredOrderWithHttpInfo(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder) throws ApiException {
        okhttp3.Call localVarCall = createPriceTriggeredOrderValidateBeforeCall(settle, futuresPriceTriggeredOrder, null);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a price-triggered order (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param futuresPriceTriggeredOrder  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Order created </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createPriceTriggeredOrderAsync(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, final ApiCallback<TriggerOrderResponse> _callback) throws ApiException {
        okhttp3.Call localVarCall = createPriceTriggeredOrderValidateBeforeCall(settle, futuresPriceTriggeredOrder, _callback);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for cancelPriceTriggeredOrderList
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Batch cancellation request accepted. Query order status by listing orders </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelPriceTriggeredOrderListCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/price_orders"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("contract", contract));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelPriceTriggeredOrderListValidateBeforeCall(String settle, String contract, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelPriceTriggeredOrderList(Async)");
        }

        // verify the required parameter 'contract' is set
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling cancelPriceTriggeredOrderList(Async)");
        }

        okhttp3.Call localVarCall = cancelPriceTriggeredOrderListCall(settle, contract, _callback);
        return localVarCall;
    }

    /**
     * Cancel all open orders
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return List&lt;FuturesPriceTriggeredOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Batch cancellation request accepted. Query order status by listing orders </td><td>  -  </td></tr>
     </table>
     */
    public List<FuturesPriceTriggeredOrder> cancelPriceTriggeredOrderList(String settle, String contract) throws ApiException {
        ApiResponse<List<FuturesPriceTriggeredOrder>> localVarResp = cancelPriceTriggeredOrderListWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    /**
     * Cancel all open orders
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @return ApiResponse&lt;List&lt;FuturesPriceTriggeredOrder&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Batch cancellation request accepted. Query order status by listing orders </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<FuturesPriceTriggeredOrder>> cancelPriceTriggeredOrderListWithHttpInfo(String settle, String contract) throws ApiException {
        okhttp3.Call localVarCall = cancelPriceTriggeredOrderListValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cancel all open orders (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param contract Futures contract (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Batch cancellation request accepted. Query order status by listing orders </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelPriceTriggeredOrderListAsync(String settle, String contract, final ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
        okhttp3.Call localVarCall = cancelPriceTriggeredOrderListValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getPriceTriggeredOrder
     * @param settle Settle currency (required)
     * @param orderId Retrieve the data of the order with the specified ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Auto order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPriceTriggeredOrderCall(String settle, String orderId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/price_orders/{order_id}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "order_id" + "\\}", localVarApiClient.escapeString(orderId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getPriceTriggeredOrderValidateBeforeCall(String settle, String orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getPriceTriggeredOrder(Async)");
        }

        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getPriceTriggeredOrder(Async)");
        }

        okhttp3.Call localVarCall = getPriceTriggeredOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    /**
     * Get a single order
     * 
     * @param settle Settle currency (required)
     * @param orderId Retrieve the data of the order with the specified ID (required)
     * @return FuturesPriceTriggeredOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Auto order detail </td><td>  -  </td></tr>
     </table>
     */
    public FuturesPriceTriggeredOrder getPriceTriggeredOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesPriceTriggeredOrder> localVarResp = getPriceTriggeredOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    /**
     * Get a single order
     * 
     * @param settle Settle currency (required)
     * @param orderId Retrieve the data of the order with the specified ID (required)
     * @return ApiResponse&lt;FuturesPriceTriggeredOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Auto order detail </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesPriceTriggeredOrder> getPriceTriggeredOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        okhttp3.Call localVarCall = getPriceTriggeredOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a single order (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param orderId Retrieve the data of the order with the specified ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Auto order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getPriceTriggeredOrderAsync(String settle, String orderId, final ApiCallback<FuturesPriceTriggeredOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = getPriceTriggeredOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for cancelPriceTriggeredOrder
     * @param settle Settle currency (required)
     * @param orderId Retrieve the data of the order with the specified ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Auto order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelPriceTriggeredOrderCall(String settle, String orderId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/futures/{settle}/price_orders/{order_id}"
            .replaceAll("\\{" + "settle" + "\\}", localVarApiClient.escapeString(settle))
            .replaceAll("\\{" + "order_id" + "\\}", localVarApiClient.escapeString(orderId));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelPriceTriggeredOrderValidateBeforeCall(String settle, String orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'settle' is set
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelPriceTriggeredOrder(Async)");
        }

        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelPriceTriggeredOrder(Async)");
        }

        okhttp3.Call localVarCall = cancelPriceTriggeredOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    /**
     * Cancel a single order
     * 
     * @param settle Settle currency (required)
     * @param orderId Retrieve the data of the order with the specified ID (required)
     * @return FuturesPriceTriggeredOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Auto order detail </td><td>  -  </td></tr>
     </table>
     */
    public FuturesPriceTriggeredOrder cancelPriceTriggeredOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesPriceTriggeredOrder> localVarResp = cancelPriceTriggeredOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    /**
     * Cancel a single order
     * 
     * @param settle Settle currency (required)
     * @param orderId Retrieve the data of the order with the specified ID (required)
     * @return ApiResponse&lt;FuturesPriceTriggeredOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Auto order detail </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FuturesPriceTriggeredOrder> cancelPriceTriggeredOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        okhttp3.Call localVarCall = cancelPriceTriggeredOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Cancel a single order (asynchronously)
     * 
     * @param settle Settle currency (required)
     * @param orderId Retrieve the data of the order with the specified ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Auto order detail </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelPriceTriggeredOrderAsync(String settle, String orderId, final ApiCallback<FuturesPriceTriggeredOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = cancelPriceTriggeredOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

}
