/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.api;

import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;

import com.google.gson.reflect.TypeToken;


import io.gate.gateapi.models.FlashSwapCurrency;
import io.gate.gateapi.models.FlashSwapOrder;
import io.gate.gateapi.models.FlashSwapOrderPreview;
import io.gate.gateapi.models.FlashSwapOrderRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlashSwapApi {
    private ApiClient localVarApiClient;

    public FlashSwapApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FlashSwapApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for listFlashSwapCurrencies
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFlashSwapCurrenciesCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flash_swap/currencies";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFlashSwapCurrenciesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listFlashSwapCurrenciesCall(_callback);
        return localVarCall;
    }

    /**
     * List all supported currencies in flash swap
     * 
     * @return List&lt;FlashSwapCurrency&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public List<FlashSwapCurrency> listFlashSwapCurrencies() throws ApiException {
        ApiResponse<List<FlashSwapCurrency>> localVarResp = listFlashSwapCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * List all supported currencies in flash swap
     * 
     * @return ApiResponse&lt;List&lt;FlashSwapCurrency&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<FlashSwapCurrency>> listFlashSwapCurrenciesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = listFlashSwapCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<FlashSwapCurrency>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all supported currencies in flash swap (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listFlashSwapCurrenciesAsync(final ApiCallback<List<FlashSwapCurrency>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFlashSwapCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<FlashSwapCurrency>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private okhttp3.Call listFlashSwapOrdersCall(Integer status, String sellCurrency, String buyCurrency, Boolean reverse, Integer limit, Integer page, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flash_swap/orders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (sellCurrency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sell_currency", sellCurrency));
        }

        if (buyCurrency != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("buy_currency", buyCurrency));
        }

        if (reverse != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("reverse", reverse));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listFlashSwapOrdersValidateBeforeCall(Integer status, String sellCurrency, String buyCurrency, Boolean reverse, Integer limit, Integer page, final ApiCallback _callback) throws ApiException {
        okhttp3.Call localVarCall = listFlashSwapOrdersCall(status, sellCurrency, buyCurrency, reverse, limit, page, _callback);
        return localVarCall;
    }


    private ApiResponse<List<FlashSwapOrder>> listFlashSwapOrdersWithHttpInfo(Integer status, String sellCurrency, String buyCurrency, Boolean reverse, Integer limit, Integer page) throws ApiException {
        okhttp3.Call localVarCall = listFlashSwapOrdersValidateBeforeCall(status, sellCurrency, buyCurrency, reverse, limit, page, null);
        Type localVarReturnType = new TypeToken<List<FlashSwapOrder>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listFlashSwapOrdersAsync(Integer status, String sellCurrency, String buyCurrency, Boolean reverse, Integer limit, Integer page, final ApiCallback<List<FlashSwapOrder>> _callback) throws ApiException {
        okhttp3.Call localVarCall = listFlashSwapOrdersValidateBeforeCall(status, sellCurrency, buyCurrency, reverse, limit, page, _callback);
        Type localVarReturnType = new TypeToken<List<FlashSwapOrder>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistFlashSwapOrdersRequest {
        private Integer status;
        private String sellCurrency;
        private String buyCurrency;
        private Boolean reverse;
        private Integer limit;
        private Integer page;

        private APIlistFlashSwapOrdersRequest() {
        }

        /**
         * Set status
         * @param status Flash swap order status  &#x60;1&#x60; - success &#x60;2&#x60; - failure (optional)
         * @return APIlistFlashSwapOrdersRequest
         */
        public APIlistFlashSwapOrdersRequest status(Integer status) {
            this.status = status;
            return this;
        }

        /**
         * Set sellCurrency
         * @param sellCurrency Currency to sell which can be retrieved from supported currency list API &#x60;GET /flash_swap/currencies&#x60; (optional)
         * @return APIlistFlashSwapOrdersRequest
         */
        public APIlistFlashSwapOrdersRequest sellCurrency(String sellCurrency) {
            this.sellCurrency = sellCurrency;
            return this;
        }

        /**
         * Set buyCurrency
         * @param buyCurrency Currency to buy which can be retrieved from supported currency list API &#x60;GET /flash_swap/currencies&#x60; (optional)
         * @return APIlistFlashSwapOrdersRequest
         */
        public APIlistFlashSwapOrdersRequest buyCurrency(String buyCurrency) {
            this.buyCurrency = buyCurrency;
            return this;
        }

        /**
         * Set reverse
         * @param reverse If results are sorted by id in reverse order. Default to &#x60;true&#x60;  - &#x60;true&#x60;: sort by id in descending order(recent first) - &#x60;false&#x60;: sort by id in ascending order(oldest first) (optional)
         * @return APIlistFlashSwapOrdersRequest
         */
        public APIlistFlashSwapOrdersRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        /**
         * Set limit
         * @param limit Maximum number of records to be returned in a single list (optional, default to 100)
         * @return APIlistFlashSwapOrdersRequest
         */
        public APIlistFlashSwapOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set page
         * @param page Page number (optional, default to 1)
         * @return APIlistFlashSwapOrdersRequest
         */
        public APIlistFlashSwapOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Build call for listFlashSwapOrders
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listFlashSwapOrdersCall(status, sellCurrency, buyCurrency, reverse, limit, page, _callback);
        }

        /**
         * Execute listFlashSwapOrders request
         * @return List&lt;FlashSwapOrder&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public List<FlashSwapOrder> execute() throws ApiException {
            ApiResponse<List<FlashSwapOrder>> localVarResp = listFlashSwapOrdersWithHttpInfo(status, sellCurrency, buyCurrency, reverse, limit, page);
            return localVarResp.getData();
        }

        /**
         * Execute listFlashSwapOrders request with HTTP info returned
         * @return ApiResponse&lt;List&lt;FlashSwapOrder&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<FlashSwapOrder>> executeWithHttpInfo() throws ApiException {
            return listFlashSwapOrdersWithHttpInfo(status, sellCurrency, buyCurrency, reverse, limit, page);
        }

        /**
         * Execute listFlashSwapOrders request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<FlashSwapOrder>> _callback) throws ApiException {
            return listFlashSwapOrdersAsync(status, sellCurrency, buyCurrency, reverse, limit, page, _callback);
        }
    }

    /**
     * List all flash swap orders
     * 
     * @return APIlistFlashSwapOrdersRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List retrieved </td><td>  -  </td></tr>
     </table>
     */
    public APIlistFlashSwapOrdersRequest listFlashSwapOrders() {
        return new APIlistFlashSwapOrdersRequest();
    }

    /**
     * Build call for createFlashSwapOrder
     * @param flashSwapOrderRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The flash swap order is created successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createFlashSwapOrderCall(FlashSwapOrderRequest flashSwapOrderRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = flashSwapOrderRequest;

        // create path and map variables
        String localVarPath = "/flash_swap/orders";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createFlashSwapOrderValidateBeforeCall(FlashSwapOrderRequest flashSwapOrderRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'flashSwapOrderRequest' is set
        if (flashSwapOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'flashSwapOrderRequest' when calling createFlashSwapOrder(Async)");
        }

        okhttp3.Call localVarCall = createFlashSwapOrderCall(flashSwapOrderRequest, _callback);
        return localVarCall;
    }

    /**
     * Create a flash swap order
     * Initiate a flash swap preview in advance because order creation requires a preview result
     * @param flashSwapOrderRequest  (required)
     * @return FlashSwapOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The flash swap order is created successfully </td><td>  -  </td></tr>
     </table>
     */
    public FlashSwapOrder createFlashSwapOrder(FlashSwapOrderRequest flashSwapOrderRequest) throws ApiException {
        ApiResponse<FlashSwapOrder> localVarResp = createFlashSwapOrderWithHttpInfo(flashSwapOrderRequest);
        return localVarResp.getData();
    }

    /**
     * Create a flash swap order
     * Initiate a flash swap preview in advance because order creation requires a preview result
     * @param flashSwapOrderRequest  (required)
     * @return ApiResponse&lt;FlashSwapOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The flash swap order is created successfully </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FlashSwapOrder> createFlashSwapOrderWithHttpInfo(FlashSwapOrderRequest flashSwapOrderRequest) throws ApiException {
        okhttp3.Call localVarCall = createFlashSwapOrderValidateBeforeCall(flashSwapOrderRequest, null);
        Type localVarReturnType = new TypeToken<FlashSwapOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a flash swap order (asynchronously)
     * Initiate a flash swap preview in advance because order creation requires a preview result
     * @param flashSwapOrderRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The flash swap order is created successfully </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createFlashSwapOrderAsync(FlashSwapOrderRequest flashSwapOrderRequest, final ApiCallback<FlashSwapOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = createFlashSwapOrderValidateBeforeCall(flashSwapOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<FlashSwapOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for getFlashSwapOrder
     * @param orderId Flash swap order ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFlashSwapOrderCall(Integer orderId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flash_swap/orders/{order_id}"
            .replaceAll("\\{" + "order_id" + "\\}", localVarApiClient.escapeString(orderId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFlashSwapOrderValidateBeforeCall(Integer orderId, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'orderId' is set
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getFlashSwapOrder(Async)");
        }

        okhttp3.Call localVarCall = getFlashSwapOrderCall(orderId, _callback);
        return localVarCall;
    }

    /**
     * Get a single flash swap order&#39;s detail
     * 
     * @param orderId Flash swap order ID (required)
     * @return FlashSwapOrder
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public FlashSwapOrder getFlashSwapOrder(Integer orderId) throws ApiException {
        ApiResponse<FlashSwapOrder> localVarResp = getFlashSwapOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    /**
     * Get a single flash swap order&#39;s detail
     * 
     * @param orderId Flash swap order ID (required)
     * @return ApiResponse&lt;FlashSwapOrder&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FlashSwapOrder> getFlashSwapOrderWithHttpInfo(Integer orderId) throws ApiException {
        okhttp3.Call localVarCall = getFlashSwapOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<FlashSwapOrder>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a single flash swap order&#39;s detail (asynchronously)
     * 
     * @param orderId Flash swap order ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFlashSwapOrderAsync(Integer orderId, final ApiCallback<FlashSwapOrder> _callback) throws ApiException {
        okhttp3.Call localVarCall = getFlashSwapOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<FlashSwapOrder>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    /**
     * Build call for previewFlashSwapOrder
     * @param flashSwapOrderRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The flash swap order successfully previewed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call previewFlashSwapOrderCall(FlashSwapOrderRequest flashSwapOrderRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = flashSwapOrderRequest;

        // create path and map variables
        String localVarPath = "/flash_swap/orders/preview";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "apiv4" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call previewFlashSwapOrderValidateBeforeCall(FlashSwapOrderRequest flashSwapOrderRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'flashSwapOrderRequest' is set
        if (flashSwapOrderRequest == null) {
            throw new ApiException("Missing the required parameter 'flashSwapOrderRequest' when calling previewFlashSwapOrder(Async)");
        }

        okhttp3.Call localVarCall = previewFlashSwapOrderCall(flashSwapOrderRequest, _callback);
        return localVarCall;
    }

    /**
     * Initiate a flash swap order preview
     * 
     * @param flashSwapOrderRequest  (required)
     * @return FlashSwapOrderPreview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The flash swap order successfully previewed </td><td>  -  </td></tr>
     </table>
     */
    public FlashSwapOrderPreview previewFlashSwapOrder(FlashSwapOrderRequest flashSwapOrderRequest) throws ApiException {
        ApiResponse<FlashSwapOrderPreview> localVarResp = previewFlashSwapOrderWithHttpInfo(flashSwapOrderRequest);
        return localVarResp.getData();
    }

    /**
     * Initiate a flash swap order preview
     * 
     * @param flashSwapOrderRequest  (required)
     * @return ApiResponse&lt;FlashSwapOrderPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The flash swap order successfully previewed </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FlashSwapOrderPreview> previewFlashSwapOrderWithHttpInfo(FlashSwapOrderRequest flashSwapOrderRequest) throws ApiException {
        okhttp3.Call localVarCall = previewFlashSwapOrderValidateBeforeCall(flashSwapOrderRequest, null);
        Type localVarReturnType = new TypeToken<FlashSwapOrderPreview>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Initiate a flash swap order preview (asynchronously)
     * 
     * @param flashSwapOrderRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The flash swap order successfully previewed </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call previewFlashSwapOrderAsync(FlashSwapOrderRequest flashSwapOrderRequest, final ApiCallback<FlashSwapOrderPreview> _callback) throws ApiException {
        okhttp3.Call localVarCall = previewFlashSwapOrderValidateBeforeCall(flashSwapOrderRequest, _callback);
        Type localVarReturnType = new TypeToken<FlashSwapOrderPreview>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

}
