/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.Contract;
import io.gate.gateapi.models.ContractStat;
import io.gate.gateapi.models.FundingRateRecord;
import io.gate.gateapi.models.FuturesAccount;
import io.gate.gateapi.models.FuturesAccountBook;
import io.gate.gateapi.models.FuturesCandlestick;
import io.gate.gateapi.models.FuturesLiquidate;
import io.gate.gateapi.models.FuturesOrder;
import io.gate.gateapi.models.FuturesOrderBook;
import io.gate.gateapi.models.FuturesPriceTriggeredOrder;
import io.gate.gateapi.models.FuturesTicker;
import io.gate.gateapi.models.FuturesTrade;
import io.gate.gateapi.models.InsuranceRecord;
import io.gate.gateapi.models.MyFuturesTrade;
import io.gate.gateapi.models.Position;
import io.gate.gateapi.models.PositionClose;
import io.gate.gateapi.models.TriggerOrderResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class FuturesApi {
    private ApiClient localVarApiClient;

    public FuturesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FuturesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listFuturesContractsCall(String settle, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/contracts".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesContractsValidateBeforeCall(String settle, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesContracts(Async)");
        }
        Call localVarCall = this.listFuturesContractsCall(settle, _callback);
        return localVarCall;
    }

    public List<Contract> listFuturesContracts(String settle) throws ApiException {
        ApiResponse<List<Contract>> localVarResp = this.listFuturesContractsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    public ApiResponse<List<Contract>> listFuturesContractsWithHttpInfo(String settle) throws ApiException {
        Call localVarCall = this.listFuturesContractsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<List<Contract>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFuturesContractsAsync(String settle, ApiCallback<List<Contract>> _callback) throws ApiException {
        Call localVarCall = this.listFuturesContractsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<List<Contract>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFuturesContractCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/contracts/{contract}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFuturesContractValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getFuturesContract(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getFuturesContract(Async)");
        }
        Call localVarCall = this.getFuturesContractCall(settle, contract, _callback);
        return localVarCall;
    }

    public Contract getFuturesContract(String settle, String contract) throws ApiException {
        ApiResponse<Contract> localVarResp = this.getFuturesContractWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    public ApiResponse<Contract> getFuturesContractWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.getFuturesContractValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<Contract>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFuturesContractAsync(String settle, String contract, ApiCallback<Contract> _callback) throws ApiException {
        Call localVarCall = this.getFuturesContractValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<Contract>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listFuturesOrderBookCall(String settle, String contract, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/order_book".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (withId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("with_id", withId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesOrderBookValidateBeforeCall(String settle, String contract, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesOrderBook(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesOrderBook(Async)");
        }
        Call localVarCall = this.listFuturesOrderBookCall(settle, contract, interval, limit, withId, _callback);
        return localVarCall;
    }

    private ApiResponse<FuturesOrderBook> listFuturesOrderBookWithHttpInfo(String settle, String contract, String interval, Integer limit, Boolean withId) throws ApiException {
        Call localVarCall = this.listFuturesOrderBookValidateBeforeCall(settle, contract, interval, limit, withId, null);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFuturesOrderBookAsync(String settle, String contract, String interval, Integer limit, Boolean withId, ApiCallback<FuturesOrderBook> _callback) throws ApiException {
        Call localVarCall = this.listFuturesOrderBookValidateBeforeCall(settle, contract, interval, limit, withId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFuturesOrderBookRequest listFuturesOrderBook(String settle, String contract) {
        return new APIlistFuturesOrderBookRequest(settle, contract);
    }

    private Call listFuturesTradesCall(String settle, String contract, Integer limit, String lastId, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/trades".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (lastId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("last_id", lastId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesTradesValidateBeforeCall(String settle, String contract, Integer limit, String lastId, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesTrades(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesTrades(Async)");
        }
        Call localVarCall = this.listFuturesTradesCall(settle, contract, limit, lastId, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesTrade>> listFuturesTradesWithHttpInfo(String settle, String contract, Integer limit, String lastId, Long from, Long to) throws ApiException {
        Call localVarCall = this.listFuturesTradesValidateBeforeCall(settle, contract, limit, lastId, from, to, null);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFuturesTradesAsync(String settle, String contract, Integer limit, String lastId, Long from, Long to, ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
        Call localVarCall = this.listFuturesTradesValidateBeforeCall(settle, contract, limit, lastId, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFuturesTradesRequest listFuturesTrades(String settle, String contract) {
        return new APIlistFuturesTradesRequest(settle, contract);
    }

    private Call listFuturesCandlesticksCall(String settle, String contract, Long from, Long to, Integer limit, String interval, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/candlesticks".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesCandlesticksValidateBeforeCall(String settle, String contract, Long from, Long to, Integer limit, String interval, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesCandlesticks(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesCandlesticks(Async)");
        }
        Call localVarCall = this.listFuturesCandlesticksCall(settle, contract, from, to, limit, interval, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesCandlestick>> listFuturesCandlesticksWithHttpInfo(String settle, String contract, Long from, Long to, Integer limit, String interval) throws ApiException {
        Call localVarCall = this.listFuturesCandlesticksValidateBeforeCall(settle, contract, from, to, limit, interval, null);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFuturesCandlesticksAsync(String settle, String contract, Long from, Long to, Integer limit, String interval, ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
        Call localVarCall = this.listFuturesCandlesticksValidateBeforeCall(settle, contract, from, to, limit, interval, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFuturesCandlesticksRequest listFuturesCandlesticks(String settle, String contract) {
        return new APIlistFuturesCandlesticksRequest(settle, contract);
    }

    private Call listFuturesTickersCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/tickers".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesTickersValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesTickers(Async)");
        }
        Call localVarCall = this.listFuturesTickersCall(settle, contract, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesTicker>> listFuturesTickersWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.listFuturesTickersValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<List<FuturesTicker>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFuturesTickersAsync(String settle, String contract, ApiCallback<List<FuturesTicker>> _callback) throws ApiException {
        Call localVarCall = this.listFuturesTickersValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesTicker>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFuturesTickersRequest listFuturesTickers(String settle) {
        return new APIlistFuturesTickersRequest(settle);
    }

    private Call listFuturesFundingRateHistoryCall(String settle, String contract, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/funding_rate".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesFundingRateHistoryValidateBeforeCall(String settle, String contract, Integer limit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesFundingRateHistory(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesFundingRateHistory(Async)");
        }
        Call localVarCall = this.listFuturesFundingRateHistoryCall(settle, contract, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FundingRateRecord>> listFuturesFundingRateHistoryWithHttpInfo(String settle, String contract, Integer limit) throws ApiException {
        Call localVarCall = this.listFuturesFundingRateHistoryValidateBeforeCall(settle, contract, limit, null);
        Type localVarReturnType = new TypeToken<List<FundingRateRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFuturesFundingRateHistoryAsync(String settle, String contract, Integer limit, ApiCallback<List<FundingRateRecord>> _callback) throws ApiException {
        Call localVarCall = this.listFuturesFundingRateHistoryValidateBeforeCall(settle, contract, limit, _callback);
        Type localVarReturnType = new TypeToken<List<FundingRateRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFuturesFundingRateHistoryRequest listFuturesFundingRateHistory(String settle, String contract) {
        return new APIlistFuturesFundingRateHistoryRequest(settle, contract);
    }

    private Call listFuturesInsuranceLedgerCall(String settle, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/insurance".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesInsuranceLedgerValidateBeforeCall(String settle, Integer limit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesInsuranceLedger(Async)");
        }
        Call localVarCall = this.listFuturesInsuranceLedgerCall(settle, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<InsuranceRecord>> listFuturesInsuranceLedgerWithHttpInfo(String settle, Integer limit) throws ApiException {
        Call localVarCall = this.listFuturesInsuranceLedgerValidateBeforeCall(settle, limit, null);
        Type localVarReturnType = new TypeToken<List<InsuranceRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFuturesInsuranceLedgerAsync(String settle, Integer limit, ApiCallback<List<InsuranceRecord>> _callback) throws ApiException {
        Call localVarCall = this.listFuturesInsuranceLedgerValidateBeforeCall(settle, limit, _callback);
        Type localVarReturnType = new TypeToken<List<InsuranceRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFuturesInsuranceLedgerRequest listFuturesInsuranceLedger(String settle) {
        return new APIlistFuturesInsuranceLedgerRequest(settle);
    }

    private Call listContractStatsCall(String settle, String contract, Long from, String interval, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/contract_stats".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listContractStatsValidateBeforeCall(String settle, String contract, Long from, String interval, Integer limit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listContractStats(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listContractStats(Async)");
        }
        Call localVarCall = this.listContractStatsCall(settle, contract, from, interval, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<ContractStat>> listContractStatsWithHttpInfo(String settle, String contract, Long from, String interval, Integer limit) throws ApiException {
        Call localVarCall = this.listContractStatsValidateBeforeCall(settle, contract, from, interval, limit, null);
        Type localVarReturnType = new TypeToken<List<ContractStat>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listContractStatsAsync(String settle, String contract, Long from, String interval, Integer limit, ApiCallback<List<ContractStat>> _callback) throws ApiException {
        Call localVarCall = this.listContractStatsValidateBeforeCall(settle, contract, from, interval, limit, _callback);
        Type localVarReturnType = new TypeToken<List<ContractStat>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistContractStatsRequest listContractStats(String settle, String contract) {
        return new APIlistContractStatsRequest(settle, contract);
    }

    private Call listLiquidatedOrdersCall(String settle, String contract, Long from, Long to, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/liq_orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listLiquidatedOrdersValidateBeforeCall(String settle, String contract, Long from, Long to, Integer limit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listLiquidatedOrders(Async)");
        }
        Call localVarCall = this.listLiquidatedOrdersCall(settle, contract, from, to, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesLiquidate>> listLiquidatedOrdersWithHttpInfo(String settle, String contract, Long from, Long to, Integer limit) throws ApiException {
        Call localVarCall = this.listLiquidatedOrdersValidateBeforeCall(settle, contract, from, to, limit, null);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listLiquidatedOrdersAsync(String settle, String contract, Long from, Long to, Integer limit, ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
        Call localVarCall = this.listLiquidatedOrdersValidateBeforeCall(settle, contract, from, to, limit, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistLiquidatedOrdersRequest listLiquidatedOrders(String settle) {
        return new APIlistLiquidatedOrdersRequest(settle);
    }

    public Call listFuturesAccountsCall(String settle, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/accounts".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesAccountsValidateBeforeCall(String settle, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesAccounts(Async)");
        }
        Call localVarCall = this.listFuturesAccountsCall(settle, _callback);
        return localVarCall;
    }

    public FuturesAccount listFuturesAccounts(String settle) throws ApiException {
        ApiResponse<FuturesAccount> localVarResp = this.listFuturesAccountsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesAccount> listFuturesAccountsWithHttpInfo(String settle) throws ApiException {
        Call localVarCall = this.listFuturesAccountsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listFuturesAccountsAsync(String settle, ApiCallback<FuturesAccount> _callback) throws ApiException {
        Call localVarCall = this.listFuturesAccountsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listFuturesAccountBookCall(String settle, Integer limit, Long from, Long to, String type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/account_book".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesAccountBookValidateBeforeCall(String settle, Integer limit, Long from, Long to, String type, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesAccountBook(Async)");
        }
        Call localVarCall = this.listFuturesAccountBookCall(settle, limit, from, to, type, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesAccountBook>> listFuturesAccountBookWithHttpInfo(String settle, Integer limit, Long from, Long to, String type) throws ApiException {
        Call localVarCall = this.listFuturesAccountBookValidateBeforeCall(settle, limit, from, to, type, null);
        Type localVarReturnType = new TypeToken<List<FuturesAccountBook>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFuturesAccountBookAsync(String settle, Integer limit, Long from, Long to, String type, ApiCallback<List<FuturesAccountBook>> _callback) throws ApiException {
        Call localVarCall = this.listFuturesAccountBookValidateBeforeCall(settle, limit, from, to, type, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesAccountBook>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFuturesAccountBookRequest listFuturesAccountBook(String settle) {
        return new APIlistFuturesAccountBookRequest(settle);
    }

    public Call listPositionsCall(String settle, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/positions".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPositionsValidateBeforeCall(String settle, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listPositions(Async)");
        }
        Call localVarCall = this.listPositionsCall(settle, _callback);
        return localVarCall;
    }

    public List<Position> listPositions(String settle) throws ApiException {
        ApiResponse<List<Position>> localVarResp = this.listPositionsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    public ApiResponse<List<Position>> listPositionsWithHttpInfo(String settle) throws ApiException {
        Call localVarCall = this.listPositionsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listPositionsAsync(String settle, ApiCallback<List<Position>> _callback) throws ApiException {
        Call localVarCall = this.listPositionsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPositionCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/positions/{contract}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPositionValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getPosition(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getPosition(Async)");
        }
        Call localVarCall = this.getPositionCall(settle, contract, _callback);
        return localVarCall;
    }

    public Position getPosition(String settle, String contract) throws ApiException {
        ApiResponse<Position> localVarResp = this.getPositionWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    public ApiResponse<Position> getPositionWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.getPositionValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPositionAsync(String settle, String contract, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.getPositionValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updatePositionMarginCall(String settle, String contract, String change, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/positions/{contract}/margin".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (change != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("change", change));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePositionMarginValidateBeforeCall(String settle, String contract, String change, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updatePositionMargin(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updatePositionMargin(Async)");
        }
        if (change == null) {
            throw new ApiException("Missing the required parameter 'change' when calling updatePositionMargin(Async)");
        }
        Call localVarCall = this.updatePositionMarginCall(settle, contract, change, _callback);
        return localVarCall;
    }

    public Position updatePositionMargin(String settle, String contract, String change) throws ApiException {
        ApiResponse<Position> localVarResp = this.updatePositionMarginWithHttpInfo(settle, contract, change);
        return localVarResp.getData();
    }

    public ApiResponse<Position> updatePositionMarginWithHttpInfo(String settle, String contract, String change) throws ApiException {
        Call localVarCall = this.updatePositionMarginValidateBeforeCall(settle, contract, change, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updatePositionMarginAsync(String settle, String contract, String change, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.updatePositionMarginValidateBeforeCall(settle, contract, change, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updatePositionLeverageCall(String settle, String contract, String leverage, String crossLeverageLimit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/positions/{contract}/leverage".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (leverage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("leverage", leverage));
        }
        if (crossLeverageLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cross_leverage_limit", crossLeverageLimit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePositionLeverageValidateBeforeCall(String settle, String contract, String leverage, String crossLeverageLimit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updatePositionLeverage(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updatePositionLeverage(Async)");
        }
        if (leverage == null) {
            throw new ApiException("Missing the required parameter 'leverage' when calling updatePositionLeverage(Async)");
        }
        Call localVarCall = this.updatePositionLeverageCall(settle, contract, leverage, crossLeverageLimit, _callback);
        return localVarCall;
    }

    public Position updatePositionLeverage(String settle, String contract, String leverage, String crossLeverageLimit) throws ApiException {
        ApiResponse<Position> localVarResp = this.updatePositionLeverageWithHttpInfo(settle, contract, leverage, crossLeverageLimit);
        return localVarResp.getData();
    }

    public ApiResponse<Position> updatePositionLeverageWithHttpInfo(String settle, String contract, String leverage, String crossLeverageLimit) throws ApiException {
        Call localVarCall = this.updatePositionLeverageValidateBeforeCall(settle, contract, leverage, crossLeverageLimit, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updatePositionLeverageAsync(String settle, String contract, String leverage, String crossLeverageLimit, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.updatePositionLeverageValidateBeforeCall(settle, contract, leverage, crossLeverageLimit, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updatePositionRiskLimitCall(String settle, String contract, String riskLimit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/positions/{contract}/risk_limit".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (riskLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("risk_limit", riskLimit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updatePositionRiskLimitValidateBeforeCall(String settle, String contract, String riskLimit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updatePositionRiskLimit(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updatePositionRiskLimit(Async)");
        }
        if (riskLimit == null) {
            throw new ApiException("Missing the required parameter 'riskLimit' when calling updatePositionRiskLimit(Async)");
        }
        Call localVarCall = this.updatePositionRiskLimitCall(settle, contract, riskLimit, _callback);
        return localVarCall;
    }

    public Position updatePositionRiskLimit(String settle, String contract, String riskLimit) throws ApiException {
        ApiResponse<Position> localVarResp = this.updatePositionRiskLimitWithHttpInfo(settle, contract, riskLimit);
        return localVarResp.getData();
    }

    public ApiResponse<Position> updatePositionRiskLimitWithHttpInfo(String settle, String contract, String riskLimit) throws ApiException {
        Call localVarCall = this.updatePositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updatePositionRiskLimitAsync(String settle, String contract, String riskLimit, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.updatePositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setDualModeCall(String settle, Boolean dualMode, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/dual_mode".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (dualMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dual_mode", dualMode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setDualModeValidateBeforeCall(String settle, Boolean dualMode, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling setDualMode(Async)");
        }
        if (dualMode == null) {
            throw new ApiException("Missing the required parameter 'dualMode' when calling setDualMode(Async)");
        }
        Call localVarCall = this.setDualModeCall(settle, dualMode, _callback);
        return localVarCall;
    }

    public FuturesAccount setDualMode(String settle, Boolean dualMode) throws ApiException {
        ApiResponse<FuturesAccount> localVarResp = this.setDualModeWithHttpInfo(settle, dualMode);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesAccount> setDualModeWithHttpInfo(String settle, Boolean dualMode) throws ApiException {
        Call localVarCall = this.setDualModeValidateBeforeCall(settle, dualMode, null);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setDualModeAsync(String settle, Boolean dualMode, ApiCallback<FuturesAccount> _callback) throws ApiException {
        Call localVarCall = this.setDualModeValidateBeforeCall(settle, dualMode, _callback);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDualModePositionCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/dual_comp/positions/{contract}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDualModePositionValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getDualModePosition(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getDualModePosition(Async)");
        }
        Call localVarCall = this.getDualModePositionCall(settle, contract, _callback);
        return localVarCall;
    }

    public List<Position> getDualModePosition(String settle, String contract) throws ApiException {
        ApiResponse<List<Position>> localVarResp = this.getDualModePositionWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    public ApiResponse<List<Position>> getDualModePositionWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.getDualModePositionValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDualModePositionAsync(String settle, String contract, ApiCallback<List<Position>> _callback) throws ApiException {
        Call localVarCall = this.getDualModePositionValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDualModePositionMarginCall(String settle, String contract, String change, String dualSide, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/dual_comp/positions/{contract}/margin".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (change != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("change", change));
        }
        if (dualSide != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dual_side", dualSide));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDualModePositionMarginValidateBeforeCall(String settle, String contract, String change, String dualSide, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDualModePositionMargin(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDualModePositionMargin(Async)");
        }
        if (change == null) {
            throw new ApiException("Missing the required parameter 'change' when calling updateDualModePositionMargin(Async)");
        }
        if (dualSide == null) {
            throw new ApiException("Missing the required parameter 'dualSide' when calling updateDualModePositionMargin(Async)");
        }
        Call localVarCall = this.updateDualModePositionMarginCall(settle, contract, change, dualSide, _callback);
        return localVarCall;
    }

    public List<Position> updateDualModePositionMargin(String settle, String contract, String change, String dualSide) throws ApiException {
        ApiResponse<List<Position>> localVarResp = this.updateDualModePositionMarginWithHttpInfo(settle, contract, change, dualSide);
        return localVarResp.getData();
    }

    public ApiResponse<List<Position>> updateDualModePositionMarginWithHttpInfo(String settle, String contract, String change, String dualSide) throws ApiException {
        Call localVarCall = this.updateDualModePositionMarginValidateBeforeCall(settle, contract, change, dualSide, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDualModePositionMarginAsync(String settle, String contract, String change, String dualSide, ApiCallback<List<Position>> _callback) throws ApiException {
        Call localVarCall = this.updateDualModePositionMarginValidateBeforeCall(settle, contract, change, dualSide, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDualModePositionLeverageCall(String settle, String contract, String leverage, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/dual_comp/positions/{contract}/leverage".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (leverage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("leverage", leverage));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDualModePositionLeverageValidateBeforeCall(String settle, String contract, String leverage, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDualModePositionLeverage(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDualModePositionLeverage(Async)");
        }
        if (leverage == null) {
            throw new ApiException("Missing the required parameter 'leverage' when calling updateDualModePositionLeverage(Async)");
        }
        Call localVarCall = this.updateDualModePositionLeverageCall(settle, contract, leverage, _callback);
        return localVarCall;
    }

    public List<Position> updateDualModePositionLeverage(String settle, String contract, String leverage) throws ApiException {
        ApiResponse<List<Position>> localVarResp = this.updateDualModePositionLeverageWithHttpInfo(settle, contract, leverage);
        return localVarResp.getData();
    }

    public ApiResponse<List<Position>> updateDualModePositionLeverageWithHttpInfo(String settle, String contract, String leverage) throws ApiException {
        Call localVarCall = this.updateDualModePositionLeverageValidateBeforeCall(settle, contract, leverage, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDualModePositionLeverageAsync(String settle, String contract, String leverage, ApiCallback<List<Position>> _callback) throws ApiException {
        Call localVarCall = this.updateDualModePositionLeverageValidateBeforeCall(settle, contract, leverage, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDualModePositionRiskLimitCall(String settle, String contract, String riskLimit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/dual_comp/positions/{contract}/risk_limit".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (riskLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("risk_limit", riskLimit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDualModePositionRiskLimitValidateBeforeCall(String settle, String contract, String riskLimit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDualModePositionRiskLimit(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDualModePositionRiskLimit(Async)");
        }
        if (riskLimit == null) {
            throw new ApiException("Missing the required parameter 'riskLimit' when calling updateDualModePositionRiskLimit(Async)");
        }
        Call localVarCall = this.updateDualModePositionRiskLimitCall(settle, contract, riskLimit, _callback);
        return localVarCall;
    }

    public List<Position> updateDualModePositionRiskLimit(String settle, String contract, String riskLimit) throws ApiException {
        ApiResponse<List<Position>> localVarResp = this.updateDualModePositionRiskLimitWithHttpInfo(settle, contract, riskLimit);
        return localVarResp.getData();
    }

    public ApiResponse<List<Position>> updateDualModePositionRiskLimitWithHttpInfo(String settle, String contract, String riskLimit) throws ApiException {
        Call localVarCall = this.updateDualModePositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDualModePositionRiskLimitAsync(String settle, String contract, String riskLimit, ApiCallback<List<Position>> _callback) throws ApiException {
        Call localVarCall = this.updateDualModePositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listFuturesOrdersCall(String settle, String contract, String status, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (lastId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("last_id", lastId));
        }
        if (countTotal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count_total", countTotal));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listFuturesOrdersValidateBeforeCall(String settle, String contract, String status, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listFuturesOrders(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listFuturesOrders(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listFuturesOrders(Async)");
        }
        Call localVarCall = this.listFuturesOrdersCall(settle, contract, status, limit, offset, lastId, countTotal, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesOrder>> listFuturesOrdersWithHttpInfo(String settle, String contract, String status, Integer limit, Integer offset, String lastId, Integer countTotal) throws ApiException {
        Call localVarCall = this.listFuturesOrdersValidateBeforeCall(settle, contract, status, limit, offset, lastId, countTotal, null);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listFuturesOrdersAsync(String settle, String contract, String status, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
        Call localVarCall = this.listFuturesOrdersValidateBeforeCall(settle, contract, status, limit, offset, lastId, countTotal, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistFuturesOrdersRequest listFuturesOrders(String settle, String contract, String status) {
        return new APIlistFuturesOrdersRequest(settle, contract, status);
    }

    public Call createFuturesOrderCall(String settle, FuturesOrder futuresOrder, ApiCallback _callback) throws ApiException {
        FuturesOrder localVarPostBody = futuresOrder;
        String localVarPath = "/futures/{settle}/orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFuturesOrderValidateBeforeCall(String settle, FuturesOrder futuresOrder, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling createFuturesOrder(Async)");
        }
        if (futuresOrder == null) {
            throw new ApiException("Missing the required parameter 'futuresOrder' when calling createFuturesOrder(Async)");
        }
        Call localVarCall = this.createFuturesOrderCall(settle, futuresOrder, _callback);
        return localVarCall;
    }

    public FuturesOrder createFuturesOrder(String settle, FuturesOrder futuresOrder) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = this.createFuturesOrderWithHttpInfo(settle, futuresOrder);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesOrder> createFuturesOrderWithHttpInfo(String settle, FuturesOrder futuresOrder) throws ApiException {
        Call localVarCall = this.createFuturesOrderValidateBeforeCall(settle, futuresOrder, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createFuturesOrderAsync(String settle, FuturesOrder futuresOrder, ApiCallback<FuturesOrder> _callback) throws ApiException {
        Call localVarCall = this.createFuturesOrderValidateBeforeCall(settle, futuresOrder, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelFuturesOrdersCall(String settle, String contract, String side, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelFuturesOrdersValidateBeforeCall(String settle, String contract, String side, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelFuturesOrders(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling cancelFuturesOrders(Async)");
        }
        Call localVarCall = this.cancelFuturesOrdersCall(settle, contract, side, _callback);
        return localVarCall;
    }

    public List<FuturesOrder> cancelFuturesOrders(String settle, String contract, String side) throws ApiException {
        ApiResponse<List<FuturesOrder>> localVarResp = this.cancelFuturesOrdersWithHttpInfo(settle, contract, side);
        return localVarResp.getData();
    }

    public ApiResponse<List<FuturesOrder>> cancelFuturesOrdersWithHttpInfo(String settle, String contract, String side) throws ApiException {
        Call localVarCall = this.cancelFuturesOrdersValidateBeforeCall(settle, contract, side, null);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelFuturesOrdersAsync(String settle, String contract, String side, ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
        Call localVarCall = this.cancelFuturesOrdersValidateBeforeCall(settle, contract, side, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFuturesOrderCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/orders/{order_id}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFuturesOrderValidateBeforeCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getFuturesOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getFuturesOrder(Async)");
        }
        Call localVarCall = this.getFuturesOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    public FuturesOrder getFuturesOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = this.getFuturesOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesOrder> getFuturesOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        Call localVarCall = this.getFuturesOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFuturesOrderAsync(String settle, String orderId, ApiCallback<FuturesOrder> _callback) throws ApiException {
        Call localVarCall = this.getFuturesOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelFuturesOrderCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/orders/{order_id}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelFuturesOrderValidateBeforeCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelFuturesOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelFuturesOrder(Async)");
        }
        Call localVarCall = this.cancelFuturesOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    public FuturesOrder cancelFuturesOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = this.cancelFuturesOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesOrder> cancelFuturesOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        Call localVarCall = this.cancelFuturesOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelFuturesOrderAsync(String settle, String orderId, ApiCallback<FuturesOrder> _callback) throws ApiException {
        Call localVarCall = this.cancelFuturesOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getMyTradesCall(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/my_trades".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", order));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (lastId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("last_id", lastId));
        }
        if (countTotal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count_total", countTotal));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMyTradesValidateBeforeCall(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getMyTrades(Async)");
        }
        Call localVarCall = this.getMyTradesCall(settle, contract, order, limit, offset, lastId, countTotal, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MyFuturesTrade>> getMyTradesWithHttpInfo(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal) throws ApiException {
        Call localVarCall = this.getMyTradesValidateBeforeCall(settle, contract, order, limit, offset, lastId, countTotal, null);
        Type localVarReturnType = new TypeToken<List<MyFuturesTrade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMyTradesAsync(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback<List<MyFuturesTrade>> _callback) throws ApiException {
        Call localVarCall = this.getMyTradesValidateBeforeCall(settle, contract, order, limit, offset, lastId, countTotal, _callback);
        Type localVarReturnType = new TypeToken<List<MyFuturesTrade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMyTradesRequest getMyTrades(String settle) {
        return new APIgetMyTradesRequest(settle);
    }

    private Call listPositionCloseCall(String settle, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/position_close".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPositionCloseValidateBeforeCall(String settle, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listPositionClose(Async)");
        }
        Call localVarCall = this.listPositionCloseCall(settle, contract, limit, offset, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<PositionClose>> listPositionCloseWithHttpInfo(String settle, String contract, Integer limit, Integer offset, Long from, Long to) throws ApiException {
        Call localVarCall = this.listPositionCloseValidateBeforeCall(settle, contract, limit, offset, from, to, null);
        Type localVarReturnType = new TypeToken<List<PositionClose>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listPositionCloseAsync(String settle, String contract, Integer limit, Integer offset, Long from, Long to, ApiCallback<List<PositionClose>> _callback) throws ApiException {
        Call localVarCall = this.listPositionCloseValidateBeforeCall(settle, contract, limit, offset, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<PositionClose>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistPositionCloseRequest listPositionClose(String settle) {
        return new APIlistPositionCloseRequest(settle);
    }

    private Call listLiquidatesCall(String settle, String contract, Integer limit, Integer at, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/liquidates".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (at != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("at", at));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listLiquidatesValidateBeforeCall(String settle, String contract, Integer limit, Integer at, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listLiquidates(Async)");
        }
        Call localVarCall = this.listLiquidatesCall(settle, contract, limit, at, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesLiquidate>> listLiquidatesWithHttpInfo(String settle, String contract, Integer limit, Integer at) throws ApiException {
        Call localVarCall = this.listLiquidatesValidateBeforeCall(settle, contract, limit, at, null);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listLiquidatesAsync(String settle, String contract, Integer limit, Integer at, ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
        Call localVarCall = this.listLiquidatesValidateBeforeCall(settle, contract, limit, at, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistLiquidatesRequest listLiquidates(String settle) {
        return new APIlistLiquidatesRequest(settle);
    }

    private Call listPriceTriggeredOrdersCall(String settle, String status, String contract, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/price_orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPriceTriggeredOrdersValidateBeforeCall(String settle, String status, String contract, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listPriceTriggeredOrders(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listPriceTriggeredOrders(Async)");
        }
        Call localVarCall = this.listPriceTriggeredOrdersCall(settle, status, contract, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesPriceTriggeredOrder>> listPriceTriggeredOrdersWithHttpInfo(String settle, String status, String contract, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listPriceTriggeredOrdersValidateBeforeCall(settle, status, contract, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listPriceTriggeredOrdersAsync(String settle, String status, String contract, Integer limit, Integer offset, ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
        Call localVarCall = this.listPriceTriggeredOrdersValidateBeforeCall(settle, status, contract, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistPriceTriggeredOrdersRequest listPriceTriggeredOrders(String settle, String status) {
        return new APIlistPriceTriggeredOrdersRequest(settle, status);
    }

    public Call createPriceTriggeredOrderCall(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, ApiCallback _callback) throws ApiException {
        FuturesPriceTriggeredOrder localVarPostBody = futuresPriceTriggeredOrder;
        String localVarPath = "/futures/{settle}/price_orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPriceTriggeredOrderValidateBeforeCall(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling createPriceTriggeredOrder(Async)");
        }
        if (futuresPriceTriggeredOrder == null) {
            throw new ApiException("Missing the required parameter 'futuresPriceTriggeredOrder' when calling createPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.createPriceTriggeredOrderCall(settle, futuresPriceTriggeredOrder, _callback);
        return localVarCall;
    }

    public TriggerOrderResponse createPriceTriggeredOrder(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder) throws ApiException {
        ApiResponse<TriggerOrderResponse> localVarResp = this.createPriceTriggeredOrderWithHttpInfo(settle, futuresPriceTriggeredOrder);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerOrderResponse> createPriceTriggeredOrderWithHttpInfo(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder) throws ApiException {
        Call localVarCall = this.createPriceTriggeredOrderValidateBeforeCall(settle, futuresPriceTriggeredOrder, null);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createPriceTriggeredOrderAsync(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, ApiCallback<TriggerOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.createPriceTriggeredOrderValidateBeforeCall(settle, futuresPriceTriggeredOrder, _callback);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelPriceTriggeredOrderListCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/price_orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPriceTriggeredOrderListValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelPriceTriggeredOrderList(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling cancelPriceTriggeredOrderList(Async)");
        }
        Call localVarCall = this.cancelPriceTriggeredOrderListCall(settle, contract, _callback);
        return localVarCall;
    }

    public List<FuturesPriceTriggeredOrder> cancelPriceTriggeredOrderList(String settle, String contract) throws ApiException {
        ApiResponse<List<FuturesPriceTriggeredOrder>> localVarResp = this.cancelPriceTriggeredOrderListWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    public ApiResponse<List<FuturesPriceTriggeredOrder>> cancelPriceTriggeredOrderListWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.cancelPriceTriggeredOrderListValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelPriceTriggeredOrderListAsync(String settle, String contract, ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
        Call localVarCall = this.cancelPriceTriggeredOrderListValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPriceTriggeredOrderCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/price_orders/{order_id}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPriceTriggeredOrderValidateBeforeCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getPriceTriggeredOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.getPriceTriggeredOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    public FuturesPriceTriggeredOrder getPriceTriggeredOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesPriceTriggeredOrder> localVarResp = this.getPriceTriggeredOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesPriceTriggeredOrder> getPriceTriggeredOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        Call localVarCall = this.getPriceTriggeredOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPriceTriggeredOrderAsync(String settle, String orderId, ApiCallback<FuturesPriceTriggeredOrder> _callback) throws ApiException {
        Call localVarCall = this.getPriceTriggeredOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelPriceTriggeredOrderCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/futures/{settle}/price_orders/{order_id}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPriceTriggeredOrderValidateBeforeCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelPriceTriggeredOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.cancelPriceTriggeredOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    public FuturesPriceTriggeredOrder cancelPriceTriggeredOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesPriceTriggeredOrder> localVarResp = this.cancelPriceTriggeredOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesPriceTriggeredOrder> cancelPriceTriggeredOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        Call localVarCall = this.cancelPriceTriggeredOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelPriceTriggeredOrderAsync(String settle, String orderId, ApiCallback<FuturesPriceTriggeredOrder> _callback) throws ApiException {
        Call localVarCall = this.cancelPriceTriggeredOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistPriceTriggeredOrdersRequest {
        private final String settle;
        private final String status;
        private String contract;
        private Integer limit;
        private Integer offset;

        private APIlistPriceTriggeredOrdersRequest(String settle, String status) {
            this.settle = settle;
            this.status = status;
        }

        public APIlistPriceTriggeredOrdersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistPriceTriggeredOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistPriceTriggeredOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listPriceTriggeredOrdersCall(this.settle, this.status, this.contract, this.limit, this.offset, _callback);
        }

        public List<FuturesPriceTriggeredOrder> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listPriceTriggeredOrdersWithHttpInfo(this.settle, this.status, this.contract, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesPriceTriggeredOrder>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listPriceTriggeredOrdersWithHttpInfo(this.settle, this.status, this.contract, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
            return FuturesApi.this.listPriceTriggeredOrdersAsync(this.settle, this.status, this.contract, this.limit, this.offset, _callback);
        }
    }

    public class APIlistLiquidatesRequest {
        private final String settle;
        private String contract;
        private Integer limit;
        private Integer at;

        private APIlistLiquidatesRequest(String settle) {
            this.settle = settle;
        }

        public APIlistLiquidatesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistLiquidatesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistLiquidatesRequest at(Integer at) {
            this.at = at;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listLiquidatesCall(this.settle, this.contract, this.limit, this.at, _callback);
        }

        public List<FuturesLiquidate> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listLiquidatesWithHttpInfo(this.settle, this.contract, this.limit, this.at);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesLiquidate>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listLiquidatesWithHttpInfo(this.settle, this.contract, this.limit, this.at);
        }

        public Call executeAsync(ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
            return FuturesApi.this.listLiquidatesAsync(this.settle, this.contract, this.limit, this.at, _callback);
        }
    }

    public class APIlistPositionCloseRequest {
        private final String settle;
        private String contract;
        private Integer limit;
        private Integer offset;
        private Long from;
        private Long to;

        private APIlistPositionCloseRequest(String settle) {
            this.settle = settle;
        }

        public APIlistPositionCloseRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistPositionCloseRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistPositionCloseRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistPositionCloseRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistPositionCloseRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listPositionCloseCall(this.settle, this.contract, this.limit, this.offset, this.from, this.to, _callback);
        }

        public List<PositionClose> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listPositionCloseWithHttpInfo(this.settle, this.contract, this.limit, this.offset, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<PositionClose>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listPositionCloseWithHttpInfo(this.settle, this.contract, this.limit, this.offset, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<PositionClose>> _callback) throws ApiException {
            return FuturesApi.this.listPositionCloseAsync(this.settle, this.contract, this.limit, this.offset, this.from, this.to, _callback);
        }
    }

    public class APIgetMyTradesRequest {
        private final String settle;
        private String contract;
        private Long order;
        private Integer limit;
        private Integer offset;
        private String lastId;
        private Integer countTotal;

        private APIgetMyTradesRequest(String settle) {
            this.settle = settle;
        }

        public APIgetMyTradesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIgetMyTradesRequest order(Long order) {
            this.order = order;
            return this;
        }

        public APIgetMyTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIgetMyTradesRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIgetMyTradesRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public APIgetMyTradesRequest countTotal(Integer countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.getMyTradesCall(this.settle, this.contract, this.order, this.limit, this.offset, this.lastId, this.countTotal, _callback);
        }

        public List<MyFuturesTrade> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.getMyTradesWithHttpInfo(this.settle, this.contract, this.order, this.limit, this.offset, this.lastId, this.countTotal);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MyFuturesTrade>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.getMyTradesWithHttpInfo(this.settle, this.contract, this.order, this.limit, this.offset, this.lastId, this.countTotal);
        }

        public Call executeAsync(ApiCallback<List<MyFuturesTrade>> _callback) throws ApiException {
            return FuturesApi.this.getMyTradesAsync(this.settle, this.contract, this.order, this.limit, this.offset, this.lastId, this.countTotal, _callback);
        }
    }

    public class APIlistFuturesOrdersRequest {
        private final String settle;
        private final String contract;
        private final String status;
        private Integer limit;
        private Integer offset;
        private String lastId;
        private Integer countTotal;

        private APIlistFuturesOrdersRequest(String settle, String contract, String status) {
            this.settle = settle;
            this.contract = contract;
            this.status = status;
        }

        public APIlistFuturesOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistFuturesOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistFuturesOrdersRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public APIlistFuturesOrdersRequest countTotal(Integer countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listFuturesOrdersCall(this.settle, this.contract, this.status, this.limit, this.offset, this.lastId, this.countTotal, _callback);
        }

        public List<FuturesOrder> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listFuturesOrdersWithHttpInfo(this.settle, this.contract, this.status, this.limit, this.offset, this.lastId, this.countTotal);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesOrder>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listFuturesOrdersWithHttpInfo(this.settle, this.contract, this.status, this.limit, this.offset, this.lastId, this.countTotal);
        }

        public Call executeAsync(ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
            return FuturesApi.this.listFuturesOrdersAsync(this.settle, this.contract, this.status, this.limit, this.offset, this.lastId, this.countTotal, _callback);
        }
    }

    public class APIlistFuturesAccountBookRequest {
        private final String settle;
        private Integer limit;
        private Long from;
        private Long to;
        private String type;

        private APIlistFuturesAccountBookRequest(String settle) {
            this.settle = settle;
        }

        public APIlistFuturesAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistFuturesAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistFuturesAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistFuturesAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listFuturesAccountBookCall(this.settle, this.limit, this.from, this.to, this.type, _callback);
        }

        public List<FuturesAccountBook> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listFuturesAccountBookWithHttpInfo(this.settle, this.limit, this.from, this.to, this.type);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesAccountBook>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listFuturesAccountBookWithHttpInfo(this.settle, this.limit, this.from, this.to, this.type);
        }

        public Call executeAsync(ApiCallback<List<FuturesAccountBook>> _callback) throws ApiException {
            return FuturesApi.this.listFuturesAccountBookAsync(this.settle, this.limit, this.from, this.to, this.type, _callback);
        }
    }

    public class APIlistLiquidatedOrdersRequest {
        private final String settle;
        private String contract;
        private Long from;
        private Long to;
        private Integer limit;

        private APIlistLiquidatedOrdersRequest(String settle) {
            this.settle = settle;
        }

        public APIlistLiquidatedOrdersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistLiquidatedOrdersRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistLiquidatedOrdersRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistLiquidatedOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listLiquidatedOrdersCall(this.settle, this.contract, this.from, this.to, this.limit, _callback);
        }

        public List<FuturesLiquidate> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listLiquidatedOrdersWithHttpInfo(this.settle, this.contract, this.from, this.to, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesLiquidate>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listLiquidatedOrdersWithHttpInfo(this.settle, this.contract, this.from, this.to, this.limit);
        }

        public Call executeAsync(ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
            return FuturesApi.this.listLiquidatedOrdersAsync(this.settle, this.contract, this.from, this.to, this.limit, _callback);
        }
    }

    public class APIlistContractStatsRequest {
        private final String settle;
        private final String contract;
        private Long from;
        private String interval;
        private Integer limit;

        private APIlistContractStatsRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        public APIlistContractStatsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistContractStatsRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public APIlistContractStatsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listContractStatsCall(this.settle, this.contract, this.from, this.interval, this.limit, _callback);
        }

        public List<ContractStat> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listContractStatsWithHttpInfo(this.settle, this.contract, this.from, this.interval, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<ContractStat>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listContractStatsWithHttpInfo(this.settle, this.contract, this.from, this.interval, this.limit);
        }

        public Call executeAsync(ApiCallback<List<ContractStat>> _callback) throws ApiException {
            return FuturesApi.this.listContractStatsAsync(this.settle, this.contract, this.from, this.interval, this.limit, _callback);
        }
    }

    public class APIlistFuturesInsuranceLedgerRequest {
        private final String settle;
        private Integer limit;

        private APIlistFuturesInsuranceLedgerRequest(String settle) {
            this.settle = settle;
        }

        public APIlistFuturesInsuranceLedgerRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listFuturesInsuranceLedgerCall(this.settle, this.limit, _callback);
        }

        public List<InsuranceRecord> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listFuturesInsuranceLedgerWithHttpInfo(this.settle, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<InsuranceRecord>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listFuturesInsuranceLedgerWithHttpInfo(this.settle, this.limit);
        }

        public Call executeAsync(ApiCallback<List<InsuranceRecord>> _callback) throws ApiException {
            return FuturesApi.this.listFuturesInsuranceLedgerAsync(this.settle, this.limit, _callback);
        }
    }

    public class APIlistFuturesFundingRateHistoryRequest {
        private final String settle;
        private final String contract;
        private Integer limit;

        private APIlistFuturesFundingRateHistoryRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        public APIlistFuturesFundingRateHistoryRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listFuturesFundingRateHistoryCall(this.settle, this.contract, this.limit, _callback);
        }

        public List<FundingRateRecord> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listFuturesFundingRateHistoryWithHttpInfo(this.settle, this.contract, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FundingRateRecord>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listFuturesFundingRateHistoryWithHttpInfo(this.settle, this.contract, this.limit);
        }

        public Call executeAsync(ApiCallback<List<FundingRateRecord>> _callback) throws ApiException {
            return FuturesApi.this.listFuturesFundingRateHistoryAsync(this.settle, this.contract, this.limit, _callback);
        }
    }

    public class APIlistFuturesTickersRequest {
        private final String settle;
        private String contract;

        private APIlistFuturesTickersRequest(String settle) {
            this.settle = settle;
        }

        public APIlistFuturesTickersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listFuturesTickersCall(this.settle, this.contract, _callback);
        }

        public List<FuturesTicker> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listFuturesTickersWithHttpInfo(this.settle, this.contract);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesTicker>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listFuturesTickersWithHttpInfo(this.settle, this.contract);
        }

        public Call executeAsync(ApiCallback<List<FuturesTicker>> _callback) throws ApiException {
            return FuturesApi.this.listFuturesTickersAsync(this.settle, this.contract, _callback);
        }
    }

    public class APIlistFuturesCandlesticksRequest {
        private final String settle;
        private final String contract;
        private Long from;
        private Long to;
        private Integer limit;
        private String interval;

        private APIlistFuturesCandlesticksRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        public APIlistFuturesCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistFuturesCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistFuturesCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistFuturesCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listFuturesCandlesticksCall(this.settle, this.contract, this.from, this.to, this.limit, this.interval, _callback);
        }

        public List<FuturesCandlestick> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listFuturesCandlesticksWithHttpInfo(this.settle, this.contract, this.from, this.to, this.limit, this.interval);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesCandlestick>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listFuturesCandlesticksWithHttpInfo(this.settle, this.contract, this.from, this.to, this.limit, this.interval);
        }

        public Call executeAsync(ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
            return FuturesApi.this.listFuturesCandlesticksAsync(this.settle, this.contract, this.from, this.to, this.limit, this.interval, _callback);
        }
    }

    public class APIlistFuturesTradesRequest {
        private final String settle;
        private final String contract;
        private Integer limit;
        private String lastId;
        private Long from;
        private Long to;

        private APIlistFuturesTradesRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        public APIlistFuturesTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistFuturesTradesRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public APIlistFuturesTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistFuturesTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listFuturesTradesCall(this.settle, this.contract, this.limit, this.lastId, this.from, this.to, _callback);
        }

        public List<FuturesTrade> execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listFuturesTradesWithHttpInfo(this.settle, this.contract, this.limit, this.lastId, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesTrade>> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listFuturesTradesWithHttpInfo(this.settle, this.contract, this.limit, this.lastId, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
            return FuturesApi.this.listFuturesTradesAsync(this.settle, this.contract, this.limit, this.lastId, this.from, this.to, _callback);
        }
    }

    public class APIlistFuturesOrderBookRequest {
        private final String settle;
        private final String contract;
        private String interval;
        private Integer limit;
        private Boolean withId;

        private APIlistFuturesOrderBookRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        public APIlistFuturesOrderBookRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public APIlistFuturesOrderBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistFuturesOrderBookRequest withId(Boolean withId) {
            this.withId = withId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return FuturesApi.this.listFuturesOrderBookCall(this.settle, this.contract, this.interval, this.limit, this.withId, _callback);
        }

        public FuturesOrderBook execute() throws ApiException {
            ApiResponse localVarResp = FuturesApi.this.listFuturesOrderBookWithHttpInfo(this.settle, this.contract, this.interval, this.limit, this.withId);
            return (FuturesOrderBook)localVarResp.getData();
        }

        public ApiResponse<FuturesOrderBook> executeWithHttpInfo() throws ApiException {
            return FuturesApi.this.listFuturesOrderBookWithHttpInfo(this.settle, this.contract, this.interval, this.limit, this.withId);
        }

        public Call executeAsync(ApiCallback<FuturesOrderBook> _callback) throws ApiException {
            return FuturesApi.this.listFuturesOrderBookAsync(this.settle, this.contract, this.interval, this.limit, this.withId, _callback);
        }
    }
}

