/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gate.gateapi.models.SpotPricePutOrder;
import io.gate.gateapi.models.SpotPriceTrigger;
import java.io.IOException;

/**
 * Spot order detail
 */
public class SpotPriceTriggeredOrder {
    public static final String SERIALIZED_NAME_TRIGGER = "trigger";
    @SerializedName(SERIALIZED_NAME_TRIGGER)
    private SpotPriceTrigger trigger;

    public static final String SERIALIZED_NAME_PUT = "put";
    @SerializedName(SERIALIZED_NAME_PUT)
    private SpotPricePutOrder put;

    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(SERIALIZED_NAME_ID)
    private Long id;

    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(SERIALIZED_NAME_USER)
    private Integer user;

    public static final String SERIALIZED_NAME_MARKET = "market";
    @SerializedName(SERIALIZED_NAME_MARKET)
    private String market;

    public static final String SERIALIZED_NAME_CTIME = "ctime";
    @SerializedName(SERIALIZED_NAME_CTIME)
    private Double ctime;

    public static final String SERIALIZED_NAME_FTIME = "ftime";
    @SerializedName(SERIALIZED_NAME_FTIME)
    private Double ftime;

    public static final String SERIALIZED_NAME_FIRED_ORDER_ID = "fired_order_id";
    @SerializedName(SERIALIZED_NAME_FIRED_ORDER_ID)
    private Long firedOrderId;

    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(SERIALIZED_NAME_STATUS)
    private String status;

    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(SERIALIZED_NAME_REASON)
    private String reason;


    public SpotPriceTriggeredOrder trigger(SpotPriceTrigger trigger) {
        
        this.trigger = trigger;
        return this;
    }

     /**
     * Get trigger
     * @return trigger
    **/
    public SpotPriceTrigger getTrigger() {
        return trigger;
    }


    public void setTrigger(SpotPriceTrigger trigger) {
        this.trigger = trigger;
    }

    public SpotPriceTriggeredOrder put(SpotPricePutOrder put) {
        
        this.put = put;
        return this;
    }

     /**
     * Get put
     * @return put
    **/
    public SpotPricePutOrder getPut() {
        return put;
    }


    public void setPut(SpotPricePutOrder put) {
        this.put = put;
    }

     /**
     * Auto order ID
     * @return id
    **/
    @javax.annotation.Nullable
    public Long getId() {
        return id;
    }


     /**
     * User ID
     * @return user
    **/
    @javax.annotation.Nullable
    public Integer getUser() {
        return user;
    }


    public SpotPriceTriggeredOrder market(String market) {
        
        this.market = market;
        return this;
    }

     /**
     * Currency pair
     * @return market
    **/
    public String getMarket() {
        return market;
    }


    public void setMarket(String market) {
        this.market = market;
    }

     /**
     * Creation time
     * @return ctime
    **/
    @javax.annotation.Nullable
    public Double getCtime() {
        return ctime;
    }


     /**
     * Finished time
     * @return ftime
    **/
    @javax.annotation.Nullable
    public Double getFtime() {
        return ftime;
    }


     /**
     * ID of the newly created order on condition triggered
     * @return firedOrderId
    **/
    @javax.annotation.Nullable
    public Long getFiredOrderId() {
        return firedOrderId;
    }


     /**
     * Status  - open: open - cancelled: being manually cancelled - finish: successfully executed - failed: failed to execute - expired - expired 
     * @return status
    **/
    @javax.annotation.Nullable
    public String getStatus() {
        return status;
    }


     /**
     * Additional remarks on how the order was finished
     * @return reason
    **/
    @javax.annotation.Nullable
    public String getReason() {
        return reason;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SpotPriceTriggeredOrder spotPriceTriggeredOrder = (SpotPriceTriggeredOrder) o;
        return Objects.equals(this.trigger, spotPriceTriggeredOrder.trigger) &&
                Objects.equals(this.put, spotPriceTriggeredOrder.put) &&
                Objects.equals(this.id, spotPriceTriggeredOrder.id) &&
                Objects.equals(this.user, spotPriceTriggeredOrder.user) &&
                Objects.equals(this.market, spotPriceTriggeredOrder.market) &&
                Objects.equals(this.ctime, spotPriceTriggeredOrder.ctime) &&
                Objects.equals(this.ftime, spotPriceTriggeredOrder.ftime) &&
                Objects.equals(this.firedOrderId, spotPriceTriggeredOrder.firedOrderId) &&
                Objects.equals(this.status, spotPriceTriggeredOrder.status) &&
                Objects.equals(this.reason, spotPriceTriggeredOrder.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(trigger, put, id, user, market, ctime, ftime, firedOrderId, status, reason);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpotPriceTriggeredOrder {\n");
        sb.append("      trigger: ").append(toIndentedString(trigger)).append("\n");
        sb.append("      put: ").append(toIndentedString(put)).append("\n");
        sb.append("      id: ").append(toIndentedString(id)).append("\n");
        sb.append("      user: ").append(toIndentedString(user)).append("\n");
        sb.append("      market: ").append(toIndentedString(market)).append("\n");
        sb.append("      ctime: ").append(toIndentedString(ctime)).append("\n");
        sb.append("      ftime: ").append(toIndentedString(ftime)).append("\n");
        sb.append("      firedOrderId: ").append(toIndentedString(firedOrderId)).append("\n");
        sb.append("      status: ").append(toIndentedString(status)).append("\n");
        sb.append("      reason: ").append(toIndentedString(reason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

