/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.DepositAddress;
import io.gate.gateapi.models.LedgerRecord;
import io.gate.gateapi.models.SubAccountBalance;
import io.gate.gateapi.models.SubAccountTransfer;
import io.gate.gateapi.models.TotalBalance;
import io.gate.gateapi.models.TradeFee;
import io.gate.gateapi.models.Transfer;
import io.gate.gateapi.models.WithdrawStatus;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class WalletApi {
    private ApiClient localVarApiClient;

    public WalletApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WalletApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getDepositAddressCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/deposit_address";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDepositAddressValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getDepositAddress(Async)");
        }
        Call localVarCall = this.getDepositAddressCall(currency, _callback);
        return localVarCall;
    }

    public DepositAddress getDepositAddress(String currency) throws ApiException {
        ApiResponse<DepositAddress> localVarResp = this.getDepositAddressWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<DepositAddress> getDepositAddressWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getDepositAddressValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<DepositAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDepositAddressAsync(String currency, ApiCallback<DepositAddress> _callback) throws ApiException {
        Call localVarCall = this.getDepositAddressValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<DepositAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listWithdrawalsCall(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/withdrawals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listWithdrawalsValidateBeforeCall(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listWithdrawalsCall(currency, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<LedgerRecord>> listWithdrawalsWithHttpInfo(String currency, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listWithdrawalsValidateBeforeCall(currency, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<LedgerRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listWithdrawalsAsync(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<LedgerRecord>> _callback) throws ApiException {
        Call localVarCall = this.listWithdrawalsValidateBeforeCall(currency, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<LedgerRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistWithdrawalsRequest listWithdrawals() {
        return new APIlistWithdrawalsRequest();
    }

    private Call listDepositsCall(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/deposits";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDepositsValidateBeforeCall(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listDepositsCall(currency, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<LedgerRecord>> listDepositsWithHttpInfo(String currency, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listDepositsValidateBeforeCall(currency, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<LedgerRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDepositsAsync(String currency, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<LedgerRecord>> _callback) throws ApiException {
        Call localVarCall = this.listDepositsValidateBeforeCall(currency, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<LedgerRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDepositsRequest listDeposits() {
        return new APIlistDepositsRequest();
    }

    public Call transferCall(Transfer transfer, ApiCallback _callback) throws ApiException {
        Transfer localVarPostBody = transfer;
        String localVarPath = "/wallet/transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transferValidateBeforeCall(Transfer transfer, ApiCallback _callback) throws ApiException {
        if (transfer == null) {
            throw new ApiException("Missing the required parameter 'transfer' when calling transfer(Async)");
        }
        Call localVarCall = this.transferCall(transfer, _callback);
        return localVarCall;
    }

    public void transfer(Transfer transfer) throws ApiException {
        this.transferWithHttpInfo(transfer);
    }

    public ApiResponse<Void> transferWithHttpInfo(Transfer transfer) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(transfer, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call transferAsync(Transfer transfer, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.transferValidateBeforeCall(transfer, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listSubAccountTransfersCall(String subUid, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/sub_account_transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_uid", subUid));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountTransfersValidateBeforeCall(String subUid, Long from, Long to, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSubAccountTransfersCall(subUid, from, to, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SubAccountTransfer>> listSubAccountTransfersWithHttpInfo(String subUid, Long from, Long to, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listSubAccountTransfersValidateBeforeCall(subUid, from, to, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<SubAccountTransfer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSubAccountTransfersAsync(String subUid, Long from, Long to, Integer limit, Integer offset, ApiCallback<List<SubAccountTransfer>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountTransfersValidateBeforeCall(subUid, from, to, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountTransfer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSubAccountTransfersRequest listSubAccountTransfers() {
        return new APIlistSubAccountTransfersRequest();
    }

    public Call transferWithSubAccountCall(SubAccountTransfer subAccountTransfer, ApiCallback _callback) throws ApiException {
        SubAccountTransfer localVarPostBody = subAccountTransfer;
        String localVarPath = "/wallet/sub_account_transfers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call transferWithSubAccountValidateBeforeCall(SubAccountTransfer subAccountTransfer, ApiCallback _callback) throws ApiException {
        if (subAccountTransfer == null) {
            throw new ApiException("Missing the required parameter 'subAccountTransfer' when calling transferWithSubAccount(Async)");
        }
        Call localVarCall = this.transferWithSubAccountCall(subAccountTransfer, _callback);
        return localVarCall;
    }

    public void transferWithSubAccount(SubAccountTransfer subAccountTransfer) throws ApiException {
        this.transferWithSubAccountWithHttpInfo(subAccountTransfer);
    }

    public ApiResponse<Void> transferWithSubAccountWithHttpInfo(SubAccountTransfer subAccountTransfer) throws ApiException {
        Call localVarCall = this.transferWithSubAccountValidateBeforeCall(subAccountTransfer, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call transferWithSubAccountAsync(SubAccountTransfer subAccountTransfer, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.transferWithSubAccountValidateBeforeCall(subAccountTransfer, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    private Call listWithdrawStatusCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/withdraw_status";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listWithdrawStatusValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listWithdrawStatusCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<WithdrawStatus>> listWithdrawStatusWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listWithdrawStatusValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<WithdrawStatus>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listWithdrawStatusAsync(String currency, ApiCallback<List<WithdrawStatus>> _callback) throws ApiException {
        Call localVarCall = this.listWithdrawStatusValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<WithdrawStatus>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistWithdrawStatusRequest listWithdrawStatus() {
        return new APIlistWithdrawStatusRequest();
    }

    private Call listSubAccountBalancesCall(String subUid, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/sub_account_balances";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (subUid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sub_uid", subUid));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSubAccountBalancesValidateBeforeCall(String subUid, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSubAccountBalancesCall(subUid, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SubAccountBalance>> listSubAccountBalancesWithHttpInfo(String subUid) throws ApiException {
        Call localVarCall = this.listSubAccountBalancesValidateBeforeCall(subUid, null);
        Type localVarReturnType = new TypeToken<List<SubAccountBalance>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSubAccountBalancesAsync(String subUid, ApiCallback<List<SubAccountBalance>> _callback) throws ApiException {
        Call localVarCall = this.listSubAccountBalancesValidateBeforeCall(subUid, _callback);
        Type localVarReturnType = new TypeToken<List<SubAccountBalance>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSubAccountBalancesRequest listSubAccountBalances() {
        return new APIlistSubAccountBalancesRequest();
    }

    private Call getTradeFeeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/fee";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTradeFeeValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTradeFeeCall(currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<TradeFee> getTradeFeeWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getTradeFeeValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<TradeFee>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTradeFeeAsync(String currencyPair, ApiCallback<TradeFee> _callback) throws ApiException {
        Call localVarCall = this.getTradeFeeValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<TradeFee>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetTradeFeeRequest getTradeFee() {
        return new APIgetTradeFeeRequest();
    }

    private Call getTotalBalanceCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/wallet/total_balance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTotalBalanceValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTotalBalanceCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<TotalBalance> getTotalBalanceWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getTotalBalanceValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<TotalBalance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getTotalBalanceAsync(String currency, ApiCallback<TotalBalance> _callback) throws ApiException {
        Call localVarCall = this.getTotalBalanceValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<TotalBalance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetTotalBalanceRequest getTotalBalance() {
        return new APIgetTotalBalanceRequest();
    }

    public class APIgetTotalBalanceRequest {
        private String currency;

        private APIgetTotalBalanceRequest() {
        }

        public APIgetTotalBalanceRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.getTotalBalanceCall(this.currency, _callback);
        }

        public TotalBalance execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.getTotalBalanceWithHttpInfo(this.currency);
            return (TotalBalance)localVarResp.getData();
        }

        public ApiResponse<TotalBalance> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.getTotalBalanceWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<TotalBalance> _callback) throws ApiException {
            return WalletApi.this.getTotalBalanceAsync(this.currency, _callback);
        }
    }

    public class APIgetTradeFeeRequest {
        private String currencyPair;

        private APIgetTradeFeeRequest() {
        }

        public APIgetTradeFeeRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.getTradeFeeCall(this.currencyPair, _callback);
        }

        public TradeFee execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.getTradeFeeWithHttpInfo(this.currencyPair);
            return (TradeFee)localVarResp.getData();
        }

        public ApiResponse<TradeFee> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.getTradeFeeWithHttpInfo(this.currencyPair);
        }

        public Call executeAsync(ApiCallback<TradeFee> _callback) throws ApiException {
            return WalletApi.this.getTradeFeeAsync(this.currencyPair, _callback);
        }
    }

    public class APIlistSubAccountBalancesRequest {
        private String subUid;

        private APIlistSubAccountBalancesRequest() {
        }

        public APIlistSubAccountBalancesRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSubAccountBalancesCall(this.subUid, _callback);
        }

        public List<SubAccountBalance> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSubAccountBalancesWithHttpInfo(this.subUid);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SubAccountBalance>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSubAccountBalancesWithHttpInfo(this.subUid);
        }

        public Call executeAsync(ApiCallback<List<SubAccountBalance>> _callback) throws ApiException {
            return WalletApi.this.listSubAccountBalancesAsync(this.subUid, _callback);
        }
    }

    public class APIlistWithdrawStatusRequest {
        private String currency;

        private APIlistWithdrawStatusRequest() {
        }

        public APIlistWithdrawStatusRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listWithdrawStatusCall(this.currency, _callback);
        }

        public List<WithdrawStatus> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listWithdrawStatusWithHttpInfo(this.currency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<WithdrawStatus>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listWithdrawStatusWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<List<WithdrawStatus>> _callback) throws ApiException {
            return WalletApi.this.listWithdrawStatusAsync(this.currency, _callback);
        }
    }

    public class APIlistSubAccountTransfersRequest {
        private String subUid;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistSubAccountTransfersRequest() {
        }

        public APIlistSubAccountTransfersRequest subUid(String subUid) {
            this.subUid = subUid;
            return this;
        }

        public APIlistSubAccountTransfersRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistSubAccountTransfersRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistSubAccountTransfersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistSubAccountTransfersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listSubAccountTransfersCall(this.subUid, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<SubAccountTransfer> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listSubAccountTransfersWithHttpInfo(this.subUid, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SubAccountTransfer>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listSubAccountTransfersWithHttpInfo(this.subUid, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<SubAccountTransfer>> _callback) throws ApiException {
            return WalletApi.this.listSubAccountTransfersAsync(this.subUid, this.from, this.to, this.limit, this.offset, _callback);
        }
    }

    public class APIlistDepositsRequest {
        private String currency;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistDepositsRequest() {
        }

        public APIlistDepositsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistDepositsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistDepositsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistDepositsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDepositsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listDepositsCall(this.currency, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<LedgerRecord> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listDepositsWithHttpInfo(this.currency, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<LedgerRecord>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listDepositsWithHttpInfo(this.currency, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<LedgerRecord>> _callback) throws ApiException {
            return WalletApi.this.listDepositsAsync(this.currency, this.from, this.to, this.limit, this.offset, _callback);
        }
    }

    public class APIlistWithdrawalsRequest {
        private String currency;
        private Long from;
        private Long to;
        private Integer limit;
        private Integer offset;

        private APIlistWithdrawalsRequest() {
        }

        public APIlistWithdrawalsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public APIlistWithdrawalsRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistWithdrawalsRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistWithdrawalsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistWithdrawalsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return WalletApi.this.listWithdrawalsCall(this.currency, this.from, this.to, this.limit, this.offset, _callback);
        }

        public List<LedgerRecord> execute() throws ApiException {
            ApiResponse localVarResp = WalletApi.this.listWithdrawalsWithHttpInfo(this.currency, this.from, this.to, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<LedgerRecord>> executeWithHttpInfo() throws ApiException {
            return WalletApi.this.listWithdrawalsWithHttpInfo(this.currency, this.from, this.to, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<LedgerRecord>> _callback) throws ApiException {
            return WalletApi.this.listWithdrawalsAsync(this.currency, this.from, this.to, this.limit, this.offset, _callback);
        }
    }
}

