/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gate.gateapi.models.AccountBalance;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 用户总资产信息
 */
public class TotalBalance {
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(SERIALIZED_NAME_TOTAL)
    private AccountBalance total;

    public static final String SERIALIZED_NAME_DETAILS = "details";
    @SerializedName(SERIALIZED_NAME_DETAILS)
    private Map<String, AccountBalance> details = null;


    public TotalBalance total(AccountBalance total) {
        
        this.total = total;
        return this;
    }

     /**
     * Get total
     * @return total
    **/
    @javax.annotation.Nullable
    public AccountBalance getTotal() {
        return total;
    }


    public void setTotal(AccountBalance total) {
        this.total = total;
    }

    public TotalBalance details(Map<String, AccountBalance> details) {
        
        this.details = details;
        return this;
    }

    public TotalBalance putDetailsItem(String key, AccountBalance detailsItem) {
        if (this.details == null) {
            this.details = new HashMap<>();
        }
        this.details.put(key, detailsItem);
        return this;
    }

     /**
     * Total balances in different accounts  - cross_margin: cross margin account - spot: spot account - finance: finance account - margin: margin account - quant: quant account - futures: futures account - delivery: delivery account - warrant: warrant account - cbbc: cbbc account
     * @return details
    **/
    @javax.annotation.Nullable
    public Map<String, AccountBalance> getDetails() {
        return details;
    }


    public void setDetails(Map<String, AccountBalance> details) {
        this.details = details;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TotalBalance totalBalance = (TotalBalance) o;
        return Objects.equals(this.total, totalBalance.total) &&
                Objects.equals(this.details, totalBalance.details);
    }

    @Override
    public int hashCode() {
        return Objects.hash(total, details);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TotalBalance {\n");
        sb.append("      total: ").append(toIndentedString(total)).append("\n");
        sb.append("      details: ").append(toIndentedString(details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

