/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * CrossMarginCurrency
 */
public class CrossMarginCurrency {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(SERIALIZED_NAME_NAME)
    private String name;

    public static final String SERIALIZED_NAME_RATE = "rate";
    @SerializedName(SERIALIZED_NAME_RATE)
    private String rate;

    public static final String SERIALIZED_NAME_PREC = "prec";
    @SerializedName(SERIALIZED_NAME_PREC)
    private String prec;

    public static final String SERIALIZED_NAME_DISCOUNT = "discount";
    @SerializedName(SERIALIZED_NAME_DISCOUNT)
    private String discount;

    public static final String SERIALIZED_NAME_MIN_BORROW_AMOUNT = "min_borrow_amount";
    @SerializedName(SERIALIZED_NAME_MIN_BORROW_AMOUNT)
    private String minBorrowAmount;

    public static final String SERIALIZED_NAME_USER_MAX_BORROW_AMOUNT = "user_max_borrow_amount";
    @SerializedName(SERIALIZED_NAME_USER_MAX_BORROW_AMOUNT)
    private String userMaxBorrowAmount;

    public static final String SERIALIZED_NAME_TOTAL_MAX_BORROW_AMOUNT = "total_max_borrow_amount";
    @SerializedName(SERIALIZED_NAME_TOTAL_MAX_BORROW_AMOUNT)
    private String totalMaxBorrowAmount;

    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(SERIALIZED_NAME_PRICE)
    private String price;


    public CrossMarginCurrency name(String name) {
        
        this.name = name;
        return this;
    }

     /**
     * Currency name
     * @return name
    **/
    @javax.annotation.Nullable
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    public CrossMarginCurrency rate(String rate) {
        
        this.rate = rate;
        return this;
    }

     /**
     * Loan rate
     * @return rate
    **/
    @javax.annotation.Nullable
    public String getRate() {
        return rate;
    }


    public void setRate(String rate) {
        this.rate = rate;
    }

    public CrossMarginCurrency prec(String prec) {
        
        this.prec = prec;
        return this;
    }

     /**
     * Currency precision
     * @return prec
    **/
    @javax.annotation.Nullable
    public String getPrec() {
        return prec;
    }


    public void setPrec(String prec) {
        this.prec = prec;
    }

    public CrossMarginCurrency discount(String discount) {
        
        this.discount = discount;
        return this;
    }

     /**
     * Currency value discount, which is used in total value calculation
     * @return discount
    **/
    @javax.annotation.Nullable
    public String getDiscount() {
        return discount;
    }


    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public CrossMarginCurrency minBorrowAmount(String minBorrowAmount) {
        
        this.minBorrowAmount = minBorrowAmount;
        return this;
    }

     /**
     * Minimum currency borrow amount. Unit is currency itself
     * @return minBorrowAmount
    **/
    @javax.annotation.Nullable
    public String getMinBorrowAmount() {
        return minBorrowAmount;
    }


    public void setMinBorrowAmount(String minBorrowAmount) {
        this.minBorrowAmount = minBorrowAmount;
    }

    public CrossMarginCurrency userMaxBorrowAmount(String userMaxBorrowAmount) {
        
        this.userMaxBorrowAmount = userMaxBorrowAmount;
        return this;
    }

     /**
     * Maximum borrow value allowed per user, in USDT
     * @return userMaxBorrowAmount
    **/
    @javax.annotation.Nullable
    public String getUserMaxBorrowAmount() {
        return userMaxBorrowAmount;
    }


    public void setUserMaxBorrowAmount(String userMaxBorrowAmount) {
        this.userMaxBorrowAmount = userMaxBorrowAmount;
    }

    public CrossMarginCurrency totalMaxBorrowAmount(String totalMaxBorrowAmount) {
        
        this.totalMaxBorrowAmount = totalMaxBorrowAmount;
        return this;
    }

     /**
     * Maximum borrow value allowed for this currency, in USDT
     * @return totalMaxBorrowAmount
    **/
    @javax.annotation.Nullable
    public String getTotalMaxBorrowAmount() {
        return totalMaxBorrowAmount;
    }


    public void setTotalMaxBorrowAmount(String totalMaxBorrowAmount) {
        this.totalMaxBorrowAmount = totalMaxBorrowAmount;
    }

    public CrossMarginCurrency price(String price) {
        
        this.price = price;
        return this;
    }

     /**
     * Price change between this currency and USDT
     * @return price
    **/
    @javax.annotation.Nullable
    public String getPrice() {
        return price;
    }


    public void setPrice(String price) {
        this.price = price;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CrossMarginCurrency crossMarginCurrency = (CrossMarginCurrency) o;
        return Objects.equals(this.name, crossMarginCurrency.name) &&
                Objects.equals(this.rate, crossMarginCurrency.rate) &&
                Objects.equals(this.prec, crossMarginCurrency.prec) &&
                Objects.equals(this.discount, crossMarginCurrency.discount) &&
                Objects.equals(this.minBorrowAmount, crossMarginCurrency.minBorrowAmount) &&
                Objects.equals(this.userMaxBorrowAmount, crossMarginCurrency.userMaxBorrowAmount) &&
                Objects.equals(this.totalMaxBorrowAmount, crossMarginCurrency.totalMaxBorrowAmount) &&
                Objects.equals(this.price, crossMarginCurrency.price);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, rate, prec, discount, minBorrowAmount, userMaxBorrowAmount, totalMaxBorrowAmount, price);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CrossMarginCurrency {\n");
        sb.append("      name: ").append(toIndentedString(name)).append("\n");
        sb.append("      rate: ").append(toIndentedString(rate)).append("\n");
        sb.append("      prec: ").append(toIndentedString(prec)).append("\n");
        sb.append("      discount: ").append(toIndentedString(discount)).append("\n");
        sb.append("      minBorrowAmount: ").append(toIndentedString(minBorrowAmount)).append("\n");
        sb.append("      userMaxBorrowAmount: ").append(toIndentedString(userMaxBorrowAmount)).append("\n");
        sb.append("      totalMaxBorrowAmount: ").append(toIndentedString(totalMaxBorrowAmount)).append("\n");
        sb.append("      price: ").append(toIndentedString(price)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

