/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/**
 * Total balances calculated with specified currency unit
 */
public class AccountBalance {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(SERIALIZED_NAME_AMOUNT)
    private String amount;

    /**
     * Currency
     */
    @JsonAdapter(CurrencyEnum.Adapter.class)
    public enum CurrencyEnum {
        BTC("BTC"),
        
        CNY("CNY"),
        
        USD("USD"),
        
        USDT("USDT");

        private String value;

        CurrencyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static CurrencyEnum fromValue(String value) {
            for (CurrencyEnum b : CurrencyEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter extends TypeAdapter<CurrencyEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final CurrencyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public CurrencyEnum read(final JsonReader jsonReader) throws IOException {
                String value =  jsonReader.nextString();
                return CurrencyEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(SERIALIZED_NAME_CURRENCY)
    private CurrencyEnum currency;


    public AccountBalance amount(String amount) {
        
        this.amount = amount;
        return this;
    }

     /**
     * Account total balance amount
     * @return amount
    **/
    @javax.annotation.Nullable
    public String getAmount() {
        return amount;
    }


    public void setAmount(String amount) {
        this.amount = amount;
    }

    public AccountBalance currency(CurrencyEnum currency) {
        
        this.currency = currency;
        return this;
    }

     /**
     * Currency
     * @return currency
    **/
    @javax.annotation.Nullable
    public CurrencyEnum getCurrency() {
        return currency;
    }


    public void setCurrency(CurrencyEnum currency) {
        this.currency = currency;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountBalance accountBalance = (AccountBalance) o;
        return Objects.equals(this.amount, accountBalance.amount) &&
                Objects.equals(this.currency, accountBalance.currency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, currency);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountBalance {\n");
        sb.append("      amount: ").append(toIndentedString(amount)).append("\n");
        sb.append("      currency: ").append(toIndentedString(currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

