/*
 * Gate API v4
 * Welcome to Gate.io API  APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.gate.gateapi.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.gate.gateapi.models.MultiChainAddressItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * DepositAddress
 */
public class DepositAddress {
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(SERIALIZED_NAME_CURRENCY)
    private String currency;

    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(SERIALIZED_NAME_ADDRESS)
    private String address;

    public static final String SERIALIZED_NAME_MULTICHAIN_ADDRESS = "multichain_address";
    @SerializedName(SERIALIZED_NAME_MULTICHAIN_ADDRESS)
    private List<MultiChainAddressItem> multichainAddress = null;


    public DepositAddress currency(String currency) {
        
        this.currency = currency;
        return this;
    }

     /**
     * Currency detail
     * @return currency
    **/
    public String getCurrency() {
        return currency;
    }


    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public DepositAddress address(String address) {
        
        this.address = address;
        return this;
    }

     /**
     * Deposit address
     * @return address
    **/
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    public DepositAddress multichainAddress(List<MultiChainAddressItem> multichainAddress) {
        
        this.multichainAddress = multichainAddress;
        return this;
    }

    public DepositAddress addMultichainAddressItem(MultiChainAddressItem multichainAddressItem) {
        if (this.multichainAddress == null) {
            this.multichainAddress = new ArrayList<>();
        }
        this.multichainAddress.add(multichainAddressItem);
        return this;
    }

     /**
     * Get multichainAddress
     * @return multichainAddress
    **/
    @javax.annotation.Nullable
    public List<MultiChainAddressItem> getMultichainAddress() {
        return multichainAddress;
    }


    public void setMultichainAddress(List<MultiChainAddressItem> multichainAddress) {
        this.multichainAddress = multichainAddress;
    }
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DepositAddress depositAddress = (DepositAddress) o;
        return Objects.equals(this.currency, depositAddress.currency) &&
                Objects.equals(this.address, depositAddress.address) &&
                Objects.equals(this.multichainAddress, depositAddress.multichainAddress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(currency, address, multichainAddress);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositAddress {\n");
        sb.append("      currency: ").append(toIndentedString(currency)).append("\n");
        sb.append("      address: ").append(toIndentedString(address)).append("\n");
        sb.append("      multichainAddress: ").append(toIndentedString(multichainAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n        ");
    }

}

