/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.BatchOrder;
import io.gate.gateapi.models.CancelOrder;
import io.gate.gateapi.models.CancelOrderResult;
import io.gate.gateapi.models.Currency;
import io.gate.gateapi.models.CurrencyPair;
import io.gate.gateapi.models.OpenOrders;
import io.gate.gateapi.models.Order;
import io.gate.gateapi.models.OrderBook;
import io.gate.gateapi.models.SpotAccount;
import io.gate.gateapi.models.SpotPriceTriggeredOrder;
import io.gate.gateapi.models.Ticker;
import io.gate.gateapi.models.Trade;
import io.gate.gateapi.models.TradeFee;
import io.gate.gateapi.models.TriggerOrderResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class SpotApi {
    private ApiClient localVarApiClient;

    public SpotApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SpotApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listCurrenciesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/currencies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCurrenciesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCurrenciesCall(_callback);
        return localVarCall;
    }

    public List<Currency> listCurrencies() throws ApiException {
        ApiResponse<List<Currency>> localVarResp = this.listCurrenciesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<Currency>> listCurrenciesWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCurrenciesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<Currency>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCurrenciesAsync(ApiCallback<List<Currency>> _callback) throws ApiException {
        Call localVarCall = this.listCurrenciesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<Currency>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCurrencyCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/currencies/{currency}".replaceAll("\\{currency\\}", this.localVarApiClient.escapeString(currency));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCurrencyValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        if (currency == null) {
            throw new ApiException("Missing the required parameter 'currency' when calling getCurrency(Async)");
        }
        Call localVarCall = this.getCurrencyCall(currency, _callback);
        return localVarCall;
    }

    public Currency getCurrency(String currency) throws ApiException {
        ApiResponse<Currency> localVarResp = this.getCurrencyWithHttpInfo(currency);
        return localVarResp.getData();
    }

    public ApiResponse<Currency> getCurrencyWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.getCurrencyValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<Currency>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCurrencyAsync(String currency, ApiCallback<Currency> _callback) throws ApiException {
        Call localVarCall = this.getCurrencyValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<Currency>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listCurrencyPairsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/currency_pairs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCurrencyPairsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listCurrencyPairsCall(_callback);
        return localVarCall;
    }

    public List<CurrencyPair> listCurrencyPairs() throws ApiException {
        ApiResponse<List<CurrencyPair>> localVarResp = this.listCurrencyPairsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<CurrencyPair>> listCurrencyPairsWithHttpInfo() throws ApiException {
        Call localVarCall = this.listCurrencyPairsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<CurrencyPair>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listCurrencyPairsAsync(ApiCallback<List<CurrencyPair>> _callback) throws ApiException {
        Call localVarCall = this.listCurrencyPairsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<CurrencyPair>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCurrencyPairCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/currency_pairs/{currency_pair}".replaceAll("\\{currency_pair\\}", this.localVarApiClient.escapeString(currencyPair));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCurrencyPairValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getCurrencyPair(Async)");
        }
        Call localVarCall = this.getCurrencyPairCall(currencyPair, _callback);
        return localVarCall;
    }

    public CurrencyPair getCurrencyPair(String currencyPair) throws ApiException {
        ApiResponse<CurrencyPair> localVarResp = this.getCurrencyPairWithHttpInfo(currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<CurrencyPair> getCurrencyPairWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getCurrencyPairValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<CurrencyPair>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCurrencyPairAsync(String currencyPair, ApiCallback<CurrencyPair> _callback) throws ApiException {
        Call localVarCall = this.getCurrencyPairValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<CurrencyPair>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listTickersCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/tickers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTickersValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listTickersCall(currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Ticker>> listTickersWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.listTickersValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<List<Ticker>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listTickersAsync(String currencyPair, ApiCallback<List<Ticker>> _callback) throws ApiException {
        Call localVarCall = this.listTickersValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<List<Ticker>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistTickersRequest listTickers() {
        return new APIlistTickersRequest();
    }

    private Call listOrderBookCall(String currencyPair, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/order_book";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (withId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("with_id", withId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOrderBookValidateBeforeCall(String currencyPair, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listOrderBook(Async)");
        }
        Call localVarCall = this.listOrderBookCall(currencyPair, interval, limit, withId, _callback);
        return localVarCall;
    }

    private ApiResponse<OrderBook> listOrderBookWithHttpInfo(String currencyPair, String interval, Integer limit, Boolean withId) throws ApiException {
        Call localVarCall = this.listOrderBookValidateBeforeCall(currencyPair, interval, limit, withId, null);
        Type localVarReturnType = new TypeToken<OrderBook>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOrderBookAsync(String currencyPair, String interval, Integer limit, Boolean withId, ApiCallback<OrderBook> _callback) throws ApiException {
        Call localVarCall = this.listOrderBookValidateBeforeCall(currencyPair, interval, limit, withId, _callback);
        Type localVarReturnType = new TypeToken<OrderBook>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOrderBookRequest listOrderBook(String currencyPair) {
        return new APIlistOrderBookRequest(currencyPair);
    }

    private Call listTradesCall(String currencyPair, Integer limit, String lastId, Boolean reverse, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (lastId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("last_id", lastId));
        }
        if (reverse != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("reverse", reverse));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listTradesValidateBeforeCall(String currencyPair, Integer limit, String lastId, Boolean reverse, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listTrades(Async)");
        }
        Call localVarCall = this.listTradesCall(currencyPair, limit, lastId, reverse, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Trade>> listTradesWithHttpInfo(String currencyPair, Integer limit, String lastId, Boolean reverse) throws ApiException {
        Call localVarCall = this.listTradesValidateBeforeCall(currencyPair, limit, lastId, reverse, null);
        Type localVarReturnType = new TypeToken<List<Trade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listTradesAsync(String currencyPair, Integer limit, String lastId, Boolean reverse, ApiCallback<List<Trade>> _callback) throws ApiException {
        Call localVarCall = this.listTradesValidateBeforeCall(currencyPair, limit, lastId, reverse, _callback);
        Type localVarReturnType = new TypeToken<List<Trade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistTradesRequest listTrades(String currencyPair) {
        return new APIlistTradesRequest(currencyPair);
    }

    private Call listCandlesticksCall(String currencyPair, Integer limit, Long from, Long to, String interval, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/candlesticks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listCandlesticksValidateBeforeCall(String currencyPair, Integer limit, Long from, Long to, String interval, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listCandlesticks(Async)");
        }
        Call localVarCall = this.listCandlesticksCall(currencyPair, limit, from, to, interval, _callback);
        return localVarCall;
    }

    private ApiResponse<List<List<String>>> listCandlesticksWithHttpInfo(String currencyPair, Integer limit, Long from, Long to, String interval) throws ApiException {
        Call localVarCall = this.listCandlesticksValidateBeforeCall(currencyPair, limit, from, to, interval, null);
        Type localVarReturnType = new TypeToken<List<List<String>>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listCandlesticksAsync(String currencyPair, Integer limit, Long from, Long to, String interval, ApiCallback<List<List<String>>> _callback) throws ApiException {
        Call localVarCall = this.listCandlesticksValidateBeforeCall(currencyPair, limit, from, to, interval, _callback);
        Type localVarReturnType = new TypeToken<List<List<String>>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistCandlesticksRequest listCandlesticks(String currencyPair) {
        return new APIlistCandlesticksRequest(currencyPair);
    }

    private Call getFeeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/fee";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @Deprecated
    private Call getFeeValidateBeforeCall(String currencyPair, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getFeeCall(currencyPair, _callback);
        return localVarCall;
    }

    private ApiResponse<TradeFee> getFeeWithHttpInfo(String currencyPair) throws ApiException {
        Call localVarCall = this.getFeeValidateBeforeCall(currencyPair, null);
        Type localVarReturnType = new TypeToken<TradeFee>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getFeeAsync(String currencyPair, ApiCallback<TradeFee> _callback) throws ApiException {
        Call localVarCall = this.getFeeValidateBeforeCall(currencyPair, _callback);
        Type localVarReturnType = new TypeToken<TradeFee>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public APIgetFeeRequest getFee() {
        return new APIgetFeeRequest();
    }

    private Call listSpotAccountsCall(String currency, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currency != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency", currency));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSpotAccountsValidateBeforeCall(String currency, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listSpotAccountsCall(currency, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SpotAccount>> listSpotAccountsWithHttpInfo(String currency) throws ApiException {
        Call localVarCall = this.listSpotAccountsValidateBeforeCall(currency, null);
        Type localVarReturnType = new TypeToken<List<SpotAccount>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSpotAccountsAsync(String currency, ApiCallback<List<SpotAccount>> _callback) throws ApiException {
        Call localVarCall = this.listSpotAccountsValidateBeforeCall(currency, _callback);
        Type localVarReturnType = new TypeToken<List<SpotAccount>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSpotAccountsRequest listSpotAccounts() {
        return new APIlistSpotAccountsRequest();
    }

    public Call createBatchOrdersCall(List<Order> order, ApiCallback _callback) throws ApiException {
        List<Order> localVarPostBody = order;
        String localVarPath = "/spot/batch_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBatchOrdersValidateBeforeCall(List<Order> order, ApiCallback _callback) throws ApiException {
        if (order == null) {
            throw new ApiException("Missing the required parameter 'order' when calling createBatchOrders(Async)");
        }
        Call localVarCall = this.createBatchOrdersCall(order, _callback);
        return localVarCall;
    }

    public List<BatchOrder> createBatchOrders(List<Order> order) throws ApiException {
        ApiResponse<List<BatchOrder>> localVarResp = this.createBatchOrdersWithHttpInfo(order);
        return localVarResp.getData();
    }

    public ApiResponse<List<BatchOrder>> createBatchOrdersWithHttpInfo(List<Order> order) throws ApiException {
        Call localVarCall = this.createBatchOrdersValidateBeforeCall(order, null);
        Type localVarReturnType = new TypeToken<List<BatchOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createBatchOrdersAsync(List<Order> order, ApiCallback<List<BatchOrder>> _callback) throws ApiException {
        Call localVarCall = this.createBatchOrdersValidateBeforeCall(order, _callback);
        Type localVarReturnType = new TypeToken<List<BatchOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listAllOpenOrdersCall(Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/open_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listAllOpenOrdersValidateBeforeCall(Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listAllOpenOrdersCall(page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<OpenOrders>> listAllOpenOrdersWithHttpInfo(Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listAllOpenOrdersValidateBeforeCall(page, limit, null);
        Type localVarReturnType = new TypeToken<List<OpenOrders>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listAllOpenOrdersAsync(Integer page, Integer limit, ApiCallback<List<OpenOrders>> _callback) throws ApiException {
        Call localVarCall = this.listAllOpenOrdersValidateBeforeCall(page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<OpenOrders>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistAllOpenOrdersRequest listAllOpenOrders() {
        return new APIlistAllOpenOrdersRequest();
    }

    private Call listOrdersCall(String currencyPair, String status, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listOrdersValidateBeforeCall(String currencyPair, String status, Integer page, Integer limit, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listOrders(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listOrders(Async)");
        }
        Call localVarCall = this.listOrdersCall(currencyPair, status, page, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Order>> listOrdersWithHttpInfo(String currencyPair, String status, Integer page, Integer limit) throws ApiException {
        Call localVarCall = this.listOrdersValidateBeforeCall(currencyPair, status, page, limit, null);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listOrdersAsync(String currencyPair, String status, Integer page, Integer limit, ApiCallback<List<Order>> _callback) throws ApiException {
        Call localVarCall = this.listOrdersValidateBeforeCall(currencyPair, status, page, limit, _callback);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistOrdersRequest listOrders(String currencyPair, String status) {
        return new APIlistOrdersRequest(currencyPair, status);
    }

    public Call createOrderCall(Order order, ApiCallback _callback) throws ApiException {
        Order localVarPostBody = order;
        String localVarPath = "/spot/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createOrderValidateBeforeCall(Order order, ApiCallback _callback) throws ApiException {
        if (order == null) {
            throw new ApiException("Missing the required parameter 'order' when calling createOrder(Async)");
        }
        Call localVarCall = this.createOrderCall(order, _callback);
        return localVarCall;
    }

    public Order createOrder(Order order) throws ApiException {
        ApiResponse<Order> localVarResp = this.createOrderWithHttpInfo(order);
        return localVarResp.getData();
    }

    public ApiResponse<Order> createOrderWithHttpInfo(Order order) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(order, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createOrderAsync(Order order, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.createOrderValidateBeforeCall(order, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelOrdersCall(String currencyPair, String side, String account, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelOrdersValidateBeforeCall(String currencyPair, String side, String account, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling cancelOrders(Async)");
        }
        Call localVarCall = this.cancelOrdersCall(currencyPair, side, account, _callback);
        return localVarCall;
    }

    public List<Order> cancelOrders(String currencyPair, String side, String account) throws ApiException {
        ApiResponse<List<Order>> localVarResp = this.cancelOrdersWithHttpInfo(currencyPair, side, account);
        return localVarResp.getData();
    }

    public ApiResponse<List<Order>> cancelOrdersWithHttpInfo(String currencyPair, String side, String account) throws ApiException {
        Call localVarCall = this.cancelOrdersValidateBeforeCall(currencyPair, side, account, null);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelOrdersAsync(String currencyPair, String side, String account, ApiCallback<List<Order>> _callback) throws ApiException {
        Call localVarCall = this.cancelOrdersValidateBeforeCall(currencyPair, side, account, _callback);
        Type localVarReturnType = new TypeToken<List<Order>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelBatchOrdersCall(List<CancelOrder> cancelOrder, ApiCallback _callback) throws ApiException {
        List<CancelOrder> localVarPostBody = cancelOrder;
        String localVarPath = "/spot/cancel_batch_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelBatchOrdersValidateBeforeCall(List<CancelOrder> cancelOrder, ApiCallback _callback) throws ApiException {
        if (cancelOrder == null) {
            throw new ApiException("Missing the required parameter 'cancelOrder' when calling cancelBatchOrders(Async)");
        }
        Call localVarCall = this.cancelBatchOrdersCall(cancelOrder, _callback);
        return localVarCall;
    }

    public List<CancelOrderResult> cancelBatchOrders(List<CancelOrder> cancelOrder) throws ApiException {
        ApiResponse<List<CancelOrderResult>> localVarResp = this.cancelBatchOrdersWithHttpInfo(cancelOrder);
        return localVarResp.getData();
    }

    public ApiResponse<List<CancelOrderResult>> cancelBatchOrdersWithHttpInfo(List<CancelOrder> cancelOrder) throws ApiException {
        Call localVarCall = this.cancelBatchOrdersValidateBeforeCall(cancelOrder, null);
        Type localVarReturnType = new TypeToken<List<CancelOrderResult>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelBatchOrdersAsync(List<CancelOrder> cancelOrder, ApiCallback<List<CancelOrderResult>> _callback) throws ApiException {
        Call localVarCall = this.cancelBatchOrdersValidateBeforeCall(cancelOrder, _callback);
        Type localVarReturnType = new TypeToken<List<CancelOrderResult>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOrderCall(String orderId, String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrderValidateBeforeCall(String orderId, String currencyPair, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getOrder(Async)");
        }
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling getOrder(Async)");
        }
        Call localVarCall = this.getOrderCall(orderId, currencyPair, _callback);
        return localVarCall;
    }

    public Order getOrder(String orderId, String currencyPair) throws ApiException {
        ApiResponse<Order> localVarResp = this.getOrderWithHttpInfo(orderId, currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<Order> getOrderWithHttpInfo(String orderId, String currencyPair) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderId, currencyPair, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrderAsync(String orderId, String currencyPair, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.getOrderValidateBeforeCall(orderId, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelOrderCall(String orderId, String currencyPair, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelOrderValidateBeforeCall(String orderId, String currencyPair, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelOrder(Async)");
        }
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling cancelOrder(Async)");
        }
        Call localVarCall = this.cancelOrderCall(orderId, currencyPair, _callback);
        return localVarCall;
    }

    public Order cancelOrder(String orderId, String currencyPair) throws ApiException {
        ApiResponse<Order> localVarResp = this.cancelOrderWithHttpInfo(orderId, currencyPair);
        return localVarResp.getData();
    }

    public ApiResponse<Order> cancelOrderWithHttpInfo(String orderId, String currencyPair) throws ApiException {
        Call localVarCall = this.cancelOrderValidateBeforeCall(orderId, currencyPair, null);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelOrderAsync(String orderId, String currencyPair, ApiCallback<Order> _callback) throws ApiException {
        Call localVarCall = this.cancelOrderValidateBeforeCall(orderId, currencyPair, _callback);
        Type localVarReturnType = new TypeToken<Order>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listMyTradesCall(String currencyPair, Integer limit, Integer page, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/my_trades";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (currencyPair != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currency_pair", currencyPair));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order_id", orderId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listMyTradesValidateBeforeCall(String currencyPair, Integer limit, Integer page, String orderId, ApiCallback _callback) throws ApiException {
        if (currencyPair == null) {
            throw new ApiException("Missing the required parameter 'currencyPair' when calling listMyTrades(Async)");
        }
        Call localVarCall = this.listMyTradesCall(currencyPair, limit, page, orderId, _callback);
        return localVarCall;
    }

    private ApiResponse<List<Trade>> listMyTradesWithHttpInfo(String currencyPair, Integer limit, Integer page, String orderId) throws ApiException {
        Call localVarCall = this.listMyTradesValidateBeforeCall(currencyPair, limit, page, orderId, null);
        Type localVarReturnType = new TypeToken<List<Trade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listMyTradesAsync(String currencyPair, Integer limit, Integer page, String orderId, ApiCallback<List<Trade>> _callback) throws ApiException {
        Call localVarCall = this.listMyTradesValidateBeforeCall(currencyPair, limit, page, orderId, _callback);
        Type localVarReturnType = new TypeToken<List<Trade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistMyTradesRequest listMyTrades(String currencyPair) {
        return new APIlistMyTradesRequest(currencyPair);
    }

    private Call listSpotPriceTriggeredOrdersCall(String status, String market, String account, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/price_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (market != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("market", market));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSpotPriceTriggeredOrdersValidateBeforeCall(String status, String market, String account, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listSpotPriceTriggeredOrders(Async)");
        }
        Call localVarCall = this.listSpotPriceTriggeredOrdersCall(status, market, account, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<SpotPriceTriggeredOrder>> listSpotPriceTriggeredOrdersWithHttpInfo(String status, String market, String account, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listSpotPriceTriggeredOrdersValidateBeforeCall(status, market, account, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<SpotPriceTriggeredOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listSpotPriceTriggeredOrdersAsync(String status, String market, String account, Integer limit, Integer offset, ApiCallback<List<SpotPriceTriggeredOrder>> _callback) throws ApiException {
        Call localVarCall = this.listSpotPriceTriggeredOrdersValidateBeforeCall(status, market, account, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<SpotPriceTriggeredOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistSpotPriceTriggeredOrdersRequest listSpotPriceTriggeredOrders(String status) {
        return new APIlistSpotPriceTriggeredOrdersRequest(status);
    }

    public Call createSpotPriceTriggeredOrderCall(SpotPriceTriggeredOrder spotPriceTriggeredOrder, ApiCallback _callback) throws ApiException {
        SpotPriceTriggeredOrder localVarPostBody = spotPriceTriggeredOrder;
        String localVarPath = "/spot/price_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSpotPriceTriggeredOrderValidateBeforeCall(SpotPriceTriggeredOrder spotPriceTriggeredOrder, ApiCallback _callback) throws ApiException {
        if (spotPriceTriggeredOrder == null) {
            throw new ApiException("Missing the required parameter 'spotPriceTriggeredOrder' when calling createSpotPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.createSpotPriceTriggeredOrderCall(spotPriceTriggeredOrder, _callback);
        return localVarCall;
    }

    public TriggerOrderResponse createSpotPriceTriggeredOrder(SpotPriceTriggeredOrder spotPriceTriggeredOrder) throws ApiException {
        ApiResponse<TriggerOrderResponse> localVarResp = this.createSpotPriceTriggeredOrderWithHttpInfo(spotPriceTriggeredOrder);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerOrderResponse> createSpotPriceTriggeredOrderWithHttpInfo(SpotPriceTriggeredOrder spotPriceTriggeredOrder) throws ApiException {
        Call localVarCall = this.createSpotPriceTriggeredOrderValidateBeforeCall(spotPriceTriggeredOrder, null);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSpotPriceTriggeredOrderAsync(SpotPriceTriggeredOrder spotPriceTriggeredOrder, ApiCallback<TriggerOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.createSpotPriceTriggeredOrderValidateBeforeCall(spotPriceTriggeredOrder, _callback);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelSpotPriceTriggeredOrderListCall(String market, String account, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/price_orders";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (market != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("market", market));
        }
        if (account != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("account", account));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelSpotPriceTriggeredOrderListValidateBeforeCall(String market, String account, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderListCall(market, account, _callback);
        return localVarCall;
    }

    public List<SpotPriceTriggeredOrder> cancelSpotPriceTriggeredOrderList(String market, String account) throws ApiException {
        ApiResponse<List<SpotPriceTriggeredOrder>> localVarResp = this.cancelSpotPriceTriggeredOrderListWithHttpInfo(market, account);
        return localVarResp.getData();
    }

    public ApiResponse<List<SpotPriceTriggeredOrder>> cancelSpotPriceTriggeredOrderListWithHttpInfo(String market, String account) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderListValidateBeforeCall(market, account, null);
        Type localVarReturnType = new TypeToken<List<SpotPriceTriggeredOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelSpotPriceTriggeredOrderListAsync(String market, String account, ApiCallback<List<SpotPriceTriggeredOrder>> _callback) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderListValidateBeforeCall(market, account, _callback);
        Type localVarReturnType = new TypeToken<List<SpotPriceTriggeredOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSpotPriceTriggeredOrderCall(String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/price_orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSpotPriceTriggeredOrderValidateBeforeCall(String orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getSpotPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.getSpotPriceTriggeredOrderCall(orderId, _callback);
        return localVarCall;
    }

    public SpotPriceTriggeredOrder getSpotPriceTriggeredOrder(String orderId) throws ApiException {
        ApiResponse<SpotPriceTriggeredOrder> localVarResp = this.getSpotPriceTriggeredOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<SpotPriceTriggeredOrder> getSpotPriceTriggeredOrderWithHttpInfo(String orderId) throws ApiException {
        Call localVarCall = this.getSpotPriceTriggeredOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<SpotPriceTriggeredOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSpotPriceTriggeredOrderAsync(String orderId, ApiCallback<SpotPriceTriggeredOrder> _callback) throws ApiException {
        Call localVarCall = this.getSpotPriceTriggeredOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<SpotPriceTriggeredOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelSpotPriceTriggeredOrderCall(String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/spot/price_orders/{order_id}".replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelSpotPriceTriggeredOrderValidateBeforeCall(String orderId, ApiCallback _callback) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelSpotPriceTriggeredOrder(Async)");
        }
        Call localVarCall = this.cancelSpotPriceTriggeredOrderCall(orderId, _callback);
        return localVarCall;
    }

    public SpotPriceTriggeredOrder cancelSpotPriceTriggeredOrder(String orderId) throws ApiException {
        ApiResponse<SpotPriceTriggeredOrder> localVarResp = this.cancelSpotPriceTriggeredOrderWithHttpInfo(orderId);
        return localVarResp.getData();
    }

    public ApiResponse<SpotPriceTriggeredOrder> cancelSpotPriceTriggeredOrderWithHttpInfo(String orderId) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderValidateBeforeCall(orderId, null);
        Type localVarReturnType = new TypeToken<SpotPriceTriggeredOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelSpotPriceTriggeredOrderAsync(String orderId, ApiCallback<SpotPriceTriggeredOrder> _callback) throws ApiException {
        Call localVarCall = this.cancelSpotPriceTriggeredOrderValidateBeforeCall(orderId, _callback);
        Type localVarReturnType = new TypeToken<SpotPriceTriggeredOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistSpotPriceTriggeredOrdersRequest {
        private final String status;
        private String market;
        private String account;
        private Integer limit;
        private Integer offset;

        private APIlistSpotPriceTriggeredOrdersRequest(String status) {
            this.status = status;
        }

        public APIlistSpotPriceTriggeredOrdersRequest market(String market) {
            this.market = market;
            return this;
        }

        public APIlistSpotPriceTriggeredOrdersRequest account(String account) {
            this.account = account;
            return this;
        }

        public APIlistSpotPriceTriggeredOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistSpotPriceTriggeredOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listSpotPriceTriggeredOrdersCall(this.status, this.market, this.account, this.limit, this.offset, _callback);
        }

        public List<SpotPriceTriggeredOrder> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listSpotPriceTriggeredOrdersWithHttpInfo(this.status, this.market, this.account, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SpotPriceTriggeredOrder>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listSpotPriceTriggeredOrdersWithHttpInfo(this.status, this.market, this.account, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<SpotPriceTriggeredOrder>> _callback) throws ApiException {
            return SpotApi.this.listSpotPriceTriggeredOrdersAsync(this.status, this.market, this.account, this.limit, this.offset, _callback);
        }
    }

    public class APIlistMyTradesRequest {
        private final String currencyPair;
        private Integer limit;
        private Integer page;
        private String orderId;

        private APIlistMyTradesRequest(String currencyPair) {
            this.currencyPair = currencyPair;
        }

        public APIlistMyTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistMyTradesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistMyTradesRequest orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listMyTradesCall(this.currencyPair, this.limit, this.page, this.orderId, _callback);
        }

        public List<Trade> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listMyTradesWithHttpInfo(this.currencyPair, this.limit, this.page, this.orderId);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Trade>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listMyTradesWithHttpInfo(this.currencyPair, this.limit, this.page, this.orderId);
        }

        public Call executeAsync(ApiCallback<List<Trade>> _callback) throws ApiException {
            return SpotApi.this.listMyTradesAsync(this.currencyPair, this.limit, this.page, this.orderId, _callback);
        }
    }

    public class APIlistOrdersRequest {
        private final String currencyPair;
        private final String status;
        private Integer page;
        private Integer limit;

        private APIlistOrdersRequest(String currencyPair, String status) {
            this.currencyPair = currencyPair;
            this.status = status;
        }

        public APIlistOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listOrdersCall(this.currencyPair, this.status, this.page, this.limit, _callback);
        }

        public List<Order> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listOrdersWithHttpInfo(this.currencyPair, this.status, this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Order>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listOrdersWithHttpInfo(this.currencyPair, this.status, this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<Order>> _callback) throws ApiException {
            return SpotApi.this.listOrdersAsync(this.currencyPair, this.status, this.page, this.limit, _callback);
        }
    }

    public class APIlistAllOpenOrdersRequest {
        private Integer page;
        private Integer limit;

        private APIlistAllOpenOrdersRequest() {
        }

        public APIlistAllOpenOrdersRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public APIlistAllOpenOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listAllOpenOrdersCall(this.page, this.limit, _callback);
        }

        public List<OpenOrders> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listAllOpenOrdersWithHttpInfo(this.page, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<OpenOrders>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listAllOpenOrdersWithHttpInfo(this.page, this.limit);
        }

        public Call executeAsync(ApiCallback<List<OpenOrders>> _callback) throws ApiException {
            return SpotApi.this.listAllOpenOrdersAsync(this.page, this.limit, _callback);
        }
    }

    public class APIlistSpotAccountsRequest {
        private String currency;

        private APIlistSpotAccountsRequest() {
        }

        public APIlistSpotAccountsRequest currency(String currency) {
            this.currency = currency;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listSpotAccountsCall(this.currency, _callback);
        }

        public List<SpotAccount> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listSpotAccountsWithHttpInfo(this.currency);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<SpotAccount>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listSpotAccountsWithHttpInfo(this.currency);
        }

        public Call executeAsync(ApiCallback<List<SpotAccount>> _callback) throws ApiException {
            return SpotApi.this.listSpotAccountsAsync(this.currency, _callback);
        }
    }

    public class APIgetFeeRequest {
        private String currencyPair;

        private APIgetFeeRequest() {
        }

        public APIgetFeeRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        @Deprecated
        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.getFeeCall(this.currencyPair, _callback);
        }

        @Deprecated
        public TradeFee execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.getFeeWithHttpInfo(this.currencyPair);
            return (TradeFee)localVarResp.getData();
        }

        @Deprecated
        public ApiResponse<TradeFee> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.getFeeWithHttpInfo(this.currencyPair);
        }

        @Deprecated
        public Call executeAsync(ApiCallback<TradeFee> _callback) throws ApiException {
            return SpotApi.this.getFeeAsync(this.currencyPair, _callback);
        }
    }

    public class APIlistCandlesticksRequest {
        private final String currencyPair;
        private Integer limit;
        private Long from;
        private Long to;
        private String interval;

        private APIlistCandlesticksRequest(String currencyPair) {
            this.currencyPair = currencyPair;
        }

        public APIlistCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listCandlesticksCall(this.currencyPair, this.limit, this.from, this.to, this.interval, _callback);
        }

        public List<List<String>> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listCandlesticksWithHttpInfo(this.currencyPair, this.limit, this.from, this.to, this.interval);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<List<String>>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listCandlesticksWithHttpInfo(this.currencyPair, this.limit, this.from, this.to, this.interval);
        }

        public Call executeAsync(ApiCallback<List<List<String>>> _callback) throws ApiException {
            return SpotApi.this.listCandlesticksAsync(this.currencyPair, this.limit, this.from, this.to, this.interval, _callback);
        }
    }

    public class APIlistTradesRequest {
        private final String currencyPair;
        private Integer limit;
        private String lastId;
        private Boolean reverse;

        private APIlistTradesRequest(String currencyPair) {
            this.currencyPair = currencyPair;
        }

        public APIlistTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistTradesRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public APIlistTradesRequest reverse(Boolean reverse) {
            this.reverse = reverse;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listTradesCall(this.currencyPair, this.limit, this.lastId, this.reverse, _callback);
        }

        public List<Trade> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listTradesWithHttpInfo(this.currencyPair, this.limit, this.lastId, this.reverse);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Trade>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listTradesWithHttpInfo(this.currencyPair, this.limit, this.lastId, this.reverse);
        }

        public Call executeAsync(ApiCallback<List<Trade>> _callback) throws ApiException {
            return SpotApi.this.listTradesAsync(this.currencyPair, this.limit, this.lastId, this.reverse, _callback);
        }
    }

    public class APIlistOrderBookRequest {
        private final String currencyPair;
        private String interval;
        private Integer limit;
        private Boolean withId;

        private APIlistOrderBookRequest(String currencyPair) {
            this.currencyPair = currencyPair;
        }

        public APIlistOrderBookRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public APIlistOrderBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistOrderBookRequest withId(Boolean withId) {
            this.withId = withId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listOrderBookCall(this.currencyPair, this.interval, this.limit, this.withId, _callback);
        }

        public OrderBook execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listOrderBookWithHttpInfo(this.currencyPair, this.interval, this.limit, this.withId);
            return (OrderBook)localVarResp.getData();
        }

        public ApiResponse<OrderBook> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listOrderBookWithHttpInfo(this.currencyPair, this.interval, this.limit, this.withId);
        }

        public Call executeAsync(ApiCallback<OrderBook> _callback) throws ApiException {
            return SpotApi.this.listOrderBookAsync(this.currencyPair, this.interval, this.limit, this.withId, _callback);
        }
    }

    public class APIlistTickersRequest {
        private String currencyPair;

        private APIlistTickersRequest() {
        }

        public APIlistTickersRequest currencyPair(String currencyPair) {
            this.currencyPair = currencyPair;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SpotApi.this.listTickersCall(this.currencyPair, _callback);
        }

        public List<Ticker> execute() throws ApiException {
            ApiResponse localVarResp = SpotApi.this.listTickersWithHttpInfo(this.currencyPair);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<Ticker>> executeWithHttpInfo() throws ApiException {
            return SpotApi.this.listTickersWithHttpInfo(this.currencyPair);
        }

        public Call executeAsync(ApiCallback<List<Ticker>> _callback) throws ApiException {
            return SpotApi.this.listTickersAsync(this.currencyPair, _callback);
        }
    }
}

