/*
 * Decompiled with CFR 0.152.
 */
package io.gate.gateapi.api;

import com.google.gson.reflect.TypeToken;
import io.gate.gateapi.ApiCallback;
import io.gate.gateapi.ApiClient;
import io.gate.gateapi.ApiException;
import io.gate.gateapi.ApiResponse;
import io.gate.gateapi.Configuration;
import io.gate.gateapi.Pair;
import io.gate.gateapi.models.DeliveryContract;
import io.gate.gateapi.models.DeliverySettlement;
import io.gate.gateapi.models.FuturesAccount;
import io.gate.gateapi.models.FuturesAccountBook;
import io.gate.gateapi.models.FuturesCandlestick;
import io.gate.gateapi.models.FuturesLiquidate;
import io.gate.gateapi.models.FuturesOrder;
import io.gate.gateapi.models.FuturesOrderBook;
import io.gate.gateapi.models.FuturesPriceTriggeredOrder;
import io.gate.gateapi.models.FuturesTicker;
import io.gate.gateapi.models.FuturesTrade;
import io.gate.gateapi.models.InsuranceRecord;
import io.gate.gateapi.models.MyFuturesTrade;
import io.gate.gateapi.models.Position;
import io.gate.gateapi.models.PositionClose;
import io.gate.gateapi.models.TriggerOrderResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class DeliveryApi {
    private ApiClient localVarApiClient;

    public DeliveryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeliveryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call listDeliveryContractsCall(String settle, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/contracts".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryContractsValidateBeforeCall(String settle, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryContracts(Async)");
        }
        Call localVarCall = this.listDeliveryContractsCall(settle, _callback);
        return localVarCall;
    }

    public List<DeliveryContract> listDeliveryContracts(String settle) throws ApiException {
        ApiResponse<List<DeliveryContract>> localVarResp = this.listDeliveryContractsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    public ApiResponse<List<DeliveryContract>> listDeliveryContractsWithHttpInfo(String settle) throws ApiException {
        Call localVarCall = this.listDeliveryContractsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<List<DeliveryContract>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDeliveryContractsAsync(String settle, ApiCallback<List<DeliveryContract>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryContractsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<List<DeliveryContract>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeliveryContractCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/contracts/{contract}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeliveryContractValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getDeliveryContract(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getDeliveryContract(Async)");
        }
        Call localVarCall = this.getDeliveryContractCall(settle, contract, _callback);
        return localVarCall;
    }

    public DeliveryContract getDeliveryContract(String settle, String contract) throws ApiException {
        ApiResponse<DeliveryContract> localVarResp = this.getDeliveryContractWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    public ApiResponse<DeliveryContract> getDeliveryContractWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.getDeliveryContractValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<DeliveryContract>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeliveryContractAsync(String settle, String contract, ApiCallback<DeliveryContract> _callback) throws ApiException {
        Call localVarCall = this.getDeliveryContractValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<DeliveryContract>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listDeliveryOrderBookCall(String settle, String contract, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/order_book".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (withId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("with_id", withId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryOrderBookValidateBeforeCall(String settle, String contract, String interval, Integer limit, Boolean withId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryOrderBook(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listDeliveryOrderBook(Async)");
        }
        Call localVarCall = this.listDeliveryOrderBookCall(settle, contract, interval, limit, withId, _callback);
        return localVarCall;
    }

    private ApiResponse<FuturesOrderBook> listDeliveryOrderBookWithHttpInfo(String settle, String contract, String interval, Integer limit, Boolean withId) throws ApiException {
        Call localVarCall = this.listDeliveryOrderBookValidateBeforeCall(settle, contract, interval, limit, withId, null);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryOrderBookAsync(String settle, String contract, String interval, Integer limit, Boolean withId, ApiCallback<FuturesOrderBook> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryOrderBookValidateBeforeCall(settle, contract, interval, limit, withId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrderBook>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryOrderBookRequest listDeliveryOrderBook(String settle, String contract) {
        return new APIlistDeliveryOrderBookRequest(settle, contract);
    }

    private Call listDeliveryTradesCall(String settle, String contract, Integer limit, String lastId, Long from, Long to, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/trades".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (lastId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("last_id", lastId));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryTradesValidateBeforeCall(String settle, String contract, Integer limit, String lastId, Long from, Long to, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryTrades(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listDeliveryTrades(Async)");
        }
        Call localVarCall = this.listDeliveryTradesCall(settle, contract, limit, lastId, from, to, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesTrade>> listDeliveryTradesWithHttpInfo(String settle, String contract, Integer limit, String lastId, Long from, Long to) throws ApiException {
        Call localVarCall = this.listDeliveryTradesValidateBeforeCall(settle, contract, limit, lastId, from, to, null);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryTradesAsync(String settle, String contract, Integer limit, String lastId, Long from, Long to, ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryTradesValidateBeforeCall(settle, contract, limit, lastId, from, to, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesTrade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryTradesRequest listDeliveryTrades(String settle, String contract) {
        return new APIlistDeliveryTradesRequest(settle, contract);
    }

    private Call listDeliveryCandlesticksCall(String settle, String contract, Long from, Long to, Integer limit, String interval, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/candlesticks".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (interval != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("interval", interval));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryCandlesticksValidateBeforeCall(String settle, String contract, Long from, Long to, Integer limit, String interval, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryCandlesticks(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling listDeliveryCandlesticks(Async)");
        }
        Call localVarCall = this.listDeliveryCandlesticksCall(settle, contract, from, to, limit, interval, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesCandlestick>> listDeliveryCandlesticksWithHttpInfo(String settle, String contract, Long from, Long to, Integer limit, String interval) throws ApiException {
        Call localVarCall = this.listDeliveryCandlesticksValidateBeforeCall(settle, contract, from, to, limit, interval, null);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryCandlesticksAsync(String settle, String contract, Long from, Long to, Integer limit, String interval, ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryCandlesticksValidateBeforeCall(settle, contract, from, to, limit, interval, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesCandlestick>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryCandlesticksRequest listDeliveryCandlesticks(String settle, String contract) {
        return new APIlistDeliveryCandlesticksRequest(settle, contract);
    }

    private Call listDeliveryTickersCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/tickers".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryTickersValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryTickers(Async)");
        }
        Call localVarCall = this.listDeliveryTickersCall(settle, contract, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesTicker>> listDeliveryTickersWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.listDeliveryTickersValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<List<FuturesTicker>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryTickersAsync(String settle, String contract, ApiCallback<List<FuturesTicker>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryTickersValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesTicker>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryTickersRequest listDeliveryTickers(String settle) {
        return new APIlistDeliveryTickersRequest(settle);
    }

    private Call listDeliveryInsuranceLedgerCall(String settle, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/insurance".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryInsuranceLedgerValidateBeforeCall(String settle, Integer limit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryInsuranceLedger(Async)");
        }
        Call localVarCall = this.listDeliveryInsuranceLedgerCall(settle, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<InsuranceRecord>> listDeliveryInsuranceLedgerWithHttpInfo(String settle, Integer limit) throws ApiException {
        Call localVarCall = this.listDeliveryInsuranceLedgerValidateBeforeCall(settle, limit, null);
        Type localVarReturnType = new TypeToken<List<InsuranceRecord>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryInsuranceLedgerAsync(String settle, Integer limit, ApiCallback<List<InsuranceRecord>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryInsuranceLedgerValidateBeforeCall(settle, limit, _callback);
        Type localVarReturnType = new TypeToken<List<InsuranceRecord>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryInsuranceLedgerRequest listDeliveryInsuranceLedger(String settle) {
        return new APIlistDeliveryInsuranceLedgerRequest(settle);
    }

    public Call listDeliveryAccountsCall(String settle, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/accounts".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryAccountsValidateBeforeCall(String settle, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryAccounts(Async)");
        }
        Call localVarCall = this.listDeliveryAccountsCall(settle, _callback);
        return localVarCall;
    }

    public FuturesAccount listDeliveryAccounts(String settle) throws ApiException {
        ApiResponse<FuturesAccount> localVarResp = this.listDeliveryAccountsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesAccount> listDeliveryAccountsWithHttpInfo(String settle) throws ApiException {
        Call localVarCall = this.listDeliveryAccountsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDeliveryAccountsAsync(String settle, ApiCallback<FuturesAccount> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryAccountsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<FuturesAccount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listDeliveryAccountBookCall(String settle, Integer limit, Long from, Long to, String type, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/account_book".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("from", from));
        }
        if (to != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("to", to));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryAccountBookValidateBeforeCall(String settle, Integer limit, Long from, Long to, String type, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryAccountBook(Async)");
        }
        Call localVarCall = this.listDeliveryAccountBookCall(settle, limit, from, to, type, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesAccountBook>> listDeliveryAccountBookWithHttpInfo(String settle, Integer limit, Long from, Long to, String type) throws ApiException {
        Call localVarCall = this.listDeliveryAccountBookValidateBeforeCall(settle, limit, from, to, type, null);
        Type localVarReturnType = new TypeToken<List<FuturesAccountBook>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryAccountBookAsync(String settle, Integer limit, Long from, Long to, String type, ApiCallback<List<FuturesAccountBook>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryAccountBookValidateBeforeCall(settle, limit, from, to, type, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesAccountBook>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryAccountBookRequest listDeliveryAccountBook(String settle) {
        return new APIlistDeliveryAccountBookRequest(settle);
    }

    public Call listDeliveryPositionsCall(String settle, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/positions".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryPositionsValidateBeforeCall(String settle, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryPositions(Async)");
        }
        Call localVarCall = this.listDeliveryPositionsCall(settle, _callback);
        return localVarCall;
    }

    public List<Position> listDeliveryPositions(String settle) throws ApiException {
        ApiResponse<List<Position>> localVarResp = this.listDeliveryPositionsWithHttpInfo(settle);
        return localVarResp.getData();
    }

    public ApiResponse<List<Position>> listDeliveryPositionsWithHttpInfo(String settle) throws ApiException {
        Call localVarCall = this.listDeliveryPositionsValidateBeforeCall(settle, null);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listDeliveryPositionsAsync(String settle, ApiCallback<List<Position>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryPositionsValidateBeforeCall(settle, _callback);
        Type localVarReturnType = new TypeToken<List<Position>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeliveryPositionCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/positions/{contract}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeliveryPositionValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getDeliveryPosition(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling getDeliveryPosition(Async)");
        }
        Call localVarCall = this.getDeliveryPositionCall(settle, contract, _callback);
        return localVarCall;
    }

    public Position getDeliveryPosition(String settle, String contract) throws ApiException {
        ApiResponse<Position> localVarResp = this.getDeliveryPositionWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    public ApiResponse<Position> getDeliveryPositionWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.getDeliveryPositionValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeliveryPositionAsync(String settle, String contract, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.getDeliveryPositionValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDeliveryPositionMarginCall(String settle, String contract, String change, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/positions/{contract}/margin".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (change != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("change", change));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDeliveryPositionMarginValidateBeforeCall(String settle, String contract, String change, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDeliveryPositionMargin(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDeliveryPositionMargin(Async)");
        }
        if (change == null) {
            throw new ApiException("Missing the required parameter 'change' when calling updateDeliveryPositionMargin(Async)");
        }
        Call localVarCall = this.updateDeliveryPositionMarginCall(settle, contract, change, _callback);
        return localVarCall;
    }

    public Position updateDeliveryPositionMargin(String settle, String contract, String change) throws ApiException {
        ApiResponse<Position> localVarResp = this.updateDeliveryPositionMarginWithHttpInfo(settle, contract, change);
        return localVarResp.getData();
    }

    public ApiResponse<Position> updateDeliveryPositionMarginWithHttpInfo(String settle, String contract, String change) throws ApiException {
        Call localVarCall = this.updateDeliveryPositionMarginValidateBeforeCall(settle, contract, change, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDeliveryPositionMarginAsync(String settle, String contract, String change, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.updateDeliveryPositionMarginValidateBeforeCall(settle, contract, change, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDeliveryPositionLeverageCall(String settle, String contract, String leverage, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/positions/{contract}/leverage".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (leverage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("leverage", leverage));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDeliveryPositionLeverageValidateBeforeCall(String settle, String contract, String leverage, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDeliveryPositionLeverage(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDeliveryPositionLeverage(Async)");
        }
        if (leverage == null) {
            throw new ApiException("Missing the required parameter 'leverage' when calling updateDeliveryPositionLeverage(Async)");
        }
        Call localVarCall = this.updateDeliveryPositionLeverageCall(settle, contract, leverage, _callback);
        return localVarCall;
    }

    public Position updateDeliveryPositionLeverage(String settle, String contract, String leverage) throws ApiException {
        ApiResponse<Position> localVarResp = this.updateDeliveryPositionLeverageWithHttpInfo(settle, contract, leverage);
        return localVarResp.getData();
    }

    public ApiResponse<Position> updateDeliveryPositionLeverageWithHttpInfo(String settle, String contract, String leverage) throws ApiException {
        Call localVarCall = this.updateDeliveryPositionLeverageValidateBeforeCall(settle, contract, leverage, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDeliveryPositionLeverageAsync(String settle, String contract, String leverage, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.updateDeliveryPositionLeverageValidateBeforeCall(settle, contract, leverage, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateDeliveryPositionRiskLimitCall(String settle, String contract, String riskLimit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/positions/{contract}/risk_limit".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{contract\\}", this.localVarApiClient.escapeString(contract));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (riskLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("risk_limit", riskLimit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateDeliveryPositionRiskLimitValidateBeforeCall(String settle, String contract, String riskLimit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling updateDeliveryPositionRiskLimit(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling updateDeliveryPositionRiskLimit(Async)");
        }
        if (riskLimit == null) {
            throw new ApiException("Missing the required parameter 'riskLimit' when calling updateDeliveryPositionRiskLimit(Async)");
        }
        Call localVarCall = this.updateDeliveryPositionRiskLimitCall(settle, contract, riskLimit, _callback);
        return localVarCall;
    }

    public Position updateDeliveryPositionRiskLimit(String settle, String contract, String riskLimit) throws ApiException {
        ApiResponse<Position> localVarResp = this.updateDeliveryPositionRiskLimitWithHttpInfo(settle, contract, riskLimit);
        return localVarResp.getData();
    }

    public ApiResponse<Position> updateDeliveryPositionRiskLimitWithHttpInfo(String settle, String contract, String riskLimit) throws ApiException {
        Call localVarCall = this.updateDeliveryPositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, null);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateDeliveryPositionRiskLimitAsync(String settle, String contract, String riskLimit, ApiCallback<Position> _callback) throws ApiException {
        Call localVarCall = this.updateDeliveryPositionRiskLimitValidateBeforeCall(settle, contract, riskLimit, _callback);
        Type localVarReturnType = new TypeToken<Position>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call listDeliveryOrdersCall(String settle, String status, String contract, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (lastId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("last_id", lastId));
        }
        if (countTotal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count_total", countTotal));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryOrdersValidateBeforeCall(String settle, String status, String contract, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryOrders(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listDeliveryOrders(Async)");
        }
        Call localVarCall = this.listDeliveryOrdersCall(settle, status, contract, limit, offset, lastId, countTotal, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesOrder>> listDeliveryOrdersWithHttpInfo(String settle, String status, String contract, Integer limit, Integer offset, String lastId, Integer countTotal) throws ApiException {
        Call localVarCall = this.listDeliveryOrdersValidateBeforeCall(settle, status, contract, limit, offset, lastId, countTotal, null);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryOrdersAsync(String settle, String status, String contract, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryOrdersValidateBeforeCall(settle, status, contract, limit, offset, lastId, countTotal, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryOrdersRequest listDeliveryOrders(String settle, String status) {
        return new APIlistDeliveryOrdersRequest(settle, status);
    }

    public Call createDeliveryOrderCall(String settle, FuturesOrder futuresOrder, ApiCallback _callback) throws ApiException {
        FuturesOrder localVarPostBody = futuresOrder;
        String localVarPath = "/delivery/{settle}/orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDeliveryOrderValidateBeforeCall(String settle, FuturesOrder futuresOrder, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling createDeliveryOrder(Async)");
        }
        if (futuresOrder == null) {
            throw new ApiException("Missing the required parameter 'futuresOrder' when calling createDeliveryOrder(Async)");
        }
        Call localVarCall = this.createDeliveryOrderCall(settle, futuresOrder, _callback);
        return localVarCall;
    }

    public FuturesOrder createDeliveryOrder(String settle, FuturesOrder futuresOrder) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = this.createDeliveryOrderWithHttpInfo(settle, futuresOrder);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesOrder> createDeliveryOrderWithHttpInfo(String settle, FuturesOrder futuresOrder) throws ApiException {
        Call localVarCall = this.createDeliveryOrderValidateBeforeCall(settle, futuresOrder, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createDeliveryOrderAsync(String settle, FuturesOrder futuresOrder, ApiCallback<FuturesOrder> _callback) throws ApiException {
        Call localVarCall = this.createDeliveryOrderValidateBeforeCall(settle, futuresOrder, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelDeliveryOrdersCall(String settle, String contract, String side, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (side != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("side", side));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelDeliveryOrdersValidateBeforeCall(String settle, String contract, String side, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelDeliveryOrders(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling cancelDeliveryOrders(Async)");
        }
        Call localVarCall = this.cancelDeliveryOrdersCall(settle, contract, side, _callback);
        return localVarCall;
    }

    public List<FuturesOrder> cancelDeliveryOrders(String settle, String contract, String side) throws ApiException {
        ApiResponse<List<FuturesOrder>> localVarResp = this.cancelDeliveryOrdersWithHttpInfo(settle, contract, side);
        return localVarResp.getData();
    }

    public ApiResponse<List<FuturesOrder>> cancelDeliveryOrdersWithHttpInfo(String settle, String contract, String side) throws ApiException {
        Call localVarCall = this.cancelDeliveryOrdersValidateBeforeCall(settle, contract, side, null);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelDeliveryOrdersAsync(String settle, String contract, String side, ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
        Call localVarCall = this.cancelDeliveryOrdersValidateBeforeCall(settle, contract, side, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeliveryOrderCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/orders/{order_id}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeliveryOrderValidateBeforeCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getDeliveryOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getDeliveryOrder(Async)");
        }
        Call localVarCall = this.getDeliveryOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    public FuturesOrder getDeliveryOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = this.getDeliveryOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesOrder> getDeliveryOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        Call localVarCall = this.getDeliveryOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeliveryOrderAsync(String settle, String orderId, ApiCallback<FuturesOrder> _callback) throws ApiException {
        Call localVarCall = this.getDeliveryOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelDeliveryOrderCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/orders/{order_id}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelDeliveryOrderValidateBeforeCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelDeliveryOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelDeliveryOrder(Async)");
        }
        Call localVarCall = this.cancelDeliveryOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    public FuturesOrder cancelDeliveryOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesOrder> localVarResp = this.cancelDeliveryOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesOrder> cancelDeliveryOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        Call localVarCall = this.cancelDeliveryOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelDeliveryOrderAsync(String settle, String orderId, ApiCallback<FuturesOrder> _callback) throws ApiException {
        Call localVarCall = this.cancelDeliveryOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call getMyDeliveryTradesCall(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/my_trades".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (order != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("order", order));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        if (lastId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("last_id", lastId));
        }
        if (countTotal != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("count_total", countTotal));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getMyDeliveryTradesValidateBeforeCall(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getMyDeliveryTrades(Async)");
        }
        Call localVarCall = this.getMyDeliveryTradesCall(settle, contract, order, limit, offset, lastId, countTotal, _callback);
        return localVarCall;
    }

    private ApiResponse<List<MyFuturesTrade>> getMyDeliveryTradesWithHttpInfo(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal) throws ApiException {
        Call localVarCall = this.getMyDeliveryTradesValidateBeforeCall(settle, contract, order, limit, offset, lastId, countTotal, null);
        Type localVarReturnType = new TypeToken<List<MyFuturesTrade>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getMyDeliveryTradesAsync(String settle, String contract, Long order, Integer limit, Integer offset, String lastId, Integer countTotal, ApiCallback<List<MyFuturesTrade>> _callback) throws ApiException {
        Call localVarCall = this.getMyDeliveryTradesValidateBeforeCall(settle, contract, order, limit, offset, lastId, countTotal, _callback);
        Type localVarReturnType = new TypeToken<List<MyFuturesTrade>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetMyDeliveryTradesRequest getMyDeliveryTrades(String settle) {
        return new APIgetMyDeliveryTradesRequest(settle);
    }

    private Call listDeliveryPositionCloseCall(String settle, String contract, Integer limit, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/position_close".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryPositionCloseValidateBeforeCall(String settle, String contract, Integer limit, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryPositionClose(Async)");
        }
        Call localVarCall = this.listDeliveryPositionCloseCall(settle, contract, limit, _callback);
        return localVarCall;
    }

    private ApiResponse<List<PositionClose>> listDeliveryPositionCloseWithHttpInfo(String settle, String contract, Integer limit) throws ApiException {
        Call localVarCall = this.listDeliveryPositionCloseValidateBeforeCall(settle, contract, limit, null);
        Type localVarReturnType = new TypeToken<List<PositionClose>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryPositionCloseAsync(String settle, String contract, Integer limit, ApiCallback<List<PositionClose>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryPositionCloseValidateBeforeCall(settle, contract, limit, _callback);
        Type localVarReturnType = new TypeToken<List<PositionClose>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryPositionCloseRequest listDeliveryPositionClose(String settle) {
        return new APIlistDeliveryPositionCloseRequest(settle);
    }

    private Call listDeliveryLiquidatesCall(String settle, String contract, Integer limit, Integer at, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/liquidates".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (at != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("at", at));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliveryLiquidatesValidateBeforeCall(String settle, String contract, Integer limit, Integer at, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliveryLiquidates(Async)");
        }
        Call localVarCall = this.listDeliveryLiquidatesCall(settle, contract, limit, at, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesLiquidate>> listDeliveryLiquidatesWithHttpInfo(String settle, String contract, Integer limit, Integer at) throws ApiException {
        Call localVarCall = this.listDeliveryLiquidatesValidateBeforeCall(settle, contract, limit, at, null);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliveryLiquidatesAsync(String settle, String contract, Integer limit, Integer at, ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
        Call localVarCall = this.listDeliveryLiquidatesValidateBeforeCall(settle, contract, limit, at, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesLiquidate>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliveryLiquidatesRequest listDeliveryLiquidates(String settle) {
        return new APIlistDeliveryLiquidatesRequest(settle);
    }

    private Call listDeliverySettlementsCall(String settle, String contract, Integer limit, Integer at, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/settlements".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (at != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("at", at));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listDeliverySettlementsValidateBeforeCall(String settle, String contract, Integer limit, Integer at, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listDeliverySettlements(Async)");
        }
        Call localVarCall = this.listDeliverySettlementsCall(settle, contract, limit, at, _callback);
        return localVarCall;
    }

    private ApiResponse<List<DeliverySettlement>> listDeliverySettlementsWithHttpInfo(String settle, String contract, Integer limit, Integer at) throws ApiException {
        Call localVarCall = this.listDeliverySettlementsValidateBeforeCall(settle, contract, limit, at, null);
        Type localVarReturnType = new TypeToken<List<DeliverySettlement>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listDeliverySettlementsAsync(String settle, String contract, Integer limit, Integer at, ApiCallback<List<DeliverySettlement>> _callback) throws ApiException {
        Call localVarCall = this.listDeliverySettlementsValidateBeforeCall(settle, contract, limit, at, _callback);
        Type localVarReturnType = new TypeToken<List<DeliverySettlement>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistDeliverySettlementsRequest listDeliverySettlements(String settle) {
        return new APIlistDeliverySettlementsRequest(settle);
    }

    private Call listPriceTriggeredDeliveryOrdersCall(String settle, String status, String contract, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/price_orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (status != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("status", status));
        }
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("offset", offset));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listPriceTriggeredDeliveryOrdersValidateBeforeCall(String settle, String status, String contract, Integer limit, Integer offset, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling listPriceTriggeredDeliveryOrders(Async)");
        }
        if (status == null) {
            throw new ApiException("Missing the required parameter 'status' when calling listPriceTriggeredDeliveryOrders(Async)");
        }
        Call localVarCall = this.listPriceTriggeredDeliveryOrdersCall(settle, status, contract, limit, offset, _callback);
        return localVarCall;
    }

    private ApiResponse<List<FuturesPriceTriggeredOrder>> listPriceTriggeredDeliveryOrdersWithHttpInfo(String settle, String status, String contract, Integer limit, Integer offset) throws ApiException {
        Call localVarCall = this.listPriceTriggeredDeliveryOrdersValidateBeforeCall(settle, status, contract, limit, offset, null);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listPriceTriggeredDeliveryOrdersAsync(String settle, String status, String contract, Integer limit, Integer offset, ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
        Call localVarCall = this.listPriceTriggeredDeliveryOrdersValidateBeforeCall(settle, status, contract, limit, offset, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistPriceTriggeredDeliveryOrdersRequest listPriceTriggeredDeliveryOrders(String settle, String status) {
        return new APIlistPriceTriggeredDeliveryOrdersRequest(settle, status);
    }

    public Call createPriceTriggeredDeliveryOrderCall(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, ApiCallback _callback) throws ApiException {
        FuturesPriceTriggeredOrder localVarPostBody = futuresPriceTriggeredOrder;
        String localVarPath = "/delivery/{settle}/price_orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createPriceTriggeredDeliveryOrderValidateBeforeCall(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling createPriceTriggeredDeliveryOrder(Async)");
        }
        if (futuresPriceTriggeredOrder == null) {
            throw new ApiException("Missing the required parameter 'futuresPriceTriggeredOrder' when calling createPriceTriggeredDeliveryOrder(Async)");
        }
        Call localVarCall = this.createPriceTriggeredDeliveryOrderCall(settle, futuresPriceTriggeredOrder, _callback);
        return localVarCall;
    }

    public TriggerOrderResponse createPriceTriggeredDeliveryOrder(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder) throws ApiException {
        ApiResponse<TriggerOrderResponse> localVarResp = this.createPriceTriggeredDeliveryOrderWithHttpInfo(settle, futuresPriceTriggeredOrder);
        return localVarResp.getData();
    }

    public ApiResponse<TriggerOrderResponse> createPriceTriggeredDeliveryOrderWithHttpInfo(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder) throws ApiException {
        Call localVarCall = this.createPriceTriggeredDeliveryOrderValidateBeforeCall(settle, futuresPriceTriggeredOrder, null);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createPriceTriggeredDeliveryOrderAsync(String settle, FuturesPriceTriggeredOrder futuresPriceTriggeredOrder, ApiCallback<TriggerOrderResponse> _callback) throws ApiException {
        Call localVarCall = this.createPriceTriggeredDeliveryOrderValidateBeforeCall(settle, futuresPriceTriggeredOrder, _callback);
        Type localVarReturnType = new TypeToken<TriggerOrderResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelPriceTriggeredDeliveryOrderListCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/price_orders".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (contract != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("contract", contract));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPriceTriggeredDeliveryOrderListValidateBeforeCall(String settle, String contract, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelPriceTriggeredDeliveryOrderList(Async)");
        }
        if (contract == null) {
            throw new ApiException("Missing the required parameter 'contract' when calling cancelPriceTriggeredDeliveryOrderList(Async)");
        }
        Call localVarCall = this.cancelPriceTriggeredDeliveryOrderListCall(settle, contract, _callback);
        return localVarCall;
    }

    public List<FuturesPriceTriggeredOrder> cancelPriceTriggeredDeliveryOrderList(String settle, String contract) throws ApiException {
        ApiResponse<List<FuturesPriceTriggeredOrder>> localVarResp = this.cancelPriceTriggeredDeliveryOrderListWithHttpInfo(settle, contract);
        return localVarResp.getData();
    }

    public ApiResponse<List<FuturesPriceTriggeredOrder>> cancelPriceTriggeredDeliveryOrderListWithHttpInfo(String settle, String contract) throws ApiException {
        Call localVarCall = this.cancelPriceTriggeredDeliveryOrderListValidateBeforeCall(settle, contract, null);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelPriceTriggeredDeliveryOrderListAsync(String settle, String contract, ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
        Call localVarCall = this.cancelPriceTriggeredDeliveryOrderListValidateBeforeCall(settle, contract, _callback);
        Type localVarReturnType = new TypeToken<List<FuturesPriceTriggeredOrder>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getPriceTriggeredDeliveryOrderCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/price_orders/{order_id}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getPriceTriggeredDeliveryOrderValidateBeforeCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling getPriceTriggeredDeliveryOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling getPriceTriggeredDeliveryOrder(Async)");
        }
        Call localVarCall = this.getPriceTriggeredDeliveryOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    public FuturesPriceTriggeredOrder getPriceTriggeredDeliveryOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesPriceTriggeredOrder> localVarResp = this.getPriceTriggeredDeliveryOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesPriceTriggeredOrder> getPriceTriggeredDeliveryOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        Call localVarCall = this.getPriceTriggeredDeliveryOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getPriceTriggeredDeliveryOrderAsync(String settle, String orderId, ApiCallback<FuturesPriceTriggeredOrder> _callback) throws ApiException {
        Call localVarCall = this.getPriceTriggeredDeliveryOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call cancelPriceTriggeredDeliveryOrderCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/delivery/{settle}/price_orders/{order_id}".replaceAll("\\{settle\\}", this.localVarApiClient.escapeString(settle)).replaceAll("\\{order_id\\}", this.localVarApiClient.escapeString(orderId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"apiv4"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call cancelPriceTriggeredDeliveryOrderValidateBeforeCall(String settle, String orderId, ApiCallback _callback) throws ApiException {
        if (settle == null) {
            throw new ApiException("Missing the required parameter 'settle' when calling cancelPriceTriggeredDeliveryOrder(Async)");
        }
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelPriceTriggeredDeliveryOrder(Async)");
        }
        Call localVarCall = this.cancelPriceTriggeredDeliveryOrderCall(settle, orderId, _callback);
        return localVarCall;
    }

    public FuturesPriceTriggeredOrder cancelPriceTriggeredDeliveryOrder(String settle, String orderId) throws ApiException {
        ApiResponse<FuturesPriceTriggeredOrder> localVarResp = this.cancelPriceTriggeredDeliveryOrderWithHttpInfo(settle, orderId);
        return localVarResp.getData();
    }

    public ApiResponse<FuturesPriceTriggeredOrder> cancelPriceTriggeredDeliveryOrderWithHttpInfo(String settle, String orderId) throws ApiException {
        Call localVarCall = this.cancelPriceTriggeredDeliveryOrderValidateBeforeCall(settle, orderId, null);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call cancelPriceTriggeredDeliveryOrderAsync(String settle, String orderId, ApiCallback<FuturesPriceTriggeredOrder> _callback) throws ApiException {
        Call localVarCall = this.cancelPriceTriggeredDeliveryOrderValidateBeforeCall(settle, orderId, _callback);
        Type localVarReturnType = new TypeToken<FuturesPriceTriggeredOrder>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIlistPriceTriggeredDeliveryOrdersRequest {
        private final String settle;
        private final String status;
        private String contract;
        private Integer limit;
        private Integer offset;

        private APIlistPriceTriggeredDeliveryOrdersRequest(String settle, String status) {
            this.settle = settle;
            this.status = status;
        }

        public APIlistPriceTriggeredDeliveryOrdersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistPriceTriggeredDeliveryOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistPriceTriggeredDeliveryOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listPriceTriggeredDeliveryOrdersCall(this.settle, this.status, this.contract, this.limit, this.offset, _callback);
        }

        public List<FuturesPriceTriggeredOrder> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listPriceTriggeredDeliveryOrdersWithHttpInfo(this.settle, this.status, this.contract, this.limit, this.offset);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesPriceTriggeredOrder>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listPriceTriggeredDeliveryOrdersWithHttpInfo(this.settle, this.status, this.contract, this.limit, this.offset);
        }

        public Call executeAsync(ApiCallback<List<FuturesPriceTriggeredOrder>> _callback) throws ApiException {
            return DeliveryApi.this.listPriceTriggeredDeliveryOrdersAsync(this.settle, this.status, this.contract, this.limit, this.offset, _callback);
        }
    }

    public class APIlistDeliverySettlementsRequest {
        private final String settle;
        private String contract;
        private Integer limit;
        private Integer at;

        private APIlistDeliverySettlementsRequest(String settle) {
            this.settle = settle;
        }

        public APIlistDeliverySettlementsRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistDeliverySettlementsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeliverySettlementsRequest at(Integer at) {
            this.at = at;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliverySettlementsCall(this.settle, this.contract, this.limit, this.at, _callback);
        }

        public List<DeliverySettlement> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliverySettlementsWithHttpInfo(this.settle, this.contract, this.limit, this.at);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<DeliverySettlement>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliverySettlementsWithHttpInfo(this.settle, this.contract, this.limit, this.at);
        }

        public Call executeAsync(ApiCallback<List<DeliverySettlement>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliverySettlementsAsync(this.settle, this.contract, this.limit, this.at, _callback);
        }
    }

    public class APIlistDeliveryLiquidatesRequest {
        private final String settle;
        private String contract;
        private Integer limit;
        private Integer at;

        private APIlistDeliveryLiquidatesRequest(String settle) {
            this.settle = settle;
        }

        public APIlistDeliveryLiquidatesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistDeliveryLiquidatesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeliveryLiquidatesRequest at(Integer at) {
            this.at = at;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryLiquidatesCall(this.settle, this.contract, this.limit, this.at, _callback);
        }

        public List<FuturesLiquidate> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryLiquidatesWithHttpInfo(this.settle, this.contract, this.limit, this.at);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesLiquidate>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryLiquidatesWithHttpInfo(this.settle, this.contract, this.limit, this.at);
        }

        public Call executeAsync(ApiCallback<List<FuturesLiquidate>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryLiquidatesAsync(this.settle, this.contract, this.limit, this.at, _callback);
        }
    }

    public class APIlistDeliveryPositionCloseRequest {
        private final String settle;
        private String contract;
        private Integer limit;

        private APIlistDeliveryPositionCloseRequest(String settle) {
            this.settle = settle;
        }

        public APIlistDeliveryPositionCloseRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistDeliveryPositionCloseRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryPositionCloseCall(this.settle, this.contract, this.limit, _callback);
        }

        public List<PositionClose> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryPositionCloseWithHttpInfo(this.settle, this.contract, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<PositionClose>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryPositionCloseWithHttpInfo(this.settle, this.contract, this.limit);
        }

        public Call executeAsync(ApiCallback<List<PositionClose>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryPositionCloseAsync(this.settle, this.contract, this.limit, _callback);
        }
    }

    public class APIgetMyDeliveryTradesRequest {
        private final String settle;
        private String contract;
        private Long order;
        private Integer limit;
        private Integer offset;
        private String lastId;
        private Integer countTotal;

        private APIgetMyDeliveryTradesRequest(String settle) {
            this.settle = settle;
        }

        public APIgetMyDeliveryTradesRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIgetMyDeliveryTradesRequest order(Long order) {
            this.order = order;
            return this;
        }

        public APIgetMyDeliveryTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIgetMyDeliveryTradesRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIgetMyDeliveryTradesRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public APIgetMyDeliveryTradesRequest countTotal(Integer countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.getMyDeliveryTradesCall(this.settle, this.contract, this.order, this.limit, this.offset, this.lastId, this.countTotal, _callback);
        }

        public List<MyFuturesTrade> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.getMyDeliveryTradesWithHttpInfo(this.settle, this.contract, this.order, this.limit, this.offset, this.lastId, this.countTotal);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<MyFuturesTrade>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.getMyDeliveryTradesWithHttpInfo(this.settle, this.contract, this.order, this.limit, this.offset, this.lastId, this.countTotal);
        }

        public Call executeAsync(ApiCallback<List<MyFuturesTrade>> _callback) throws ApiException {
            return DeliveryApi.this.getMyDeliveryTradesAsync(this.settle, this.contract, this.order, this.limit, this.offset, this.lastId, this.countTotal, _callback);
        }
    }

    public class APIlistDeliveryOrdersRequest {
        private final String settle;
        private final String status;
        private String contract;
        private Integer limit;
        private Integer offset;
        private String lastId;
        private Integer countTotal;

        private APIlistDeliveryOrdersRequest(String settle, String status) {
            this.settle = settle;
            this.status = status;
        }

        public APIlistDeliveryOrdersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public APIlistDeliveryOrdersRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeliveryOrdersRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public APIlistDeliveryOrdersRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public APIlistDeliveryOrdersRequest countTotal(Integer countTotal) {
            this.countTotal = countTotal;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryOrdersCall(this.settle, this.status, this.contract, this.limit, this.offset, this.lastId, this.countTotal, _callback);
        }

        public List<FuturesOrder> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryOrdersWithHttpInfo(this.settle, this.status, this.contract, this.limit, this.offset, this.lastId, this.countTotal);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesOrder>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryOrdersWithHttpInfo(this.settle, this.status, this.contract, this.limit, this.offset, this.lastId, this.countTotal);
        }

        public Call executeAsync(ApiCallback<List<FuturesOrder>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryOrdersAsync(this.settle, this.status, this.contract, this.limit, this.offset, this.lastId, this.countTotal, _callback);
        }
    }

    public class APIlistDeliveryAccountBookRequest {
        private final String settle;
        private Integer limit;
        private Long from;
        private Long to;
        private String type;

        private APIlistDeliveryAccountBookRequest(String settle) {
            this.settle = settle;
        }

        public APIlistDeliveryAccountBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeliveryAccountBookRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistDeliveryAccountBookRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistDeliveryAccountBookRequest type(String type) {
            this.type = type;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryAccountBookCall(this.settle, this.limit, this.from, this.to, this.type, _callback);
        }

        public List<FuturesAccountBook> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryAccountBookWithHttpInfo(this.settle, this.limit, this.from, this.to, this.type);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesAccountBook>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryAccountBookWithHttpInfo(this.settle, this.limit, this.from, this.to, this.type);
        }

        public Call executeAsync(ApiCallback<List<FuturesAccountBook>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryAccountBookAsync(this.settle, this.limit, this.from, this.to, this.type, _callback);
        }
    }

    public class APIlistDeliveryInsuranceLedgerRequest {
        private final String settle;
        private Integer limit;

        private APIlistDeliveryInsuranceLedgerRequest(String settle) {
            this.settle = settle;
        }

        public APIlistDeliveryInsuranceLedgerRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryInsuranceLedgerCall(this.settle, this.limit, _callback);
        }

        public List<InsuranceRecord> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryInsuranceLedgerWithHttpInfo(this.settle, this.limit);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<InsuranceRecord>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryInsuranceLedgerWithHttpInfo(this.settle, this.limit);
        }

        public Call executeAsync(ApiCallback<List<InsuranceRecord>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryInsuranceLedgerAsync(this.settle, this.limit, _callback);
        }
    }

    public class APIlistDeliveryTickersRequest {
        private final String settle;
        private String contract;

        private APIlistDeliveryTickersRequest(String settle) {
            this.settle = settle;
        }

        public APIlistDeliveryTickersRequest contract(String contract) {
            this.contract = contract;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryTickersCall(this.settle, this.contract, _callback);
        }

        public List<FuturesTicker> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryTickersWithHttpInfo(this.settle, this.contract);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesTicker>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryTickersWithHttpInfo(this.settle, this.contract);
        }

        public Call executeAsync(ApiCallback<List<FuturesTicker>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryTickersAsync(this.settle, this.contract, _callback);
        }
    }

    public class APIlistDeliveryCandlesticksRequest {
        private final String settle;
        private final String contract;
        private Long from;
        private Long to;
        private Integer limit;
        private String interval;

        private APIlistDeliveryCandlesticksRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        public APIlistDeliveryCandlesticksRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistDeliveryCandlesticksRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistDeliveryCandlesticksRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeliveryCandlesticksRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryCandlesticksCall(this.settle, this.contract, this.from, this.to, this.limit, this.interval, _callback);
        }

        public List<FuturesCandlestick> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryCandlesticksWithHttpInfo(this.settle, this.contract, this.from, this.to, this.limit, this.interval);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesCandlestick>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryCandlesticksWithHttpInfo(this.settle, this.contract, this.from, this.to, this.limit, this.interval);
        }

        public Call executeAsync(ApiCallback<List<FuturesCandlestick>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryCandlesticksAsync(this.settle, this.contract, this.from, this.to, this.limit, this.interval, _callback);
        }
    }

    public class APIlistDeliveryTradesRequest {
        private final String settle;
        private final String contract;
        private Integer limit;
        private String lastId;
        private Long from;
        private Long to;

        private APIlistDeliveryTradesRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        public APIlistDeliveryTradesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeliveryTradesRequest lastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public APIlistDeliveryTradesRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistDeliveryTradesRequest to(Long to) {
            this.to = to;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryTradesCall(this.settle, this.contract, this.limit, this.lastId, this.from, this.to, _callback);
        }

        public List<FuturesTrade> execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryTradesWithHttpInfo(this.settle, this.contract, this.limit, this.lastId, this.from, this.to);
            return (List)localVarResp.getData();
        }

        public ApiResponse<List<FuturesTrade>> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryTradesWithHttpInfo(this.settle, this.contract, this.limit, this.lastId, this.from, this.to);
        }

        public Call executeAsync(ApiCallback<List<FuturesTrade>> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryTradesAsync(this.settle, this.contract, this.limit, this.lastId, this.from, this.to, _callback);
        }
    }

    public class APIlistDeliveryOrderBookRequest {
        private final String settle;
        private final String contract;
        private String interval;
        private Integer limit;
        private Boolean withId;

        private APIlistDeliveryOrderBookRequest(String settle, String contract) {
            this.settle = settle;
            this.contract = contract;
        }

        public APIlistDeliveryOrderBookRequest interval(String interval) {
            this.interval = interval;
            return this;
        }

        public APIlistDeliveryOrderBookRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistDeliveryOrderBookRequest withId(Boolean withId) {
            this.withId = withId;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryOrderBookCall(this.settle, this.contract, this.interval, this.limit, this.withId, _callback);
        }

        public FuturesOrderBook execute() throws ApiException {
            ApiResponse localVarResp = DeliveryApi.this.listDeliveryOrderBookWithHttpInfo(this.settle, this.contract, this.interval, this.limit, this.withId);
            return (FuturesOrderBook)localVarResp.getData();
        }

        public ApiResponse<FuturesOrderBook> executeWithHttpInfo() throws ApiException {
            return DeliveryApi.this.listDeliveryOrderBookWithHttpInfo(this.settle, this.contract, this.interval, this.limit, this.withId);
        }

        public Call executeAsync(ApiCallback<FuturesOrderBook> _callback) throws ApiException {
            return DeliveryApi.this.listDeliveryOrderBookAsync(this.settle, this.contract, this.interval, this.limit, this.withId, _callback);
        }
    }
}

