package io.gamedock.sdk.web;

import android.annotation.SuppressLint;
import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

import com.lusfold.spinnerloading.SpinnerLoading;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.ads.AdEvents;
import io.gamedock.sdk.ads.internal.GamedockMoreAppsManager;
import io.gamedock.sdk.config.internal.GamedockConfigManager;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.splashscreen.SplashscreenManager;
import io.gamedock.sdk.utils.error.ErrorCodes;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Activity class that is created when the SDK needs to show an overlay WebView.
 */
public class WebViewActivity extends Activity {

    private String TAG = "WebViewActivity";

    private WebView webView;
    private String eventName;
    private static WebViewActivity activity;
    public JavascriptBridge javascriptBridge;

    public static RelativeLayout relativeLayout;
    public RelativeLayout.LayoutParams plp;

    public SpinnerLoading spinnerLoading;
    public ProgressBar progressBar;

    @SuppressLint({"JavascriptInterface", "SetJavaScriptEnabled"})
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        try {
            if (WebManager.webViewActivityOrientation != null) {
                if (WebManager.webViewActivityOrientation.equals("portrait")) {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);
                } else if (WebManager.webViewActivityOrientation.equals("landscape")) {
                    setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        View decorView = getWindow().getDecorView();
        // Hide the status bar.
        int uiOptions = View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                | View.SYSTEM_UI_FLAG_FULLSCREEN
                | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
        decorView.setSystemUiVisibility(uiOptions);
        // Remember that you should never show the action bar if the
        // status bar is hidden, so hide that too if necessary.
        ActionBar actionBar = getActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }

        activity = this;

        // Creating a new LinearLayout
        relativeLayout = new RelativeLayout(this);
        relativeLayout.setBackgroundColor(Color.TRANSPARENT);
        relativeLayout.setPadding(0, 0, 0, 0);

        // Defining the RelativeLayout layout parameters.
        // In this case I want to fill its parent
        RelativeLayout.LayoutParams rlp = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.MATCH_PARENT,
                RelativeLayout.LayoutParams.MATCH_PARENT);
        rlp.setMargins(0, 0, 0, 0);

        Bundle extras = getIntent().getExtras();

        if (extras != null) {
            eventName = extras.getString("eventName", "").toLowerCase().trim();

            try {
                switch (eventName) {
                    case "splashscreen":
                        GamedockSDK.getInstance(this).getSplashScreenCallbacks().splashScreenOpen();
                        break;
                    case "dailybonus":
                        GamedockSDK.getInstance(this).getDailyBonusCallbacks().dailyBonusOpen();
                        break;
                    case "tieredevent":
                        GamedockSDK.getInstance(this).getTieredEventCallbacks().tieredEventProgressOpen();
                        break;
                    case "moreapps":
                        GamedockSDK.getInstance(this).getMoreAppsCallbacks().MoreAppsStart("moreApps");
                        AdEvents.moreAppsDidDisplay(this);
                        break;
                }


                String URL = extras.getString("webViewUrl", null);
                if (URL != null && !URL.isEmpty()) {
                    webView = new WebView(this);

                    webView.setBackgroundColor(Color.TRANSPARENT);

                    //hack for android 4.x
                    webView.setWebViewClient(new WebViewClient() {
                        @Override
                        public void onPageFinished(WebView view, String url) {
                            webView.setBackgroundColor(Color.TRANSPARENT);
                        }
                    });

                    RelativeLayout.LayoutParams webViewParams = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.MATCH_PARENT, RelativeLayout.LayoutParams.MATCH_PARENT);
                    webView.setLayoutParams(webViewParams);

                    webView.clearHistory();
                    webView.getSettings().setJavaScriptEnabled(true);
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT && GamedockConfigManager.getInstance(this).isDebugModeEnabled()) {
                        WebView.setWebContentsDebuggingEnabled(true);
                    }
                    webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                        webView.setLayerType(View.LAYER_TYPE_HARDWARE, null);
                    } else {
                        webView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
                    }
                    webView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
                    webView.setBackgroundColor(Color.TRANSPARENT);
                    javascriptBridge = new JavascriptBridge(this, webView, extras);
                    webView.addJavascriptInterface(javascriptBridge, "SpilAndroidBridge");
                    relativeLayout.addView(webView, webViewParams);

                    webView.setWebViewClient(new WebViewClient() {
                        @Override
                        public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                            LoggingUtil.d("WebView Failed to load with status message:" + errorResponse.getData());
                            switch (eventName) {
                                case "splashscreen":
                                    GamedockSDK.getInstance(activity).getSplashScreenCallbacks().splashScreenError(ErrorCodes.SplashScreenLoadError);
                                    SplashscreenManager.getInstance(activity).setDelayedSplashscreen(null);
                                    break;
                                case "dailybonus":
                                    GamedockSDK.getInstance(activity).getDailyBonusCallbacks().dailyBonusError(ErrorCodes.DailyBonusLoadError);
                                    break;
                                case "tieredevent":
                                    GamedockSDK.getInstance(activity).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventShowProgressError);
                                    break;
                                case "moreapps":
                                    GamedockSDK.getInstance(activity).getMoreAppsCallbacks().MoreAppsNotAvailable("moreApps");
                                    GamedockMoreAppsManager.getInstance().gamedockMoreAppsObject = null;
                                    GamedockMoreAppsManager.getInstance().isMoreAppsEnabled = false;
                                    break;
                            }

                            Event event = new Event(activity);
                            event.setName("error");
                            event.addCustomData("type", "webview");
                            event.addCustomData("action", "show");

                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                                event.addCustomData("message", "Failed to load for request: " + request.getUrl().toString() + " --- With error: " + errorResponse.getData());
                            } else {
                                event.addCustomData("message", "Failed to load with error: " + errorResponse.getData());
                            }

                            GamedockSDK.getInstance(activity).trackEvent(event, null);

                            if (activity != null) {
                                activity.finish();
                            }
                        }

                        @Override
                        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                            LoggingUtil.d("WebView Failed to load with status message:" + error.toString());
                            switch (eventName) {
                                case "splashscreen":
                                    GamedockSDK.getInstance(activity).getSplashScreenCallbacks().splashScreenError(ErrorCodes.SplashScreenLoadError);
                                    SplashscreenManager.getInstance(activity).setDelayedSplashscreen(null);
                                    break;
                                case "dailybonus":
                                    GamedockSDK.getInstance(activity).getDailyBonusCallbacks().dailyBonusError(ErrorCodes.DailyBonusLoadError);
                                    break;
                                case "tieredevent":
                                    GamedockSDK.getInstance(activity).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventShowProgressError);
                                    break;
                                case "moreapps":
                                    GamedockSDK.getInstance(activity).getMoreAppsCallbacks().MoreAppsNotAvailable("moreApps");
                                    GamedockMoreAppsManager.getInstance().gamedockMoreAppsObject = null;
                                    GamedockMoreAppsManager.getInstance().isMoreAppsEnabled = false;
                                    break;
                            }

                            Event event = new Event(activity);
                            event.setName("error");
                            event.addCustomData("type", "webview");
                            event.addCustomData("action", "show");

                            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                                event.addCustomData("message", "Failed to load for request: " + request.getUrl().toString() + " --- With error: " + error.getDescription());
                            } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                                event.addCustomData("message", "Failed to load for request: " + request.getUrl().toString());
                            }

                            GamedockSDK.getInstance(activity).trackEvent(event, null);

                            if (activity != null) {
                                activity.finish();
                            }
                        }
                    });

                    webView.loadUrl(URL + "#" + Math.random());
                    webView.setBackgroundColor(Color.TRANSPARENT); ///hack for android 4.x
                } else {
                    switch (eventName) {
                        case "splashscreen":
                            GamedockSDK.getInstance(activity).getSplashScreenCallbacks().splashScreenError(ErrorCodes.SplashScreenLoadError);
                            SplashscreenManager.getInstance(activity).setDelayedSplashscreen(null);
                            break;
                        case "dailybonus":
                            GamedockSDK.getInstance(activity).getDailyBonusCallbacks().dailyBonusError(ErrorCodes.DailyBonusLoadError);
                            break;
                        case "tieredevent":
                            GamedockSDK.getInstance(activity).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventShowProgressError);
                            break;
                        case "moreapps":
                            GamedockSDK.getInstance(activity).getMoreAppsCallbacks().MoreAppsNotAvailable("moreApps");
                            GamedockMoreAppsManager.getInstance().gamedockMoreAppsObject = null;
                            GamedockMoreAppsManager.getInstance().isMoreAppsEnabled = false;
                            break;
                    }
                    finish();
                }
            } catch (Exception e) {
                switch (eventName) {
                    case "splashscreen":
                        GamedockSDK.getInstance(activity).getSplashScreenCallbacks().splashScreenError(ErrorCodes.SplashScreenLoadError);
                        SplashscreenManager.getInstance(activity).setDelayedSplashscreen(null);
                        break;
                    case "dailybonus":
                        GamedockSDK.getInstance(activity).getDailyBonusCallbacks().dailyBonusError(ErrorCodes.DailyBonusLoadError);
                        break;
                    case "tieredevent":
                        GamedockSDK.getInstance(activity).getTieredEventCallbacks().tieredEventsError(ErrorCodes.TieredEventShowProgressError);
                        break;
                    case "moreapps":
                        GamedockSDK.getInstance(activity).getMoreAppsCallbacks().MoreAppsNotAvailable("moreApps");
                        GamedockMoreAppsManager.getInstance().gamedockMoreAppsObject = null;
                        GamedockMoreAppsManager.getInstance().isMoreAppsEnabled = false;
                        break;
                }
                finish();
            }
        } else {
            finish();
        }
        this.setTheme(android.R.style.Theme_Translucent_NoTitleBar); //make sure activity is full width/height
        setContentView(relativeLayout, rlp);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        GamedockSDK.getInstance(this).isShowingChildActivity = false;

        switch (eventName) {
            case "splashscreen":
                GamedockSDK.getInstance(this).getSplashScreenCallbacks().splashScreenClosed();
                SplashscreenManager.getInstance(activity).setDelayedSplashscreen(null);
                break;
            case "dailybonus":
                GamedockSDK.getInstance(this).getDailyBonusCallbacks().dailyBonusClosed();
                break;
            case "tieredevent":
                GamedockSDK.getInstance(activity).getTieredEventCallbacks().tieredEventProgressClosed();
                break;
            case "moreapps":
                GamedockSDK.getInstance(this).getMoreAppsCallbacks().MoreAppsFinished("Gamedock", "moreApps", "close");
                AdEvents.moreAppsDidClose(this);
                GamedockMoreAppsManager.getInstance().gamedockMoreAppsObject = null;
                GamedockMoreAppsManager.getInstance().isMoreAppsEnabled = false;
                break;
        }

        activity = null;
    }

    public void openNewPage(final String URL, String eventName, String eventData) {
        this.eventName = eventName;
        javascriptBridge.setEventData(eventData);
        webView.post(new Runnable() {
            @Override
            public void run() {
                webView.loadUrl(URL + "#" + Math.random());
            }
        });
    }

    public static WebViewActivity getActivity() {
        return activity;
    }

    /**
     * Method that shows a circular progress bar using the custom layout.
     *
     * @param context The activity context.
     */
    public void showAdvanceSpinner(final Context context) {
        LoggingUtil.d("Showing advanced spinner!!");

        try {
            if (spinnerLoading != null) return;

            spinnerLoading = new SpinnerLoading(context);
            plp = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
            plp.addRule(RelativeLayout.CENTER_IN_PARENT);
            spinnerLoading.setLayoutParams(plp);
            spinnerLoading.setVisibility(View.VISIBLE);

            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        if (relativeLayout != null && spinnerLoading != null) {
                            relativeLayout.addView(spinnerLoading);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });


        } catch (NoClassDefFoundError | NullPointerException e) {
            LoggingUtil.d("Could not show advanced spinner! Falling back to basic spinner!");
            if (showBasicSpinner(this) != null) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            if (relativeLayout != null) {
                                relativeLayout.addView(showBasicSpinner(context));
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });

            }
        }
    }

    /**
     * Method that shows a circular progress bar using the standard android layout.
     *
     * @param context The activity context.
     * @return The generated progress bar. {@link ProgressBar}
     */
    public ProgressBar showBasicSpinner(Context context) {
        LoggingUtil.d("Showing basic spinner!!");

        if (progressBar != null) return null;

        progressBar = new ProgressBar(context, null, android.R.attr.progressBarStyleLarge);
        plp = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        plp.addRule(RelativeLayout.CENTER_IN_PARENT);
        progressBar.setLayoutParams(plp);
        progressBar.setIndeterminate(true);
        progressBar.setVisibility(View.VISIBLE);

        return progressBar;
    }

    /**
     * Method that hides the generated circular progress bar after the ad has finished showing.
     */
    public void hideSpinner() {
        LoggingUtil.d("Hiding spinner!!");

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (spinnerLoading != null) {
                    spinnerLoading.setVisibility(View.GONE);
                    if (relativeLayout != null) {
                        relativeLayout.removeView(spinnerLoading);
                    }
                    spinnerLoading = null;

                }

                if (progressBar != null) {
                    progressBar.setVisibility(View.GONE);
                    if (relativeLayout != null) {
                        relativeLayout.removeView(progressBar);
                    }
                    progressBar = null;
                }

                webView.setVisibility(View.VISIBLE);
            }
        });
    }

}
