package io.gamedock.sdk.utils.privacy;

import com.unity3d.player.UnityPlayer;

import io.gamedock.sdk.utils.logging.LoggingUtil;

public class PrivacyPolicyCallbacks {

    private OnPrivacyPolicyListener privacyPolicyListener;

    public PrivacyPolicyCallbacks() {
        privacyPolicyListener = null;
    }

    public PrivacyPolicyCallbacks(OnPrivacyPolicyListener privacyPolicyListener) {
        this.privacyPolicyListener = privacyPolicyListener;
    }

    /**
     * Method that is called when the server time has been updated been received by the SDK.
     */
    public void privacyPolicyStatus(boolean accepted) {
        if (privacyPolicyListener != null) {
            privacyPolicyListener.PrivacyPolicyStatus(accepted);
        } else {
            try {
                UnityPlayer.UnitySendMessage("GamedockSDK", "PrivacyPolicyStatus", String.valueOf(accepted));
            } catch (NoClassDefFoundError e) {
                LoggingUtil.w("Tried to send information to Unity but UnityPlayer could not be found (NoClassDefFoundError). This can happen by design and is not necessarily a problem.");
            }
        }
    }

}
