package io.gamedock.sdk.utils.privacy;

import android.os.Bundle;

import androidx.fragment.app.FragmentActivity;

import com.unity3d.player.UnityPlayer;

import java.util.ArrayList;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.R;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.events.EventManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;
import io.gamedock.sdk.utils.storage.StorageUtil;

public class PrivacyPolicyActivity extends FragmentActivity implements PrivacyPolicyMainFragment.OnPrivacyPolicyMainListener, PrivacyPolicySettingsFragment.OnPrivacyPolicySettingsListener, PrivacyPolicyInfoFragment.OnPrivacyPolicyInfoListener {

    public PrivacyPolicyActivity activity;

    private boolean withPersonalisedAds;
    private boolean withPersonalisedContent;

    private boolean openedSettings = false;

    private int openId = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_privacy_policy);
        try {
            overridePendingTransition(android.R.anim.slide_in_left, android.R.anim.slide_out_right);
        } catch (Exception e) {
        }

        activity = this;

        int priv = GamedockSDK.getInstance(activity).getStorageUtil().getInt(StorageUtil.Keys.GDPRStatus, -1);

        switch (priv) {
            case -1:
            case 0:
                withPersonalisedAds = false;
                withPersonalisedContent = false;
                break;
            case 1:
                withPersonalisedAds = false;
                withPersonalisedContent = true;
                break;
            case 2:
                withPersonalisedAds = true;
                withPersonalisedContent = false;
                break;
            case 3:
                withPersonalisedAds = true;
                withPersonalisedContent = true;
                break;
        }

        Bundle args = getIntent().getExtras();
        if (args != null) {
            openId = args.getInt("openId", 0);

            if (openId == 0) {
                getSupportFragmentManager().beginTransaction()
                        .replace(R.id.privacyPolicyContainer, PrivacyPolicyMainFragment.newInstance(openedSettings))
                        .commitAllowingStateLoss();
                GamedockSDK.getInstance(this).getStorageUtil().putBoolean(StorageUtil.Keys.PrivacyPolicyWasShowing, true);
            } else if (openId == 1) {
                openedSettings = true;
                getSupportFragmentManager().beginTransaction()
                        .replace(R.id.privacyPolicyContainer, PrivacyPolicySettingsFragment.newInstance(withPersonalisedAds, withPersonalisedContent))
                        .commitAllowingStateLoss();
            }
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        GamedockSDK.getInstance(this).isShowingPrivacyPolicy = false;
        GamedockSDK.getInstance(this).isShowingChildActivity = false;

        boolean isUnity = false;

        try {
            if (UnityPlayer.currentActivity != null) {
                isUnity = true;
            }
        } catch (Exception | NoClassDefFoundError e) {
        }

        if(openId == 0 && isUnity) {
            GamedockSDK.getInstance(activity).checkPrivacyPolicy(false);
        }

        activity = null;
    }

    @Override
    public void onBackPressed() {

    }

    @Override
    public void OnShowSettingsScreen() {
        openedSettings = true;
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.privacyPolicyContainer, PrivacyPolicySettingsFragment.newInstance(withPersonalisedAds, withPersonalisedContent))
                .commitAllowingStateLoss();
    }

    @Override
    public void OnPrivacyPolicyAccepted() {
        GamedockSDK.getInstance(activity).getStorageUtil().putBoolean(StorageUtil.Keys.PrivacyPolicyStatus, true);
        GamedockSDK.getInstance(activity).getStorageUtil().putBoolean(StorageUtil.Keys.PrivacyPolicyAsked, true);

        savePrivValue();

        if (GamedockSDK.getInstance(activity).initializationOptions != null) {
            if (GamedockSDK.getInstance(activity).initializationOptions.isWithAutoProcessPrivacyPolicy()) {
                GamedockSDK.getInstance(activity).init(true, GamedockSDK.getInstance(this).isCoppaEnabled());
            }
        }

        GamedockSDK.getInstance(activity).getPrivacyPolicyCallbacks().privacyPolicyStatus(true);

        Event event = new Event(this);
        event.setName("privacyChanged");

        event.addCustomData("acceptGDPR", true);
        event.addCustomData("personalizedAds", withPersonalisedAds);
        event.addCustomData("personalizedContents", withPersonalisedContent);
        event.addCustomData("location", "StartScreen");

        GamedockSDK.getInstance(this).trackEvent(event, null);

        GamedockSDK.getInstance(this).getStorageUtil().putBoolean(StorageUtil.Keys.PrivacyPolicyWasShowing, false);

        finish();
    }

    @Override
    public void OnPersonalisedAdsSetting(boolean enabled) {
        withPersonalisedAds = enabled;
    }

    @Override
    public void OnPersonalisedContentSetting(boolean enabled) {
        withPersonalisedContent = enabled;
    }

    @Override
    public void OnSettingsSaved() {
        if (openId == 0) {
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.privacyPolicyContainer, PrivacyPolicyMainFragment.newInstance(openedSettings))
                    .commitAllowingStateLoss();
        } else if (openId == 1) {
            try {
                for(int i = 0; i < EventManager.getInstance(this).getPersistenceListSize(); i++) {
                    ArrayList<Event> persistenceList =  EventManager.getInstance(this).getPersistenceEventsList(i + 1);
                    for (int j = 0; j < persistenceList.size(); j++) {
                        if(persistenceList.get(j).getName().equals("advertisementInit")) {
                            persistenceList.remove(j);
                        }
                    }
                    EventManager.getInstance(this).savePersistenceEventsList(persistenceList, i + 1);
                }
            } catch (Exception e) {
                LoggingUtil.d("Error occurred while removing offline advertisement event.");
            }

            int oldPriv = GamedockSDK.getInstance(activity).getStorageUtil().getInt(StorageUtil.Keys.GDPRStatus, -1);
            int newPriv = savePrivValue();

            if(oldPriv != newPriv) {
                Event event = new Event(this);
                event.setName("privacyChanged");

                event.addCustomData("personalizedAds", withPersonalisedAds);
                event.addCustomData("personalizedContents", withPersonalisedContent);
                event.addCustomData("location", "GeneralSettingsScreen");

                GamedockSDK.getInstance(this).trackEvent(event, null);

                getSupportFragmentManager().beginTransaction()
                        .replace(R.id.privacyPolicyContainer, new PrivacyPolicyInfoFragment())
                        .commitAllowingStateLoss();
            } else {
                if (activity != null) {
                    activity.finish();
                }
            }
        } else if (openId == 2) {
            int oldPriv = GamedockSDK.getInstance(activity).getStorageUtil().getInt(StorageUtil.Keys.GDPRStatus, -1);
            int newPriv = savePrivValue();

            if(oldPriv != newPriv) {
                Event event = new Event(this);
                event.setName("privacyChanged");

                event.addCustomData("personalizedAds", withPersonalisedAds);
                event.addCustomData("personalizedContents", withPersonalisedContent);
                event.addCustomData("location", "AdsSettingsScreen");

                GamedockSDK.getInstance(this).trackEvent(event, null);

                getSupportFragmentManager().beginTransaction()
                        .replace(R.id.privacyPolicyContainer, new PrivacyPolicyInfoFragment())
                        .commitAllowingStateLoss();
            } else {
                if (activity != null) {
                    activity.finish();
                }
            }
        }
    }

    @Override
    public void OnInfoAccepted() {
        if (activity != null) {
            activity.finish();
        }
    }

    private int savePrivValue() {
        if (!openedSettings) {
            withPersonalisedContent = true;
            withPersonalisedAds = true;
        }

        int priv = 0;
        if(withPersonalisedContent && !withPersonalisedAds) {
            priv = 1;
        } else if(!withPersonalisedContent && withPersonalisedAds) {
            priv = 2;
        } else if(withPersonalisedContent && withPersonalisedAds) {
            priv = 3;
        }

        GamedockSDK.getInstance(activity).savePrivValue(priv);

        return priv;
    }
}
