package io.gamedock.sdk.utils.permissions;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.R;
import io.gamedock.sdk.utils.dialog.MaterialDialog;
import io.gamedock.sdk.utils.dialog.MaterialStyledDialog;
import io.gamedock.sdk.utils.dialog.internal.DialogAction;


public class PermissionRationaleActivity extends Activity {

    public static Activity activity;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        activity = this;

        Bundle extras = getIntent().getExtras();

        if (extras != null) {
            String dialogTitle = extras.getString("dialogTitle");
            String dialogMessage = extras.getString("dialogMessage");
            boolean dialogWithSettings = extras.getBoolean("dialogWithSettings");
            boolean dialogWithAskAgain = extras.getBoolean("dialogWithAskAgain");

            createDialog(dialogTitle, dialogMessage, dialogWithSettings, dialogWithAskAgain);
        }


    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        activity = null;

        GamedockSDK.getInstance(this).isShowingChildActivity = false;
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        GamedockSDK.getInstance(this).onRequestPermissionsResult(requestCode, permissions, grantResults);
        finish();
    }

    private void createDialog(String title, String message, boolean withSettings, boolean withAskAgain) {
        int permissionHeader;
        int resourceId = this.getResources().getIdentifier("permission_deny_header_custom", "drawable", this.getPackageName());

        if (resourceId != 0) {
            permissionHeader = resourceId;
        } else {
            permissionHeader = R.drawable.permission_deny_header;
        }

        MaterialStyledDialog.Builder builder = new MaterialStyledDialog.Builder(this)
                .setTitle(title)
                .setDescription(message)
                .setHeaderDrawable(permissionHeader)
                .withDialogAnimation(true)
                .setPositiveText(android.R.string.ok)
                .onPositive(new MaterialDialog.SingleButtonCallback() {
                    @Override
                    public void onClick(@NonNull MaterialDialog materialDialog, @NonNull DialogAction dialogAction) {
                        if (activity != null) {
                            activity.finish();
                        }
                        materialDialog.dismiss();
                    }
                });

        if (withSettings) {
            String settingsText = PermissionUtil.settings;
            if (settingsText.equals("")) {
                settingsText = "Settings";
            }
            builder = builder.setNegativeText(settingsText);
            builder = builder.onNegative(new MaterialDialog.SingleButtonCallback() {
                @Override
                public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                    if (activity != null) {
                        Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
                        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        Uri uri = Uri.fromParts("package", GamedockSDK.getInstance(activity).getApplicationPackageName(), null);
                        intent.setData(uri);
                        activity.startActivity(intent);
                    }
                }
            });
        }

        if (withAskAgain) {
            String askAgainText = PermissionUtil.askAgain;
            if (askAgainText.equals("")) {
                askAgainText = "Ask Again";
            }
            builder = builder.setNeutralText(askAgainText);
            builder = builder.onNeutral(new MaterialDialog.SingleButtonCallback() {
                @Override
                public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                    requestPermissions();
                    dialog.dismiss();
                }
            });
        }

        builder.show();
    }

    private void requestPermissions() {
        PermissionUtil.requestAllDangerousPermissions(activity, false, false, false);
    }
}
