package io.gamedock.sdk.utils.gcm;

import android.content.Context;

import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Utility class that handles all the logic for registering the device with Google Cloud Messaging
 */
public class RegisterDevice {

    public static String TAG = "GamedockSDK";

    /**
     * Method that registers the current device with the Google GCM Service.
     *
     * @param context   The activity context.
     */
    public static void register(final Context context) {
        try {
            if (!GCMUtils.checkPlayServices(context)) {
                LoggingUtil.d("Google Play Services are not present on the device");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
