package io.gamedock.sdk.utils.device;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.utils.logging.LoggingUtil;

public class NetworkUtil {
    public static boolean isInternetAvailable(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo netInfo = null;
            if (cm != null) {
                netInfo = cm.getActiveNetworkInfo();
            }
            return netInfo != null && netInfo.isConnectedOrConnecting();
        } catch (NullPointerException e) {
            return false;
        }
    }

    public static void registerNetworkStatusReceiver(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);
            context.registerReceiver(networkChangeReceiver, intentFilter);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unregisterNetworkStatusReceiver(Context context) {
        try {
            context.unregisterReceiver(networkChangeReceiver);
        } catch (Exception ignored) {

        }
    }

    private static BroadcastReceiver networkChangeReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(final Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                Handler handler = new Handler(Looper.getMainLooper());
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            if (DeviceUtil.isClass("com.google.android.gms.ads.AdListener") && isInternetAvailable(context)) {
                            }
                        } catch (Exception | NoClassDefFoundError e) {
                            LoggingUtil.e("Gamedock AdMob Module not included! If you want to use AdMob please include the gamedock-sdk-admob dependency");
                        }
                    }
                }, 60000);
            }
        }
    };
}
