package io.gamedock.sdk.utils.device;


import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

import io.gamedock.sdk.GamedockSDK;

/**
 * Class that handles the {@link BroadcastReceiver} for the install referrer links.
 */
public class InstallReferrerReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        try {
            String referrer = "" + intent.getStringExtra("referrer");
            GamedockSDK.getInstance(context).getStorageUtil().putString("installReferrer", referrer);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
