package io.gamedock.sdk.userdata;


import org.json.JSONObject;

import io.gamedock.sdk.models.userdata.UpdatedUserData;
import io.gamedock.sdk.models.userdata.inventory.UniquePlayerItem;
import io.gamedock.sdk.models.userdata.mission.UpdatedMissionData;
import io.gamedock.sdk.utils.error.ErrorCodes;

/**
 * Interface used by the User Data Callbacks.
 * Describes all the methods that will be fired in the User Data Operations.
 */
public interface OnUserDataListener {
    void UserDataAvailable(String walletJSON, String inventoryJSON, String containersJSON, String missionJSON);

    void UserDataError(ErrorCodes error);

    void UserDataMergeConflict(JSONObject localData, JSONObject remoteData);

    void UserDataMergeSuccessful(String walletJSON, String inventoryJSON, String containersJSON, String missionJSON);

    void UserDataMergeFailed(JSONObject mergeData, String mergeType);

    void UserDataLockError();

    void UserDataSyncError();

    void UserDataHandleMerge(String mergeType);

    void PlayerDataUpdated(String reason, UpdatedUserData updatedUserData, String walletJSON, String inventoryJSON);

    void PlayerDataNewUniqueItem(UniquePlayerItem uniquePlayerItem);

    void PlayerDataEmptyGacha();

    void GameStateUpdated(String access);

    void OtherUsersGameStateLoaded(String provider, JSONObject data);

    void MissionDataUpdated(String reason, UpdatedMissionData updatedMissionData, String containersJSON, String missionsJSON);
}
