package io.gamedock.sdk.splashscreen;

import io.gamedock.sdk.utils.error.ErrorCodes;

/**
 * Interface used by the Splash Screen Callbacks.
 * Describes all the methods that will be fired in the Splash Screen Operations.
 */
public interface OnSplashScreenListener {
    void SplashScreenOpenShop();

    void SplashScreenOpen();

    void SplashScreenClosed();

    void SplashScreenAvailable(String type);

    void SplashScreenNotAvailable();

    void SplashScreenData(String payload);

    void SplashScreenError(ErrorCodes errorCode);
}
