package io.gamedock.sdk.social;

import io.gamedock.sdk.utils.error.ErrorCodes;

/**
 * Interface used by the Social Login Callbacks.
 * Describes all the methods that will be fired in the Social Login Operations.
 */
public interface OnSocialListener {
    void OnLoginSuccessful(boolean resetData, String socialProvider, String socialId, boolean isGuest);

    void OnLoginFailed(ErrorCodes errorCode);

    void OnRequestLogin();

    void OnLogoutSuccessful();

    void OnLogoutFailed(ErrorCodes errorCode);

    void OnAuthError(ErrorCodes errorCode);
}
