package io.gamedock.sdk.reward;

import org.json.JSONArray;

import io.gamedock.sdk.utils.error.ErrorCodes;

/**
 * Interface used by the Reward Callbacks.
 * Describes all the methods that will be fired in the Reward Operations.
 */
public interface OnRewardListener {
    void onRewardTokenReceived(String token, JSONArray reward, String rewardType);

    void onRewardTokenClaimed(JSONArray reward, String rewardType);

    void onRewardTokenClaimFailed(String rewardType, ErrorCodes error);

    void onNotificationReceived(String notification);
}
