package io.gamedock.sdk.models.userdata.wallet;


import io.gamedock.sdk.models.gamedata.currencies.Currency;

public class PlayerCurrency extends Currency {

    private int currentBalance;
    private int delta;
    private int overflow;

    public PlayerCurrency() {
        super();
    }

    public PlayerCurrency(Currency currency) {
        setId(currency.getId());
        setName(currency.getName());
        setType(currency.getType());
        setCurrentBalance(0);
        setDelta(0);
        setDisplayName(currency.getDisplayName());
        setDisplayDescription(currency.getDisplayDescription());
        setImageUrl(currency.getImageUrl());
        setLimit(currency.getLimit());
    }

    public int getCurrentBalance() {
        return currentBalance;
    }

    public void setCurrentBalance(int currentBalance) {
        this.currentBalance = currentBalance;
    }

    public int getDelta() {
        return delta;
    }

    public void setDelta(int delta) {
        this.delta = delta;
    }

    public int getOverflow() {
        return overflow;
    }

    public void setOverflow(int overflow) {
        this.overflow = overflow;
    }

    public PlayerCurrency clone() {
        PlayerCurrency clone = new PlayerCurrency();

        clone.setCurrentBalance(currentBalance);
        clone.setDelta(delta);

        clone.setId(getId());
        clone.setName(getName());
        clone.setInitialValue(getInitialValue());
        clone.setType(getType());
        clone.setDisplayName(getDisplayName());
        clone.setDisplayDescription(getDisplayDescription());
        clone.setImageUrl(getImageUrl());
        clone.setLimit(getLimit());

        return clone;
    }

    public void populateValues(Currency currency) {
        setId(currency.getId());
        setName(currency.getName());
        setInitialValue(currency.getInitialValue());
        setType(currency.getType());
        setDisplayName(currency.getDisplayName());
        setDisplayDescription(currency.getDisplayDescription());
        setImageUrl(currency.getImageUrl());
        setLimit(currency.getLimit());
    }
}
