package io.gamedock.sdk.models.performance;

public class PerformanceMetric {
    public enum MetricEnum {
        Memory,
        CPU,
        GPU,
        FPS,
        BatteryUsage,
        NetworkTrafficSent,
        NetworkTrafficReceived
    }

    private String name;
    private float currentValue = -1;
    private float averageValue = -1;
    private float totalValue = -1;
    private float maxValue = -1;
    private float minValue = -1;

    public PerformanceMetric(MetricEnum metric, float currentValue, float averageValue, float totalValue, float maxValue, float minValue) {
        name = metric.toString();
        this.currentValue = currentValue;
        this.averageValue = averageValue;
        this.totalValue = totalValue;
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getCurrentValue() {
        return currentValue;
    }

    public void setCurrentValue(float currentValue) {
        this.currentValue = currentValue;
    }

    public float getAverageValue() {
        return averageValue;
    }

    public void setAverageValue(float averageValue) {
        this.averageValue = averageValue;
    }

    public float getTotalValue() {
        return totalValue;
    }

    public void setTotalValue(float totalValue) {
        this.totalValue = totalValue;
    }

    public float getMaxValue() {
        return maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    public float getMinValue() {
        return minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public class PerformanceSubPoints {
        private String subPointInGame;
        private long subPointTime;

        public PerformanceSubPoints(String subPointInGame, long subPointTime) {
            this.subPointInGame = subPointInGame;
            this.subPointTime = subPointTime;
        }
    }
}
