package io.gamedock.sdk.models.gamedata.items;

import com.google.gson.JsonObject;

import java.util.ArrayList;

import io.gamedock.sdk.models.gamedata.gacha.GachaContent;

public class Item {

    private int id;
    private String name;
    private int initialValue;
    private int type;
    private String reportingName;
    private String displayName;
    private String displayDescription;
    private String imageUrl;
    private JsonObject properties;
    private int limit;
    private boolean isUnique;

    private boolean isGacha;
    private ArrayList<GachaContent> content = new ArrayList<>();
    private boolean allowDuplicates;
    private boolean shouldReroll;
    private GachaContent duplicateReward;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getInitialValue() {
        return initialValue;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getReportingName() {
        return reportingName;
    }

    public void setReportingName(String reportingName) {
        this.reportingName = reportingName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayDescription() {
        return displayDescription;
    }

    public void setDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public boolean isGacha() {
        return isGacha;
    }

    public void setGacha(boolean gacha) {
        isGacha = gacha;
    }

    public ArrayList<GachaContent> getContent() {
        if(content == null) {
            content = new ArrayList<>();
        }
        return content;
    }

    public void setContent(ArrayList<GachaContent> content) {
        this.content = content;
    }

    public boolean doesAllowDuplicates() {
        return allowDuplicates;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public boolean shouldReroll() {
        return shouldReroll;
    }

    public void setShouldReroll(boolean shouldReroll) {
        this.shouldReroll = shouldReroll;
    }

    public GachaContent getDuplicateReward() {
        return duplicateReward;
    }

    public void setDuplicateReward(GachaContent duplicateReward) {
        this.duplicateReward = duplicateReward;
    }

    public JsonObject getProperties() {
        return properties;
    }

    public void setProperties(JsonObject properties) {
        this.properties = properties;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isUnique() {
        return isUnique;
    }

    public void setUnique(boolean unique) {
        isUnique = unique;
    }
}
