package io.gamedock.sdk.models.gamedata;


import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.HashMap;

import io.gamedock.sdk.models.gamedata.bundles.Bundle;
import io.gamedock.sdk.models.gamedata.currencies.Currency;
import io.gamedock.sdk.models.gamedata.items.Item;
import io.gamedock.sdk.models.gamedata.shop.Tab;

public class GamedockGameData {

    private HashMap<Integer, Item> itemsMap = new HashMap<>();
    private ArrayList<Item> items = new ArrayList<>();

    private HashMap<Integer, Currency> currenciesMap = new HashMap<>();
    private ArrayList<Currency> currencies = new ArrayList<>();

    private HashMap<Integer, Bundle> bundlesMap = new HashMap<>();
    private ArrayList<Bundle> bundles = new ArrayList<>();

    private ArrayList<Tab> shop = new ArrayList<>();

    public HashMap<Integer, Item> getItemsMap() {
        return itemsMap;
    }

    public void setItemsMap(HashMap<Integer, Item> itemsMap) {
        for (Item item : this.getItemsMap().values()) {
            if(itemsMap.containsKey(item.getId())) {
                itemsMap.get(item.getId()).setLimit(item.getLimit());
            }
        }
        this.itemsMap = itemsMap;
    }

    public ArrayList<Item> getItems() {
        return items;
    }

    public void setItems(ArrayList<Item> items) {
        this.items = items;
    }

    public HashMap<Integer, Currency> getCurrenciesMap() {
        return currenciesMap;
    }

    public void setCurrenciesMap(HashMap<Integer, Currency> currenciesMap) {
        for (Currency currency : this.currenciesMap.values()) {
            if(currenciesMap.containsKey(currency.getId())) {
                currenciesMap.get(currency.getId()).setLimit(currency.getLimit());
            }
        }
        this.currenciesMap = currenciesMap;
    }

    public ArrayList<Currency> getCurrencies() {
        return currencies;
    }

    public void setCurrencies(ArrayList<Currency> currencies) {
        this.currencies = currencies;
    }

    public HashMap<Integer, Bundle> getBundlesMap() {
        return bundlesMap;
    }

    public void setBundlesMap(HashMap<Integer, Bundle> bundlesMap) {
        this.bundlesMap = bundlesMap;
    }

    public ArrayList<Bundle> getBundles() {
        return bundles;
    }

    public void setBundles(ArrayList<Bundle> bundles) {
        this.bundles = bundles;
    }

    public ArrayList<Tab> getShop() {
        return shop;
    }

    public void setShop(ArrayList<Tab> shop) {
        this.shop = shop;
    }

    public void Build() {
        for (int i = 0; i < items.size(); i++) {
            itemsMap.put(items.get(i).getId(), items.get(i));
        }

        items.clear();

        for (int i = 0; i < currencies.size(); i++) {
            currenciesMap.put(currencies.get(i).getId(), currencies.get(i));
        }

        currencies.clear();

        for (int i = 0; i < bundles.size(); i++) {
            bundlesMap.put(bundles.get(i).getId(), bundles.get(i));
        }

        bundles.clear();
    }

    public String Build(GamedockGameData gamedockGameData) {

        GamedockGameData data = new GamedockGameData();

        data.getItems().addAll(gamedockGameData.getItemsMap().values());

        data.getCurrencies().addAll(gamedockGameData.getCurrenciesMap().values());

        data.getBundles().addAll(gamedockGameData.getBundlesMap().values());

        data.setShop(gamedockGameData.getShop());

        return new Gson().toJson(data);
    }
}
