package io.gamedock.sdk.events.response;


import android.content.Context;

import org.json.JSONArray;

import java.util.ArrayList;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.dailybonus.DailyBonusManager;
import io.gamedock.sdk.models.reward.Reward;
import io.gamedock.sdk.reward.RewardManager;
import io.gamedock.sdk.utils.error.ErrorCodes;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding reward responses.
 */
public class RewardResponseEvent extends ResponseEvent {

    private ArrayList<Reward> collectibles;

    private ArrayList<Reward> rewards;
    private boolean success;
    private String rewardType;
    private String error;

    RewardResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            JSONArray jsonArray = null;
            if (responseEvent.responseData.has("collectibles")) {
                collectibles = new ArrayList<>();
                jsonArray = responseEvent.responseData.getJSONArray("collectibles");
            }

            if (responseEvent.responseData.has("reward")) {
                rewards = new ArrayList<>();
                jsonArray = responseEvent.responseData.getJSONArray("reward");
            }

            if (jsonArray != null) {
                for (int i = 0; i < jsonArray.length(); i++) {
                    Reward reward = new Reward();

                    if (jsonArray.getJSONObject(i).get("id") instanceof String) {
                        reward.externalId = jsonArray.getJSONObject(i).getString("id");
                    } else if (jsonArray.getJSONObject(i).get("id") instanceof Integer) {
                        reward.id = jsonArray.getJSONObject(i).getInt("id");
                    }

                    reward.type = jsonArray.getJSONObject(i).getString("type");
                    reward.amount = jsonArray.getJSONObject(i).getInt("amount");

                    if (collectibles != null) {
                        collectibles.add(reward);
                    }

                    if (rewards != null) {
                        rewards.add(reward);
                    }
                }
            }

            if (responseEvent.responseData.has("success")) {
                success = responseEvent.responseData.getBoolean("success");
            }

            if (responseEvent.responseData.has("rewardType")) {
                rewardType = responseEvent.responseData.getString("rewardType");
            }

            if (responseEvent.responseData.has("error")) {
                error = responseEvent.responseData.getString("error");
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for RewardResponseEvent");

        String action = getAction().toLowerCase().trim();

        switch (action) {
            case "collect":
                DailyBonusManager.getInstance(context).processRewardResponse(collectibles);
                break;
            case "error":
                GamedockSDK.getInstance(context).getDailyBonusCallbacks().dailyBonusError(ErrorCodes.DailyBonusServerError);
                break;
            case "claim":
                RewardManager.processReward(context, rewards, success, rewardType, error);
                break;
        }
    }
}
