package io.gamedock.sdk.events.response;

import android.content.Context;
import android.content.Intent;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.dailybonus.DailyBonusManager;
import io.gamedock.sdk.splashscreen.SplashscreenManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;
import io.gamedock.sdk.web.WebViewActivity;

/**
 * Class that processes information regarding overlay {@link android.webkit.WebView} responses
 */
public class OverlayResponseEvent extends ResponseEvent {
    private String url;

    OverlayResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.responseData.has("url")) {
                this.url = responseEvent.responseData.getString("url");
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for OverlayResponseEvent");

        String action = getAction().toLowerCase().trim();

        if (action.equals("show") && context != null) {
            try {
                switch (getName().trim().toLowerCase()) {
                    case "dailybonus":
                        DailyBonusManager.getInstance(context).processDailyBonusResponse(responseData.toString());
                        break;
                    case "splashscreen":
                        SplashscreenManager.getInstance(context).processSplashscreenResponse(responseData);
                        break;
                    default:
                        GamedockSDK.getInstance(context).isShowingChildActivity = true;

                        Intent intent = new Intent(context, WebViewActivity.class);
                        intent.putExtra("webViewUrl", url);
                        intent.putExtra("eventName", getName());
                        intent.putExtra("eventData", responseData.toString());
                        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        context.startActivity(intent);
                        break;
                }
            } catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else if (action.equals("notavailable")) {
            if (getName().toLowerCase().equals("splashscreen")) {
                GamedockSDK.getInstance(context).getSplashScreenCallbacks().splashScreenNotAvailable();
            } else if (getName().toLowerCase().equals("dailybonus")) {
                DailyBonusManager.getInstance(context).resetDailyBonusConfig();
                GamedockSDK.getInstance(context).getDailyBonusCallbacks().dailyBonusNotAvailable();
            }
        }
    }

    public String getUrl() {
        return url;
    }
}
