package io.gamedock.sdk.events.response;

import android.content.Context;

import org.json.JSONObject;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.localization.LocalizationManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class used to process the localization responses from the Backend.
 */
public class LocalizationResponseEvent extends ResponseEvent {
    private JSONObject localizationJSON;

    LocalizationResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.responseData != null) {
                this.localizationJSON = responseEvent.responseData;
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for LocalizationResponseEvent");

        String action = getAction().toLowerCase().trim();

        if (action.equals("request")) {
            LocalizationManager.getInstance(context).processRequestLocalizationResponse(localizationJSON);
        } else if (action.equals("notavailable")) {
            GamedockSDK.getInstance(context).getLocalizationCallbacks().localizationNotAvailable();
        }
    }
}
