package io.gamedock.sdk.events.response;

import android.content.Context;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

import io.gamedock.sdk.gamedata.GamedockGameDataManager;
import io.gamedock.sdk.models.gamedata.bundles.Bundle;
import io.gamedock.sdk.models.gamedata.currencies.Currency;
import io.gamedock.sdk.models.gamedata.items.Item;
import io.gamedock.sdk.models.gamedata.shop.Entry;
import io.gamedock.sdk.models.gamedata.shop.Tab;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding game data responses.
 */
public class GameDataResponseEvent extends ResponseEvent {

    private HashMap<Integer, Bundle> bundles = null;
    private HashMap<Integer, Item> items = null;
    private HashMap<Integer, Currency> currencies = null;
    private ArrayList<Tab> shop = null;
    private JSONArray packages = null;

    GameDataResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            Gson gson = new Gson();
            if (responseEvent.responseData.has("items")) {
                items = new HashMap<>();
                JSONArray itemsJSON = responseEvent.responseData.getJSONArray("items");
                JsonParser jsonParser = new JsonParser();
                for (int i = 0; i < itemsJSON.length(); i++) {
                    Item item = gson.fromJson(itemsJSON.getJSONObject(i).toString(), Item.class);
                    if(itemsJSON.getJSONObject(i).has("properties")) {
                        JsonObject properties = (JsonObject) jsonParser.parse(itemsJSON.getJSONObject(i).getJSONObject("properties").toString());
                        item.setProperties(properties);
                    }
                    items.put(item.getId(), item);
                }
            }

            if (responseEvent.responseData.has("bundles")) {
                bundles = new HashMap<>();
                JSONArray bundlesJSON = responseEvent.responseData.getJSONArray("bundles");
                JsonParser jsonParser = new JsonParser();
                for (int i = 0; i < bundlesJSON.length(); i++) {
                    Bundle bundle = gson.fromJson(bundlesJSON.getJSONObject(i).toString(), Bundle.class);
                    if(bundlesJSON.getJSONObject(i).has("properties")) {
                        JsonObject properties = (JsonObject) jsonParser.parse(bundlesJSON.getJSONObject(i).getJSONObject("properties").toString());
                        bundle.setProperties(properties);
                    }
                    bundles.put(bundle.getId(), bundle);
                }
            }

            if (responseEvent.responseData.has("currencies")) {
                currencies = new HashMap<>();
                JSONArray currenciesJSON = responseEvent.responseData.getJSONArray("currencies");
                for (int i = 0; i < currenciesJSON.length(); i++) {
                    Currency currency = gson.fromJson(currenciesJSON.getJSONObject(i).toString(), Currency.class);
                    currencies.put(currency.getId(), currency);
                }
            }

            if (responseEvent.responseData.has("shop")) {
                shop = new ArrayList<>();

                JSONArray shopJSON = responseEvent.responseData.getJSONArray("shop");
                JsonParser jsonParser = new JsonParser();
                for (int i = 0; i < shopJSON.length(); i++) {
                    JSONObject tabJSON = shopJSON.getJSONObject(i);
                    JSONArray entryJSON = tabJSON.getJSONArray("entries");

                    ArrayList<Entry> entries = new ArrayList<>();

                    for(int j = 0; j < entryJSON.length(); j++) {
                        Entry entry = gson.fromJson(entryJSON.getJSONObject(j).toString(), Entry.class);
                        if(entryJSON.getJSONObject(j).has("properties")) {
                            JsonObject properties = (JsonObject) jsonParser.parse(entryJSON.getJSONObject(j).getJSONObject("properties").toString());
                            entry.setProperties(properties);
                        }
                        entries.add(entry);
                    }

                    Tab tab = gson.fromJson(tabJSON.toString(), Tab.class);
                    if(tabJSON.has("properties")) {
                        JsonObject properties = (JsonObject) jsonParser.parse(tabJSON.getJSONObject("properties").toString());
                        tab.setProperties(properties);
                    }
                    tab.setEntries(entries);
                    shop.add(tab);
                }
            }

            if (responseEvent.responseData.has("packages")) {
                packages = responseEvent.responseData.getJSONArray("packages");
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for GameDataResponseEvent");

        GamedockGameDataManager.getInstance(context).processGameData(currencies, items, bundles, shop, packages);
    }

    public HashMap<Integer, Bundle> getBundles() {
        return bundles;
    }

    public HashMap<Integer, Item> getItems() {
        return items;
    }

    public HashMap<Integer, Currency> getCurrencies() {
        return currencies;
    }

    public ArrayList<Tab> getShop() {
        return shop;
    }
}
