package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.config.ConfigManager;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding game configuration responses.
 */
public class ConfigResponseEvent extends ResponseEvent {

    private String configJSON;

    ConfigResponseEvent(ResponseEvent responseEvent) {
        super();

        try {
            if (responseEvent.responseData != null) {
                this.configJSON = responseEvent.responseData.toString();
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for ConfigResponseEvent");

        ConfigManager.getInstance(context).processConfigJSON(configJSON);
    }

    public String getConfigJSON() {
        return configJSON;
    }
}
