package io.gamedock.sdk.events.response;

import android.content.Context;

import com.google.gson.Gson;

import org.json.JSONArray;

import java.util.ArrayList;

import io.gamedock.sdk.assetbundles.AssetBundlesManager;
import io.gamedock.sdk.models.assetbundles.AssetBundle;
import io.gamedock.sdk.utils.logging.LoggingUtil;

/**
 * Class that processes information regarding asset bundle configuration response.
 */
public class AssetBundlesResponseEvent extends ResponseEvent {

    private ArrayList<AssetBundle> assetBundles = null;

    AssetBundlesResponseEvent(ResponseEvent responseEvent) {
        super();

        LoggingUtil.d("Received Asset Bundles Data: " + responseEvent.toJSONString(false));

        try {
            Gson gson = new Gson();
            if (responseEvent.getAction().equals("request")) {
                if (responseEvent.responseData.has("assetBundles")) {
                    assetBundles = new ArrayList<>();

                    JSONArray assetBundlesJSON = responseEvent.responseData.getJSONArray("assetBundles");

                    for (int i = 0; i < assetBundlesJSON.length(); i++) {
                        AssetBundle assetBundle = gson.fromJson(assetBundlesJSON.getJSONObject(i).toString(), AssetBundle.class);
                        assetBundles.add(assetBundle);
                    }
                }
            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            setMessage(responseEvent.getMessage());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for AssetBundlesResponseEvent");

        String action = getAction().toLowerCase().trim();

        if (action.equals("request")) {
            AssetBundlesManager.getInstance(context).processAssetBundles(assetBundles);
        }

    }

    public ArrayList<AssetBundle> getAssetBundles() {
        return assetBundles;
    }
}
