package io.gamedock.sdk.events.response;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.utils.logging.LoggingUtil;

public class AdvertisementResponseEvent extends ResponseEvent{

    ResponseEvent responseEvent;

    AdvertisementResponseEvent(ResponseEvent responseEvent) {
        super();

        try {

            if (responseEvent.getAction().toLowerCase().trim().equals("show")) {
                //Check if the response informs the SDK if the ad can be shown (based on conditions from the backend)

                this.responseEvent = responseEvent;


            }

            setName(responseEvent.getName());
            setType(responseEvent.getType());
            setAction(responseEvent.getAction());
            setIds(responseEvent.getIds());
            this.responseData = responseEvent.responseData;
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void processData(Context context) {
        LoggingUtil.d("Processing data for AdvertisementResponseEvent");

        String action = getAction().toLowerCase().trim();

        if (action.equals("show")) {
            GamedockSDK.getInstance(context).getMoreAppsCallbacks().OnAdTrigger(responseEvent.toJSONString(false));

            //GamedockSDK.getInstance(context).sendDataToUnity("OnAdTrigger", responseEvent.toJSONString(false));

        }
    }
}
