package io.gamedock.sdk.events.internal;


import android.content.Context;

import org.json.JSONException;
import org.json.JSONObject;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.device.NetworkUtil;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class UserDataEvent extends Event {

    public static final String RequestUserData = "requestUserData";
    public static final String MergeUserData = "mergeUserData";

    public static final String RequestOtherUsersGameState = "requestOtherUsersGameState";

    public static final String UpdateGameState = "updateGameState";
    public static final String UpdatePlayerData = "updatePlayerData";

    public UserDataEvent(Context context) {
        super(context);
    }

    public void setRequestUserData() {
        this.setName(RequestUserData);
    }

    public void setMergeUserData() {
        this.setName(MergeUserData);
    }

    public void setRequestOtherUsersGameState() {
        this.setName(RequestOtherUsersGameState);
    }

    public void setUpdateGameState() {
        this.setName(UpdateGameState);
    }

    public void setUpdatePlayerData() {
        this.setName(UpdatePlayerData);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if(getName().equals(RequestUserData)) {
            if(NetworkUtil.isInternetAvailable(context)) {
                GamedockSDK.getInstance(context).getUserDataCallbacks().userDataError(ErrorCodes.UserDataServerError);
            }
        } else if(getName().equals(MergeUserData)) {
            try {
                JSONObject jsonData = new JSONObject(customData.toString());
                String mergeType = jsonData.getString("mergeType");
                jsonData.remove("mergeType");
                jsonData.remove("deviceVersions");
                GamedockSDK.getInstance(context).getUserDataCallbacks().userDataMergeFailed(jsonData, mergeType);
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        setNetworkErrorHandled(true);
    }
}
