package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class ServerDataEvent extends Event {

    public static final String RequestServerTime = "requestServerTime";

    public ServerDataEvent(Context context) {
        super(context);
    }

    public void setRequestServerTime() {
        this.setName(RequestServerTime);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        GamedockSDK.getInstance(context).getServerDataCallbacks().serverTimeRequestFailed(ErrorCodes.ServerTimeRequestError);
        setNetworkErrorHandled(true);
    }
}
