package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class OverlayEvent extends Event {

    public static final String RequestDailyBonus = "requestDailyBonus";
    public static final String RequestSplashscreen = "requestSplashscreen";
    public static final String DroppedSplashscreen = "droppedSplashscreen";

    public OverlayEvent(Context context) {
        super(context);
    }

    public void setRequestDailyBonus() {
        this.setName(RequestDailyBonus);
    }

    public void setRequestSplashscreen() {
        this.setName(RequestSplashscreen);
    }

    public void setDroppedSplashscreen() {
        this.setName(DroppedSplashscreen);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if (getName().equals(RequestDailyBonus)) {
            GamedockSDK.getInstance(context).getDailyBonusCallbacks().dailyBonusError(ErrorCodes.DailyBonusLoadError);
        } else if (getName().equals(RequestSplashscreen)) {
            GamedockSDK.getInstance(context).getSplashScreenCallbacks().splashScreenError(ErrorCodes.SplashScreenLoadError);
        }

        setNetworkErrorHandled(true);
    }
}
