package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.mission.MissionConfigurationManager;
import io.gamedock.sdk.utils.device.NetworkUtil;
import io.gamedock.sdk.utils.error.ErrorCodes;

public class MissionEvent extends Event {

    public static final String RequestMissionConfig = "requestMissionConfig";
    public static final String UpdateUserMissionData = "updateUserMissionData";

    public void setRequestMissionConfig() {
        this.setName(RequestMissionConfig);
    }

    public void setUpdateUserMissionData() {
        this.setName(UpdateUserMissionData);
    }

    public MissionEvent(Context context) {
        super(context);
    }


    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if (getName().equals(RequestMissionConfig) && NetworkUtil.isInternetAvailable(context)) {
            GamedockSDK.getInstance(context).getMissionConfigurationCallbacks().missionConfigurationError(ErrorCodes.MissionConfigurationServerError);
        } else if(getName().equals(RequestMissionConfig) && !NetworkUtil.isInternetAvailable(context)) {
            if (MissionConfigurationManager.getInstance(context).getMissionConfiguration() != null) {
                if (!MissionConfigurationManager.getInstance(context).getMissionConfiguration().getMissions().isEmpty()) {
                    GamedockSDK.getInstance(context).getMissionConfigurationCallbacks().missionConfigurationAvailable(GamedockSDK.getInstance(context).getGson().toJson(GamedockSDK.getInstance(context).getContainersConfiguration()), GamedockSDK.getInstance(context).getGson().toJson(GamedockSDK.getInstance(context).getMissionsConfiguration(null)));
                } else {
                    GamedockSDK.getInstance(context).getMissionConfigurationCallbacks().missionConfigurationNotAvailable();
                }
            } else {
                GamedockSDK.getInstance(context).getMissionConfigurationCallbacks().missionConfigurationNotAvailable();
            }
        }

        setNetworkErrorHandled(true);
    }

}
