package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;

public class InitializeSDKEvent extends Event{
    public static final String InitializeSDK = "initializeSdk";
    public static final String UserChanged = "userChange";

    public InitializeSDKEvent(Context context) {
        super(context);
    }

    public void setInitializeSDK() {
        this.setName(InitializeSDK);
    }

    public void setUserChanged() {
        this.setName(UserChanged);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }


        if (getName().equals(InitializeSDK)) {
            GamedockSDK.getInstance(context).initFeatures();
        }

        setNetworkErrorHandled(true);
    }
}
