package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.events.Event;

/**
 * Class that extends the event class.
 * It is used for holding all the attributes of a heartbeat event.
 * Heartbeat event an event that is sent every minute by the game to notify the server that the user is currently playing the game.
 */
public class HeartbeatEvent extends Event {

    public static final String HeartBeat = "heartBeat";

    public void setHeartBeat() {
        this.setName(HeartBeat);
    }

    public HeartbeatEvent(Context context) {
        super(context);
    }

}
