package io.gamedock.sdk.events.internal;

import android.content.Context;

import io.gamedock.sdk.GamedockSDK;
import io.gamedock.sdk.events.Event;
import io.gamedock.sdk.utils.device.NetworkUtil;
import io.gamedock.sdk.utils.error.ErrorCodes;


public class GameDataEvent extends Event {

    public static final String RequestGameData = "requestGameData";
    public static final String SetCurrencyLimit = "setCurrencyLimit";
    public static final String SetItemLimit = "setItemLimit";

    public GameDataEvent(Context context) {
        super(context);
    }

    public void setRequestGameData() {
        this.setName(RequestGameData);
    }

    public void setSetCurrencyLimit() {
        this.setName(SetCurrencyLimit);
    }

    public void setSetItemLimit() {
        this.setName(SetItemLimit);
    }

    @Override
    public void handleNetworkError(Context context) {
        if (isNetworkErrorHandled()) {
            return;
        }

        if (getName().equals(RequestGameData) && NetworkUtil.isInternetAvailable(context)) {
            GamedockSDK.getInstance(context).getGameDataCallbacks().gameDataError(ErrorCodes.GameDataServerError);
        } else {
            GamedockSDK.getInstance(context).getGameDataCallbacks().gameDataAvailable(GamedockSDK.getInstance(context).getGamedockGameData());
            GamedockSDK.getInstance(context).getPackagesCallbacks().packagesAvailable(GamedockSDK.getInstance(context).getAllPackages());
        }

        setNetworkErrorHandled(true);
    }
}
